/*
 * Decompiled with CFR 0.152.
 */
package com.filemaker.largeobject;

import com.filemaker.jdbc.FMSQLException;
import com.filemaker.largeobject.BlobInputStream;
import com.filemaker.largeobject.BlobOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.SQLException;

public class LargeObject {
    public static final int SEEK_SET = 0;
    public static final int SEEK_CUR = 1;
    public static final int SEEK_END = 2;
    private int type;
    private int fd;
    private BlobOutputStream os;
    private boolean closed = false;

    protected void finalize() throws SQLException {
    }

    public int getType() {
        return this.type;
    }

    public void close() throws SQLException {
        if (!this.closed) {
            if (this.os != null) {
                try {
                    this.os.flush();
                }
                catch (IOException iOException) {
                    throw new FMSQLException(iOException.getMessage(), 27226);
                }
                finally {
                    this.os = null;
                }
            }
            this.closed = true;
        }
    }

    public byte[] read(int n) throws SQLException {
        return null;
    }

    public int read(byte[] byArray, int n, int n2) throws SQLException {
        byte[] byArray2 = this.read(n2);
        if (byArray2.length < n2) {
            n2 = byArray2.length;
        }
        System.arraycopy(byArray2, 0, byArray, n, n2);
        return n2;
    }

    public void write(byte[] byArray) throws SQLException {
    }

    public void write(byte[] byArray, int n, int n2) throws SQLException {
        byte[] byArray2 = new byte[n2];
        System.arraycopy(byArray, n, byArray2, 0, n2);
        this.write(byArray2);
    }

    public void seek(int n, int n2) throws SQLException {
    }

    public void seek(int n) throws SQLException {
        this.seek(n, 0);
    }

    public int tell() throws SQLException {
        return 0;
    }

    public int size() throws SQLException {
        int n = this.tell();
        this.seek(0, 2);
        int n2 = this.tell();
        this.seek(n, 0);
        return n2;
    }

    public InputStream getInputStream() throws SQLException {
        return new BlobInputStream(this, 4096);
    }

    public OutputStream getOutputStream() throws SQLException {
        if (this.os == null) {
            this.os = new BlobOutputStream(this, 4096);
        }
        return this.os;
    }
}

