/*
 * Definitions for libfsapfs
 *
 * Copyright (C) 2018-2022, Joachim Metz <joachim.metz@gmail.com>
 *
 * Refer to AUTHORS for acknowledgements.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

#if !defined( _LIBFSAPFS_DEFINITIONS_H )
#define _LIBFSAPFS_DEFINITIONS_H

#include <libfsapfs/types.h>

#define LIBFSAPFS_VERSION		20220430

/* The version string
 */
#define LIBFSAPFS_VERSION_STRING	"20220430"

/* The file access
 * bit 1        set to 1 for read access
 * bit 2        set to 1 for write access
 * bit 3-8      not used
 */
enum LIBFSAPFS_ACCESS_FLAGS
{
	LIBFSAPFS_ACCESS_FLAG_READ	= 0x01,
/* Reserved: not supported yet */
	LIBFSAPFS_ACCESS_FLAG_WRITE	= 0x02
};

/* The file access macros
 */
#define LIBFSAPFS_OPEN_READ		( LIBFSAPFS_ACCESS_FLAG_READ )
/* Reserved: not supported yet */
#define LIBFSAPFS_OPEN_WRITE		( LIBFSAPFS_ACCESS_FLAG_WRITE )
/* Reserved: not supported yet */
#define LIBFSAPFS_OPEN_READ_WRITE	( LIBFSAPFS_ACCESS_FLAG_READ | LIBFSAPFS_ACCESS_FLAG_WRITE )

/* The path segment separator
 */
#define LIBFSAPFS_SEPARATOR		'/'

#endif /* !defined( _LIBFSAPFS_DEFINITIONS_H ) */

