
# Slot: mappings


A list of terms from different schemas or terminology systems that have comparable meaning. These may include terms that are precisely equivalent, broader or narrower in meaning, or otherwise semantically related but not equivalent from a strict ontological perspective.

URI: [linkml:mappings](https://w3id.org/linkml/mappings)


## Domain and Range

None ->  <sub>0..*</sub> [Uriorcurie](types/Uriorcurie.md)

## Parents


## Children

 *  [broad mappings](broad_mappings.md)
 *  [close mappings](close_mappings.md)
 *  [exact mappings](exact_mappings.md)
 *  [narrow mappings](narrow_mappings.md)
 *  [related mappings](related_mappings.md)

## Used by

 * [ClassDefinition](ClassDefinition.md)
 * [Definition](Definition.md)
 * [Element](Element.md)
 * [EnumDefinition](EnumDefinition.md)
 * [SchemaDefinition](SchemaDefinition.md)
 * [SlotDefinition](SlotDefinition.md)
 * [SubsetDefinition](SubsetDefinition.md)
 * [TypeDefinition](TypeDefinition.md)

## Other properties

|  |  |  |
| --- | --- | --- |
| **Mappings:** | | skos:mappingRelation |

