import numpy as np

RNG = np.random.default_rng(seed=0)  # Random Number Generator

"""The following two parameters were altered in the different experiments"""
FOG_DCS = 0
FOG_IDLE_SHUTDOWN = False

# TODO Logging

"""Simulation duration and intervals in simulated seconds"""
SIMULATION_TIME = 3600 * 24
UPDATE_MOBILITY_INTERVAL = 1
POWER_MEASUREMENT_INTERVAL = 1
UPDATE_WIFI_CONNECTIONS_INTERVAL = 60

"""City scenario parameters"""
STREETS_PER_AXIS = 4
BLOCK_SIZE_WIDTH = 274  # Manhattan
BLOCK_SIZE_HEIGHT = 80  # Manhattan
CITY_WIDTH = (STREETS_PER_AXIS + 1) * BLOCK_SIZE_WIDTH
CITY_HEIGHT = (STREETS_PER_AXIS + 1) * BLOCK_SIZE_HEIGHT

"""Taxi generation rate and speed distribution according to 2015 DEBS Grand Challenge dataset"""
MAX_CARS_PER_MINUTE = 75  # This parameter can be adapted to scale the simulation
TAXI_COUNT_DISTRIBUTION = [0.7061738625112995, 0.7029400370194998, 0.7053398476174078, 0.7111026214971374, 0.7048663423873273, 0.7015787094830184, 0.7053183246524041, 0.6968651801472171, 0.6924744952864706, 0.6902414876673411, 0.6890953897808962, 0.6827730188110714, 0.6834402307261849, 0.672259050406784, 0.6702574146614437, 0.6693265464250355, 0.6647582971030089, 0.6589901424820284, 0.6571391674917136, 0.6553473806551591, 0.6474592139813181, 0.6434505617493866, 0.6423421290516982, 0.638753174637338, 0.6380052516034609, 0.6276580861779518, 0.623670956911024, 0.6259362489776592, 0.6209106366493048, 0.6199959106366493, 0.6154922302096337, 0.6130978003529767, 0.6063987774955878, 0.6052365373853902, 0.6013516422022298, 0.5962668417201153, 0.5947548534286083, 0.5912681330980156, 0.5874101416211097, 0.5857421118333261, 0.586199474839654, 0.5807487839524773, 0.5804474624424261, 0.5783543540958203, 0.5726507683698506, 0.5721180749860101, 0.5678403856915328, 0.5644558994447075, 0.5647464594722569, 0.5577030691748095, 0.5541302569842022, 0.5523815160776548, 0.5486795660970255, 0.5468339718479618, 0.5466886918341871, 0.5400542378718092, 0.539876673410529, 0.5352869011234987, 0.5342753217683268, 0.5300083939563515, 0.5297393568938057, 0.5299115406138349, 0.5250957771942663, 0.526693857345788, 0.5239927252378288, 0.5203445826697086, 0.5207373767810254, 0.516405880074039, 0.5153673970126125, 0.511923722612027, 0.5084100985751797, 0.504229262623219, 0.5015496534802635, 0.49490981877663465, 0.4952165210279368, 0.4927306185700142, 0.48950217381946537, 0.4834434591709354, 0.48196375532693386, 0.48073156558047436, 0.4790635357926908, 0.4741024923593474, 0.4760664629159313, 0.4698140415823684, 0.4708040979725367, 0.46645107830054666, 0.46687077611811806, 0.46201196676854206, 0.4583423012354182, 0.4572876759502389, 0.4560393439800267, 0.4494802203951616, 0.44758619947483963, 0.4500559597090095, 0.4430018079290603, 0.44195794412638284, 0.4362328354354096, 0.43453790194137143, 0.4334886573974431, 0.429958891136843, 0.42814020059403385, 0.42555744479359475, 0.42357733201325815, 0.42204382075674746, 0.4200314235289053, 0.4198538590676252, 0.4171634884421678, 0.41338082734277476, 0.41468834746674704, 0.4126275235676467, 0.41012547888597134, 0.40929684473333044, 0.4063858637165856, 0.40454026946752186, 0.403770823468641, 0.4001657268305282, 0.3994124230554001, 0.397023373939994, 0.3976959665963583, 0.3943276225732857, 0.3903835392363652, 0.390900090396453, 0.39136283414403167, 0.3869452455770307, 0.3874833197021222, 0.3855623950755456, 0.38477680685291205, 0.38629955662692095, 0.38174206878739614, 0.3797135293358013, 0.37561878524385517, 0.37574792303387716, 0.3714702337393999, 0.37271318496836126, 0.36844625715638585, 0.36719792518617367, 0.3641147604493995, 0.3644322241832035, 0.362382161766605, 0.35897615255477594, 0.3594819422323619, 0.3558122766992381, 0.35240626748740905, 0.3503239206233051, 0.3469448151177306, 0.34571800611252207, 0.3462776032026172, 0.3422958546769403, 0.3414564590417976, 0.3413542249580302, 0.3375446601523826, 0.33749085273987345, 0.3361241444621411, 0.33155051439886357, 0.3299040075760837, 0.3281229822220309, 0.32869872153587876, 0.32637962205673454, 0.3204285222332228, 0.32024557703069173, 0.31614545219749474, 0.3173399767551978, 0.3170332745038957, 0.3128901037406913, 0.3107324264990745, 0.30924196117257113, 0.3094571908226077, 0.3058305712194912, 0.30676143945589945, 0.3010793766949335, 0.3023223279238948, 0.29978799879471396, 0.2997557143472085, 0.29970728767595023, 0.29638737032413587, 0.2955318324652404, 0.29151241875080713, 0.2913994231845379, 0.29079678016443544, 0.28989281563428176, 0.29229262623218977, 0.2881064095389781, 0.2890641814816409, 0.28879514441909515, 0.2847757307046619, 0.28293551719684906, 0.2821875941629719, 0.28112220739529076, 0.27943265464250355, 0.2770597477508502, 0.27574684688562695, 0.2743155697128836, 0.27055443157849424, 0.27111402866858936, 0.26901553958073265, 0.26683095863286127, 0.2639522620636219, 0.2620636218845508, 0.2585230941414489, 0.25970147647539926, 0.25506865825836167, 0.2540570789031897, 0.25093086823640826, 0.2514366579139942, 0.2494888295811631, 0.24520037880418408, 0.2447753002453618, 0.24546403512547887, 0.24311265119882916, 0.2418212732986096, 0.24120248805475442, 0.23996491756704402, 0.2399541560845422, 0.23697860617278638, 0.23518143859498084, 0.23733373509534675, 0.23595088459386165, 0.23452498816236925, 0.23266863243080366, 0.23046790925917954, 0.229870646980328, 0.22877835650639233, 0.22814342903878437, 0.2270188541173432, 0.22899896689767982, 0.22782596530498042, 0.2274600748999182, 0.22549610434333434, 0.22545305841332702, 0.22532392062330506, 0.22600189402092033, 0.22345680340923765, 0.2242101071843657, 0.22446300202315872, 0.22298329817915716, 0.22472127760320262, 0.22384421677930352, 0.22398949679307822, 0.22346218415048857, 0.22593194438465844, 0.2219017691877233, 0.2274546941586673, 0.23259330205329087, 0.23555809048254486, 0.23471331410615126, 0.23439585037234728, 0.23532671860875554, 0.2325717790882872, 0.23221665016572682, 0.2320229434806939, 0.22790667642374413, 0.2254799621195816, 0.22218156773277087, 0.2157623434204296, 0.2158322930566915, 0.2122218156773277, 0.209805862855667, 0.2081701175153889, 0.20525375575739313, 0.20136347983298178, 0.19996986784899487, 0.19634862898712926, 0.19487430588437862, 0.19192027893762645, 0.1872659377555852, 0.1853988205415178, 0.18299362920235893, 0.18091128233825493, 0.17961990443803538, 0.17642374413499204, 0.17379256166329474, 0.1725388489518316, 0.17232900004304594, 0.16728186474968793, 0.16681912100210924, 0.16382742886660065, 0.16352610735654943, 0.16279970728767595, 0.15923227583831948, 0.15600921182902155, 0.15503529766260601, 0.155729413283974, 0.15272695966596359, 0.1511611639619474, 0.15243101889716326, 0.1504670483405794, 0.14976217123670957, 0.14602255606732384, 0.14609250570358573, 0.1435258921268994, 0.14456975592957685, 0.14302010244931343, 0.14314385949808445, 0.14293401058929878, 0.14023287848133958, 0.13657935517196848, 0.13867784425982524, 0.13564310619430933, 0.13521802763548707, 0.13430330162283155, 0.13203800955619646, 0.1325276570100297, 0.13293659334509922, 0.13242542292626233, 0.1334800482114416, 0.13343162154018337, 0.1335876630364599, 0.13376522749774009, 0.13200572510869096, 0.13127394429856656, 0.13223709698248032, 0.13090805389350438, 0.13132775171107572, 0.13027850716714734, 0.13046145236967846, 0.13244156515001507, 0.1324899918212733, 0.13217790882872024, 0.13388898454651113, 0.13502970169170506, 0.13565924841806207, 0.13596056992811328, 0.13590138177435324, 0.13598209289311697, 0.13703133743704532, 0.13733265894709656, 0.1390598768886402, 0.1389953079936292, 0.14059338814515088, 0.14327837802935733, 0.14935323490164004, 0.1513172054582239, 0.1526946752184581, 0.15500839395635144, 0.1549976324738496, 0.15669256596788775, 0.16027075889974604, 0.1616858938487366, 0.16512418750807112, 0.16628104687701778, 0.16920817011751538, 0.17047264431148035, 0.17561663294735483, 0.17495480177349232, 0.17949076664801342, 0.18248783952477293, 0.18354784555120313, 0.18789010374069132, 0.18923528905342, 0.18694309328053033, 0.19056433214239593, 0.18904158236838706, 0.1913929662950368, 0.19432547027678532, 0.1961818260083509, 0.19478283328311308, 0.19600964228832163, 0.19524019628944084, 0.1963217252808747, 0.19619258749085275, 0.19685979940596618, 0.1966445697559296, 0.2005240841978391, 0.20309069777452543, 0.2041130386121992, 0.2068841203564203, 0.20886961387800784, 0.21093043777710818, 0.21699453316688908, 0.22100318539882055, 0.2245329516594206, 0.23112974043304205, 0.23603159571262536, 0.23821079591924585, 0.2465670870819164, 0.24615277000559596, 0.2497740088674616, 0.2537557573931385, 0.2575545607162843, 0.26182686926951054, 0.2675681201842366, 0.27064052343850886, 0.27522491498428825, 0.27936270500624166, 0.2843506521458396, 0.2841730876845594, 0.28878438293659336, 0.29272846627351384, 0.29302440704231414, 0.29942748913090267, 0.30610498902328787, 0.31173324437174466, 0.31937927768929447, 0.3272190176918772, 0.3338319486892514, 0.34205910206190004, 0.350517627308338, 0.35876630364599027, 0.3705770306917481, 0.3793584004132409, 0.3891029228186475, 0.3954037708234686, 0.4031681804485386, 0.41228315612758815, 0.42238280745555506, 0.42480952175971765, 0.4287428436141363, 0.43304205587361716, 0.43752421333562913, 0.43765873186690196, 0.4384335586070337, 0.44123154405750936, 0.43899853643837977, 0.4420870819164048, 0.4394020920321984, 0.4369699969867849, 0.43266540398605313, 0.43253626619603114, 0.4367547673367483, 0.4353988205415178, 0.43502754939520466, 0.43859498084456117, 0.4397356979897551, 0.4438035383754466, 0.4484202143687314, 0.45452735568851965, 0.46282983943868106, 0.46660711979682323, 0.47476970427446086, 0.4793271921139856, 0.48419676294606345, 0.489652834574491, 0.49308036675132366, 0.4943986483577978, 0.5025020446816754, 0.5071779088287203, 0.5112134647669063, 0.5182084283930954, 0.5223946450863071, 0.5247890749429641, 0.5262956824932202, 0.5284641212173389, 0.5298846369075804, 0.5335004950281951, 0.5394515948517068, 0.5381978821402437, 0.5420128276871422, 0.5454726443114803, 0.553253196160303, 0.5558574749257458, 0.5644558994447075, 0.5665759114975679, 0.5763903835392363, 0.5802645172398949, 0.5859842451896173, 0.5948140415823684, 0.6078892428220912, 0.6122584047178339, 0.6218845508157204, 0.6271146313116095, 0.6300363738108562, 0.6350512246567087, 0.638381903491025, 0.640146786621325, 0.6470610391287503, 0.6444890448108131, 0.6480403340364168, 0.6502679609142955, 0.653770823468641, 0.6541689983212088, 0.6531574189660367, 0.6515970040032715, 0.653265033791055, 0.6467920020662047, 0.6506930394731179, 0.6444567603633077, 0.641847100856614, 0.6417125823253411, 0.6390006887348801, 0.6382097197709956, 0.6386025138823124, 0.6374564159958676, 0.6407494296414274, 0.64500021522965, 0.6529260470922474, 0.6575965304980415, 0.6602976626060006, 0.6662810468770177, 0.6668137402608584, 0.673082303818174, 0.6724635185743189, 0.6782370539365503, 0.679582239249279, 0.6784361413628341, 0.6851190219964702, 0.6871045155180577, 0.6847369893676553, 0.6890200594033834, 0.6904674787998795, 0.6877663466919203, 0.6915597692738151, 0.6915382463088116, 0.6885896001033103, 0.685135164220223, 0.6837038870474796, 0.6791517799492058, 0.681723774267143, 0.6809543282682622, 0.6814547372045973, 0.6839836855925272, 0.6904836210236323, 0.688541173432052, 0.6939649606129741, 0.6995501700314235, 0.699517885583918, 0.7040161852696828, 0.7121895312298222, 0.7178231673195299, 0.7216596358314321, 0.7233169041367139, 0.7322489346132324, 0.7306400929792088, 0.7369086565365245, 0.7331313761783823, 0.7339331066247686, 0.7352782919374973, 0.7378556669966855, 0.7386358744780681, 0.7418051310748569, 0.7440811846239938, 0.7438982394214627, 0.7354074297275193, 0.738452929275537, 0.7312158322930566, 0.7262225044122078, 0.7225044122078258, 0.7184042873746287, 0.715923765657957, 0.7145140114502174, 0.709929619904438, 0.711635314880978, 0.7121249623348113, 0.7091171279755499, 0.7108389651758427, 0.7123617149498515, 0.7076320433902974, 0.7148045714777668, 0.7159721923292153, 0.7182536266196031, 0.7199485601136413, 0.7227250225991133, 0.7192867289397787, 0.7220847143902545, 0.7184634755283887, 0.7208848090913004, 0.724947268735741, 0.7238226938142999, 0.7219017691877233, 0.7238011708492962, 0.7248181309457191, 0.7205081572037364, 0.7184742370108906, 0.7174196117257113, 0.7167846842581034, 0.7175272265507296, 0.7089664672205243, 0.7080840256553743, 0.7117052645172399, 0.7061523395462959, 0.7084606775429383, 0.7080086952778615, 0.7069594507339331, 0.7096498213593905, 0.7091225087168008, 0.707212345572726, 0.7105537858895441, 0.7205458223924928, 0.7201637897636779, 0.7279228186474969, 0.7339384873660195, 0.7346541259523912, 0.7403308079721063, 0.7452918514054496, 0.7426768111575051, 0.7449205802591365, 0.7497578666437088, 0.7507210193276226, 0.7513936119839869, 0.755111704188369, 0.7462281003831088, 0.7522437691016315, 0.7484019198484784, 0.7461742929705997, 0.7385228789117989, 0.7325771598295381, 0.7230855322629245, 0.7157246782316732, 0.7126307520123972, 0.7043013645559812, 0.6998030648702165, 0.6944061813955491, 0.684946838276441, 0.6871367999655632, 0.6857539494640782, 0.6835747492574578, 0.6810511816107787, 0.6871906073780724, 0.6814009297920881, 0.682670784727304, 0.6837200292712324, 0.6835478455512032, 0.6828106839998278, 0.6864964917567044, 0.6842903878438293, 0.6868462399380139, 0.693900391717963, 0.686770909560501, 0.6891384357109035, 0.6907688003099307, 0.6901769187723301, 0.6870722310705523, 0.6875295940768801, 0.6819820498471869, 0.6844302871163531, 0.6865341569454608, 0.6817560587146485, 0.6821488528259653, 0.6795660970255263, 0.6785760406353579, 0.6803409237656579, 0.6818260083509105, 0.679829753346821, 0.6850490723602083, 0.6894128535147002, 0.6906934699324179, 0.692259265636434, 0.7078418922990831, 0.708358443459171, 0.7116245533984762, 0.7231016744866773, 0.7248019887219663, 0.7260180362446731, 0.7360423571951272, 0.7338039688347466, 0.7381892729542422, 0.7425638155912359, 0.7402554775945934, 0.7417836081098532, 0.7445008824415652, 0.7420311222073953, 0.7423109207524429, 0.7406375102234084, 0.7348263096724205, 0.7267444363135466, 0.723559037493005, 0.713082734277474, 0.7132979639275107, 0.702423485859412, 0.6958482200507942, 0.6930502346003186, 0.688923206060867, 0.6802440704231415, 0.6847100856614007, 0.6828967758598424, 0.6803947311781671, 0.6818582927984159, 0.689106151263398, 0.6867224828892429, 0.6889447290258706, 0.6940349102492359, 0.690376006198614, 0.694158667298007, 0.6966284275321768, 0.6944546080668073, 0.694664456975593, 0.7009330205329086, 0.6959504541345616, 0.69876458180879, 0.7061146743575395, 0.6963432482458783, 0.700152813051526, 0.7046511127372906, 0.6999106796952348, 0.700717790882872, 0.7022243984331281, 0.6990067151650812, 0.696929749042228, 0.7007285523653739, 0.6966929964271878, 0.6975754379923378, 0.7051192372261202, 0.7068733588739184, 0.7072769144677371, 0.7098865739744307, 0.7138575610176058, 0.7198570875123758, 0.7307477078042272, 0.7313503508243295, 0.7404545650208773, 0.7493489303086394, 0.748547199862253, 0.7552462227196418, 0.7666264904653265, 0.7604440187680255, 0.76994102707589, 0.7763548706469803, 0.7734815548189918, 0.7787869656923938, 0.7881655976927382, 0.7801482932288752, 0.7864491412336964, 0.7861155352761396, 0.7836081098532134, 0.7753217683268047, 0.7757629891093797, 0.7658785674314493, 0.763381903491025, 0.7587329430502346, 0.7515550342215144, 0.7481328827859326, 0.754605914510783, 0.7421172140674099, 0.7456738840342646, 0.7513021393827214, 0.7531692565967888, 0.7525773750591882, 0.7597122379579011, 0.7564837932073523, 0.7651575481038267, 0.7698441737333735, 0.7671538031079161, 0.7761073565494383, 0.7780390426585166, 0.7750473505230081, 0.7745038956566657, 0.7821445482329645, 0.7745738452929275, 0.7750688734880117, 0.7835004950281951, 0.7745630838104257, 0.7742671430416254, 0.7727551547501184, 0.7666318712065774, 0.7642751065386768, 0.7660776548577332, 0.7537342344281348, 0.7532553484568034, 0.7510546252851793, 0.7500107614825018, 0.745582411432999, 0.7505811200550988, 0.7420956911024063, 0.745388704747966, 0.7490906547285954, 0.7450820024966639, 0.7469975463819896, 0.7482135939046963, 0.7511245749214411, 0.7632742886660067, 0.7656525762989109, 0.7628384486246825, 0.7645064784124661, 0.7726098747363437, 0.7707373767810254, 0.7726206362188455, 0.7804496147389265, 0.7705490508372433, 0.7759513150531617, 0.7822037363867247, 0.7780605656235203, 0.7785340708536008, 0.7766185269682752, 0.7701993026559338, 0.7725453058413327, 0.7730510955189187, 0.758899746029013, 0.7572048125349748, 0.754611295252034, 0.744382506134045, 0.7405406568808919, 0.7456523610692609, 0.7347725022599113, 0.7377157677241617, 0.739023287848134, 0.7372745469415867, 0.7392438982394215, 0.7460559166630795, 0.7409334509922086, 0.7423539666824501, 0.7457599758942792, 0.7444040290990487, 0.7476755197796049, 0.7486332917222677, 0.7436614868064224, 0.7442210838965175, 0.7426929533812578, 0.7405406568808919, 0.7444632172528087, 0.7467554130256984, 0.7418105118161078, 0.7467016056131893, 0.7429888941500581, 0.7415522362360639, 0.7407343635659248, 0.7418481770048642, 0.7349124015324351, 0.7351545348887263, 0.7427682837587706, 0.7394376049244544, 0.7389102922818648, 0.746405664844389, 0.7348424518961733, 0.7505326933838405, 0.7470943997245061, 0.7455662692092463, 0.7547242908183032, 0.7634464723860359, 0.7557143472084714, 0.7657978563126856, 0.7683967543368775, 0.7680201024493134, 0.7734923163014937, 0.7792012827687143, 0.7734600318539882, 0.7772642159183849, 0.7854375618785244, 0.7802612887951444, 0.784076234342043, 0.7896722052429943, 0.7802666695363953, 0.7850393870259567, 0.785082432955964, 0.7777538633722182, 0.7758167965218888, 0.7765539580732642, 0.7671645645904179, 0.7679447720718006, 0.7692738151607765, 0.7593033016228316, 0.7582701993026559, 0.7629944901209591, 0.753282252163058, 0.7572801429124876, 0.7654965348026345, 0.761864534458267, 0.7649476991950411, 0.7694459988808058, 0.7656687185226637, 0.7716790064999355, 0.7747245060479532, 0.7697419396496061, 0.7735730274202575, 0.7800837243338642, 0.7704791012009814, 0.7763925358357368, 0.7758598424518962, 0.7733201325814644, 0.7738582067065559, 0.7776570100297017, 0.7747567904954586, 0.7775870603934398, 0.7793680857474926, 0.7720395161637467, 0.7758275580043907, 0.7748052171667169, 0.7682191898755972, 0.7725022599113254, 0.7738958718953123, 0.7689724936507253, 0.7713615427661314, 0.773094141448926, 0.7695912788945806, 0.7747460290129569, 0.7801967199001334, 0.7783026989798114, 0.7817248504153932, 0.7918460247083638, 0.7825965304980415, 0.7914155654082906, 0.7959461495415608, 0.7931427833498342, 0.7936378115449184, 0.8029626361327536, 0.798840988334553, 0.7938907063837114, 0.7983567216219707, 0.7986634238732728, 0.7956394472902587, 0.8006435366536094, 0.7955533554302441, 0.7949722353751453, 0.7917814558133528, 0.7893547415091903, 0.7858249752485903, 0.7823328741767466, 0.778964530153674, 0.7764571047307477, 0.7734385088889846, 0.7684720847143902, 0.7633227153372648, 0.7714906805561534, 0.7649584606775429, 0.7699195041108863, 0.76994102707589, 0.7700055959709009, 0.7775978218759416, 0.7833175498256639, 0.7772157892471266, 0.7789860531186776, 0.7835435409582024, 0.7746330334466877, 0.7738582067065559, 0.7746276527054367, 0.7648077999225174, 0.7681707632043391, 0.7692791959020274, 0.7622573285695837, 0.7623757048771038, 0.7664865911928027, 0.759152640867806, 0.7571241014162111, 0.757441565150015, 0.7522599113253842, 0.7513936119839869, 0.7534382936593345, 0.7435108260513968, 0.7424831044724721, 0.7407128406009211, 0.7349285437561879, 0.7398088760707675, 0.7392546597219233, 0.7358809349575998, 0.7392600404631742, 0.7386358744780681, 0.7384152640867806, 0.7394214627007016, 0.7389479574706211, 0.7351922000774826, 0.7363921053764366, 0.7402393353708406, 0.7346218415048857, 0.7310328870905256, 0.7297146054840515, 0.7246459472256898, 0.7240540656880892, 0.722800352976626, 0.7201906934699324, 0.7169245835306272, 0.7183666221858723, 0.7137069002625802, 0.7117967371185054, 0.7100103310232018, 0.7009222590504068, 0.6993026559338814, 0.6969727949722354, 0.683929878180018, 0.6868570014205156, 0.6834994188799449, 0.6707632043390297, 0.6688691834187077, 0.6832734277474065, 0.6752184580947871, 0.6740669794670914, 0.6724742800568206, 0.6706932547027679, 0.6677553699797684, 0.6718501140717145, 0.6650004304593, 0.6662595239120142, 0.662982652490207, 0.6579624209031036, 0.6565580474366148, 0.6540560027549395, 0.646641341311179, 0.6488366837415522, 0.6428048727992768, 0.6356915328655676, 0.638441091644785, 0.6338136541689984, 0.6305152597821876, 0.6270016357453403, 0.6254573630063277, 0.6175853385562395, 0.6167728466273514, 0.6169665533123844, 0.6076094442770436, 0.6100253970987043, 0.6053387714691576, 0.602788300116224, 0.6004638198958289, 0.6015776333347682, 0.5995921398131807, 0.6035954113038612, 0.6056400929792088, 0.5956372949937584, 0.6004853428608325, 0.6027452541862167, 0.5987796478842925, 0.5968748654814687, 0.5975044122078258, 0.5942113985622659, 0.5949808445611467, 0.5958794283500495, 0.5907031552666695, 0.5949324178898885, 0.594900133442383, 0.5899337092677888, 0.5960892772588352, 0.596734966208945, 0.5929146399207955, 0.6012494081184624, 0.5982254315354483, 0.5984083767379794, 0.5980424863329172, 0.601405449614739, 0.5979671559554044, 0.6049190736515863, 0.6084111747234299, 0.6114997202014549, 0.6141685678619087, 0.6236601954285222, 0.623229736128449, 0.6293691618957428, 0.6410507511514786, 0.6438056906719469, 0.6478251043863803, 0.6639135207266152, 0.6620679264775515, 0.6727809823081228, 0.6793401058929878, 0.6781993887477938, 0.6858454220653437, 0.6894074727734493, 0.6930179501528131, 0.6992111833326159, 0.7051838061211313, 0.7057810683999828, 0.7067388403426456, 0.7164995049718049, 0.7194427704360553, 0.7226819766691059, 0.7291012009814472, 0.7265668718522663, 0.7376673410529034, 0.7382161766604968, 0.7369517024665317, 0.7444147905815505, 0.7466047522706728, 0.7477616116396195, 0.7512537127114631, 0.7606538676768112, 0.7640491154061384, 0.7678479187292842, 0.7771942662821231, 0.7768821832895699, 0.7865244716112092, 0.7886713873703242, 0.7930351685248159, 0.8024084197839094, 0.8064385949808446, 0.8063901683095863, 0.8067668201971504, 0.8181148034953295, 0.8171408893289139, 0.8244533166889071, 0.8274127243769102, 0.825464896044079, 0.8285480607808532, 0.8386638543325728, 0.8387660884163403, 0.8411013301192373, 0.8458094787137876, 0.8439638844647238, 0.8474021781240584, 0.8504046317420688, 0.8458040979725368, 0.8464336446988937, 0.8518843355860704, 0.8479402522491498, 0.8515076836985063, 0.857082131634454, 0.8567700486419009, 0.863829581163101, 0.8771522965003659, 0.8779325039817485, 0.88452929275537, 0.8914704489690499, 0.8916533941715811, 0.8965283457449098, 0.8994931341741639, 0.8974323102750635, 0.9000204468167535, 0.910211570745986, 0.9023395462958977, 0.9151618526968275, 0.9103837544660153, 0.915317894193104, 0.9187615685936895, 0.9218985407429727, 0.9201228961301708, 0.9190252249149843, 0.9199883775988981, 0.923771038698291, 0.922953166028152, 0.9245835306271792, 0.9176800396022556, 0.9235073823769963, 0.9213604666178813, 0.922076105204253, 0.9245996728509319, 0.9254552107098274, 0.921946967414231, 0.927182428651371, 0.9295338125780207, 0.9293508673754897, 0.9344571908226077, 0.9411077870087383, 0.9381914252507425, 0.9453478111144591, 0.9512773879729671, 0.9461710645258491, 0.9585360079204511, 0.9635347165425509, 0.9603869829107657, 0.9655847789591494, 0.9709332357625586, 0.9676456028582497, 0.9752485902457922, 0.9805701433429469, 0.9750333605957556, 0.9816086264043735, 0.9860423571951272, 0.9801504455253756, 0.9744630020231587, 0.97476432353321, 0.9698086608411175, 0.9686625629546727, 0.9679953510395592, 0.9642503551289225, 0.9650574663165598, 0.9681083466058285, 0.9637069002625802, 0.9642449743876716, 0.9687917007446946, 0.9705404416512419, 0.9720147647539925, 0.9791872928414619, 0.9766099177822737, 0.9767013903835392, 0.9826686324308037, 0.9782564246050536, 0.9808068959579872, 0.9851114889587189, 0.9827654857733201, 0.9874574921441178, 0.9932848349188584, 0.9856172786363049, 0.991358529551031, 0.9942103224140157, 0.9914500021522965, 0.9957868796005338, 1.0, 0.9900241057208041, 0.9888780078343593, 0.9873875425078559, 0.981199690069304, 0.9757436184408764, 0.9800966381128664, 0.9729617752141535, 0.972364512935302, 0.9710300891050752, 0.9653910722741165, 0.969206017821015, 0.9617267874822436, 0.960435409582024, 0.9593538805905901, 0.9644978692264646, 0.960247083638242, 0.9717887736214541, 0.9738980241918127, 0.9680276354870647, 0.9717511084326977, 0.9767336748310447, 0.9736074641642632, 0.9702714045886961, 0.976405449614739, 0.9738334552968017, 0.9739518316043219, 0.9785954113038612, 0.972547458137833, 0.9723806551590547, 0.9728057337178769, 0.9709547587275623, 0.9640028410313805, 0.9640136025138824, 0.9564913262451036, 0.9527032844044595, 0.9506047953166028, 0.9475162498385777, 0.9425874908527399, 0.942582110111489, 0.9393160001721838, 0.939870216521028, 0.9416028152038225, 0.9404674787998795, 0.9376856355731565, 0.9482964573199604, 0.9460742111833326, 0.9412584477637639, 0.9462786793508674, 0.9423991649089578, 0.9381968059919935, 0.9399509276397917, 0.9382183289569971, 0.9374381214756144, 0.939106151263398, 0.9357808531703328, 0.93582389910034, 0.9406450432611596, 0.9331711936636391, 0.9319874305884379, 0.9303785889544144, 0.9247072876759502, 0.9212582325341139, 0.9245996728509319, 0.9160281520382247, 0.9177553699797684, 0.9200314235289053, 0.9114329990099436, 0.9074189660367612, 0.912100210925057, 0.906800180792906, 0.9063374370453273, 0.9055733717876975, 0.9030390426585166, 0.903329602686066, 0.9010105032069218, 0.9034479789935862, 0.9041098101674486, 0.9036309241961172, 0.9064988592828548, 0.9044111316774999, 0.9085004950281951, 0.9062943911153201, 0.9083390727906676, 0.9104752270672808, 0.9110886315698851, 0.9091677069433085, 0.9200206620464035, 0.9136229606990659, 0.9167868365546038, 0.921129094744092, 0.9125252894838793, 0.9160981016744867, 0.9245996728509319, 0.9077525719943179, 0.9103622315010116, 0.9106420300460591, 0.9101739055572295, 0.9066279970728768, 0.9093936980758469, 0.9098456803409237, 0.9100609099909603, 0.9111908656536525, 0.91235310576385, 0.9123154405750936, 0.9179598381473032, 0.9126598080151521, 0.9107980715423357, 0.9139242822091171, 0.9071606904567173, 0.9072898282467393, 0.90805927424562, 0.9023718307434032, 0.9035017864060954, 0.9076395764280487, 0.9022050277646249, 0.9004240024105721, 0.9030121389522621, 0.9012903017519693, 0.8978466273513839, 0.9032542723085533, 0.897276268778787, 0.9030498041410184, 0.9028560974559855, 0.901252636563213, 0.9009835995006672, 0.9019951788558391, 0.8959203219835564, 0.8916211097240756, 0.8973139339675433, 0.8975775902888382, 0.8983900822177263, 0.9027753863372218, 0.9022480736946322, 0.8987990185527959, 0.8997783134604623, 0.8970879428350049, 0.9009351728294089, 0.9004724290818303, 0.8983685592527226, 0.8987613533640394, 0.9009351728294089, 0.8961247901510913, 0.9002625801730446, 0.9077740949593216, 0.9005100942705867, 0.8994500882441565, 0.9054011880676682, 0.9018714218070681, 0.90017648831303, 0.9053366191726572, 0.9043196590762344, 0.9017369032757953, 0.9061275881365417, 0.8970718006112522, 0.8979380999526495, 0.9029421893160001, 0.8948334122508717, 0.8992725237828764, 0.9039483879299213, 0.9012849210107184, 0.9071068830442082, 0.9074082045542594, 0.9113200034436744, 0.9058316473677414, 0.9117773664500022, 0.904976109508846, 0.9044918427962636, 0.9072683052817356, 0.9011073565494383, 0.8961247901510913, 0.8986967844690285, 0.893429038784383, 0.8931600017218372, 0.8908301407601911, 0.8829043088975937, 0.8864233136756919, 0.889199776161164, 0.8840127415952822, 0.8826245103525462, 0.8814730317248504, 0.8807251086909733, 0.8783844862468254, 0.8745695406999269, 0.8739615169385735, 0.8737193835822823, 0.8763559467952305, 0.8714540915156472, 0.8675530541087341, 0.8700550987904093, 0.8748547199862253, 0.8682095045413456, 0.8728477034996341, 0.8707384529292755, 0.8730844561146743, 0.8714218070681417, 0.8706308381042572, 0.8663961947397874, 0.8661486806422453, 0.8628987129266927, 0.8661432999009944, 0.865976496922216, 0.8673754896474538, 0.8620270328440446, 0.8593850888898454, 0.8597455985536567, 0.8576955361370583, 0.86111768757264, 0.8575287331582799, 0.8567861908656537, 0.8573995953682579, 0.8544993758340149, 0.8529281993887478, 0.8513839266497353, 0.8473376092290474, 0.8464444061813956, 0.8425810339632388, 0.8412250871680083, 0.8402780767078473, 0.8364362274546941, 0.8401973655890835, 0.8410744264129827, 0.8446849037923464, 0.8413488442167794, 0.8379482157462012, 0.8403534070853601, 0.8343538805905901, 0.8285426800396023, 0.8328795574878395, 0.8223655890835522, 0.81852912057165, 0.8167104300288408, 0.8147841246610134, 0.8103988205415178, 0.8080366751323662, 0.7992337824458697, 0.8026344109164478, 0.8002130773535362, 0.7904039860531187, 0.7885852955103095, 0.7897636778442598, 0.7875199087426283, 0.7838771469157592, 0.7849909603546985, 0.7785017864060954, 0.7817625156041497, 0.7842807025095777, 0.7782435108260514, 0.779658645775042, 0.7779852352460075, 0.7728573888338858, 0.774611510481684, 0.774988162369248, 0.7677026387155095, 0.7655826266626491, 0.7630213938272137, 0.7591580216090569, 0.761046661788128, 0.7558058198097369, 0.7508393956351427, 0.7507802074813826, 0.7504035555938185, 0.7451411906504241, 0.7479553183246525, 0.7423324437174466, 0.7372584047178339, 0.7395075545607163, 0.7348962593086824, 0.7316301493693771, 0.7311082174680384, 0.7298867892040808, 0.7218910077052215, 0.7232146700529465, 0.7169461064956308, 0.7157569626791787, 0.7104784555120314, 0.7052806594636477, 0.7073199603977444, 0.7039354741509191]
TAXI_SPEED_DISTRIBUTION = [6.524102629210642, 6.546463526945012, 6.567956705367584, 6.588598903461066, 6.608406860208169, 6.627397314591603, 6.645587005594075, 6.662992672198297, 6.679631053386977, 6.695518888142825, 6.7106729154485505, 6.725109874286861, 6.738846503640469, 6.751899542492082, 6.76428572982441, 6.776021804620163, 6.787124505862049, 6.797610572532777, 6.807496743615059, 6.816799758091603, 6.825536354945118, 6.833723273158315, 6.841377251713901, 6.848515029594587, 6.855153345783083, 6.861308939262097, 6.8669985490143395, 6.872238914022519, 6.877046773269345, 6.881438865737529, 6.885431930409777, 6.8890427062688016, 6.89228793229731, 6.895184347478013, 6.897748690793619, 6.899997701226838, 6.90194811776038, 6.903616679376953, 6.905020125059267, 6.906175193790033, 6.907098624551958, 6.907807156327753, 6.9083175281001274, 6.908646478851789, 6.908810747565449, 6.908827073223817, 6.908712194809601, 6.908482851305511, 6.908155781694256, 6.907747724958547, 6.907275420081092, 6.906755606044601, 6.9062050218317825, 6.905640406425348, 6.905078498808004, 6.904536037962463, 6.904029762871432, 6.903576412517622, 6.903192725883742, 6.902895441952501, 6.902701299704348, 6.906754768594559, 6.921966696801165, 6.940822456870921, 6.95263767034037, 6.953010727998542, 6.965824591489537, 6.9715608612509055, 6.9602133996610025, 6.985033953736527, 6.988722991763325, 6.992676161312925, 7.014573654255106, 7.0274598892365265, 7.033261897654854, 7.034390138948801, 7.053793978683457, 7.04693821635852, 7.039699507413591, 7.044834173527815, 7.048775034660343, 7.052733340158507, 7.043414592231259, 7.056092337471228, 7.063643999064063, 7.061799985510275, 7.08122977104021, 7.096520994178246, 7.114321949199943, 7.1274009982281195, 7.148798016943959, 7.169600433825675, 7.184033164976006, 7.1832959139471, 7.202088307842684, 7.1991734331941855, 7.182330389884138, 7.183327595892526, 7.197344132321815, 7.224252184352763, 7.240730520968947, 7.246840640265434, 7.236845851135065, 7.243757926624717, 7.249424495182015, 7.266872453503202, 7.263209010956104, 7.275384674530802, 7.272264523057485, 7.255251456793475, 7.267994887486499, 7.272460540431561, 7.261881435369434, 7.261510182829127, 7.24611825976673, 7.232495539637871, 7.228507026583065, 7.2217358831304965, 7.2073504973556055, 7.246539701098323, 7.245512356799288, 7.253431776752833, 7.2706131996082926, 7.2577628315148965, 7.269625862688431, 7.282016108823393, 7.268666587923187, 7.270531250394879, 7.2584500939389205, 7.259467231812541, 7.2788423786154075, 7.259639216693311, 7.251404053093822, 7.274451173554011, 7.276381464567414, 7.269006698580725, 7.260471852845345, 7.236977486235393, 7.2198417089706775, 7.2035287014154425, 7.216923828933154, 7.187292328457201, 7.173184108050412, 7.178846551532479, 7.166595887875709, 7.136352124420731, 7.131468699883739, 7.132898957261751, 7.1615886544191625, 7.1418427245945875, 7.140223837709636, 7.141516190667834, 7.162072569878241, 7.189246665874084, 7.190663273242901, 7.190892930208257, 7.158100256037898, 7.143842459070865, 7.114427247717186, 7.113299870011195, 7.11184778471377, 7.0998073493363565, 7.083767122287067, 7.0674079627815445, 7.067312118409815, 7.083748330770252, 7.090406350557365, 7.072399917954618, 7.047410627123433, 7.045438499367952, 7.044584501380668, 7.030250591576786, 7.015339394546216, 7.025649686942931, 7.003853176282017, 7.007924361769409, 7.029961895484334, 7.030543522466083, 7.02300112202421, 7.01504267586673, 7.016592370675228, 7.049599465349111, 7.0375124925195545, 7.036740021833623, 7.049822722076894, 7.052378957011858, 7.053502970206422, 7.058398636941843, 7.06328677913391, 7.075626340060527, 7.066743076950424, 7.068767112266865, 7.092716951375364, 7.064910112955846, 7.072578742076242, 7.088753786570413, 7.096467396649197, 7.090469484708122, 7.09430825158062, 7.100742189954183, 7.098550821568355, 7.119913038745491, 7.112075020558897, 7.13767178962133, 7.1268820868267655, 7.112303187823884, 7.11066669886113, 7.124486607501596, 7.136977020985357, 7.116918219804155, 7.121134272002295, 7.0903591335317495, 7.106475422299277, 7.087590041634059, 7.113060087263392, 7.101432737941812, 7.111588052631307, 7.132284328916556, 7.122829859441274, 7.0896323797581005, 7.094431695509833, 7.076601321075422, 7.06156760090906, 7.105357836763098, 7.132211929763713, 7.149024036793291, 7.114805641497647, 7.148052090268684, 7.132780344355716, 7.166425951679274, 7.170409194848647, 7.157249331484322, 7.196426905891478, 7.188985699815198, 7.210082026766931, 7.208962653273003, 7.221561265346945, 7.226311251002797, 7.232935635100388, 7.276163917990072, 7.293955605512372, 7.303031851389701, 7.332728380405331, 7.353545867548627, 7.426349418566988, 7.430480859404816, 7.424576376682491, 7.4788178409462045, 7.51974031658977, 7.530293881181777, 7.601026557354277, 7.594042976345452, 7.649621370416259, 7.667413881128461, 7.71760631837079, 7.723589451271976, 7.7415149243982, 7.7635048880336734, 7.825171320371885, 7.917193935399905, 7.9674114154767395, 7.980618520798833, 8.019900835990265, 8.061649786213106, 8.083599642600896, 8.117373871791207, 8.167349208058281, 8.206476835976238, 8.284772369496524, 8.324926467881909, 8.401522971648662, 8.435469519335417, 8.471436843406195, 8.487375369952318, 8.555359213279253, 8.591980101948234, 8.610920984531937, 8.716672573102334, 8.766483560091816, 8.81687534578692, 8.907738068035439, 8.962475843138638, 8.987189770241455, 9.023345866562451, 9.099020241995685, 9.123922328445177, 9.162748522292286, 9.186756508417457, 9.221553395175029, 9.294792944754736, 9.331191455964003, 9.368978918859431, 9.405693418172081, 9.44423554717214, 9.472257387726993, 9.525427666934956, 9.574262175929377, 9.605661591700805, 9.624016739384366, 9.698780824344636, 9.724161148670298, 9.790445248691324, 9.837810066090436, 9.899872086537647, 9.934860776508835, 9.950526508763922, 9.96283984782749, 10.028394734206639, 10.035778419136637, 10.042225157695109, 10.049229199222863, 10.072248235246787, 10.087905314560025, 10.098929445511855, 10.165573593113107, 10.16428749669205, 10.187295913294859, 10.18127214750355, 10.187939295467284, 10.190363604092898, 10.225786959957736, 10.23898839684163, 10.222323153674967, 10.25023506940813, 10.241551083948472, 10.256227856121368, 10.26416384808002, 10.272539396670458, 10.248944001365905, 10.22344388240544, 10.242565788397123, 10.258035282361382, 10.273866935102985, 10.253537283059917, 10.256103637830387, 10.222049454176169, 10.227862298226114, 10.20438525596818, 10.190899748612264, 10.206547364577274, 10.203372510764481, 10.160589296789178, 10.15295171423733, 10.149474704721039, 10.105957793074829, 10.057408400738444, 10.043615336493366, 10.052250844588889, 10.007016776404347, 9.990289412762216, 9.93091554145118, 9.923296824320824, 9.916270264017681, 9.85627663206155, 9.854198220904138, 9.792763463772502, 9.772452200939066, 9.75518655276341, 9.746552368906503, 9.745444915666727, 9.697195079265633, 9.678130054800665, 9.664761198248495, 9.619620384693699, 9.5887305468941, 9.522694511326003, 9.502427349146888, 9.490559001707936, 9.444262984826127, 9.397064364422988, 9.378262174879694, 9.308981136604714, 9.299677728951297, 9.250286227929777, 9.235134235840336, 9.167436111445468, 9.150007863932837, 9.127983763831988, 9.11196919329511, 9.062928830418846, 8.982789522686126, 8.939537153485443, 8.914876111851322, 8.89525901084043, 8.877877029266026, 8.856384194754138, 8.836521172918742, 8.817918037920043, 8.80174903957953, 8.738694203124762, 8.696888121317103, 8.659075379929789, 8.638566363903271, 8.619231921965582, 8.613482055405777, 8.535817653209191, 8.51771379927314, 8.4984625828491, 8.425306594794131, 8.380653616027583, 8.365069419644483, 8.29689347700019, 8.248181533690733, 8.224022964510707, 8.204652653762457, 8.14482254976378, 8.123637810910799, 8.074875041850454, 8.049293204000994, 8.016132103276966, 7.969814267497799, 7.949511128747844, 7.933281610115345, 7.912732449877741, 7.8928587443228775, 7.863017865277121, 7.846918576519689, 7.810226511038482, 7.79429835245363, 7.7828019254870675, 7.719847177684903, 7.715449906380945, 7.654649649544852, 7.604316826400912, 7.569718133165127, 7.535388602117159, 7.5020686497072155, 7.484014227861058, 7.423887828971147, 7.406966639815333, 7.388471952489004, 7.370456710431932, 7.335226508862654, 7.323190362372748, 7.287820671283389, 7.228940793722626, 7.208820566124803, 7.161402996882785, 7.14282271054442, 7.109405565417123, 7.091224544330768, 7.041934351057717, 6.985849984605741, 6.963341934929471, 6.9321207718176066, 6.8979307911560825, 6.857802153999157, 6.836733059118783, 6.81862272821006, 6.7984785441351026, 6.776791223575811, 6.742794029999158, 6.691126425018005, 6.655795126952583, 6.6209280396631724, 6.597641587693168, 6.578267956789991, 6.508445217100239, 6.489332999610096, 6.378978612968199, 6.341481480654713, 6.328125616773525, 6.312314963936392, 6.305312900392162, 6.292089500193566, 6.278990721935312, 6.265969628675973, 6.23036187595125, 6.194226832375522, 6.167675541034982, 6.130296740152622, 6.0929087107018765, 6.073436191967268, 6.053478097655983, 6.017385986905519, 5.991230905426975, 5.99445749091677, 5.987217633475525, 5.979472716423188, 5.961073158950412, 5.935727756012134, 5.909378248587099, 5.898705167724413, 5.885218802487418, 5.877904032394692, 5.855475822879204, 5.843804630443299, 5.835468693868957, 5.82176024010091, 5.810259763168309, 5.799892934670038, 5.789664902968423, 5.780194767367885, 5.760335217597921, 5.728541429684938, 5.718925834759212, 5.698359675393353, 5.687532342338552, 5.679998256475347, 5.643113924545995, 5.637479902585472, 5.637107230816231, 5.62140668537544, 5.615992453182365, 5.602864307285946, 5.568125557203189, 5.564409856956456, 5.558203970516072, 5.552447618473336, 5.525162322593501, 5.500823324685458, 5.496966713731666, 5.486049507354313, 5.485379275956736, 5.4868250231106614, 5.450855358073161, 5.453589834512987, 5.430130487611895, 5.433197713006939, 5.412828308837604, 5.415904192184169, 5.414952127022654, 5.41477869610508, 5.417859619489303, 5.421491893265097, 5.421485693229431, 5.422966068318933, 5.421951005180615, 5.42182274656327, 5.423658432587867, 5.435382333867564, 5.441978020533062, 5.440310027474992, 5.431872030608739, 5.430043063258652, 5.4282853983807655, 5.437636942448192, 5.439922438556595, 5.438990841576464, 5.437953893888234, 5.4387414520185535, 5.437504903289366, 5.403918912437288, 5.402635744014242, 5.417856701354548, 5.417323097321402, 5.418820973303236, 5.413770450482153, 5.393071118195349, 5.39242476022316, 5.391508012742897, 5.371846840000928, 5.3779308709360825, 5.378384367802253, 5.377561545029612, 5.384407275823764, 5.383537953723239, 5.382027845263874, 5.383398637857443, 5.377497509345092, 5.375786029124986, 5.375778377255646, 5.3645483554948985, 5.381796968259384, 5.382359225668292, 5.378905485873589, 5.3753459610473815, 5.363496045422183, 5.349332590030577, 5.342162808103531, 5.341730433742801, 5.336118640133189, 5.33001438750995, 5.323254673536316, 5.316815704677172, 5.312450120561728, 5.312222746383113, 5.268044161222101, 5.28462324064519, 5.277749358335136, 5.357530968715063, 5.3623148864295125, 5.363278021571637, 5.366489991186998, 5.361819053133418, 5.363838434399968, 5.360101454987035, 5.362800094470903, 5.3068889110652835, 5.310431162314984, 5.3111970598813345, 5.335335794337928, 5.341842800838224, 5.349340904889914, 5.353385479063904, 5.38982541275614, 5.3986638468256904, 5.401628341686926, 5.404822358233569, 5.404508233448988, 5.413887279142723, 5.420106239691729, 5.423123142129726, 5.423326649404617, 5.42620138997018, 5.423371830088628, 5.4207674180379675, 5.417923693117639, 5.416310186975878, 5.412019869198803, 5.409382483601802, 5.406447557605887, 5.403764489142878, 5.396048477875473, 5.37137186683534, 5.396672698017669, 5.389952502587261, 5.390647188777804, 5.390293248917437, 5.386396482114524, 5.401527490637695, 5.397387122802319, 5.368898683693738, 5.3635993319627575, 5.3585006084950635, 5.355532183049048, 5.330477862429967, 5.337541734454358, 5.34210345841763, 5.345822749252097, 5.369558413946817, 5.395181073176801, 5.403835986425922, 5.407108006194359, 5.389299746737851, 5.394846475816686, 5.426274555383013, 5.430792112320298, 5.467008258974575, 5.45076635737116, 5.483576729007375, 5.491808165704909, 5.5060818391223885, 5.514839899894996, 5.521730751009061, 5.526939938665187, 5.475543511122221, 5.481294858129347, 5.492466641713739, 5.503190315636026, 5.510108058082619, 5.5138143323268745, 5.459523766678179, 5.4659800619917105, 5.471654192320253, 5.479140038529216, 5.485907033134152, 5.490462958363834, 5.4996327506822915, 5.49005550815729, 5.4979588897838045, 5.500993452820873, 5.508968740966168, 5.530442378321138, 5.531633868142032, 5.529923082695581, 5.536001101741413, 5.5325145303408165, 5.481672467520834, 5.507873577368877, 5.513612379502498, 5.493947814897199, 5.523772984899278, 5.524419404342269, 5.534330547278302, 5.486216806508431, 5.486597016089983, 5.495877530774746, 5.512663482921703, 5.521864387555975, 5.534737887609605, 5.538038461521234, 5.537984876172683, 5.519223898425122, 5.522941775763149, 5.501904935578975, 5.500340783192912, 5.506126680913137, 5.4670773686122205, 5.482721430868001, 5.488010221374862, 5.487730090132797, 5.4936020664811, 5.496832378219717, 5.502185267747745, 5.507576514262916, 5.506562263671896, 5.501995570261242, 5.5167426886021715, 5.522766468176894, 5.52543284551333, 5.534608207575222, 5.540405165193376, 5.538410086027768, 5.540148742082122, 5.518310170414127, 5.517875384204491, 5.519698450472551, 5.520250008255558, 5.574407906746083, 5.576847537352704, 5.582988499226984, 5.581932702135035, 5.609865212663551, 5.606085327371872, 5.6010971218302235, 5.56959509632417, 5.569110854839279, 5.57489893351956, 5.572999409088439, 5.550023321467818, 5.545890515936708, 5.540848429342515, 5.534248522442847, 5.535823892224247, 5.529638211411685, 5.528265794528973, 5.503754371877512, 5.495446749415367, 5.49153295583833, 5.4823848922401, 5.482705235494023, 5.475541912278721, 5.474263788370769, 5.466429906797202, 5.482811690396574, 5.452612269872182, 5.453536613475752, 5.446903801095616, 5.437049504775395, 5.431003569672807, 5.429267590577457, 5.421632284834877, 5.435820922118813, 5.431561636192951, 5.428895341890576, 5.421014039054111, 5.4672286553346225, 5.460026398881497, 5.45414665700765, 5.427631204617154, 5.432001116459385, 5.429249198526859, 5.4158180410909225, 5.409702514713331, 5.406551473898475, 5.400861329316892, 5.392021524649006, 5.38757435907733, 5.379956270916173, 5.405445282824541, 5.401770937566111, 5.397663961107337, 5.36556906916288, 5.3547208629760235, 5.346960798405327, 5.338694193049489, 5.311169068624907, 5.313027485684805, 5.30750858434457, 5.294243544695616, 5.289550750931062, 5.293091208186569, 5.346201542186364, 5.345929440518871, 5.350730231926905, 5.350122825877256, 5.351282621088951, 5.352104533386874, 5.3436900900331326, 5.358919052833386, 5.360496475357637, 5.357929249938281, 5.354210282151895, 5.277097178508043, 5.286743721551743, 5.296092791538466, 5.293920421239648, 5.298340245164606, 5.335431342312279, 5.3212537857832825, 5.325600700937104, 5.356035183580272, 5.3649656134231805, 5.382190088628711, 5.386383847371503, 5.446174349383766, 5.457575826622492, 5.462346914608618, 5.464189722299154, 5.444111077565222, 5.446827272003157, 5.430357929038555, 5.415194662914447, 5.4465042871266105, 5.459837744869101, 5.445296473942556, 5.459513969607115, 5.449936628265818, 5.507706245980868, 5.529139766282761, 5.547645845807804, 5.55860374763883, 5.57145599899147, 5.587824838127171, 5.60094082693989, 5.61104331766293, 5.6208446492177355, 5.631822768797131, 5.663158899182598, 5.674736218986805, 5.688498509427096, 5.670434105273533, 5.680531938556235, 5.692313742884453, 5.696379835219358, 5.7308915536322305, 5.731252021640155, 5.736490853778547, 5.712012303270552, 5.720034967074407, 5.726939250086183, 5.7262976565067065, 5.7101997045170085, 5.6976785010108975, 5.695533462714583, 5.706482868170514, 5.738056507066678, 5.741530389088455, 5.7300377249631, 5.728493905099002, 5.757218308024746, 5.732687440830429, 5.736136432837012, 5.740394776381228, 5.733747595021542, 5.736913329900925, 5.712336621271793, 5.7318341133038535, 5.7123167184000545, 5.715945241957286, 5.64604961069417, 5.634429251136368, 5.623349599057777, 5.629501784688938, 5.634330801417428, 5.6359273326679755, 5.669232639497619, 5.649577588339765, 5.656050704583498, 5.661523642226174, 5.661460002329811, 5.664979604059296, 5.675446508954959, 5.674883913206716, 5.677887819505335, 5.673087476592105, 5.680955029165111, 5.680366158784423, 5.653790565642488, 5.630458682425012, 5.650970037568958, 5.622788930026411, 5.622359309711984, 5.626271104406241, 5.628815285687677, 5.650481289481421, 5.652254496015147, 5.65692179596972, 5.654457261959555, 5.644754951662389, 5.628718422103149, 5.618736125633384, 5.607461284812172, 5.618266973912347, 5.6098067003445, 5.6118563152648715, 5.603021399303243, 5.676967047652238, 5.673697579298137, 5.649332552129669, 5.660730582251361, 5.65832595035177, 5.6486900861041045, 5.642082532564195, 5.640545945185132, 5.613725167847887, 5.6107045685057555, 5.607401084038636, 5.605606740831712, 5.605329470744009, 5.597855860354743, 5.5901893990006, 5.5807134634790625, 5.5742032841976075, 5.648971432681763, 5.64361849886198, 5.629537446218189, 5.619509049794763, 5.587886796565456, 5.598765530766753, 5.607962558971196, 5.603639760652791, 5.59663638831405, 5.587395568533326, 5.552892501362371, 5.5478710641183815, 5.546176072572836, 5.5389595639274285, 5.5414850728983, 5.52769844469196, 5.538790538597044, 5.527452913619104, 5.5397950493572035, 5.534989347814335, 5.532199887491236, 5.516794738968952, 5.555458527841361, 5.555275673861922, 5.555869528128092, 5.55791801672973, 5.558098939507495, 5.556882024175247, 5.5611531091144, 5.564688632600375, 5.560007634460565, 5.5341208139681735, 5.531232653234316, 5.5306168425081506, 5.522465810081427, 5.517719619624761, 5.5083329246238515, 5.497897604217482, 5.512902481355584, 5.499119833547444, 5.4895476790615625, 5.489571211628298, 5.473091678642293, 5.473188373570481, 5.460219620058963, 5.476024075961296, 5.470288747653901, 5.453687152389773, 5.446649695614507, 5.462309748583179, 5.466919067061493, 5.470036341946793, 5.438347108957569, 5.427130778937709, 5.408286381319185, 5.411183367895764, 5.399823924200682, 5.382030790078069, 5.3975284198180615, 5.387615523212358, 5.376516984351205, 5.369447200852689, 5.355805532420442, 5.365753240779986, 5.357173700504832, 5.3711908581838035, 5.364607314627925, 5.433981549429546, 5.455404415231483, 5.473992897265954, 5.472320881491823, 5.4719632714096935, 5.476632205566075, 5.474331012100722, 5.495380910808951, 5.497474437089139, 5.492423224248083, 5.491708009708677, 5.490755602112551, 5.485223669555997, 5.49118126503793, 5.490001825325303, 5.491296408442756, 5.481020685782744, 5.474390260945269, 5.495568682822753, 5.514122995982654, 5.513592751407556, 5.540095319969726, 5.537896912597121, 5.534918739823261, 5.535320987343045, 5.528671612829325, 5.517487305862701, 5.483992509874145, 5.482514149319509, 5.478092448232365, 5.484001080295465, 5.485915066662519, 5.482825261634958, 5.483004688710105, 5.47846041328191, 5.463449520180138, 5.458125490058336, 5.450474324325853, 5.448097853731051, 5.462982810484286, 5.425569544334078, 5.425687660587983, 5.419934520191085, 5.414850638430441, 5.4004134614953045, 5.40980018351596, 5.378470914740507, 5.366891854293412, 5.359333634366625, 5.352411324003998, 5.34541765189618, 5.333630080820168, 5.326636124335438, 5.309445267070314, 5.273309153130323, 5.25505047274526, 5.24618541990863, 5.238370832725811, 5.255972313827, 5.248672777354335, 5.250424049472827, 5.247223628732994, 5.239288464697034, 5.20811544594796, 5.2225054897089915, 5.201817198205308, 5.190367889157601, 5.181351520841264, 5.168151716794534, 5.167696910870011, 5.152760330675861, 5.147550679812072, 5.14866975658295, 5.166356881379743, 5.165694537365043, 5.17008128290847, 5.168357775845364, 5.1620673337078875, 5.178313569630496, 5.181157242513989, 5.17419852987691, 5.166846517594342, 5.157084820494451, 5.143050685261674, 5.135777545441203, 5.150518512979534, 5.1058675082567, 5.104350490129148, 5.101798241988393, 5.107956065811457, 5.107456022182829, 5.105341239741539, 5.1083274366464275, 5.112744500199421, 5.117502685504015, 5.108629255705154, 5.1201346775300784, 5.119284910481002, 5.118681197642752, 5.11255052742606, 5.085504109020481, 5.089229480412363, 5.08518158562253, 5.084978685593642, 5.085927425495169, 4.999572042707309, 5.023904886202018, 5.008036573582296, 5.027567740029482, 5.031999532131794, 5.026315112797118, 5.040125447845971, 5.046569163112369, 5.05081649914118, 5.059738151327985, 5.074176626603824, 5.083024519023251, 5.075329902000398, 5.022767626737198, 5.0433542573095025, 5.041890307523401, 5.063631579715184, 5.014533551723481, 5.038355667889924, 5.0647700442023, 5.096543618293296, 5.121124598815134, 5.1410098410340845, 5.167604662222939, 5.187691985531665, 5.188122357235683, 5.210521922319007, 5.230441692753906, 5.2494656814782505, 5.257550616227443, 5.269584286545293, 5.279389312167764, 5.30258360681187, 5.327194183883955, 5.340262006540561, 5.335648041728213, 5.347026827898066, 5.3545884449420225, 5.376256060558452, 5.3691438612053775, 5.373242833885306, 5.389508563282272, 5.391678216815697, 5.4306629951623515, 5.446635746981339, 5.466050815460057, 5.4747865158656905, 5.484334471206089, 5.424563899127167, 5.442030020047804, 5.4640970127264445, 5.477026942268272, 5.48772396784584, 5.4995395132115, 5.50550643429678, 5.516307113049071, 5.548262549201568, 5.550807801523168, 5.554704599706839, 5.560328152623787, 5.573980784803075, 5.569375475834278, 5.601701479515525, 5.619755377017445, 5.628516202564837, 5.625754008715117, 5.633958958630351, 5.652573532351871, 5.640497231113678, 5.650875912579764, 5.6833784708386785, 5.692377738663652, 5.689773955954845, 5.684371916784295, 5.683433973728549, 5.695703357203872, 5.701732732669949, 5.705749376604385, 5.718401623265783, 5.7378689437367205, 5.743995576139821, 5.755775182624349, 5.768134634252302, 5.769295075219144, 5.79095909013237, 5.804940170061114, 5.822457521242366, 5.832908088753179, 5.840462718503978, 5.842734980733307, 5.8499224377116015, 5.837763706080523, 5.847694250836154, 5.85662401058687, 5.859864506382134, 5.85463916822806, 5.85020950561822, 5.838894751058735, 5.8449605560255495, 5.849627786825189, 5.849106041437355, 5.850502342566311, 5.880595545991578, 5.8808753325339795, 5.874554514010439, 5.859751635816432, 5.861924894919394, 5.862495211116574, 5.8647388717254865, 5.852729412419459, 5.847140834074697, 5.837029609599973, 5.826177630160673, 5.807191589527041, 5.808946936187012, 5.807367758786735, 5.818181098976, 5.815722659116313, 5.817760571686709, 5.819274830124006, 5.815575315609071, 5.894137054525471, 5.891150063314729, 5.906404805531615, 5.896380996973665, 5.90257581974383, 5.919999355654732, 5.919187755341813, 5.9174329112212085, 5.914975094064423, 5.91389879040911, 5.917745282231594, 5.9085714714568445, 5.932922306958379, 6.00127036402336, 6.007777046137587, 6.029021568469031, 6.038037747900945, 6.102835192664666, 6.118407475199652, 6.116792242111362, 6.115138880857069, 6.131317564351513, 6.138447417744161, 6.1415902437958225, 6.14949220878296, 6.137740285473186, 6.155611005932229, 6.161816405002194, 6.168740903944049, 6.184523332314027, 6.178007582636205, 6.198962502633066, 6.202456708872725, 6.209622282748768, 6.20975022968066, 6.232469870509343, 6.250150167108279, 6.262358024950983, 6.2603833779951135, 6.285515472482946, 6.2928840206692795, 6.305088372564565, 6.328400268033306, 6.331219128431875, 6.334700673941661, 6.338622965699434, 6.331576903625838, 6.328633835364724, 6.423102679578676, 6.426877120078018, 6.435358223810196, 6.4405396376637825, 6.450256675734898, 6.453025338416355, 6.4572090666798605, 6.462841252114092, 6.474557823303671, 6.482618378221226, 6.492888679099717, 6.493415253923792, 6.495776927144424, 6.519298357147111, 6.520161163642501, 6.522970619704967, 6.520685174300075, 6.532202109031418, 6.5360478853251145, 6.521851984707042, 6.539850377800827, 6.540617470143408, 6.54315415263407, 6.555042347798956, 6.565436029906965, 6.587792109110902, 6.590041034392856, 6.598035000285633, 6.603046035831825, 6.604595665345233, 6.600511298955446, 6.610085521825074, 6.6137004040114595, 6.624182959964342, 6.627475250576547, 6.644257297184681, 6.639051304550646, 6.631813082824942, 6.637999053871295, 6.645424760700641, 6.644834485817655, 6.6508231470132815, 6.6355340032966605, 6.645341955095903, 6.63549669629638, 6.622946016581549, 6.61524971785107, 6.610406950735488, 6.611353809487648, 6.626171765788711, 6.627094679082473, 6.618417700322628, 6.615121890351678, 6.603645118741359, 6.605285421796017, 6.604894013220132, 6.607133099850246, 6.615634786481503, 6.622698171227061, 6.615842280262167, 6.607312048984789, 6.608272315252842, 6.608315622691214, 6.608648698923932, 6.6032104570839, 6.6051918307389625, 6.597623596787092, 6.595439654777665, 6.6081674624190505, 6.605752689801405, 6.594247766442498, 6.5948328728561085, 6.580231816426601, 6.574638832104039, 6.57801287671496, 6.579101982845528, 6.557189266138439, 6.546428993233472, 6.54061972468676, 6.540286774669196, 6.542733584930638, 6.55426554632191, 6.553829527414898, 6.545068778948574, 6.55722267153255, 6.559227696927114, 6.559180985156985, 6.547212956810423, 6.552834239223049, 6.545802303819574, 6.5562587865346655, 6.55288913204859, 6.561106811614433, 6.571782245494484, 6.555682602810491, 6.547695316898299, 6.5387255201224885, 6.535641699157091, 6.573708467188498, 6.561004391564758, 6.556932075983257, 6.564738857760856, 6.573309091932045, 6.590637664420894, 6.582308301214007, 6.5923471033216625, 6.582452963174254, 6.587208039091804, 6.601849473644657, 6.594727752979858, 6.593150143059064, 6.60579401805208, 6.615261736798919, 6.628203537929225, 6.628884326726014, 6.6338237723462035, 6.644736473374135, 6.652624667487359, 6.656889781203909, 6.681718947517043, 6.695084366411844, 6.679661202105258, 6.678517169108627, 6.648341949939299, 6.661869211382632, 6.657648868998093, 6.659289162204802, 6.655473002537723, 6.661475407268668, 6.660556088971073, 6.662196202829474, 6.653693722550027, 6.676388906360204, 6.679367052789723, 6.682000230970587, 6.684499304330604, 6.686856059361425, 6.68906228255251, 6.69110976039332, 6.692990279373315, 6.694695625981955, 6.6962175867087, 6.697547948043012, 6.698678496474351, 6.699601018492177, 6.70030730058595, 6.700789129245132, 6.701038290959182, 6.701046572217561, 6.70080575950973, 6.700307639325148, 6.699543998153277, 6.698506622483576, 6.697187298805507, 6.695577813608529, 6.693669953382104, 6.69145550461569, 6.68892625379875, 6.686073987420744, 6.682890491971131, 6.679367553939373, 6.675496959814929, 6.671270496087261, 6.666679949245828, 6.661717105780092, 6.656373752179511, 6.650641674933548, 6.644512660531663, 6.637978495463315, 6.631030966217966, 6.623661859285075, 6.615862961154105, 6.607626058314513, 6.598942937255762, 6.5898053844673115, 6.580205186438622, 6.570134129659154, 6.559584000618368, 6.548546585805724, 6.5370136717106835, 6.524977044822705, 6.512428491631252, 6.4993597986257825, 6.4857627522957575, 6.471629139130638, 6.456950745619883, 6.441719358252954, 6.425926763519313, 6.4095647479084175, 6.392625097909731, 6.37509960001271, 6.356980040706818, 6.338258206481515, 6.318925883826261]

"""Compute nodes"""
FOG_MIPS = 400000
FOG_MAX_POWER = 240
FOG_STATIC_POWER = 100
FOG_UTILIZATION_THRESHOLD = 0.85

CLOUD_MIPS = np.inf
CLOUD_WATT_PER_MIPS = 700e-6

"""Network (Latency is only used for determining shortest paths in the routing)"""
WAN_BANDWIDTH = np.inf
WAN_LATENCY = 100
WAN_WATT_PER_BIT_UP = 6658e-9
WAN_WATT_PER_BIT_DOWN = 20572e-9

WIFI_BANDWIDTH = 1.6e9
WIFI_LATENCY = 10
WIFI_TAXI_TO_TL_WATT_PER_BIT = 300e-9
WIFI_TL_TO_TL_WATT_PER_BIT = 100e-9
WIFI_RANGE = 300  # e.g. Cisco Aironet 1570 Series

ETHERNET_BANDWIDTH = 1e9
ETHERNET_LATENCY = 1
ETHERNET_WATT_PER_BIT = 0

"""Applications"""
CCTV_PROCESSOR_MIPS = 30000
CCTV_SOURCE_TO_PROCESSOR_BIT_RATE = 10e6
CCTV_PROCESSOR_TO_SINK_BIT_RATE = 200e3

V2I_PROCESSOR_MIPS = 7000
V2I_SOURCE_TO_PROCESSOR_BIT_RATE = 100e3
V2I_PROCESSOR_TO_SINK_BIT_RATE = 50e3
