"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.AlexaSkillDeployAction = void 0;
const codepipeline = require("@aws-cdk/aws-codepipeline");
const action_1 = require("../action");
/**
 * Deploys the skill to Alexa.
 */
class AlexaSkillDeployAction extends action_1.Action {
    /**
     *
     */
    constructor(props) {
        super({
            ...props,
            category: codepipeline.ActionCategory.DEPLOY,
            owner: 'ThirdParty',
            provider: 'AlexaSkillsKit',
            artifactBounds: {
                minInputs: 1,
                maxInputs: 2,
                minOutputs: 0,
                maxOutputs: 0,
            },
            inputs: getInputs(props),
        });
        this.props = props;
    }
    /**
     * The method called when an Action is attached to a Pipeline.
     *
     * This method is guaranteed to be called only once for each Action instance.
     */
    bound(_scope, _stage, _options) {
        return {
            configuration: {
                ClientId: this.props.clientId,
                ClientSecret: this.props.clientSecret,
                RefreshToken: this.props.refreshToken,
                SkillId: this.props.skillId,
            },
        };
    }
}
exports.AlexaSkillDeployAction = AlexaSkillDeployAction;
function getInputs(props) {
    const ret = [props.input];
    if (props.parameterOverridesArtifact) {
        ret.push(props.parameterOverridesArtifact);
    }
    return ret;
}
//# sourceMappingURL=data:application/json;base64,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