/*
 * Decompiled with CFR 0.152.
 */
package eu.quanticol.moonlight.space;

import eu.quanticol.moonlight.core.space.DistanceDomain;
import eu.quanticol.moonlight.core.space.DistanceStructure;
import eu.quanticol.moonlight.core.space.SpatialModel;
import eu.quanticol.moonlight.space.RegularGridModel;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;

public class ManhattanDistanceStructure<E, M>
implements DistanceStructure<E, M> {
    private final Function<E, M> distanceFunction;
    private final DistanceDomain<M> distanceDomain;
    private final M lowerBound;
    private final M upperBound;
    private final RegularGridModel<E> model;

    public ManhattanDistanceStructure(@NotNull Function<E, M> distanceFunction, @NotNull DistanceDomain<M> distanceDomain, @NotNull M lowerBound, @NotNull M upperBound, @NotNull RegularGridModel<E> model) {
        this.distanceFunction = distanceFunction;
        this.distanceDomain = distanceDomain;
        this.lowerBound = lowerBound;
        this.upperBound = upperBound;
        this.model = model;
    }

    @Override
    public boolean areWithinBounds(int from, int to) {
        return this.isWithinBounds(this.getDistance(from, to));
    }

    @Override
    public M getDistance(int from, int to) {
        int[] fPair = this.model.toCoordinates(from);
        int[] tPair = this.model.toCoordinates(to);
        return this.computeManhattanDistance(fPair, tPair);
    }

    private M computeManhattanDistance(int[] from, int[] to) {
        int distX = Math.abs(from[0] - to[0]);
        int distY = Math.abs(from[1] - to[1]);
        int dist = distX + distY;
        return this.distanceToMetric(dist);
    }

    private M distanceToMetric(int distance) {
        M weight = this.distanceFunction.apply(this.model.getWeight());
        return this.distanceDomain.multiply(weight, distance);
    }

    @Override
    public boolean isWithinBounds(M d) {
        return this.distanceDomain.lessOrEqual(this.lowerBound, d) && this.distanceDomain.lessOrEqual(d, this.upperBound);
    }

    @Override
    public SpatialModel<E> getModel() {
        return this.model;
    }

    @Override
    public Function<E, M> getDistanceFunction() {
        return this.distanceFunction;
    }

    @Override
    public DistanceDomain<M> getDistanceDomain() {
        return this.distanceDomain;
    }
}

