/*
 * Decompiled with CFR 0.152.
 */
package eu.quanticol.moonlight.space;

import eu.quanticol.moonlight.core.base.Pair;
import eu.quanticol.moonlight.core.space.SpatialModel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;

public class ImmutableGraphModel<T>
implements SpatialModel<T> {
    private final List<HashMap<Integer, T>> edges;
    private final List<List<Pair<Integer, T>>> outEdges;
    private final List<List<Pair<Integer, T>>> inEdges;
    private final int locations;

    public ImmutableGraphModel(int size) {
        this.locations = size;
        this.edges = new ArrayList<HashMap<Integer, T>>(size);
        this.outEdges = new ArrayList<List<Pair<Integer, T>>>(size);
        this.inEdges = new ArrayList<List<Pair<Integer, T>>>(size);
        this.init();
    }

    private ImmutableGraphModel(int locations, List<HashMap<Integer, T>> edges, List<List<Pair<Integer, T>>> inEdges, List<List<Pair<Integer, T>>> outEdges) {
        this.locations = locations;
        this.edges = edges;
        this.inEdges = inEdges;
        this.outEdges = outEdges;
    }

    private void init() {
        for (int i = 0; i < this.locations; ++i) {
            this.edges.add(i, new HashMap());
            this.outEdges.add(i, new LinkedList());
            this.inEdges.add(i, new LinkedList());
        }
    }

    public ImmutableGraphModel<T> remove(int src, int trg) {
        if (src >= this.locations || trg >= this.locations) {
            throw new ArrayIndexOutOfBoundsException("Unable to remove the edge");
        }
        if (!this.edges.get(src).containsKey(trg)) {
            throw new IllegalArgumentException("Edge not present!");
        }
        return this.generateFromRemoval(src, trg);
    }

    public ImmutableGraphModel<T> add(int src, T value, int trg) {
        if (src == trg) {
            throw new IllegalArgumentException("Self-loops are not allowed!");
        }
        if (this.edges.get(src).containsKey(trg)) {
            throw new IllegalArgumentException("Duplicated edge!");
        }
        return this.generateFromAddition(src, value, trg);
    }

    @Override
    public T get(int source, int target) {
        return this.edges.get(source).get(target);
    }

    @Override
    public int size() {
        return this.locations;
    }

    @Override
    public List<Pair<Integer, T>> next(int location) {
        return this.outEdges.get(location);
    }

    @Override
    public List<Pair<Integer, T>> previous(int location) {
        return this.inEdges.get(location);
    }

    private ImmutableGraphModel<T> generateFromRemoval(int src, int trg) {
        Pair<Integer, T> out = this.outEdges.get(src).get(trg);
        Pair<Integer, T> in = this.inEdges.get(src).get(trg);
        ArrayList<HashMap<Integer, T>> newEdges = new ArrayList<HashMap<Integer, T>>(this.edges);
        newEdges.set(src, new HashMap(this.edges.get(src)));
        ((HashMap)newEdges.get(src)).remove(trg);
        ArrayList<List<Pair<Integer, T>>> newInEdges = new ArrayList<List<Pair<Integer, T>>>(this.inEdges);
        newInEdges.set(trg, new ArrayList(trg));
        ((List)newInEdges.get(trg)).remove(in);
        ArrayList<List<Pair<Integer, T>>> newOutEdges = new ArrayList<List<Pair<Integer, T>>>(this.outEdges);
        newOutEdges.set(src, new ArrayList(src));
        ((List)newOutEdges.get(src)).remove(out);
        return new ImmutableGraphModel<T>(this.locations, newEdges, newInEdges, newOutEdges);
    }

    private ImmutableGraphModel<T> generateFromAddition(int src, T value, int trg) {
        ArrayList<HashMap<Integer, T>> newEdges = new ArrayList<HashMap<Integer, T>>(this.edges);
        newEdges.set(src, new HashMap(this.edges.get(src)));
        ((HashMap)newEdges.get(src)).put(trg, value);
        ArrayList<List<Pair<Integer, T>>> newInEdges = new ArrayList<List<Pair<Integer, T>>>(this.inEdges);
        newInEdges.set(trg, new ArrayList(this.inEdges.get(trg)));
        ((List)newInEdges.get(trg)).add(new Pair<Integer, T>(src, value));
        ArrayList<List<Pair<Integer, T>>> newOutEdges = new ArrayList<List<Pair<Integer, T>>>(this.outEdges);
        newOutEdges.set(src, new ArrayList(this.outEdges.get(src)));
        ((List)newOutEdges.get(src)).add(new Pair<Integer, T>(trg, value));
        return new ImmutableGraphModel<T>(this.locations, newEdges, newInEdges, newOutEdges);
    }
}

