/*
 * Decompiled with CFR 0.152.
 */
package eu.quanticol.moonlight.space;

import eu.quanticol.moonlight.core.base.Pair;
import eu.quanticol.moonlight.core.space.SpatialModel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class GraphModel<E>
implements SpatialModel<E> {
    private final List<Map<Integer, E>> edges;
    private final List<List<Pair<Integer, E>>> outEdges;
    private final List<List<Pair<Integer, E>>> inEdges;
    private final int size;

    public GraphModel(int size) {
        this.size = size;
        this.edges = new ArrayList<Map<Integer, E>>(size);
        this.outEdges = new ArrayList<List<Pair<Integer, E>>>(size);
        this.inEdges = new ArrayList<List<Pair<Integer, E>>>(size);
        this.init();
    }

    private void init() {
        for (int i = 0; i < this.size; ++i) {
            this.edges.add(i, new HashMap());
            this.outEdges.add(i, new LinkedList());
            this.inEdges.add(i, new LinkedList());
        }
    }

    public void remove(int src, int trg) {
        if (src >= this.size || trg >= this.size) {
            throw new ArrayIndexOutOfBoundsException("Unable to remove the edge");
        }
        if (!this.edges.get(src).containsKey(trg)) {
            throw new IllegalArgumentException("Edge not present!");
        }
        Pair<Integer, E> out = this.outEdges.get(src).get(trg);
        Pair<Integer, E> in = this.inEdges.get(src).get(trg);
        this.edges.get(src).remove(trg);
        this.outEdges.get(src).remove(out);
        this.inEdges.get(trg).remove(in);
    }

    public void add(int src, E value, int trg) {
        if (src == trg) {
            return;
        }
        this.edges.get(src).put(trg, value);
        this.outEdges.get(src).add(new Pair<Integer, E>(trg, value));
        this.inEdges.get(trg).add(new Pair<Integer, E>(src, value));
    }

    @Override
    public E get(int source, int target) {
        return this.edges.get(source).get(target);
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public List<Pair<Integer, E>> next(int location) {
        return this.outEdges.get(location);
    }

    @Override
    public List<Pair<Integer, E>> previous(int location) {
        return this.inEdges.get(location);
    }
}

