/*
 * Decompiled with CFR 0.152.
 */
package eu.quanticol.moonlight.online.signal;

import eu.quanticol.moonlight.core.base.Box;
import eu.quanticol.moonlight.core.signal.SignalDomain;
import eu.quanticol.moonlight.core.signal.TimeSignal;
import eu.quanticol.moonlight.online.algorithms.Signals;
import eu.quanticol.moonlight.online.signal.TimeChain;
import eu.quanticol.moonlight.online.signal.TimeSegment;
import eu.quanticol.moonlight.online.signal.Update;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class MultiOnlineSpaceTimeSignal
implements TimeSignal<Double, List<List<Box<?>>>> {
    private final TimeChain<Double, List<List<Box<?>>>> segments;
    private final int size;

    public MultiOnlineSpaceTimeSignal(int locations, SignalDomain<List<Box<?>>> domain) {
        List any = IntStream.range(0, locations).boxed().map(i -> (List)domain.any()).collect(Collectors.toList());
        this.segments = new TimeChain(new TimeSegment(0.0, any), Double.valueOf(Double.POSITIVE_INFINITY));
        this.size = locations;
    }

    @Override
    public boolean refine(Update<Double, List<List<Box<?>>>> u) {
        return Signals.refine(this.segments, u, (v, vNew) -> IntStream.range(0, this.size).filter(i -> MultiOnlineSpaceTimeSignal.containment((List)v.get(i), (List)vNew.get(i))).count() != 0L);
    }

    @Override
    public boolean refine(TimeChain<Double, List<List<Box<?>>>> updates) {
        return Signals.refineChain(this.segments, updates, (v, vNew) -> IntStream.range(0, this.size).filter(i -> MultiOnlineSpaceTimeSignal.containment((List)v.get(i), (List)vNew.get(i))).count() != 0L);
    }

    private static boolean containment(List<Box<?>> v, List<Box<?>> vNew) {
        return IntStream.range(0, v.size()).filter(i -> !((Box)v.get(i)).contains((Box)vNew.get(i))).count() != 0L;
    }

    @Override
    public TimeChain<Double, List<List<Box<?>>>> select(Double start, Double end) {
        throw new UnsupportedOperationException("Not allowed for SpaceTime Signals");
    }

    @Override
    public TimeChain<Double, List<List<Box<?>>>> getSegments() {
        return this.segments;
    }
}

