/*
 * Decompiled with CFR 0.152.
 */
package eu.quanticol.moonlight.online.monitoring.temporal;

import eu.quanticol.moonlight.core.base.Box;
import eu.quanticol.moonlight.core.signal.SignalDomain;
import eu.quanticol.moonlight.core.signal.TimeSignal;
import eu.quanticol.moonlight.online.algorithms.BooleanOp;
import eu.quanticol.moonlight.online.monitoring.OnlineMonitor;
import eu.quanticol.moonlight.online.signal.OnlineSignal;
import eu.quanticol.moonlight.online.signal.TimeChain;
import eu.quanticol.moonlight.online.signal.Update;
import java.util.ArrayList;
import java.util.List;
import java.util.function.UnaryOperator;

public class UnaryMonitor<V, R extends Comparable<R>>
implements OnlineMonitor<Double, V, Box<R>> {
    private final UnaryOperator<Box<R>> op;
    private final TimeSignal<Double, Box<R>> rho;
    private final OnlineMonitor<Double, V, Box<R>> argumentMonitor;

    public UnaryMonitor(OnlineMonitor<Double, V, Box<R>> argument, UnaryOperator<Box<R>> unaryOp, SignalDomain<R> interpretation) {
        this.op = unaryOp;
        this.rho = new OnlineSignal<R>(interpretation);
        this.argumentMonitor = argument;
    }

    @Override
    public List<TimeChain<Double, Box<R>>> monitor(Update<Double, V> signalUpdate) {
        List<TimeChain<Double, Box<R>>> argUpdates = this.argumentMonitor.monitor(signalUpdate);
        ArrayList<TimeChain<Double, Box<R>>> updates = new ArrayList<TimeChain<Double, Box<R>>>();
        for (TimeChain<Double, Box<R>> argU : argUpdates) {
            updates.add(BooleanOp.unarySequence(argU, this.op));
        }
        updates.forEach(this.rho::refine);
        return updates;
    }

    @Override
    public List<TimeChain<Double, Box<R>>> monitor(TimeChain<Double, V> updates) {
        List<TimeChain<Double, Box<R>>> argUpdates = this.argumentMonitor.monitor(updates);
        ArrayList<TimeChain<Double, Box<R>>> outputUpdates = new ArrayList<TimeChain<Double, Box<R>>>();
        for (TimeChain<Double, Box<R>> argU : argUpdates) {
            outputUpdates.add(BooleanOp.unarySequence(argU, this.op));
        }
        outputUpdates.forEach(this.rho::refine);
        return outputUpdates;
    }

    @Override
    public TimeSignal<Double, Box<R>> getResult() {
        return this.rho;
    }
}

