/*
 * Decompiled with CFR 0.152.
 */
package eu.quanticol.moonlight.offline.monitoring.mfr;

import eu.quanticol.moonlight.core.formula.Formula;
import eu.quanticol.moonlight.core.formula.Interval;
import eu.quanticol.moonlight.core.signal.SignalDomain;
import eu.quanticol.moonlight.core.space.DistanceStructure;
import eu.quanticol.moonlight.core.space.LocationService;
import eu.quanticol.moonlight.core.space.SpatialModel;
import eu.quanticol.moonlight.formula.AtomicFormula;
import eu.quanticol.moonlight.formula.Parameters;
import eu.quanticol.moonlight.formula.mfr.BinaryFormula;
import eu.quanticol.moonlight.formula.mfr.FilterFormula;
import eu.quanticol.moonlight.formula.mfr.MapFormula;
import eu.quanticol.moonlight.formula.mfr.ReduceFormula;
import eu.quanticol.moonlight.formula.mfr.SetFormula;
import eu.quanticol.moonlight.formula.temporal.SinceFormula;
import eu.quanticol.moonlight.offline.monitoring.mfr.MfrMonitor;
import eu.quanticol.moonlight.offline.monitoring.mfr.MfrMonitorAtomic;
import eu.quanticol.moonlight.offline.monitoring.mfr.MfrMonitorBinary;
import eu.quanticol.moonlight.offline.monitoring.mfr.MfrMonitorFilter;
import eu.quanticol.moonlight.offline.monitoring.mfr.MfrMonitorMap;
import eu.quanticol.moonlight.offline.monitoring.mfr.MfrMonitorReduce;
import eu.quanticol.moonlight.offline.monitoring.mfr.MfrMonitorSince;
import eu.quanticol.moonlight.offline.monitoring.mfr.MfrSetMonitor;
import java.lang.runtime.SwitchBootstraps;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BinaryOperator;
import java.util.function.Function;

public class MfrMonitoring<S, T, R> {
    private final Map<String, Function<Parameters, Function<T, R>>> atoms;
    private final Map<String, Function<SpatialModel<S>, DistanceStructure<S, ?>>> distanceFunctions;
    private final LocationService<Double, S> locationService;
    private final SignalDomain<R> domain;

    public MfrMonitoring(Map<String, Function<Parameters, Function<T, R>>> atomicPropositions, Map<String, Function<SpatialModel<S>, DistanceStructure<S, ?>>> distanceFunctions, SignalDomain<R> domain, LocationService<Double, S> locationService) {
        this.atoms = atomicPropositions;
        this.distanceFunctions = distanceFunctions;
        this.domain = domain;
        this.locationService = locationService;
    }

    public MfrMonitor<S, T, R> monitor(Formula f) {
        Formula formula = f;
        Objects.requireNonNull(formula);
        Formula formula2 = formula;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{AtomicFormula.class, BinaryFormula.class, SinceFormula.class, ReduceFormula.class}, (Object)formula2, n)) {
            case 0 -> {
                AtomicFormula atomic = (AtomicFormula)formula2;
                yield this.generateAtomicMonitor(atomic);
            }
            case 1 -> {
                BinaryFormula binary = (BinaryFormula)formula2;
                yield this.generateBinaryMonitor(binary);
            }
            case 2 -> {
                SinceFormula since = (SinceFormula)formula2;
                yield this.generateSinceMonitor(since);
            }
            case 3 -> {
                ReduceFormula reduce = (ReduceFormula)formula2;
                yield this.generateReduceMonitor(reduce);
            }
            default -> this.illegalFormula(f);
        };
    }

    private <V> MfrSetMonitor<S, T, R> monitorSet(SetFormula f) {
        SetFormula setFormula = f;
        Objects.requireNonNull(setFormula);
        SetFormula setFormula2 = setFormula;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{MapFormula.class, FilterFormula.class, Formula.class}, (Object)setFormula2, n)) {
            case 0 -> {
                MapFormula map = (MapFormula)setFormula2;
                yield this.generateMapMonitor(map);
            }
            case 1 -> {
                FilterFormula filter = (FilterFormula)setFormula2;
                yield this.generateFilterFormula(filter);
            }
            case 2 -> {
                Formula formula = (Formula)setFormula2;
                yield this.mapToLocationSet(formula, this::monitor);
            }
            default -> throw new UnsupportedOperationException("illegal set formula");
        };
    }

    private <V> MfrSetMonitor<S, T, R> mapToLocationSet(Formula f, Function<Formula, MfrMonitor<S, T, R>> m) {
        return this.monitor(f);
    }

    private <K> MfrMonitor<S, T, K> illegalFormula(Formula f) {
        throw new IllegalArgumentException("Unsupported formula: " + f);
    }

    private <K> MfrMonitor<S, T, R> generateAtomicMonitor(AtomicFormula f) {
        Function<Parameters, Function<Object, R>> atomicFunc = this.atoms.get(f.getAtomicId());
        if (atomicFunc == null) {
            throw new IllegalArgumentException("Unknown atomic ID " + f.getAtomicId());
        }
        Function<T, R> atomic = atomicFunc.apply(null);
        return new MfrMonitorAtomic(atomic);
    }

    private <K> MfrMonitor<S, T, R> generateBinaryMonitor(BinaryFormula<R> f) {
        BinaryOperator<R> operator = f.getOperator();
        MfrMonitor<S, T, R> leftArg = this.monitor(f.getLeftArgument());
        MfrMonitor<S, T, R> rightArg = this.monitor(f.getRightArgument());
        return new MfrMonitorBinary<S, T, R>(operator, leftArg, rightArg);
    }

    private <K> MfrMonitor<S, T, R> generateSinceMonitor(SinceFormula f) {
        MfrMonitor<S, T, R> leftArg = this.monitor(f.getFirstArgument());
        MfrMonitor<S, T, R> rightArg = this.monitor(f.getSecondArgument());
        Interval interval = f.isUnbounded() ? null : f.getInterval();
        return new MfrMonitorSince<S, T, R>(leftArg, interval, rightArg, this.domain);
    }

    private <V> MfrMonitor<S, T, R> generateReduceMonitor(ReduceFormula<R, R> f) {
        Function<List<R>, R> aggregator = f.getAggregator();
        MfrSetMonitor<S, T, R> argMonitor = this.monitorSet(f.getArgument());
        Function<SpatialModel<S>, DistanceStructure<S, ?>> distanceFunction = this.distanceFunctions.get(f.getDistanceFunctionId());
        return new MfrMonitorReduce<S, T, R, R>(argMonitor, aggregator, distanceFunction, this.locationService);
    }

    private <V> MfrSetMonitor<S, T, R> generateMapMonitor(MapFormula<R> f) {
        MfrSetMonitor<S, T, R> argMonitor = this.monitorSet(f.getArgument());
        return new MfrMonitorMap<S, T, R>(f.getMapper(), argMonitor);
    }

    private <V> MfrSetMonitor<S, T, R> generateFilterFormula(FilterFormula<R> f) {
        MfrSetMonitor<S, T, R> argMonitor = this.monitorSet(f.getArgument());
        return new MfrMonitorFilter<S, T, R>(f.getPredicate(), argMonitor);
    }
}

