/*
 * Decompiled with CFR 0.152.
 */
package eu.quanticol.moonlight.core.io;

import eu.quanticol.moonlight.offline.signal.IllegalValueException;

public interface DataHandler<S> {
    public static final DataHandler<Double> REAL = new DataHandler<Double>(){

        @Override
        public Class<Double> getTypeOf() {
            return Double.class;
        }

        @Override
        public Double fromObject(Object value) {
            if (value == null) {
                return 0.0;
            }
            if (value instanceof Double) {
                return (Double)value;
            }
            if (value instanceof Number) {
                return ((Number)value).doubleValue();
            }
            throw new IllegalValueException("Expected a double is " + value.toString());
        }

        @Override
        public Double fromString(String str) {
            try {
                return Double.parseDouble(str);
            }
            catch (NumberFormatException e) {
                throw new IllegalValueException(e);
            }
        }

        @Override
        public Double fromDouble(double value) {
            return value;
        }

        @Override
        public String stringOf(Double aDouble) {
            return aDouble.toString();
        }

        @Override
        public double doubleOf(Object aDouble) {
            if (aDouble instanceof Double) {
                return (Double)aDouble;
            }
            return Double.NaN;
        }

        @Override
        public boolean checkObjectValue(Object o) {
            return o instanceof Double;
        }

        @Override
        public boolean checkStringValue(String value) {
            try {
                Double.parseDouble(value);
                return true;
            }
            catch (NumberFormatException e) {
                return false;
            }
        }
    };
    public static final DataHandler<Integer> INTEGER = new DataHandler<Integer>(){

        @Override
        public Class<Integer> getTypeOf() {
            return Integer.class;
        }

        @Override
        public Integer fromObject(Object value) {
            if (value == null) {
                return 0;
            }
            if (value instanceof Integer) {
                return (Integer)value;
            }
            if (value instanceof Number) {
                return ((Number)value).intValue();
            }
            throw new IllegalValueException("Expected an Integer is " + value);
        }

        @Override
        public Integer fromString(String str) {
            try {
                return Integer.parseInt(str);
            }
            catch (NumberFormatException e) {
                throw new IllegalValueException(e);
            }
        }

        @Override
        public Integer fromDouble(double value) {
            return (int)Math.floor(value);
        }

        @Override
        public String stringOf(Integer integer) {
            return integer.toString();
        }

        @Override
        public double doubleOf(Object integer) {
            if (integer instanceof Integer) {
                return ((Integer)integer).intValue();
            }
            return Double.NaN;
        }

        @Override
        public boolean checkObjectValue(Object o) {
            return o instanceof Integer;
        }

        @Override
        public boolean checkStringValue(String value) {
            try {
                Integer.parseInt(value);
                return true;
            }
            catch (NumberFormatException e) {
                return false;
            }
        }
    };
    public static final DataHandler<Boolean> BOOLEAN = new DataHandler<Boolean>(){

        @Override
        public Class<Boolean> getTypeOf() {
            return Boolean.class;
        }

        @Override
        public Boolean fromObject(Object value) throws IllegalValueException {
            if (value == null) {
                return false;
            }
            if (value instanceof Boolean) {
                return (Boolean)value;
            }
            throw new IllegalValueException("Expected Boolean is " + value);
        }

        @Override
        public Boolean fromString(String str) throws IllegalValueException {
            return Boolean.parseBoolean(str);
        }

        @Override
        public Boolean fromDouble(double value) {
            return value > 0.0;
        }

        @Override
        public String stringOf(Boolean aBoolean) {
            return aBoolean.toString();
        }

        @Override
        public double doubleOf(Object aBoolean) {
            if (aBoolean instanceof Boolean) {
                return (Boolean)aBoolean != false ? 1.0 : -1.0;
            }
            return Double.NaN;
        }

        @Override
        public boolean checkObjectValue(Object o) {
            return o instanceof Boolean;
        }

        @Override
        public boolean checkStringValue(String value) {
            return true;
        }
    };

    public Class<S> getTypeOf();

    public S fromObject(Object var1);

    public S fromString(String var1);

    public S fromDouble(double var1);

    public String stringOf(S var1);

    public double doubleOf(Object var1);

    public boolean checkObjectValue(Object var1);

    public boolean checkStringValue(String var1);

    default public boolean checkDoubleValue(double value) {
        return true;
    }
}

