/*
 * Decompiled with CFR 0.152.
 */
package eu.quanticol.moonlight.core.algorithms;

import eu.quanticol.moonlight.core.algorithms.ReachAlgorithm;
import eu.quanticol.moonlight.core.base.Box;
import eu.quanticol.moonlight.core.signal.SignalDomain;
import eu.quanticol.moonlight.core.space.DistanceStructure;
import eu.quanticol.moonlight.space.IntManhattanDistanceStructure;
import java.util.function.BinaryOperator;
import java.util.function.IntFunction;
import java.util.function.IntPredicate;
import java.util.stream.IntStream;

public class SpatialAlgorithms<E, M, R> {
    private final DistanceStructure<E, M> ds;
    private final boolean parallel;
    private final SignalDomain<R> domain;

    public SpatialAlgorithms(DistanceStructure<E, M> distanceStructure, SignalDomain<R> signalDomain, boolean isParallel) {
        this.ds = distanceStructure;
        this.domain = signalDomain;
        this.parallel = isParallel;
    }

    public SpatialAlgorithms(DistanceStructure<E, M> distanceStructure, SignalDomain<R> signalDomain) {
        this.ds = distanceStructure;
        this.domain = signalDomain;
        this.parallel = false;
    }

    public static <E, M, R> IntFunction<R> reach(SignalDomain<R> signalDomain, IntFunction<R> leftSpatialSignal, IntFunction<R> rightSpatialSignal, DistanceStructure<E, M> distStr) {
        return new ReachAlgorithm<E, M, R>(distStr, signalDomain, leftSpatialSignal, rightSpatialSignal).compute();
    }

    public IntFunction<R> somewhere(IntFunction<R> s) {
        return this.unaryOperation(this.allLocations(), this::neighbourhood, this.domain::disjunction, this.domain.min(), this.domain.max(), s);
    }

    public IntFunction<R> unaryOperation(Box<Integer> range, IntFunction<IntPredicate> filter, BinaryOperator<R> domainOp, R identity, R bound, IntFunction<R> spatialSignal) {
        IntFunction<R> algorithm = this.filterReduce(filter, domainOp, identity, bound, spatialSignal);
        return i -> this.locationStream((Integer)range.getStart(), (Integer)range.getEnd()).mapToObj(algorithm).toList().get(i);
    }

    private IntFunction<R> filterReduce(IntFunction<IntPredicate> neighbourhood, BinaryOperator<R> op, R id, R bound, IntFunction<R> s) {
        IntFunction<int[]> inRangeLocs = this.ds instanceof IntManhattanDistanceStructure ? this.ds::getNeighbourhood : this.genericNeighbourhood(neighbourhood);
        return i -> this.reduceToBound((int[])inRangeLocs.apply(i), s, id, bound, op);
    }

    private R reduceToBound(int[] locations, IntFunction<R> signal, R start, R toBound, BinaryOperator<R> op) {
        int element;
        R result = start;
        int[] nArray = locations;
        int n = nArray.length;
        for (int i = 0; i < n && !(result = op.apply(result, signal.apply(element = nArray[i]))).equals(toBound); ++i) {
        }
        return result;
    }

    private IntFunction<int[]> genericNeighbourhood(IntFunction<IntPredicate> neighbourhood) {
        IntFunction<IntStream> closeEnoughLocs = i -> {
            int[] range = this.ds.getBoundingBox(i);
            return this.locationStream(range[0], range[1]);
        };
        IntFunction<IntStream> locStream = i -> ((IntStream)closeEnoughLocs.apply(i)).filter((IntPredicate)neighbourhood.apply(i));
        return i -> ((IntStream)locStream.apply(i)).toArray();
    }

    private IntStream locationStream(int start, int end) {
        if (this.parallel) {
            return IntStream.range(start, end).parallel();
        }
        return IntStream.range(start, end);
    }

    private Box<Integer> allLocations() {
        return new Box<Integer>(0, this.ds.getModel().size());
    }

    private IntPredicate neighbourhood(int i) {
        return j -> this.ds.areWithinBounds(i, j);
    }

    public IntFunction<R> everywhere(IntFunction<R> s) {
        return this.unaryOperation(this.allLocations(), this::neighbourhood, this.domain::conjunction, this.domain.max(), this.domain.min(), s);
    }
}

