/*
 * Decompiled with CFR 0.152.
 */
package eu.quanticol.moonlight.core.algorithms;

import eu.quanticol.moonlight.core.base.Pair;
import eu.quanticol.moonlight.core.signal.SignalDomain;
import eu.quanticol.moonlight.core.space.DistanceStructure;
import eu.quanticol.moonlight.core.space.SpatialModel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.IntFunction;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class EscapeAlgorithm<E, M, R> {
    private final SpatialModel<E> model;
    private final SignalDomain<R> signalDomain;
    private final IntFunction<R> spatialSignal;
    private final DistanceStructure<E, M> distStr;
    private final Map<Integer, Map<Integer, R>> minimalDistanceMap;

    public EscapeAlgorithm(DistanceStructure<E, M> distStr, SignalDomain<R> signalDomain, IntFunction<R> spatialSignal) {
        this.spatialSignal = spatialSignal;
        this.distStr = distStr;
        this.model = distStr.getModel();
        this.signalDomain = signalDomain;
        this.minimalDistanceMap = new HashMap<Integer, Map<Integer, R>>();
    }

    public IntFunction<R> compute() {
        Set<Pair<Integer, Integer>> neighbourhood = this.getNeighbourhood();
        while (!neighbourhood.isEmpty()) {
            neighbourhood = this.updateShortestPaths(neighbourhood);
        }
        List<R> result = this.extractResult();
        return result::get;
    }

    private Set<Pair<Integer, Integer>> getNeighbourhood() {
        HashSet<Pair<Integer, Integer>> neighbourhood = new HashSet<Pair<Integer, Integer>>();
        for (int i = 0; i < this.model.size(); ++i) {
            HashMap<Integer, R> initialDistance = new HashMap<Integer, R>();
            initialDistance.put(i, this.spatialSignal.apply(i));
            this.minimalDistanceMap.put(i, initialDistance);
            neighbourhood.add(new Pair<Integer, Integer>(i, i));
        }
        return neighbourhood;
    }

    private Set<Pair<Integer, Integer>> updateShortestPaths(Set<Pair<Integer, Integer>> neighbourhood) {
        HashMap<Integer, Map<Integer, R>> neighboursDistanceMap = new HashMap<Integer, Map<Integer, R>>();
        HashSet<Pair<Integer, Integer>> extendedNeighbourhood = new HashSet<Pair<Integer, Integer>>();
        for (Pair<Integer, Integer> pair : neighbourhood) {
            int l1 = pair.getFirst();
            int l2 = pair.getSecond();
            this.updateDistance(l1, l2, extendedNeighbourhood, neighboursDistanceMap);
        }
        this.addAll(neighboursDistanceMap);
        return extendedNeighbourhood;
    }

    private void updateDistance(int source, int target, Set<Pair<Integer, Integer>> extendedNeighbourhood, Map<Integer, Map<Integer, R>> neighboursDistanceMap) {
        for (int neighbour : this.getIncomingEdgesLocations(source)) {
            R oldV = this.getCurrentMinimalDistance(neighbour, target);
            R selfV = this.getCurrentMinimalDistance(source, source);
            R newV = this.combine(oldV, this.spatialSignal.apply(neighbour), selfV);
            if (this.signalDomain.equalTo(newV, oldV)) continue;
            extendedNeighbourhood.add(new Pair<Integer, Integer>(neighbour, target));
            this.addDistancePair(neighboursDistanceMap, neighbour, target, newV);
        }
    }

    private List<Integer> getIncomingEdgesLocations(int location) {
        return this.model.previous(location).stream().map(Pair::getFirst).collect(Collectors.toList());
    }

    private R combine(R oldV, R signalV, R selfV) {
        return this.signalDomain.disjunction(oldV, this.signalDomain.conjunction(signalV, selfV));
    }

    private void addAll(Map<Integer, Map<Integer, R>> eMapNext) {
        eMapNext.forEach((l1, distanceMap) -> distanceMap.forEach((l2, distance) -> this.addDistancePair(this.minimalDistanceMap, (int)l1, (int)l2, (R)distance)));
    }

    private R getCurrentMinimalDistance(int l1, int l2) {
        return this.minimalDistanceMap.get(l1).getOrDefault(l2, this.signalDomain.min());
    }

    private void addDistancePair(Map<Integer, Map<Integer, R>> map, int l1, int l2, R v) {
        Map m = map.computeIfAbsent(l1, x -> new HashMap());
        m.put(l2, v);
    }

    private List<R> extractResult() {
        List<R> toReturn = this.createArray();
        for (int i = 0; i < this.model.size(); ++i) {
            Map<Integer, R> minimalDistance = this.minimalDistanceMap.get(i);
            Set<Map.Entry<Integer, R>> entries = minimalDistance.entrySet();
            R value = this.updateValue(entries, i);
            toReturn.set(i, value);
        }
        return toReturn;
    }

    private List<R> createArray() {
        return IntStream.range(0, this.model.size()).mapToObj(i -> this.signalDomain.min()).collect(Collectors.toCollection(ArrayList::new));
    }

    private R updateValue(Set<Map.Entry<Integer, R>> entries, int i) {
        Object value = this.signalDomain.min();
        for (Map.Entry<Integer, R> k : entries) {
            int location = k.getKey();
            R distance = k.getValue();
            if (!this.distStr.areWithinBounds(i, location)) continue;
            value = this.signalDomain.disjunction(value, distance);
        }
        return value;
    }
}

