/*
 * Decompiled with CFR 0.152.
 */
package eu.quanticol.moonlight;

import eu.quanticol.moonlight.SpatialTemporalMonitorDefinition;
import eu.quanticol.moonlight.core.base.MoonLightRecord;
import eu.quanticol.moonlight.core.signal.SignalDomain;
import eu.quanticol.moonlight.core.space.LocationService;
import eu.quanticol.moonlight.io.SpatialTemporalSignalWriter;
import eu.quanticol.moonlight.offline.monitoring.spatialtemporal.SpatialTemporalMonitor;
import eu.quanticol.moonlight.offline.signal.RecordHandler;
import eu.quanticol.moonlight.offline.signal.SpatialTemporalSignal;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;

public class SpatialTemporalScriptComponent<S> {
    private final SpatialTemporalMonitorDefinition definition;
    private final SignalDomain<S> domain;

    public SpatialTemporalScriptComponent(SpatialTemporalMonitorDefinition definition, SignalDomain<S> domain) {
        this.definition = definition;
        this.domain = domain;
    }

    public double[][][] monitorToArrayFromDouble(LocationService<Double, MoonLightRecord> locations, SpatialTemporalSignal<MoonLightRecord> input, double ... parameters) {
        return this.monitorFromDouble(locations, input, parameters).toArray(this.domain.getDataHandler()::doubleOf);
    }

    public SpatialTemporalSignal<S> monitorFromDouble(LocationService<Double, MoonLightRecord> locations, SpatialTemporalSignal<MoonLightRecord> input, double ... parameters) {
        SpatialTemporalMonitor<MoonLightRecord, MoonLightRecord, MoonLightRecord> monitor = this.getMonitor(parameters);
        return monitor.monitor(locations, input);
    }

    public SpatialTemporalMonitor<MoonLightRecord, MoonLightRecord, S> getMonitor(double ... values) {
        return this.definition.getMonitorFromDouble(this.domain, values);
    }

    public double[][][] monitorToObjectArrayAdjacencyMatrix(double[] locationTimeArray, String[][][][] graph, double[] signalTimeArray, String[][][] signalValues, String ... parameters) {
        int locations = signalValues.length;
        SpatialTemporalSignal<MoonLightRecord> signal = RecordHandler.buildSpatioTemporalSignal(locations, this.definition.getSignalRecordHandler(), signalTimeArray, signalValues);
        LocationService<Double, MoonLightRecord> locationService = LocationService.buildLocationServiceFromAdjacencyMatrix(locations, this.definition.getEdgeRecordHandler(), locationTimeArray, graph);
        return this.monitorToArrayFromString(locationService, signal, parameters);
    }

    public double[][][] monitorToArrayFromString(LocationService<Double, MoonLightRecord> locations, SpatialTemporalSignal<MoonLightRecord> input, String ... parameters) {
        return this.monitorFromString(locations, input, parameters).toArray(this.domain.getDataHandler()::doubleOf);
    }

    public SpatialTemporalSignal<S> monitorFromString(LocationService<Double, MoonLightRecord> locations, SpatialTemporalSignal<MoonLightRecord> input, String ... parameters) {
        SpatialTemporalMonitor<MoonLightRecord, MoonLightRecord, MoonLightRecord> monitor = this.getMonitor(parameters);
        return monitor.monitor(locations, input);
    }

    public SpatialTemporalMonitor<MoonLightRecord, MoonLightRecord, S> getMonitor(String ... values) {
        return this.definition.getMonitorFromString(this.domain, values);
    }

    public double[][][] monitorToObjectArrayAdjacencyMatrix(String[][][] graph, double[] signalTimeArray, String[][][] signalValues, String ... parameters) {
        int locations = signalValues.length;
        SpatialTemporalSignal<MoonLightRecord> signal = RecordHandler.buildSpatioTemporalSignal(locations, this.definition.getSignalRecordHandler(), signalTimeArray, signalValues);
        LocationService<Double, MoonLightRecord> locationService = LocationService.buildLocationServiceFromAdjacencyMatrix(locations, this.definition.getEdgeRecordHandler(), signalTimeArray[0], graph);
        return this.monitorToArrayFromString(locationService, signal, parameters);
    }

    public double[][][] monitorToObjectArrayAdjacencyMatrix(double[] locationTimeArray, double[][][][] graph, double[] signalTimeArray, double[][][] signalValues, double ... parameters) {
        int locations = signalValues.length;
        SpatialTemporalSignal<MoonLightRecord> signal = RecordHandler.buildSpatioTemporalSignal(locations, this.definition.getSignalRecordHandler(), signalTimeArray, signalValues);
        LocationService<Double, MoonLightRecord> locationService = LocationService.buildLocationServiceFromAdjacencyMatrix(locations, this.definition.getEdgeRecordHandler(), locationTimeArray, graph);
        return this.monitorFromDouble(locationService, signal, parameters).toArray(this.domain.getDataHandler()::doubleOf);
    }

    public double[][][] monitorToObjectArrayAdjacencyMatrix(double[][][] graph, double[] signalTimeArray, double[][][] signalValues, double ... parameters) {
        int locations = signalValues.length;
        SpatialTemporalSignal<MoonLightRecord> signal = RecordHandler.buildSpatioTemporalSignal(locations, this.definition.getSignalRecordHandler(), signalTimeArray, signalValues);
        LocationService<Double, MoonLightRecord> locationService = LocationService.buildLocationServiceFromAdjacencyMatrix(locations, this.definition.getEdgeRecordHandler(), signalTimeArray[0], graph);
        return this.monitorFromDouble(locationService, signal, parameters).toArray(this.domain.getDataHandler()::doubleOf);
    }

    public double[][][] monitorToDoubleArrayAdjacencyList(double[] locationTimeArray, String[][][] graph, double[] signalTimeArray, String[][][] signalValues, String ... parameters) {
        int locations = signalValues.length;
        SpatialTemporalSignal<MoonLightRecord> signal = RecordHandler.buildSpatioTemporalSignal(locations, this.definition.getSignalRecordHandler(), signalTimeArray, signalValues);
        LocationService<Double, MoonLightRecord> locationService = LocationService.buildLocationServiceFromAdjacencyList(locations, this.definition.getEdgeRecordHandler(), locationTimeArray, graph);
        return this.monitorToArrayFromString(locationService, signal, parameters);
    }

    public double[][][] monitorToDoubleArrayAdjacencyList(String[][] graph, double[] signalTimeArray, String[][][] signalValues, String ... parameters) {
        int locations = signalValues.length;
        SpatialTemporalSignal<MoonLightRecord> signal = RecordHandler.buildSpatioTemporalSignal(locations, this.definition.getSignalRecordHandler(), signalTimeArray, signalValues);
        LocationService<Double, MoonLightRecord> locationService = LocationService.buildLocationServiceFromAdjacencyList(locations, this.definition.getEdgeRecordHandler(), signalTimeArray[0], graph);
        return this.monitorToArrayFromString(locationService, signal, parameters);
    }

    public double[][][] monitorToDoubleArrayAdjacencyList(double[] locationTimeArray, double[][][] graph, double[] signalTimeArray, double[][][] signalValues, double ... parameters) {
        int locations = signalValues.length;
        SpatialTemporalSignal<MoonLightRecord> signal = RecordHandler.buildSpatioTemporalSignal(locations, this.definition.getSignalRecordHandler(), signalTimeArray, signalValues);
        LocationService<Double, MoonLightRecord> locationService = LocationService.buildLocationServiceFromAdjacencyList(locations, this.definition.getEdgeRecordHandler(), locationTimeArray, graph);
        return this.monitorFromDouble(locationService, signal, parameters).toArray(this.domain.getDataHandler()::doubleOf);
    }

    public double[][][] monitorToObjectArrayAdjacencyListWithPrint(double[] locationTimeArray, double[][][] graph, double[] signalTimeArray, double[][][] signalValues, double ... parameters) {
        System.out.println("times = new double[]" + Arrays.toString(locationTimeArray).replace("[", "{").replace("]", "}"));
        System.out.println("graph = new double[][][]" + Arrays.deepToString((Object[])graph).replace("[", "{").replace("]", "}"));
        System.out.println("signalTimeArray = new double[]" + Arrays.toString(signalTimeArray).replace("[", "{").replace("]", "}"));
        System.out.println("signalValues = new double[][][]" + Arrays.deepToString((Object[])signalValues).replace("[", "{").replace("]", "}"));
        int locations = signalValues.length;
        SpatialTemporalSignal<MoonLightRecord> signal = RecordHandler.buildSpatioTemporalSignal(locations, this.definition.getSignalRecordHandler(), signalTimeArray, signalValues);
        LocationService<Double, MoonLightRecord> locationService = LocationService.buildLocationServiceFromAdjacencyList(locations, this.definition.getEdgeRecordHandler(), locationTimeArray, graph);
        return this.monitorFromDouble(locationService, signal, parameters).toArray(this.domain.getDataHandler()::doubleOf);
    }

    public double[][][] monitorToDoubleArrayAdjacencyList(double[][] graph, double[] signalTimeArray, double[][][] signalValues, double ... parameters) {
        int locations = signalValues.length;
        SpatialTemporalSignal<MoonLightRecord> signal = RecordHandler.buildSpatioTemporalSignal(locations, this.definition.getSignalRecordHandler(), signalTimeArray, signalValues);
        LocationService<Double, MoonLightRecord> locationService = LocationService.buildLocationServiceFromAdjacencyList(locations, this.definition.getEdgeRecordHandler(), signalTimeArray[0], graph);
        return this.monitorFromDouble(locationService, signal, parameters).toArray(this.domain.getDataHandler()::doubleOf);
    }

    public void monitorToFile(SpatialTemporalSignalWriter writer, File output, LocationService<Double, MoonLightRecord> locations, SpatialTemporalSignal<MoonLightRecord> input, String ... values) throws IOException {
        SpatialTemporalSignal<S> signal = this.monitorFromString(locations, input, values);
        writer.write(this.domain.getDataHandler(), signal, output);
    }

    public void monitorToFile(SpatialTemporalSignalWriter writer, File output, LocationService<Double, MoonLightRecord> locations, SpatialTemporalSignal<MoonLightRecord> input, double ... values) throws IOException {
        SpatialTemporalSignal<S> signal = this.monitorFromDouble(locations, input, values);
        writer.write(this.domain.getDataHandler(), signal, output);
    }

    public String getInfo() {
        return this.getName();
    }

    public String getName() {
        return this.definition.getName();
    }

    public String[] getVariables() {
        return this.definition.getSignalRecordHandler().getVariables();
    }

    public RecordHandler getSignalHandler() {
        return this.definition.getSignalRecordHandler();
    }

    public RecordHandler getEdgeHandler() {
        return this.definition.getEdgeRecordHandler();
    }
}

