"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ElasticDBInstance = exports.ElasticDBInstanceProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const gpdb_generated_1 = require("./gpdb.generated");
Object.defineProperty(exports, "ElasticDBInstanceProperty", { enumerable: true, get: function () { return gpdb_generated_1.RosElasticDBInstance; } });
/**
 * A ROS resource type:  `ALIYUN::GPDB::ElasticDBInstance`
 */
class ElasticDBInstance extends ros.Resource {
    /**
     * Create a new `ALIYUN::GPDB::ElasticDBInstance`.
     *
     * Param scope - scope in which this resource is defined
     * Param id    - scoped id of the resource
     * Param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        const rosElasticDBInstance = new gpdb_generated_1.RosElasticDBInstance(this, id, {
            masterNodeNum: props.masterNodeNum,
            encryptionType: props.encryptionType,
            instanceSpec: props.instanceSpec,
            engineVersion: props.engineVersion,
            zoneId: props.zoneId,
            vpcId: props.vpcId,
            vSwitchId: props.vSwitchId,
            segNodeNum: props.segNodeNum,
            period: props.period,
            segStorageType: props.segStorageType,
            storageSize: props.storageSize,
            encryptionKey: props.encryptionKey,
            payType: props.payType === undefined || props.payType === null ? 'Postpaid' : props.payType,
            dbInstanceCategory: props.dbInstanceCategory,
            securityIpList: props.securityIpList,
            dbInstanceDescription: props.dbInstanceDescription,
            periodUnit: props.periodUnit === undefined || props.periodUnit === null ? 'Month' : props.periodUnit,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosElasticDBInstance;
        this.attrConnectionString = rosElasticDBInstance.attrConnectionString;
        this.attrDbInstanceId = rosElasticDBInstance.attrDbInstanceId;
        this.attrOrderId = rosElasticDBInstance.attrOrderId;
        this.attrPort = rosElasticDBInstance.attrPort;
    }
}
exports.ElasticDBInstance = ElasticDBInstance;
//# sourceMappingURL=data:application/json;base64,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