"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.DBInstance = exports.DBInstanceProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const gpdb_generated_1 = require("./gpdb.generated");
Object.defineProperty(exports, "DBInstanceProperty", { enumerable: true, get: function () { return gpdb_generated_1.RosDBInstance; } });
/**
 * A ROS resource type:  `ALIYUN::GPDB::DBInstance`
 */
class DBInstance extends ros.Resource {
    /**
     * Create a new `ALIYUN::GPDB::DBInstance`.
     *
     * Param scope - scope in which this resource is defined
     * Param id    - scoped id of the resource
     * Param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        const rosDBInstance = new gpdb_generated_1.RosDBInstance(this, id, {
            engineVersion: props.engineVersion,
            zoneId: props.zoneId,
            vpcId: props.vpcId,
            dbInstanceClass: props.dbInstanceClass,
            securityIpList: props.securityIpList,
            vSwitchId: props.vSwitchId,
            period: props.period,
            payType: props.payType === undefined || props.payType === null ? 'Postpaid' : props.payType,
            dbInstanceDescription: props.dbInstanceDescription,
            dbInstanceGroupCount: props.dbInstanceGroupCount,
            periodUnit: props.periodUnit === undefined || props.periodUnit === null ? 'Month' : props.periodUnit,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosDBInstance;
        this.attrConnectionString = rosDBInstance.attrConnectionString;
        this.attrDbInstanceId = rosDBInstance.attrDbInstanceId;
        this.attrOrderId = rosDBInstance.attrOrderId;
        this.attrPort = rosDBInstance.attrPort;
    }
}
exports.DBInstance = DBInstance;
//# sourceMappingURL=data:application/json;base64,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