"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const run_ecs_task_base_1 = require("./run-ecs-task-base");
/**
 * Start a service on an ECS cluster
 */
class RunEcsFargateTask extends run_ecs_task_base_1.EcsRunTaskBase {
    constructor(props) {
        if (!props.taskDefinition.isFargateCompatible) {
            throw new Error('Supplied TaskDefinition is not configured for compatibility with Fargate');
        }
        if (!props.taskDefinition.defaultContainer) {
            throw new Error('A TaskDefinition must have at least one essential container');
        }
        super({
            ...props,
            parameters: {
                LaunchType: 'FARGATE',
            },
        });
        this.configureAwsVpcNetworking(props.cluster.vpc, props.assignPublicIp, props.subnets, props.securityGroup);
    }
}
exports.RunEcsFargateTask = RunEcsFargateTask;
//# sourceMappingURL=data:application/json;base64,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