class TwoWayDict(dict):
    '''
    Two Way Dictionary
    '''

    def __len__(self):
        return dict.__len__(self) / 2

    def __setitem__(self, key, value):
        dict.__setitem__(self, key, value)
        dict.__setitem__(self, value, key)
