# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['sphinx_github_changelog']

package_data = \
{'': ['*']}

install_requires = \
['Sphinx>=3.5.4,<4.0.0', 'docutils>=0.16,<0.17', 'requests>=2.25.1,<3.0.0']

extras_require = \
{':python_version < "3.8"': ['importlib-metadata>=3.10.1,<4.0.0']}

setup_kwargs = {
    'name': 'sphinx-github-changelog',
    'version': '1.0.7',
    'description': 'Build a sphinx changelog from GitHub Releases',
    'long_description': 'Sphinx Github Changelog: Build a sphinx changelog from GitHub Releases\n======================================================================\n\n.. image:: https://badge.fury.io/py/sphinx-github-changelog.svg\n    :target: https://pypi.org/pypi/sphinx-github-changelog\n    :alt: Deployed to PyPI\n\n.. image:: https://readthedocs.org/projects/sphinx-github-changelog/badge/?version=latest\n    :target: http://sphinx-github-changelog.readthedocs.io/en/latest/?badge=latest\n    :alt: Documentation Status\n\n.. image:: https://travis-ci.org/peopledoc/sphinx-github-changelog.svg?branch=main\n    :target: https://travis-ci.org/peopledoc/sphinx-github-changelog\n    :alt: Continuous Integration Status\n\n.. image:: https://results.pre-commit.ci/badge/github/ewjoachim/sphinx-github-changelog/main.svg\n    :target: https://results.pre-commit.ci/repo/github/274927215\n    :alt: Pre-commit Status\n\n.. image:: https://codecov.io/gh/peopledoc/sphinx-github-changelog/branch/main/graph/badge.svg\n    :target: https://codecov.io/gh/peopledoc/sphinx-github-changelog\n    :alt: Coverage Status\n\n.. image:: https://img.shields.io/badge/License-MIT-green.svg\n    :target: https://github.com/peopledoc/sphinx-github-changelog/blob/main/LICENSE\n    :alt: MIT License\n\n.. image:: https://img.shields.io/badge/Contributor%20Covenant-v1.4%20adopted-ff69b4.svg\n    :target: CODE_OF_CONDUCT.md\n    :alt: Contributor Covenant\n\nSphinx-github-changelog is a Sphinx_ plugin that builds a changelog section based on\na repository\'s `GitHub Releases`_ content.\n\n.. _Sphinx: https://www.sphinx-doc.org/en/master/\n.. _`GitHub Releases`: https://docs.github.com/en/github/administering-a-repository/about-releases\n\nHow ? (the short version)\n=========================\n\nIn your Sphinx documentation ``conf.py``::\n\n    extensions = [\n        ...,  # your other extensions\n        "sphinx_github_changelog",\n    ]\n\n    # Provide a GitHub API token:\n    # Pass the SPHINX_GITHUB_CHANGELOG_TOKEN environment variable to your build\n    # OR\n    sphinx_github_changelog_token = "..."\n\nIn your documentation:\n\n.. code-block:: restructuredtext\n\n    .. changelog::\n        :changelog-url: https://your-project.readthedocs.io/en/stable/#changelog\n        :github: https://github.com/you/your-project/releases/\n        :pypi: https://pypi.org/project/your-project/\n\n\nSee the end result for this project on ReadTheDocs__.\n\n.. __: https://sphinx-github-changelog.readthedocs.io/en/stable/#changelog\n\nWhy ?\n=====\n\nOn the way to continuous delivery, it\'s important to be able to release easily.\nOne of the criteria for easy releases is that the release doesn\'t require a commit and\na Pull Request. Release Pull Requests usually include 2 parts:\n\n- Changing the version\n- Updating the changelog (if you keep a changelog, let\'s assume you do)\n\nCommitless releases need a way to store the version and the changelog, as close as\npossible to the code, but actually **not in** the code.\n\nSetting aside the "version" question, ``sphinx-github-changelog`` aims at providing\na good way of managing the "changelog" part:\n\nThe best solution we\'ve found so far for the changelog is to store it in the body of\n`GitHub Releases`_. That\'s very practical for maintainers, but it may not be the first\nplace people will look for it. As far as we\'ve seen, people expect the changelog to\nbe:\n\n- in the repo, in ``CHANGELOG.rst``,\n- in the documentation.\n\nHaving the changelog in ``CHANGELOG.rst`` causes a few problems:\n\n- Either each PR adds its single line of changelog, but:\n\n  - you\'ll most probably run into countless merge conflicts,\n  - the changelog won\'t tell you which contribution was part of which release\n\n  This reduces the interest for the whole thing.\n\n- Or your changelog is edited at release time. Maybe you\'re using towncrier_ for\n  fragment-based changelog, but you\'re not doing commitless releases anymore. You could\n  imagine that the release commit is done by your CI, but this can quickly become\n  annoying, especially if you require Pull Requests.\n\nBut there is another way. Instead of providing the changelog, the ``CHANGELOG.rst``\nfile can hold a *link* to the changelog. This makes things much easier.\n``sphinx-github-changelog`` encourages you to do that.\n\nA complete toolbelt\n-------------------\n\nAlongside ``sphinx-github-changelog``, we suggest a few tools that play nice together:\n\n- `setuptools-scm`_ will compute your version in ``setup.py`` based on git tags.\n- `release-drafter`_ will keep a "Draft release" updated as you merge Pull Requests to\n  your repository, so you just have to slightly adjust the release body, and create a\n  tag.\n- Any Continuous Integration solution should be able to listen to new tags, and build\n  and upload distributions to PyPI. Don\'t forget to use `PyPI API tokens`_!\n- And ReadTheDocs_ to host your built documentation, of course.\n\n.. _`setuptools-scm`: https://pypi.org/project/setuptools-scm/\n.. _`release-drafter`: https://help.github.com/en/github/administering-a-repository/about-releases\n.. _towncrier: https://pypi.org/project/towncrier/\n.. _`PyPI API tokens`: https://pypi.org/help/#token\n.. _ReadTheDocs: https://readthedocs.org/\n\nIf you\'re using all the tools above, then releasing is simple as proof-reading the\ndraft GitHub Release and press "Publish Release". That\'s it.\n\nReference documentation\n=======================\n\nExtension options (``conf.py``)\n-------------------------------\n\n- ``changelog_github_token``: GitHub API token, with read access to the repository.\n  Defaults to the value of the environment variable ``SPHINX_GITHUB_CHANGELOG_TOKEN``.\n  If no value is provided, the build will still pass but the changelog will not be\n  built, and a link to the ``changelog-url`` will be displayed (if provided).\n\nDirective\n---------\n\n.. code-block:: restructuredtext\n\n    .. changelog::\n        :changelog-url: https://your-project.readthedocs.io/en/stable/changelog.html\n        :github: https://github.com/you/your-project/releases/\n        :pypi: https://pypi.org/project/your-project/\n\nAttributes\n~~~~~~~~~~\n\n- ``github`` (**required**): URL to the releases page of the repository.\n- ``changelog-url`` (optional): URL to the built version of your changelog.\n  ``sphinx-github-changelog`` will display a link to your built changelog if the GitHub\n  token is not provided (hopefully, this does not happen in your built documentation)\n- ``pypi`` (optional): URL to the PyPI page of the repository. This allows the changelog\n  to display links to each PyPI release.\n\nYou\'ll notice that each parameter here is not requested in the simplest form but as\nvery specific URLs from which the program extracts the needed information. This is\ndone on purpose. If people browse the unbuilt version of your documentation\n(e.g. on GitHub or PyPI directly), they\'ll still be presented with links to the pages\nthat contain the information they will need, instead of unhelping directives.\n\n.. Below this line is content specific to GitHub / PyPI that will not appear in the\n   built doc.\n.. end-of-index-doc\n\nCheck out the built version!\n============================\n\nThis Readme is also built as a Sphinx documentation, and it includes the changelog.\nInterested to see how it looks? Check it out on `our ReadTheDocs space`_.\n\n.. _`our ReadTheDocs space`: https://sphinx-github-changelog.readthedocs.io/en/stable\n\nIf you encounter a bug, or want to get in touch, you\'re always welcome to open a\nticket_.\n\n.. _ticket: https://github.com/peopledoc/sphinx-github-changelog/issues/new\n\nOther links\n===========\n\n- `Code of Conduct <CODE_OF_CONDUCT.rst>`_.\n- `License <LICENCE.rst>`_.\n- `Contributing Guidelines <CONTRIBUTING.rst>`_.\n',
    'author': 'Joachim Jablon',
    'author_email': 'ewjoachim@gmail.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://sphinx-github-changelog.readthedocs.io/en/latest/',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'extras_require': extras_require,
    'python_requires': '>=3.7,<4.0',
}


setup(**setup_kwargs)
