# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['stack_exchange']

package_data = \
{'': ['*']}

install_requires = \
['PyYAML>=6.0,<7.0',
 'markdownify>=0.11.2,<0.12.0',
 'redis>=4.3.4,<5.0.0',
 'requests>=2.28.0,<3.0.0',
 'rich>=12.4.4,<13.0.0',
 'toml>=0.10.2,<0.11.0']

entry_points = \
{'console_scripts': ['se = stack_exchange.__main__:main']}

setup_kwargs = {
    'name': 'stack-exchange-cli',
    'version': '1.0.0',
    'description': 'Stack Exchange CLI for searching',
    'long_description': '# Stack Exchange Search CLI\n\n[![PyPI](https://img.shields.io/pypi/v/stack-exchange-cli?color=brightgreen)](https://pypi.org/project/stack-exchange-cli/) ![Build status](https://github.com/myke2424/stack-exchange-cli/actions/workflows/build.yaml/badge.svg)\n\nSearch stack exchange websites in your terminal!\n\nWith beautiful terminal formatting using Rich.\n\nAll stack exchange websites available for searching: https://stackexchange.com/sites\n\n### Fast Search\n![Fast search Demo](https://s1.gifyu.com/images/Recording-2022-07-17-at-18.39.33-4.gif)\n\n### Interactive Search\n![Interactive search Demo](https://s4.gifyu.com/images/Recording-2022-07-21-at-11.33.13.gif)\n\n## Table of Contents\n1. [How it works](#how-it-works)\n2. [Install](#install)\n3. [Usage](#usage)\n4. [Command Line Arguments](#cli-args)\n5. [Configuration](#config)\n6. [Testing](#testing)\n7. [TODO](#todo)\n\n## How it works  <a name="how-it-works"></a>\n\nDisplays the highest up-voted question and top answer for your search request \\\n*Inspired by*: https://github.com/chubin/cheat.sh\n\n## Install\n\n##### Supported platforms\n\n* Linux\n* Windows\n* Mac\n\n##### Requirements\n\n* Python 3.10 or higher\n \n\n### Main Installation\nJust pip install it! Fast and easy.\n\n```bash\npython3.10 -m pip install stack-exchange-cli\n```\n\n### Install Python 3.10\n\n#### Mac\n```bash\nbrew install python@3.10\n```\n\n#### Linux\n```bash\nsudo apt install software-properties-common -y\nsudo add-apt-repository ppa:deadsnakes/ppa -y\nsudo apt update\nsudo apt install python3.10 -y\n```\n#### Windows\nDownload from here: https://www.python.org/downloads/\n\nIf you can\'t use \'se\' after installing stack-exchange-cli via pip, ensure your Python310\\Scripts is set in your PATH.\nYou will recieve a warning to add to PATH when pip installing stack-exchange-cli.\n\n### Alternative methods to install\n- Install the **requirements** file manually\n\n    ```bash\n    python3.10 -m pip install -r requirements.txt\n    ```\n  \n- Use **poetry** to install dependencies locally (https://python-poetry.org/docs/)\n\n    ```bash\n    poetry install\n    ```\n\n- Run the `scripts/install_ubuntu.sh` script [*UBUNTU* ONLY]\n\n    ```bash\n    # run in root directory\n    sudo bash scripts/install_ubuntu.sh\n    ```\n\n- Install to venv named `.stack-exchange-venv` using make \n    \n  ```bash\n  # run in root directory\n  make\n  ```\n\n- Build from source using poetry\n\n  ```bash\n  # run in root directory\n  poetry build\n  python3.10 -m pip install dist/stack_exchange_cli*.whl\n  ```\n\n## Usage  <a name="usage"></a>\n\n### Fast Search\n\nUse the **-q** command followed by the search query:\n\n```bash\nse -q="BFS vs DFS"\n```\n\nThe above command uses fast search, which fetches the top-voted question and answer and displays them to the console.\n\n### Interactive Search\nUse the **-q** command followed by the search query and **-i** or **--interactive**\n\n```bash\nse -q="BFS vs DFS" -i\n```\nInteractive search allows the user to interact while searching, analogous to browsing stack-exchange questions in your browser, except in the terminal!\n\n\n\n### Run directly with python interpreter\n```bash\npython3.10 -m stack_exchange -q="BFS vs DFS"\n```\n\n## Command Line Arguments  <a name="cli-args"></a>\n| Short | Long | Description | Example | Default |\n|---|---|---|---|---|\n| -q | --query | [*REQUIRED FOR SEARCH*] Search query | se -q="How to merge two dictionaries" | N/A |\n| -s | --site | [*OPTIONAL*] Stack Exchange website to search on View all sites here: (https://stackexchange.com/sites) | se -q="Big O" -s="softwareengineering" | "stackoverflow" |\n| -t | --tags | [*OPTIONAL*] Search tags (space-delimited) | se -q="Segmentation fault cause" -t="c c++" | N/A |\n| -i | --interactive | [*OPTIONAL*] Allow the user to interact while searching | se -q="Tree traversal" -i | False |\n| -n | --num | [*OPTIONAL*] [*INTERACTIVE ONLY*] Number of results to display | se -q="Segmentation fault cause" -i -n=20 | 30 |\n| -sb | --sortby | [*OPTIONAL*]  Method to sort the search results by  choices = ["votes", "creation", "relevance", "activity"] | se -q="Python memory" -sb="relevance" | "votes" |\n| -vv | --verbose | [*OPTIONAL*] Verbose logging flag, set log level to DEBUG | se -q="Dictionary internals" -vv | False |\n| -c | --config | [*OPTIONAL*] config.yaml file path to use for  API, Redis and logging settings | se -q="Directed graph" -c="/mnt/c/config.yaml" | N/A |\n| -k | --key | [*OPTIONAL*] Use stack exchange API key for requests | se -q="Min heap vs max heap" -k="12345" | N/A |\n| -sk | --set-key | [*OPTIONAL*] Set stack exchange API key in config.yaml, to avoid repeating using -k in search commands  | se -sk="12345" | N/A |\n| -fc | --flush-cache | [*OPTIONAL*] Flush all keys/values in redis cache | se -fc | False |\n| -oc | --overwrite-cache | [*OPTIONAL*] Overwrite cache value if key exists | se -q="DFS vs BFS" -oc | False |\n| -j | --json | [*OPTIONAL*] Print search results as json to stdout | se -q="DFS vs BFS" -j | False |\n| -a | --alias | [*OPTIONAL*] View the cached search result under the specified alias | se -a ="my_alias_i_saved_my_search_result" | N/A |\n| -h | --help | [*OPTIONAL*] Displays help text  | se -h | N/A |\n| -v | --version | [*OPTIONAL*] Displays version number | se -v | N/A |\n## Configuration  <a name="config"></a>\n\nThe application can be configured by using the `-c` cmd line argument to point it to a `yaml` config file path. \n```bash\nse -q="DFS vs BFS" -c="/mnt/c/my_config_file.yaml"\n```\n\n**Note**: Most users won\'t need to configure the application, it\'s supposed to be easy to use out of the box! These are **optional** configuration settings the user can use. By default, the application will be packaged up with the `config.yaml` in the root directory.\n### API Configuration\n\nFill out yaml `api` values with a stack exchange `API key` to prevent **request throttling**. \\\nRead more here:  https://api.stackexchange.com/docs/throttle\n\nYou can get an API Key by **registering** as a new app from here: http://stackapps.com/apps/oauth/register \\\nIf you use an api key, you will have a daily request limit of **10000**\n\n**Note**: You probably won\'t need an API key if you are a light-user.\n\n**From stack-exchange**: "Every application is subject to an IP based concurrent request throttle. If a single IP is making more than 30 requests a second, new requests will be dropped. The exact ban period is subject to change, but will be on the order of 30 seconds to a few minutes typically."\n\n\n### Redis Configuration\n\nFill out yaml `redis` values with redis credentials if you want to hook up the application to a redis db for request caching.\n\nSpeed benefits are minor, but it will help with being throttled as it will just read the cache instead of going over the network to the stack exchange API if you request the same thing more than once.\n\nThere are also command line arguments for interfacing with the cache, i.e. overwrite values in the cache or flush the cache.\n\nThis isn\'t needed but if you want to use the redis free tier, check out: https://redis.com/try-free/\n### Logging configuration\n\nModify `logging` values to adjust application log settings.\n\nBy default, logging to a file will be disabled and the log level will be critical to avoid polluting the output.\n\n### Example Config File\n*config.yaml*\n```yaml\napi:\n  api_key: your_api_key # optional\n  default_site: "stackoverflow"  # required\n  version: 2.3 # required\n\nredis: # all fields optional\n  host: redis-notarealhost.redislabs.com\n  port: 12345\n  password: redisdbfakepassword\n\nlogging: # all fields required\n  log_to_file: true \n  log_filename: "stackexchange.log"\n  log_level: "DEBUG"\n```\n\n## Testing  <a name="testing"></a>\nRun tests using pytest\n```bash\npython3.10 -m pytest\n```\n\n## TODO <a name="todo"></a>\nRefactor CLI to use https://github.com/Textualize/textual for interactive search',
    'author': 'Mike Davidson',
    'author_email': None,
    'maintainer': None,
    'maintainer_email': None,
    'url': None,
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.10,<4.0',
}


setup(**setup_kwargs)
