# coding: utf-8

"""
    Kubeflow Pipelines API

    This file contains REST API specification for Kubeflow Pipelines. The file is autogenerated from the swagger definition.

    Contact: kubeflow-pipelines@google.com
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from kfp_server_api.configuration import Configuration


class V2beta1Visualization(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'type': 'V2beta1VisualizationType',
        'source': 'str',
        'arguments': 'str',
        'html': 'str',
        'error': 'str'
    }

    attribute_map = {
        'type': 'type',
        'source': 'source',
        'arguments': 'arguments',
        'html': 'html',
        'error': 'error'
    }

    def __init__(self, type=None, source=None, arguments=None, html=None, error=None, local_vars_configuration=None):  # noqa: E501
        """V2beta1Visualization - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._type = None
        self._source = None
        self._arguments = None
        self._html = None
        self._error = None
        self.discriminator = None

        if type is not None:
            self.type = type
        if source is not None:
            self.source = source
        if arguments is not None:
            self.arguments = arguments
        if html is not None:
            self.html = html
        if error is not None:
            self.error = error

    @property
    def type(self):
        """Gets the type of this V2beta1Visualization.  # noqa: E501


        :return: The type of this V2beta1Visualization.  # noqa: E501
        :rtype: V2beta1VisualizationType
        """
        return self._type

    @type.setter
    def type(self, type):
        """Sets the type of this V2beta1Visualization.


        :param type: The type of this V2beta1Visualization.  # noqa: E501
        :type type: V2beta1VisualizationType
        """

        self._type = type

    @property
    def source(self):
        """Gets the source of this V2beta1Visualization.  # noqa: E501

        Path pattern of input data to be used during generation of visualizations. This is required when creating the pipeline through CreateVisualization API.  # noqa: E501

        :return: The source of this V2beta1Visualization.  # noqa: E501
        :rtype: str
        """
        return self._source

    @source.setter
    def source(self, source):
        """Sets the source of this V2beta1Visualization.

        Path pattern of input data to be used during generation of visualizations. This is required when creating the pipeline through CreateVisualization API.  # noqa: E501

        :param source: The source of this V2beta1Visualization.  # noqa: E501
        :type source: str
        """

        self._source = source

    @property
    def arguments(self):
        """Gets the arguments of this V2beta1Visualization.  # noqa: E501

        Variables to be used during generation of a visualization. This should be provided as a JSON string. This is required when creating the pipeline through CreateVisualization API.  # noqa: E501

        :return: The arguments of this V2beta1Visualization.  # noqa: E501
        :rtype: str
        """
        return self._arguments

    @arguments.setter
    def arguments(self, arguments):
        """Sets the arguments of this V2beta1Visualization.

        Variables to be used during generation of a visualization. This should be provided as a JSON string. This is required when creating the pipeline through CreateVisualization API.  # noqa: E501

        :param arguments: The arguments of this V2beta1Visualization.  # noqa: E501
        :type arguments: str
        """

        self._arguments = arguments

    @property
    def html(self):
        """Gets the html of this V2beta1Visualization.  # noqa: E501

        Output. Generated visualization html.  # noqa: E501

        :return: The html of this V2beta1Visualization.  # noqa: E501
        :rtype: str
        """
        return self._html

    @html.setter
    def html(self, html):
        """Sets the html of this V2beta1Visualization.

        Output. Generated visualization html.  # noqa: E501

        :param html: The html of this V2beta1Visualization.  # noqa: E501
        :type html: str
        """

        self._html = html

    @property
    def error(self):
        """Gets the error of this V2beta1Visualization.  # noqa: E501

        In case any error happens when generating visualizations, only visualization ID and the error message are returned. Client has the flexibility of choosing how to handle the error.  # noqa: E501

        :return: The error of this V2beta1Visualization.  # noqa: E501
        :rtype: str
        """
        return self._error

    @error.setter
    def error(self, error):
        """Sets the error of this V2beta1Visualization.

        In case any error happens when generating visualizations, only visualization ID and the error message are returned. Client has the flexibility of choosing how to handle the error.  # noqa: E501

        :param error: The error of this V2beta1Visualization.  # noqa: E501
        :type error: str
        """

        self._error = error

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, V2beta1Visualization):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, V2beta1Visualization):
            return True

        return self.to_dict() != other.to_dict()
