# coding: utf-8

"""
    Kubeflow Pipelines API

    This file contains REST API specification for Kubeflow Pipelines. The file is autogenerated from the swagger definition.

    Contact: kubeflow-pipelines@google.com
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from kfp_server_api.configuration import Configuration


class V2beta1Run(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'experiment_id': 'str',
        'run_id': 'str',
        'display_name': 'str',
        'storage_state': 'V2beta1RunStorageState',
        'description': 'str',
        'pipeline_version_id': 'str',
        'pipeline_spec': 'ProtobufStruct',
        'runtime_config': 'V2beta1RuntimeConfig',
        'service_account': 'str',
        'created_at': 'datetime',
        'scheduled_at': 'datetime',
        'finished_at': 'datetime',
        'state': 'V2beta1RuntimeState',
        'error': 'GooglerpcStatus',
        'run_details': 'V2beta1RunDetails',
        'recurring_run_id': 'str',
        'state_history': 'list[V2beta1RuntimeStatus]'
    }

    attribute_map = {
        'experiment_id': 'experiment_id',
        'run_id': 'run_id',
        'display_name': 'display_name',
        'storage_state': 'storage_state',
        'description': 'description',
        'pipeline_version_id': 'pipeline_version_id',
        'pipeline_spec': 'pipeline_spec',
        'runtime_config': 'runtime_config',
        'service_account': 'service_account',
        'created_at': 'created_at',
        'scheduled_at': 'scheduled_at',
        'finished_at': 'finished_at',
        'state': 'state',
        'error': 'error',
        'run_details': 'run_details',
        'recurring_run_id': 'recurring_run_id',
        'state_history': 'state_history'
    }

    def __init__(self, experiment_id=None, run_id=None, display_name=None, storage_state=None, description=None, pipeline_version_id=None, pipeline_spec=None, runtime_config=None, service_account=None, created_at=None, scheduled_at=None, finished_at=None, state=None, error=None, run_details=None, recurring_run_id=None, state_history=None, local_vars_configuration=None):  # noqa: E501
        """V2beta1Run - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._experiment_id = None
        self._run_id = None
        self._display_name = None
        self._storage_state = None
        self._description = None
        self._pipeline_version_id = None
        self._pipeline_spec = None
        self._runtime_config = None
        self._service_account = None
        self._created_at = None
        self._scheduled_at = None
        self._finished_at = None
        self._state = None
        self._error = None
        self._run_details = None
        self._recurring_run_id = None
        self._state_history = None
        self.discriminator = None

        if experiment_id is not None:
            self.experiment_id = experiment_id
        if run_id is not None:
            self.run_id = run_id
        if display_name is not None:
            self.display_name = display_name
        if storage_state is not None:
            self.storage_state = storage_state
        if description is not None:
            self.description = description
        if pipeline_version_id is not None:
            self.pipeline_version_id = pipeline_version_id
        if pipeline_spec is not None:
            self.pipeline_spec = pipeline_spec
        if runtime_config is not None:
            self.runtime_config = runtime_config
        if service_account is not None:
            self.service_account = service_account
        if created_at is not None:
            self.created_at = created_at
        if scheduled_at is not None:
            self.scheduled_at = scheduled_at
        if finished_at is not None:
            self.finished_at = finished_at
        if state is not None:
            self.state = state
        if error is not None:
            self.error = error
        if run_details is not None:
            self.run_details = run_details
        if recurring_run_id is not None:
            self.recurring_run_id = recurring_run_id
        if state_history is not None:
            self.state_history = state_history

    @property
    def experiment_id(self):
        """Gets the experiment_id of this V2beta1Run.  # noqa: E501

        Input. ID of the parent experiment. The default experiment ID will be used if this is not specified.  # noqa: E501

        :return: The experiment_id of this V2beta1Run.  # noqa: E501
        :rtype: str
        """
        return self._experiment_id

    @experiment_id.setter
    def experiment_id(self, experiment_id):
        """Sets the experiment_id of this V2beta1Run.

        Input. ID of the parent experiment. The default experiment ID will be used if this is not specified.  # noqa: E501

        :param experiment_id: The experiment_id of this V2beta1Run.  # noqa: E501
        :type experiment_id: str
        """

        self._experiment_id = experiment_id

    @property
    def run_id(self):
        """Gets the run_id of this V2beta1Run.  # noqa: E501

        Output. Unique run ID. Generated by API server.  # noqa: E501

        :return: The run_id of this V2beta1Run.  # noqa: E501
        :rtype: str
        """
        return self._run_id

    @run_id.setter
    def run_id(self, run_id):
        """Sets the run_id of this V2beta1Run.

        Output. Unique run ID. Generated by API server.  # noqa: E501

        :param run_id: The run_id of this V2beta1Run.  # noqa: E501
        :type run_id: str
        """

        self._run_id = run_id

    @property
    def display_name(self):
        """Gets the display_name of this V2beta1Run.  # noqa: E501

        Required input. Name provided by user, or auto generated if run is created by a recurring run.  # noqa: E501

        :return: The display_name of this V2beta1Run.  # noqa: E501
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """Sets the display_name of this V2beta1Run.

        Required input. Name provided by user, or auto generated if run is created by a recurring run.  # noqa: E501

        :param display_name: The display_name of this V2beta1Run.  # noqa: E501
        :type display_name: str
        """

        self._display_name = display_name

    @property
    def storage_state(self):
        """Gets the storage_state of this V2beta1Run.  # noqa: E501


        :return: The storage_state of this V2beta1Run.  # noqa: E501
        :rtype: V2beta1RunStorageState
        """
        return self._storage_state

    @storage_state.setter
    def storage_state(self, storage_state):
        """Sets the storage_state of this V2beta1Run.


        :param storage_state: The storage_state of this V2beta1Run.  # noqa: E501
        :type storage_state: V2beta1RunStorageState
        """

        self._storage_state = storage_state

    @property
    def description(self):
        """Gets the description of this V2beta1Run.  # noqa: E501

        Optional input. Short description of the run.  # noqa: E501

        :return: The description of this V2beta1Run.  # noqa: E501
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """Sets the description of this V2beta1Run.

        Optional input. Short description of the run.  # noqa: E501

        :param description: The description of this V2beta1Run.  # noqa: E501
        :type description: str
        """

        self._description = description

    @property
    def pipeline_version_id(self):
        """Gets the pipeline_version_id of this V2beta1Run.  # noqa: E501

        ID of an existing pipeline version.  # noqa: E501

        :return: The pipeline_version_id of this V2beta1Run.  # noqa: E501
        :rtype: str
        """
        return self._pipeline_version_id

    @pipeline_version_id.setter
    def pipeline_version_id(self, pipeline_version_id):
        """Sets the pipeline_version_id of this V2beta1Run.

        ID of an existing pipeline version.  # noqa: E501

        :param pipeline_version_id: The pipeline_version_id of this V2beta1Run.  # noqa: E501
        :type pipeline_version_id: str
        """

        self._pipeline_version_id = pipeline_version_id

    @property
    def pipeline_spec(self):
        """Gets the pipeline_spec of this V2beta1Run.  # noqa: E501


        :return: The pipeline_spec of this V2beta1Run.  # noqa: E501
        :rtype: ProtobufStruct
        """
        return self._pipeline_spec

    @pipeline_spec.setter
    def pipeline_spec(self, pipeline_spec):
        """Sets the pipeline_spec of this V2beta1Run.


        :param pipeline_spec: The pipeline_spec of this V2beta1Run.  # noqa: E501
        :type pipeline_spec: ProtobufStruct
        """

        self._pipeline_spec = pipeline_spec

    @property
    def runtime_config(self):
        """Gets the runtime_config of this V2beta1Run.  # noqa: E501


        :return: The runtime_config of this V2beta1Run.  # noqa: E501
        :rtype: V2beta1RuntimeConfig
        """
        return self._runtime_config

    @runtime_config.setter
    def runtime_config(self, runtime_config):
        """Sets the runtime_config of this V2beta1Run.


        :param runtime_config: The runtime_config of this V2beta1Run.  # noqa: E501
        :type runtime_config: V2beta1RuntimeConfig
        """

        self._runtime_config = runtime_config

    @property
    def service_account(self):
        """Gets the service_account of this V2beta1Run.  # noqa: E501

        Optional input. Specifies which kubernetes service account is used.  # noqa: E501

        :return: The service_account of this V2beta1Run.  # noqa: E501
        :rtype: str
        """
        return self._service_account

    @service_account.setter
    def service_account(self, service_account):
        """Sets the service_account of this V2beta1Run.

        Optional input. Specifies which kubernetes service account is used.  # noqa: E501

        :param service_account: The service_account of this V2beta1Run.  # noqa: E501
        :type service_account: str
        """

        self._service_account = service_account

    @property
    def created_at(self):
        """Gets the created_at of this V2beta1Run.  # noqa: E501

        Output. Creation time of the run.  # noqa: E501

        :return: The created_at of this V2beta1Run.  # noqa: E501
        :rtype: datetime
        """
        return self._created_at

    @created_at.setter
    def created_at(self, created_at):
        """Sets the created_at of this V2beta1Run.

        Output. Creation time of the run.  # noqa: E501

        :param created_at: The created_at of this V2beta1Run.  # noqa: E501
        :type created_at: datetime
        """

        self._created_at = created_at

    @property
    def scheduled_at(self):
        """Gets the scheduled_at of this V2beta1Run.  # noqa: E501

        Output. When this run is scheduled to start. This could be different from created_at. For example, if a run is from a backfilling job that was supposed to run 2 month ago, the created_at will be 2 month behind scheduled_at.  # noqa: E501

        :return: The scheduled_at of this V2beta1Run.  # noqa: E501
        :rtype: datetime
        """
        return self._scheduled_at

    @scheduled_at.setter
    def scheduled_at(self, scheduled_at):
        """Sets the scheduled_at of this V2beta1Run.

        Output. When this run is scheduled to start. This could be different from created_at. For example, if a run is from a backfilling job that was supposed to run 2 month ago, the created_at will be 2 month behind scheduled_at.  # noqa: E501

        :param scheduled_at: The scheduled_at of this V2beta1Run.  # noqa: E501
        :type scheduled_at: datetime
        """

        self._scheduled_at = scheduled_at

    @property
    def finished_at(self):
        """Gets the finished_at of this V2beta1Run.  # noqa: E501

        Output. Completion of the run.  # noqa: E501

        :return: The finished_at of this V2beta1Run.  # noqa: E501
        :rtype: datetime
        """
        return self._finished_at

    @finished_at.setter
    def finished_at(self, finished_at):
        """Sets the finished_at of this V2beta1Run.

        Output. Completion of the run.  # noqa: E501

        :param finished_at: The finished_at of this V2beta1Run.  # noqa: E501
        :type finished_at: datetime
        """

        self._finished_at = finished_at

    @property
    def state(self):
        """Gets the state of this V2beta1Run.  # noqa: E501


        :return: The state of this V2beta1Run.  # noqa: E501
        :rtype: V2beta1RuntimeState
        """
        return self._state

    @state.setter
    def state(self, state):
        """Sets the state of this V2beta1Run.


        :param state: The state of this V2beta1Run.  # noqa: E501
        :type state: V2beta1RuntimeState
        """

        self._state = state

    @property
    def error(self):
        """Gets the error of this V2beta1Run.  # noqa: E501


        :return: The error of this V2beta1Run.  # noqa: E501
        :rtype: GooglerpcStatus
        """
        return self._error

    @error.setter
    def error(self, error):
        """Sets the error of this V2beta1Run.


        :param error: The error of this V2beta1Run.  # noqa: E501
        :type error: GooglerpcStatus
        """

        self._error = error

    @property
    def run_details(self):
        """Gets the run_details of this V2beta1Run.  # noqa: E501


        :return: The run_details of this V2beta1Run.  # noqa: E501
        :rtype: V2beta1RunDetails
        """
        return self._run_details

    @run_details.setter
    def run_details(self, run_details):
        """Sets the run_details of this V2beta1Run.


        :param run_details: The run_details of this V2beta1Run.  # noqa: E501
        :type run_details: V2beta1RunDetails
        """

        self._run_details = run_details

    @property
    def recurring_run_id(self):
        """Gets the recurring_run_id of this V2beta1Run.  # noqa: E501

        ID of the recurring run that triggered this run.  # noqa: E501

        :return: The recurring_run_id of this V2beta1Run.  # noqa: E501
        :rtype: str
        """
        return self._recurring_run_id

    @recurring_run_id.setter
    def recurring_run_id(self, recurring_run_id):
        """Sets the recurring_run_id of this V2beta1Run.

        ID of the recurring run that triggered this run.  # noqa: E501

        :param recurring_run_id: The recurring_run_id of this V2beta1Run.  # noqa: E501
        :type recurring_run_id: str
        """

        self._recurring_run_id = recurring_run_id

    @property
    def state_history(self):
        """Gets the state_history of this V2beta1Run.  # noqa: E501

        Output. A sequence of run statuses. This field keeps a record  of state transitions.  # noqa: E501

        :return: The state_history of this V2beta1Run.  # noqa: E501
        :rtype: list[V2beta1RuntimeStatus]
        """
        return self._state_history

    @state_history.setter
    def state_history(self, state_history):
        """Sets the state_history of this V2beta1Run.

        Output. A sequence of run statuses. This field keeps a record  of state transitions.  # noqa: E501

        :param state_history: The state_history of this V2beta1Run.  # noqa: E501
        :type state_history: list[V2beta1RuntimeStatus]
        """

        self._state_history = state_history

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, V2beta1Run):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, V2beta1Run):
            return True

        return self.to_dict() != other.to_dict()
