import * as cdk from '@aws-cdk/core';
import * as cfn_parse from '@aws-cdk/core/lib/cfn-parse';
/**
 * Properties for defining a `AWS::EC2::CapacityReservation`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-capacityreservation.html
 */
export interface CfnCapacityReservationProps {
    /**
     * `AWS::EC2::CapacityReservation.AvailabilityZone`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-capacityreservation.html#cfn-ec2-capacityreservation-availabilityzone
     */
    readonly availabilityZone: string;
    /**
     * `AWS::EC2::CapacityReservation.InstanceCount`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-capacityreservation.html#cfn-ec2-capacityreservation-instancecount
     */
    readonly instanceCount: number;
    /**
     * `AWS::EC2::CapacityReservation.InstancePlatform`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-capacityreservation.html#cfn-ec2-capacityreservation-instanceplatform
     */
    readonly instancePlatform: string;
    /**
     * `AWS::EC2::CapacityReservation.InstanceType`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-capacityreservation.html#cfn-ec2-capacityreservation-instancetype
     */
    readonly instanceType: string;
    /**
     * `AWS::EC2::CapacityReservation.EbsOptimized`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-capacityreservation.html#cfn-ec2-capacityreservation-ebsoptimized
     */
    readonly ebsOptimized?: boolean | cdk.IResolvable;
    /**
     * `AWS::EC2::CapacityReservation.EndDate`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-capacityreservation.html#cfn-ec2-capacityreservation-enddate
     */
    readonly endDate?: string;
    /**
     * `AWS::EC2::CapacityReservation.EndDateType`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-capacityreservation.html#cfn-ec2-capacityreservation-enddatetype
     */
    readonly endDateType?: string;
    /**
     * `AWS::EC2::CapacityReservation.EphemeralStorage`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-capacityreservation.html#cfn-ec2-capacityreservation-ephemeralstorage
     */
    readonly ephemeralStorage?: boolean | cdk.IResolvable;
    /**
     * `AWS::EC2::CapacityReservation.InstanceMatchCriteria`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-capacityreservation.html#cfn-ec2-capacityreservation-instancematchcriteria
     */
    readonly instanceMatchCriteria?: string;
    /**
     * `AWS::EC2::CapacityReservation.OutPostArn`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-capacityreservation.html#cfn-ec2-capacityreservation-outpostarn
     */
    readonly outPostArn?: string;
    /**
     * `AWS::EC2::CapacityReservation.PlacementGroupArn`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-capacityreservation.html#cfn-ec2-capacityreservation-placementgrouparn
     */
    readonly placementGroupArn?: string;
    /**
     * `AWS::EC2::CapacityReservation.TagSpecifications`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-capacityreservation.html#cfn-ec2-capacityreservation-tagspecifications
     */
    readonly tagSpecifications?: Array<CfnCapacityReservation.TagSpecificationProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::EC2::CapacityReservation.Tenancy`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-capacityreservation.html#cfn-ec2-capacityreservation-tenancy
     */
    readonly tenancy?: string;
}
/**
 * A CloudFormation `AWS::EC2::CapacityReservation`.
 *
 * @external
 * @cloudformationResource AWS::EC2::CapacityReservation
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-capacityreservation.html
 */
export declare class CfnCapacityReservation extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::EC2::CapacityReservation";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnCapacityReservation;
    /**
     * @external
     * @cloudformationAttribute AvailabilityZone
     */
    readonly attrAvailabilityZone: string;
    /**
     * @external
     * @cloudformationAttribute AvailableInstanceCount
     */
    readonly attrAvailableInstanceCount: number;
    /**
     * @external
     * @cloudformationAttribute InstanceType
     */
    readonly attrInstanceType: string;
    /**
     * @external
     * @cloudformationAttribute Tenancy
     */
    readonly attrTenancy: string;
    /**
     * @external
     * @cloudformationAttribute TotalInstanceCount
     */
    readonly attrTotalInstanceCount: number;
    /**
     * `AWS::EC2::CapacityReservation.AvailabilityZone`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-capacityreservation.html#cfn-ec2-capacityreservation-availabilityzone
     */
    availabilityZone: string;
    /**
     * `AWS::EC2::CapacityReservation.InstanceCount`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-capacityreservation.html#cfn-ec2-capacityreservation-instancecount
     */
    instanceCount: number;
    /**
     * `AWS::EC2::CapacityReservation.InstancePlatform`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-capacityreservation.html#cfn-ec2-capacityreservation-instanceplatform
     */
    instancePlatform: string;
    /**
     * `AWS::EC2::CapacityReservation.InstanceType`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-capacityreservation.html#cfn-ec2-capacityreservation-instancetype
     */
    instanceType: string;
    /**
     * `AWS::EC2::CapacityReservation.EbsOptimized`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-capacityreservation.html#cfn-ec2-capacityreservation-ebsoptimized
     */
    ebsOptimized: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::EC2::CapacityReservation.EndDate`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-capacityreservation.html#cfn-ec2-capacityreservation-enddate
     */
    endDate: string | undefined;
    /**
     * `AWS::EC2::CapacityReservation.EndDateType`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-capacityreservation.html#cfn-ec2-capacityreservation-enddatetype
     */
    endDateType: string | undefined;
    /**
     * `AWS::EC2::CapacityReservation.EphemeralStorage`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-capacityreservation.html#cfn-ec2-capacityreservation-ephemeralstorage
     */
    ephemeralStorage: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::EC2::CapacityReservation.InstanceMatchCriteria`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-capacityreservation.html#cfn-ec2-capacityreservation-instancematchcriteria
     */
    instanceMatchCriteria: string | undefined;
    /**
     * `AWS::EC2::CapacityReservation.OutPostArn`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-capacityreservation.html#cfn-ec2-capacityreservation-outpostarn
     */
    outPostArn: string | undefined;
    /**
     * `AWS::EC2::CapacityReservation.PlacementGroupArn`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-capacityreservation.html#cfn-ec2-capacityreservation-placementgrouparn
     */
    placementGroupArn: string | undefined;
    /**
     * `AWS::EC2::CapacityReservation.TagSpecifications`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-capacityreservation.html#cfn-ec2-capacityreservation-tagspecifications
     */
    tagSpecifications: Array<CfnCapacityReservation.TagSpecificationProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * `AWS::EC2::CapacityReservation.Tenancy`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-capacityreservation.html#cfn-ec2-capacityreservation-tenancy
     */
    tenancy: string | undefined;
    /**
     * Create a new `AWS::EC2::CapacityReservation`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnCapacityReservationProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @external
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::EC2::CapacityReservation`.
 *
 * @external
 * @cloudformationResource AWS::EC2::CapacityReservation
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-capacityreservation.html
 */
export declare namespace CfnCapacityReservation {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-capacityreservation-tagspecification.html
     */
    interface TagSpecificationProperty {
        /**
         * `CfnCapacityReservation.TagSpecificationProperty.ResourceType`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-capacityreservation-tagspecification.html#cfn-ec2-capacityreservation-tagspecification-resourcetype
         */
        readonly resourceType?: string;
        /**
         * `CfnCapacityReservation.TagSpecificationProperty.Tags`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-capacityreservation-tagspecification.html#cfn-ec2-capacityreservation-tagspecification-tags
         */
        readonly tags?: cdk.CfnTag[];
    }
}
/**
 * Properties for defining a `AWS::EC2::CapacityReservationFleet`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-capacityreservationfleet.html
 */
export interface CfnCapacityReservationFleetProps {
    /**
     * `AWS::EC2::CapacityReservationFleet.AllocationStrategy`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-capacityreservationfleet.html#cfn-ec2-capacityreservationfleet-allocationstrategy
     */
    readonly allocationStrategy?: string;
    /**
     * `AWS::EC2::CapacityReservationFleet.EndDate`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-capacityreservationfleet.html#cfn-ec2-capacityreservationfleet-enddate
     */
    readonly endDate?: string;
    /**
     * `AWS::EC2::CapacityReservationFleet.InstanceMatchCriteria`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-capacityreservationfleet.html#cfn-ec2-capacityreservationfleet-instancematchcriteria
     */
    readonly instanceMatchCriteria?: string;
    /**
     * `AWS::EC2::CapacityReservationFleet.InstanceTypeSpecifications`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-capacityreservationfleet.html#cfn-ec2-capacityreservationfleet-instancetypespecifications
     */
    readonly instanceTypeSpecifications?: Array<CfnCapacityReservationFleet.InstanceTypeSpecificationProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::EC2::CapacityReservationFleet.NoRemoveEndDate`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-capacityreservationfleet.html#cfn-ec2-capacityreservationfleet-noremoveenddate
     */
    readonly noRemoveEndDate?: boolean | cdk.IResolvable;
    /**
     * `AWS::EC2::CapacityReservationFleet.RemoveEndDate`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-capacityreservationfleet.html#cfn-ec2-capacityreservationfleet-removeenddate
     */
    readonly removeEndDate?: boolean | cdk.IResolvable;
    /**
     * `AWS::EC2::CapacityReservationFleet.TagSpecifications`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-capacityreservationfleet.html#cfn-ec2-capacityreservationfleet-tagspecifications
     */
    readonly tagSpecifications?: Array<CfnCapacityReservationFleet.TagSpecificationProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::EC2::CapacityReservationFleet.Tenancy`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-capacityreservationfleet.html#cfn-ec2-capacityreservationfleet-tenancy
     */
    readonly tenancy?: string;
    /**
     * `AWS::EC2::CapacityReservationFleet.TotalTargetCapacity`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-capacityreservationfleet.html#cfn-ec2-capacityreservationfleet-totaltargetcapacity
     */
    readonly totalTargetCapacity?: number;
}
/**
 * A CloudFormation `AWS::EC2::CapacityReservationFleet`.
 *
 * @external
 * @cloudformationResource AWS::EC2::CapacityReservationFleet
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-capacityreservationfleet.html
 */
export declare class CfnCapacityReservationFleet extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::EC2::CapacityReservationFleet";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnCapacityReservationFleet;
    /**
     * @external
     * @cloudformationAttribute CapacityReservationFleetId
     */
    readonly attrCapacityReservationFleetId: string;
    /**
     * `AWS::EC2::CapacityReservationFleet.AllocationStrategy`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-capacityreservationfleet.html#cfn-ec2-capacityreservationfleet-allocationstrategy
     */
    allocationStrategy: string | undefined;
    /**
     * `AWS::EC2::CapacityReservationFleet.EndDate`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-capacityreservationfleet.html#cfn-ec2-capacityreservationfleet-enddate
     */
    endDate: string | undefined;
    /**
     * `AWS::EC2::CapacityReservationFleet.InstanceMatchCriteria`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-capacityreservationfleet.html#cfn-ec2-capacityreservationfleet-instancematchcriteria
     */
    instanceMatchCriteria: string | undefined;
    /**
     * `AWS::EC2::CapacityReservationFleet.InstanceTypeSpecifications`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-capacityreservationfleet.html#cfn-ec2-capacityreservationfleet-instancetypespecifications
     */
    instanceTypeSpecifications: Array<CfnCapacityReservationFleet.InstanceTypeSpecificationProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * `AWS::EC2::CapacityReservationFleet.NoRemoveEndDate`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-capacityreservationfleet.html#cfn-ec2-capacityreservationfleet-noremoveenddate
     */
    noRemoveEndDate: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::EC2::CapacityReservationFleet.RemoveEndDate`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-capacityreservationfleet.html#cfn-ec2-capacityreservationfleet-removeenddate
     */
    removeEndDate: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::EC2::CapacityReservationFleet.TagSpecifications`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-capacityreservationfleet.html#cfn-ec2-capacityreservationfleet-tagspecifications
     */
    tagSpecifications: Array<CfnCapacityReservationFleet.TagSpecificationProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * `AWS::EC2::CapacityReservationFleet.Tenancy`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-capacityreservationfleet.html#cfn-ec2-capacityreservationfleet-tenancy
     */
    tenancy: string | undefined;
    /**
     * `AWS::EC2::CapacityReservationFleet.TotalTargetCapacity`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-capacityreservationfleet.html#cfn-ec2-capacityreservationfleet-totaltargetcapacity
     */
    totalTargetCapacity: number | undefined;
    /**
     * Create a new `AWS::EC2::CapacityReservationFleet`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props?: CfnCapacityReservationFleetProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @external
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::EC2::CapacityReservationFleet`.
 *
 * @external
 * @cloudformationResource AWS::EC2::CapacityReservationFleet
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-capacityreservationfleet.html
 */
export declare namespace CfnCapacityReservationFleet {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-capacityreservationfleet-instancetypespecification.html
     */
    interface InstanceTypeSpecificationProperty {
        /**
         * `CfnCapacityReservationFleet.InstanceTypeSpecificationProperty.AvailabilityZone`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-capacityreservationfleet-instancetypespecification.html#cfn-ec2-capacityreservationfleet-instancetypespecification-availabilityzone
         */
        readonly availabilityZone?: string;
        /**
         * `CfnCapacityReservationFleet.InstanceTypeSpecificationProperty.AvailabilityZoneId`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-capacityreservationfleet-instancetypespecification.html#cfn-ec2-capacityreservationfleet-instancetypespecification-availabilityzoneid
         */
        readonly availabilityZoneId?: string;
        /**
         * `CfnCapacityReservationFleet.InstanceTypeSpecificationProperty.EbsOptimized`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-capacityreservationfleet-instancetypespecification.html#cfn-ec2-capacityreservationfleet-instancetypespecification-ebsoptimized
         */
        readonly ebsOptimized?: boolean | cdk.IResolvable;
        /**
         * `CfnCapacityReservationFleet.InstanceTypeSpecificationProperty.InstancePlatform`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-capacityreservationfleet-instancetypespecification.html#cfn-ec2-capacityreservationfleet-instancetypespecification-instanceplatform
         */
        readonly instancePlatform?: string;
        /**
         * `CfnCapacityReservationFleet.InstanceTypeSpecificationProperty.InstanceType`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-capacityreservationfleet-instancetypespecification.html#cfn-ec2-capacityreservationfleet-instancetypespecification-instancetype
         */
        readonly instanceType?: string;
        /**
         * `CfnCapacityReservationFleet.InstanceTypeSpecificationProperty.Priority`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-capacityreservationfleet-instancetypespecification.html#cfn-ec2-capacityreservationfleet-instancetypespecification-priority
         */
        readonly priority?: number;
        /**
         * `CfnCapacityReservationFleet.InstanceTypeSpecificationProperty.Weight`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-capacityreservationfleet-instancetypespecification.html#cfn-ec2-capacityreservationfleet-instancetypespecification-weight
         */
        readonly weight?: number;
    }
}
/**
 * A CloudFormation `AWS::EC2::CapacityReservationFleet`.
 *
 * @external
 * @cloudformationResource AWS::EC2::CapacityReservationFleet
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-capacityreservationfleet.html
 */
export declare namespace CfnCapacityReservationFleet {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-capacityreservationfleet-tagspecification.html
     */
    interface TagSpecificationProperty {
        /**
         * `CfnCapacityReservationFleet.TagSpecificationProperty.ResourceType`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-capacityreservationfleet-tagspecification.html#cfn-ec2-capacityreservationfleet-tagspecification-resourcetype
         */
        readonly resourceType?: string;
        /**
         * `CfnCapacityReservationFleet.TagSpecificationProperty.Tags`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-capacityreservationfleet-tagspecification.html#cfn-ec2-capacityreservationfleet-tagspecification-tags
         */
        readonly tags?: cdk.CfnTag[];
    }
}
/**
 * Properties for defining a `AWS::EC2::CarrierGateway`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-carriergateway.html
 */
export interface CfnCarrierGatewayProps {
    /**
     * `AWS::EC2::CarrierGateway.VpcId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-carriergateway.html#cfn-ec2-carriergateway-vpcid
     */
    readonly vpcId: string;
    /**
     * `AWS::EC2::CarrierGateway.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-carriergateway.html#cfn-ec2-carriergateway-tags
     */
    readonly tags?: cdk.CfnTag[];
}
/**
 * A CloudFormation `AWS::EC2::CarrierGateway`.
 *
 * @external
 * @cloudformationResource AWS::EC2::CarrierGateway
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-carriergateway.html
 */
export declare class CfnCarrierGateway extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::EC2::CarrierGateway";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnCarrierGateway;
    /**
     * @external
     * @cloudformationAttribute CarrierGatewayId
     */
    readonly attrCarrierGatewayId: string;
    /**
     * @external
     * @cloudformationAttribute OwnerId
     */
    readonly attrOwnerId: string;
    /**
     * @external
     * @cloudformationAttribute State
     */
    readonly attrState: string;
    /**
     * `AWS::EC2::CarrierGateway.VpcId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-carriergateway.html#cfn-ec2-carriergateway-vpcid
     */
    vpcId: string;
    /**
     * `AWS::EC2::CarrierGateway.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-carriergateway.html#cfn-ec2-carriergateway-tags
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::EC2::CarrierGateway`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnCarrierGatewayProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @external
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::EC2::ClientVpnAuthorizationRule`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-clientvpnauthorizationrule.html
 */
export interface CfnClientVpnAuthorizationRuleProps {
    /**
     * `AWS::EC2::ClientVpnAuthorizationRule.ClientVpnEndpointId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-clientvpnauthorizationrule.html#cfn-ec2-clientvpnauthorizationrule-clientvpnendpointid
     */
    readonly clientVpnEndpointId: string;
    /**
     * `AWS::EC2::ClientVpnAuthorizationRule.TargetNetworkCidr`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-clientvpnauthorizationrule.html#cfn-ec2-clientvpnauthorizationrule-targetnetworkcidr
     */
    readonly targetNetworkCidr: string;
    /**
     * `AWS::EC2::ClientVpnAuthorizationRule.AccessGroupId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-clientvpnauthorizationrule.html#cfn-ec2-clientvpnauthorizationrule-accessgroupid
     */
    readonly accessGroupId?: string;
    /**
     * `AWS::EC2::ClientVpnAuthorizationRule.AuthorizeAllGroups`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-clientvpnauthorizationrule.html#cfn-ec2-clientvpnauthorizationrule-authorizeallgroups
     */
    readonly authorizeAllGroups?: boolean | cdk.IResolvable;
    /**
     * `AWS::EC2::ClientVpnAuthorizationRule.Description`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-clientvpnauthorizationrule.html#cfn-ec2-clientvpnauthorizationrule-description
     */
    readonly description?: string;
}
/**
 * A CloudFormation `AWS::EC2::ClientVpnAuthorizationRule`.
 *
 * @external
 * @cloudformationResource AWS::EC2::ClientVpnAuthorizationRule
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-clientvpnauthorizationrule.html
 */
export declare class CfnClientVpnAuthorizationRule extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::EC2::ClientVpnAuthorizationRule";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnClientVpnAuthorizationRule;
    /**
     * `AWS::EC2::ClientVpnAuthorizationRule.ClientVpnEndpointId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-clientvpnauthorizationrule.html#cfn-ec2-clientvpnauthorizationrule-clientvpnendpointid
     */
    clientVpnEndpointId: string;
    /**
     * `AWS::EC2::ClientVpnAuthorizationRule.TargetNetworkCidr`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-clientvpnauthorizationrule.html#cfn-ec2-clientvpnauthorizationrule-targetnetworkcidr
     */
    targetNetworkCidr: string;
    /**
     * `AWS::EC2::ClientVpnAuthorizationRule.AccessGroupId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-clientvpnauthorizationrule.html#cfn-ec2-clientvpnauthorizationrule-accessgroupid
     */
    accessGroupId: string | undefined;
    /**
     * `AWS::EC2::ClientVpnAuthorizationRule.AuthorizeAllGroups`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-clientvpnauthorizationrule.html#cfn-ec2-clientvpnauthorizationrule-authorizeallgroups
     */
    authorizeAllGroups: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::EC2::ClientVpnAuthorizationRule.Description`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-clientvpnauthorizationrule.html#cfn-ec2-clientvpnauthorizationrule-description
     */
    description: string | undefined;
    /**
     * Create a new `AWS::EC2::ClientVpnAuthorizationRule`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnClientVpnAuthorizationRuleProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @external
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::EC2::ClientVpnEndpoint`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-clientvpnendpoint.html
 */
export interface CfnClientVpnEndpointProps {
    /**
     * `AWS::EC2::ClientVpnEndpoint.AuthenticationOptions`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-clientvpnendpoint.html#cfn-ec2-clientvpnendpoint-authenticationoptions
     */
    readonly authenticationOptions: Array<CfnClientVpnEndpoint.ClientAuthenticationRequestProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::EC2::ClientVpnEndpoint.ClientCidrBlock`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-clientvpnendpoint.html#cfn-ec2-clientvpnendpoint-clientcidrblock
     */
    readonly clientCidrBlock: string;
    /**
     * `AWS::EC2::ClientVpnEndpoint.ConnectionLogOptions`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-clientvpnendpoint.html#cfn-ec2-clientvpnendpoint-connectionlogoptions
     */
    readonly connectionLogOptions: CfnClientVpnEndpoint.ConnectionLogOptionsProperty | cdk.IResolvable;
    /**
     * `AWS::EC2::ClientVpnEndpoint.ServerCertificateArn`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-clientvpnendpoint.html#cfn-ec2-clientvpnendpoint-servercertificatearn
     */
    readonly serverCertificateArn: string;
    /**
     * `AWS::EC2::ClientVpnEndpoint.ClientConnectOptions`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-clientvpnendpoint.html#cfn-ec2-clientvpnendpoint-clientconnectoptions
     */
    readonly clientConnectOptions?: CfnClientVpnEndpoint.ClientConnectOptionsProperty | cdk.IResolvable;
    /**
     * `AWS::EC2::ClientVpnEndpoint.Description`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-clientvpnendpoint.html#cfn-ec2-clientvpnendpoint-description
     */
    readonly description?: string;
    /**
     * `AWS::EC2::ClientVpnEndpoint.DnsServers`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-clientvpnendpoint.html#cfn-ec2-clientvpnendpoint-dnsservers
     */
    readonly dnsServers?: string[];
    /**
     * `AWS::EC2::ClientVpnEndpoint.SecurityGroupIds`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-clientvpnendpoint.html#cfn-ec2-clientvpnendpoint-securitygroupids
     */
    readonly securityGroupIds?: string[];
    /**
     * `AWS::EC2::ClientVpnEndpoint.SelfServicePortal`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-clientvpnendpoint.html#cfn-ec2-clientvpnendpoint-selfserviceportal
     */
    readonly selfServicePortal?: string;
    /**
     * `AWS::EC2::ClientVpnEndpoint.SplitTunnel`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-clientvpnendpoint.html#cfn-ec2-clientvpnendpoint-splittunnel
     */
    readonly splitTunnel?: boolean | cdk.IResolvable;
    /**
     * `AWS::EC2::ClientVpnEndpoint.TagSpecifications`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-clientvpnendpoint.html#cfn-ec2-clientvpnendpoint-tagspecifications
     */
    readonly tagSpecifications?: Array<CfnClientVpnEndpoint.TagSpecificationProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::EC2::ClientVpnEndpoint.TransportProtocol`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-clientvpnendpoint.html#cfn-ec2-clientvpnendpoint-transportprotocol
     */
    readonly transportProtocol?: string;
    /**
     * `AWS::EC2::ClientVpnEndpoint.VpcId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-clientvpnendpoint.html#cfn-ec2-clientvpnendpoint-vpcid
     */
    readonly vpcId?: string;
    /**
     * `AWS::EC2::ClientVpnEndpoint.VpnPort`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-clientvpnendpoint.html#cfn-ec2-clientvpnendpoint-vpnport
     */
    readonly vpnPort?: number;
}
/**
 * A CloudFormation `AWS::EC2::ClientVpnEndpoint`.
 *
 * @external
 * @cloudformationResource AWS::EC2::ClientVpnEndpoint
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-clientvpnendpoint.html
 */
export declare class CfnClientVpnEndpoint extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::EC2::ClientVpnEndpoint";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnClientVpnEndpoint;
    /**
     * `AWS::EC2::ClientVpnEndpoint.AuthenticationOptions`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-clientvpnendpoint.html#cfn-ec2-clientvpnendpoint-authenticationoptions
     */
    authenticationOptions: Array<CfnClientVpnEndpoint.ClientAuthenticationRequestProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::EC2::ClientVpnEndpoint.ClientCidrBlock`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-clientvpnendpoint.html#cfn-ec2-clientvpnendpoint-clientcidrblock
     */
    clientCidrBlock: string;
    /**
     * `AWS::EC2::ClientVpnEndpoint.ConnectionLogOptions`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-clientvpnendpoint.html#cfn-ec2-clientvpnendpoint-connectionlogoptions
     */
    connectionLogOptions: CfnClientVpnEndpoint.ConnectionLogOptionsProperty | cdk.IResolvable;
    /**
     * `AWS::EC2::ClientVpnEndpoint.ServerCertificateArn`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-clientvpnendpoint.html#cfn-ec2-clientvpnendpoint-servercertificatearn
     */
    serverCertificateArn: string;
    /**
     * `AWS::EC2::ClientVpnEndpoint.ClientConnectOptions`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-clientvpnendpoint.html#cfn-ec2-clientvpnendpoint-clientconnectoptions
     */
    clientConnectOptions: CfnClientVpnEndpoint.ClientConnectOptionsProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::EC2::ClientVpnEndpoint.Description`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-clientvpnendpoint.html#cfn-ec2-clientvpnendpoint-description
     */
    description: string | undefined;
    /**
     * `AWS::EC2::ClientVpnEndpoint.DnsServers`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-clientvpnendpoint.html#cfn-ec2-clientvpnendpoint-dnsservers
     */
    dnsServers: string[] | undefined;
    /**
     * `AWS::EC2::ClientVpnEndpoint.SecurityGroupIds`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-clientvpnendpoint.html#cfn-ec2-clientvpnendpoint-securitygroupids
     */
    securityGroupIds: string[] | undefined;
    /**
     * `AWS::EC2::ClientVpnEndpoint.SelfServicePortal`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-clientvpnendpoint.html#cfn-ec2-clientvpnendpoint-selfserviceportal
     */
    selfServicePortal: string | undefined;
    /**
     * `AWS::EC2::ClientVpnEndpoint.SplitTunnel`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-clientvpnendpoint.html#cfn-ec2-clientvpnendpoint-splittunnel
     */
    splitTunnel: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::EC2::ClientVpnEndpoint.TagSpecifications`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-clientvpnendpoint.html#cfn-ec2-clientvpnendpoint-tagspecifications
     */
    tagSpecifications: Array<CfnClientVpnEndpoint.TagSpecificationProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * `AWS::EC2::ClientVpnEndpoint.TransportProtocol`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-clientvpnendpoint.html#cfn-ec2-clientvpnendpoint-transportprotocol
     */
    transportProtocol: string | undefined;
    /**
     * `AWS::EC2::ClientVpnEndpoint.VpcId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-clientvpnendpoint.html#cfn-ec2-clientvpnendpoint-vpcid
     */
    vpcId: string | undefined;
    /**
     * `AWS::EC2::ClientVpnEndpoint.VpnPort`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-clientvpnendpoint.html#cfn-ec2-clientvpnendpoint-vpnport
     */
    vpnPort: number | undefined;
    /**
     * Create a new `AWS::EC2::ClientVpnEndpoint`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnClientVpnEndpointProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @external
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::EC2::ClientVpnEndpoint`.
 *
 * @external
 * @cloudformationResource AWS::EC2::ClientVpnEndpoint
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-clientvpnendpoint.html
 */
export declare namespace CfnClientVpnEndpoint {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-clientvpnendpoint-certificateauthenticationrequest.html
     */
    interface CertificateAuthenticationRequestProperty {
        /**
         * `CfnClientVpnEndpoint.CertificateAuthenticationRequestProperty.ClientRootCertificateChainArn`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-clientvpnendpoint-certificateauthenticationrequest.html#cfn-ec2-clientvpnendpoint-certificateauthenticationrequest-clientrootcertificatechainarn
         */
        readonly clientRootCertificateChainArn: string;
    }
}
/**
 * A CloudFormation `AWS::EC2::ClientVpnEndpoint`.
 *
 * @external
 * @cloudformationResource AWS::EC2::ClientVpnEndpoint
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-clientvpnendpoint.html
 */
export declare namespace CfnClientVpnEndpoint {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-clientvpnendpoint-clientauthenticationrequest.html
     */
    interface ClientAuthenticationRequestProperty {
        /**
         * `CfnClientVpnEndpoint.ClientAuthenticationRequestProperty.ActiveDirectory`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-clientvpnendpoint-clientauthenticationrequest.html#cfn-ec2-clientvpnendpoint-clientauthenticationrequest-activedirectory
         */
        readonly activeDirectory?: CfnClientVpnEndpoint.DirectoryServiceAuthenticationRequestProperty | cdk.IResolvable;
        /**
         * `CfnClientVpnEndpoint.ClientAuthenticationRequestProperty.FederatedAuthentication`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-clientvpnendpoint-clientauthenticationrequest.html#cfn-ec2-clientvpnendpoint-clientauthenticationrequest-federatedauthentication
         */
        readonly federatedAuthentication?: CfnClientVpnEndpoint.FederatedAuthenticationRequestProperty | cdk.IResolvable;
        /**
         * `CfnClientVpnEndpoint.ClientAuthenticationRequestProperty.MutualAuthentication`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-clientvpnendpoint-clientauthenticationrequest.html#cfn-ec2-clientvpnendpoint-clientauthenticationrequest-mutualauthentication
         */
        readonly mutualAuthentication?: CfnClientVpnEndpoint.CertificateAuthenticationRequestProperty | cdk.IResolvable;
        /**
         * `CfnClientVpnEndpoint.ClientAuthenticationRequestProperty.Type`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-clientvpnendpoint-clientauthenticationrequest.html#cfn-ec2-clientvpnendpoint-clientauthenticationrequest-type
         */
        readonly type: string;
    }
}
/**
 * A CloudFormation `AWS::EC2::ClientVpnEndpoint`.
 *
 * @external
 * @cloudformationResource AWS::EC2::ClientVpnEndpoint
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-clientvpnendpoint.html
 */
export declare namespace CfnClientVpnEndpoint {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-clientvpnendpoint-clientconnectoptions.html
     */
    interface ClientConnectOptionsProperty {
        /**
         * `CfnClientVpnEndpoint.ClientConnectOptionsProperty.Enabled`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-clientvpnendpoint-clientconnectoptions.html#cfn-ec2-clientvpnendpoint-clientconnectoptions-enabled
         */
        readonly enabled: boolean | cdk.IResolvable;
        /**
         * `CfnClientVpnEndpoint.ClientConnectOptionsProperty.LambdaFunctionArn`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-clientvpnendpoint-clientconnectoptions.html#cfn-ec2-clientvpnendpoint-clientconnectoptions-lambdafunctionarn
         */
        readonly lambdaFunctionArn?: string;
    }
}
/**
 * A CloudFormation `AWS::EC2::ClientVpnEndpoint`.
 *
 * @external
 * @cloudformationResource AWS::EC2::ClientVpnEndpoint
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-clientvpnendpoint.html
 */
export declare namespace CfnClientVpnEndpoint {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-clientvpnendpoint-connectionlogoptions.html
     */
    interface ConnectionLogOptionsProperty {
        /**
         * `CfnClientVpnEndpoint.ConnectionLogOptionsProperty.CloudwatchLogGroup`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-clientvpnendpoint-connectionlogoptions.html#cfn-ec2-clientvpnendpoint-connectionlogoptions-cloudwatchloggroup
         */
        readonly cloudwatchLogGroup?: string;
        /**
         * `CfnClientVpnEndpoint.ConnectionLogOptionsProperty.CloudwatchLogStream`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-clientvpnendpoint-connectionlogoptions.html#cfn-ec2-clientvpnendpoint-connectionlogoptions-cloudwatchlogstream
         */
        readonly cloudwatchLogStream?: string;
        /**
         * `CfnClientVpnEndpoint.ConnectionLogOptionsProperty.Enabled`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-clientvpnendpoint-connectionlogoptions.html#cfn-ec2-clientvpnendpoint-connectionlogoptions-enabled
         */
        readonly enabled: boolean | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::EC2::ClientVpnEndpoint`.
 *
 * @external
 * @cloudformationResource AWS::EC2::ClientVpnEndpoint
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-clientvpnendpoint.html
 */
export declare namespace CfnClientVpnEndpoint {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-clientvpnendpoint-directoryserviceauthenticationrequest.html
     */
    interface DirectoryServiceAuthenticationRequestProperty {
        /**
         * `CfnClientVpnEndpoint.DirectoryServiceAuthenticationRequestProperty.DirectoryId`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-clientvpnendpoint-directoryserviceauthenticationrequest.html#cfn-ec2-clientvpnendpoint-directoryserviceauthenticationrequest-directoryid
         */
        readonly directoryId: string;
    }
}
/**
 * A CloudFormation `AWS::EC2::ClientVpnEndpoint`.
 *
 * @external
 * @cloudformationResource AWS::EC2::ClientVpnEndpoint
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-clientvpnendpoint.html
 */
export declare namespace CfnClientVpnEndpoint {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-clientvpnendpoint-federatedauthenticationrequest.html
     */
    interface FederatedAuthenticationRequestProperty {
        /**
         * `CfnClientVpnEndpoint.FederatedAuthenticationRequestProperty.SAMLProviderArn`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-clientvpnendpoint-federatedauthenticationrequest.html#cfn-ec2-clientvpnendpoint-federatedauthenticationrequest-samlproviderarn
         */
        readonly samlProviderArn: string;
        /**
         * `CfnClientVpnEndpoint.FederatedAuthenticationRequestProperty.SelfServiceSAMLProviderArn`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-clientvpnendpoint-federatedauthenticationrequest.html#cfn-ec2-clientvpnendpoint-federatedauthenticationrequest-selfservicesamlproviderarn
         */
        readonly selfServiceSamlProviderArn?: string;
    }
}
/**
 * A CloudFormation `AWS::EC2::ClientVpnEndpoint`.
 *
 * @external
 * @cloudformationResource AWS::EC2::ClientVpnEndpoint
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-clientvpnendpoint.html
 */
export declare namespace CfnClientVpnEndpoint {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-clientvpnendpoint-tagspecification.html
     */
    interface TagSpecificationProperty {
        /**
         * `CfnClientVpnEndpoint.TagSpecificationProperty.ResourceType`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-clientvpnendpoint-tagspecification.html#cfn-ec2-clientvpnendpoint-tagspecification-resourcetype
         */
        readonly resourceType: string;
        /**
         * `CfnClientVpnEndpoint.TagSpecificationProperty.Tags`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-clientvpnendpoint-tagspecification.html#cfn-ec2-clientvpnendpoint-tagspecification-tags
         */
        readonly tags: cdk.CfnTag[];
    }
}
/**
 * Properties for defining a `AWS::EC2::ClientVpnRoute`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-clientvpnroute.html
 */
export interface CfnClientVpnRouteProps {
    /**
     * `AWS::EC2::ClientVpnRoute.ClientVpnEndpointId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-clientvpnroute.html#cfn-ec2-clientvpnroute-clientvpnendpointid
     */
    readonly clientVpnEndpointId: string;
    /**
     * `AWS::EC2::ClientVpnRoute.DestinationCidrBlock`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-clientvpnroute.html#cfn-ec2-clientvpnroute-destinationcidrblock
     */
    readonly destinationCidrBlock: string;
    /**
     * `AWS::EC2::ClientVpnRoute.TargetVpcSubnetId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-clientvpnroute.html#cfn-ec2-clientvpnroute-targetvpcsubnetid
     */
    readonly targetVpcSubnetId: string;
    /**
     * `AWS::EC2::ClientVpnRoute.Description`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-clientvpnroute.html#cfn-ec2-clientvpnroute-description
     */
    readonly description?: string;
}
/**
 * A CloudFormation `AWS::EC2::ClientVpnRoute`.
 *
 * @external
 * @cloudformationResource AWS::EC2::ClientVpnRoute
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-clientvpnroute.html
 */
export declare class CfnClientVpnRoute extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::EC2::ClientVpnRoute";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnClientVpnRoute;
    /**
     * `AWS::EC2::ClientVpnRoute.ClientVpnEndpointId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-clientvpnroute.html#cfn-ec2-clientvpnroute-clientvpnendpointid
     */
    clientVpnEndpointId: string;
    /**
     * `AWS::EC2::ClientVpnRoute.DestinationCidrBlock`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-clientvpnroute.html#cfn-ec2-clientvpnroute-destinationcidrblock
     */
    destinationCidrBlock: string;
    /**
     * `AWS::EC2::ClientVpnRoute.TargetVpcSubnetId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-clientvpnroute.html#cfn-ec2-clientvpnroute-targetvpcsubnetid
     */
    targetVpcSubnetId: string;
    /**
     * `AWS::EC2::ClientVpnRoute.Description`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-clientvpnroute.html#cfn-ec2-clientvpnroute-description
     */
    description: string | undefined;
    /**
     * Create a new `AWS::EC2::ClientVpnRoute`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnClientVpnRouteProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @external
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::EC2::ClientVpnTargetNetworkAssociation`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-clientvpntargetnetworkassociation.html
 */
export interface CfnClientVpnTargetNetworkAssociationProps {
    /**
     * `AWS::EC2::ClientVpnTargetNetworkAssociation.ClientVpnEndpointId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-clientvpntargetnetworkassociation.html#cfn-ec2-clientvpntargetnetworkassociation-clientvpnendpointid
     */
    readonly clientVpnEndpointId: string;
    /**
     * `AWS::EC2::ClientVpnTargetNetworkAssociation.SubnetId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-clientvpntargetnetworkassociation.html#cfn-ec2-clientvpntargetnetworkassociation-subnetid
     */
    readonly subnetId: string;
}
/**
 * A CloudFormation `AWS::EC2::ClientVpnTargetNetworkAssociation`.
 *
 * @external
 * @cloudformationResource AWS::EC2::ClientVpnTargetNetworkAssociation
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-clientvpntargetnetworkassociation.html
 */
export declare class CfnClientVpnTargetNetworkAssociation extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::EC2::ClientVpnTargetNetworkAssociation";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnClientVpnTargetNetworkAssociation;
    /**
     * `AWS::EC2::ClientVpnTargetNetworkAssociation.ClientVpnEndpointId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-clientvpntargetnetworkassociation.html#cfn-ec2-clientvpntargetnetworkassociation-clientvpnendpointid
     */
    clientVpnEndpointId: string;
    /**
     * `AWS::EC2::ClientVpnTargetNetworkAssociation.SubnetId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-clientvpntargetnetworkassociation.html#cfn-ec2-clientvpntargetnetworkassociation-subnetid
     */
    subnetId: string;
    /**
     * Create a new `AWS::EC2::ClientVpnTargetNetworkAssociation`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnClientVpnTargetNetworkAssociationProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @external
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::EC2::CustomerGateway`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-customer-gateway.html
 */
export interface CfnCustomerGatewayProps {
    /**
     * `AWS::EC2::CustomerGateway.BgpAsn`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-customer-gateway.html#cfn-ec2-customergateway-bgpasn
     */
    readonly bgpAsn: number;
    /**
     * `AWS::EC2::CustomerGateway.IpAddress`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-customer-gateway.html#cfn-ec2-customergateway-ipaddress
     */
    readonly ipAddress: string;
    /**
     * `AWS::EC2::CustomerGateway.Type`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-customer-gateway.html#cfn-ec2-customergateway-type
     */
    readonly type: string;
    /**
     * `AWS::EC2::CustomerGateway.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-customer-gateway.html#cfn-ec2-customergateway-tags
     */
    readonly tags?: cdk.CfnTag[];
}
/**
 * A CloudFormation `AWS::EC2::CustomerGateway`.
 *
 * @external
 * @cloudformationResource AWS::EC2::CustomerGateway
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-customer-gateway.html
 */
export declare class CfnCustomerGateway extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::EC2::CustomerGateway";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnCustomerGateway;
    /**
     * `AWS::EC2::CustomerGateway.BgpAsn`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-customer-gateway.html#cfn-ec2-customergateway-bgpasn
     */
    bgpAsn: number;
    /**
     * `AWS::EC2::CustomerGateway.IpAddress`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-customer-gateway.html#cfn-ec2-customergateway-ipaddress
     */
    ipAddress: string;
    /**
     * `AWS::EC2::CustomerGateway.Type`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-customer-gateway.html#cfn-ec2-customergateway-type
     */
    type: string;
    /**
     * `AWS::EC2::CustomerGateway.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-customer-gateway.html#cfn-ec2-customergateway-tags
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::EC2::CustomerGateway`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnCustomerGatewayProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @external
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::EC2::DHCPOptions`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-dhcpoptions.html
 */
export interface CfnDHCPOptionsProps {
    /**
     * `AWS::EC2::DHCPOptions.DomainName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-dhcpoptions.html#cfn-ec2-dhcpoptions-domainname
     */
    readonly domainName?: string;
    /**
     * `AWS::EC2::DHCPOptions.DomainNameServers`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-dhcpoptions.html#cfn-ec2-dhcpoptions-domainnameservers
     */
    readonly domainNameServers?: string[];
    /**
     * `AWS::EC2::DHCPOptions.NetbiosNameServers`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-dhcpoptions.html#cfn-ec2-dhcpoptions-netbiosnameservers
     */
    readonly netbiosNameServers?: string[];
    /**
     * `AWS::EC2::DHCPOptions.NetbiosNodeType`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-dhcpoptions.html#cfn-ec2-dhcpoptions-netbiosnodetype
     */
    readonly netbiosNodeType?: number;
    /**
     * `AWS::EC2::DHCPOptions.NtpServers`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-dhcpoptions.html#cfn-ec2-dhcpoptions-ntpservers
     */
    readonly ntpServers?: string[];
    /**
     * `AWS::EC2::DHCPOptions.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-dhcpoptions.html#cfn-ec2-dhcpoptions-tags
     */
    readonly tags?: cdk.CfnTag[];
}
/**
 * A CloudFormation `AWS::EC2::DHCPOptions`.
 *
 * @external
 * @cloudformationResource AWS::EC2::DHCPOptions
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-dhcpoptions.html
 */
export declare class CfnDHCPOptions extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::EC2::DHCPOptions";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnDHCPOptions;
    /**
     * @external
     * @cloudformationAttribute DhcpOptionsId
     */
    readonly attrDhcpOptionsId: string;
    /**
     * `AWS::EC2::DHCPOptions.DomainName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-dhcpoptions.html#cfn-ec2-dhcpoptions-domainname
     */
    domainName: string | undefined;
    /**
     * `AWS::EC2::DHCPOptions.DomainNameServers`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-dhcpoptions.html#cfn-ec2-dhcpoptions-domainnameservers
     */
    domainNameServers: string[] | undefined;
    /**
     * `AWS::EC2::DHCPOptions.NetbiosNameServers`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-dhcpoptions.html#cfn-ec2-dhcpoptions-netbiosnameservers
     */
    netbiosNameServers: string[] | undefined;
    /**
     * `AWS::EC2::DHCPOptions.NetbiosNodeType`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-dhcpoptions.html#cfn-ec2-dhcpoptions-netbiosnodetype
     */
    netbiosNodeType: number | undefined;
    /**
     * `AWS::EC2::DHCPOptions.NtpServers`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-dhcpoptions.html#cfn-ec2-dhcpoptions-ntpservers
     */
    ntpServers: string[] | undefined;
    /**
     * `AWS::EC2::DHCPOptions.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-dhcpoptions.html#cfn-ec2-dhcpoptions-tags
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::EC2::DHCPOptions`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props?: CfnDHCPOptionsProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @external
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::EC2::EC2Fleet`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-ec2fleet.html
 */
export interface CfnEC2FleetProps {
    /**
     * `AWS::EC2::EC2Fleet.LaunchTemplateConfigs`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-ec2fleet.html#cfn-ec2-ec2fleet-launchtemplateconfigs
     */
    readonly launchTemplateConfigs: Array<CfnEC2Fleet.FleetLaunchTemplateConfigRequestProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::EC2::EC2Fleet.TargetCapacitySpecification`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-ec2fleet.html#cfn-ec2-ec2fleet-targetcapacityspecification
     */
    readonly targetCapacitySpecification: CfnEC2Fleet.TargetCapacitySpecificationRequestProperty | cdk.IResolvable;
    /**
     * `AWS::EC2::EC2Fleet.Context`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-ec2fleet.html#cfn-ec2-ec2fleet-context
     */
    readonly context?: string;
    /**
     * `AWS::EC2::EC2Fleet.ExcessCapacityTerminationPolicy`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-ec2fleet.html#cfn-ec2-ec2fleet-excesscapacityterminationpolicy
     */
    readonly excessCapacityTerminationPolicy?: string;
    /**
     * `AWS::EC2::EC2Fleet.OnDemandOptions`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-ec2fleet.html#cfn-ec2-ec2fleet-ondemandoptions
     */
    readonly onDemandOptions?: CfnEC2Fleet.OnDemandOptionsRequestProperty | cdk.IResolvable;
    /**
     * `AWS::EC2::EC2Fleet.ReplaceUnhealthyInstances`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-ec2fleet.html#cfn-ec2-ec2fleet-replaceunhealthyinstances
     */
    readonly replaceUnhealthyInstances?: boolean | cdk.IResolvable;
    /**
     * `AWS::EC2::EC2Fleet.SpotOptions`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-ec2fleet.html#cfn-ec2-ec2fleet-spotoptions
     */
    readonly spotOptions?: CfnEC2Fleet.SpotOptionsRequestProperty | cdk.IResolvable;
    /**
     * `AWS::EC2::EC2Fleet.TagSpecifications`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-ec2fleet.html#cfn-ec2-ec2fleet-tagspecifications
     */
    readonly tagSpecifications?: Array<CfnEC2Fleet.TagSpecificationProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::EC2::EC2Fleet.TerminateInstancesWithExpiration`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-ec2fleet.html#cfn-ec2-ec2fleet-terminateinstanceswithexpiration
     */
    readonly terminateInstancesWithExpiration?: boolean | cdk.IResolvable;
    /**
     * `AWS::EC2::EC2Fleet.Type`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-ec2fleet.html#cfn-ec2-ec2fleet-type
     */
    readonly type?: string;
    /**
     * `AWS::EC2::EC2Fleet.ValidFrom`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-ec2fleet.html#cfn-ec2-ec2fleet-validfrom
     */
    readonly validFrom?: string;
    /**
     * `AWS::EC2::EC2Fleet.ValidUntil`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-ec2fleet.html#cfn-ec2-ec2fleet-validuntil
     */
    readonly validUntil?: string;
}
/**
 * A CloudFormation `AWS::EC2::EC2Fleet`.
 *
 * @external
 * @cloudformationResource AWS::EC2::EC2Fleet
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-ec2fleet.html
 */
export declare class CfnEC2Fleet extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::EC2::EC2Fleet";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnEC2Fleet;
    /**
     * @external
     * @cloudformationAttribute FleetId
     */
    readonly attrFleetId: string;
    /**
     * `AWS::EC2::EC2Fleet.LaunchTemplateConfigs`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-ec2fleet.html#cfn-ec2-ec2fleet-launchtemplateconfigs
     */
    launchTemplateConfigs: Array<CfnEC2Fleet.FleetLaunchTemplateConfigRequestProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::EC2::EC2Fleet.TargetCapacitySpecification`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-ec2fleet.html#cfn-ec2-ec2fleet-targetcapacityspecification
     */
    targetCapacitySpecification: CfnEC2Fleet.TargetCapacitySpecificationRequestProperty | cdk.IResolvable;
    /**
     * `AWS::EC2::EC2Fleet.Context`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-ec2fleet.html#cfn-ec2-ec2fleet-context
     */
    context: string | undefined;
    /**
     * `AWS::EC2::EC2Fleet.ExcessCapacityTerminationPolicy`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-ec2fleet.html#cfn-ec2-ec2fleet-excesscapacityterminationpolicy
     */
    excessCapacityTerminationPolicy: string | undefined;
    /**
     * `AWS::EC2::EC2Fleet.OnDemandOptions`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-ec2fleet.html#cfn-ec2-ec2fleet-ondemandoptions
     */
    onDemandOptions: CfnEC2Fleet.OnDemandOptionsRequestProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::EC2::EC2Fleet.ReplaceUnhealthyInstances`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-ec2fleet.html#cfn-ec2-ec2fleet-replaceunhealthyinstances
     */
    replaceUnhealthyInstances: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::EC2::EC2Fleet.SpotOptions`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-ec2fleet.html#cfn-ec2-ec2fleet-spotoptions
     */
    spotOptions: CfnEC2Fleet.SpotOptionsRequestProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::EC2::EC2Fleet.TagSpecifications`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-ec2fleet.html#cfn-ec2-ec2fleet-tagspecifications
     */
    tagSpecifications: Array<CfnEC2Fleet.TagSpecificationProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * `AWS::EC2::EC2Fleet.TerminateInstancesWithExpiration`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-ec2fleet.html#cfn-ec2-ec2fleet-terminateinstanceswithexpiration
     */
    terminateInstancesWithExpiration: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::EC2::EC2Fleet.Type`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-ec2fleet.html#cfn-ec2-ec2fleet-type
     */
    type: string | undefined;
    /**
     * `AWS::EC2::EC2Fleet.ValidFrom`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-ec2fleet.html#cfn-ec2-ec2fleet-validfrom
     */
    validFrom: string | undefined;
    /**
     * `AWS::EC2::EC2Fleet.ValidUntil`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-ec2fleet.html#cfn-ec2-ec2fleet-validuntil
     */
    validUntil: string | undefined;
    /**
     * Create a new `AWS::EC2::EC2Fleet`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnEC2FleetProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @external
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::EC2::EC2Fleet`.
 *
 * @external
 * @cloudformationResource AWS::EC2::EC2Fleet
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-ec2fleet.html
 */
export declare namespace CfnEC2Fleet {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-acceleratorcountrequest.html
     */
    interface AcceleratorCountRequestProperty {
        /**
         * `CfnEC2Fleet.AcceleratorCountRequestProperty.Max`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-acceleratorcountrequest.html#cfn-ec2-ec2fleet-acceleratorcountrequest-max
         */
        readonly max?: number;
        /**
         * `CfnEC2Fleet.AcceleratorCountRequestProperty.Min`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-acceleratorcountrequest.html#cfn-ec2-ec2fleet-acceleratorcountrequest-min
         */
        readonly min?: number;
    }
}
/**
 * A CloudFormation `AWS::EC2::EC2Fleet`.
 *
 * @external
 * @cloudformationResource AWS::EC2::EC2Fleet
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-ec2fleet.html
 */
export declare namespace CfnEC2Fleet {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-acceleratortotalmemorymibrequest.html
     */
    interface AcceleratorTotalMemoryMiBRequestProperty {
        /**
         * `CfnEC2Fleet.AcceleratorTotalMemoryMiBRequestProperty.Max`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-acceleratortotalmemorymibrequest.html#cfn-ec2-ec2fleet-acceleratortotalmemorymibrequest-max
         */
        readonly max?: number;
        /**
         * `CfnEC2Fleet.AcceleratorTotalMemoryMiBRequestProperty.Min`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-acceleratortotalmemorymibrequest.html#cfn-ec2-ec2fleet-acceleratortotalmemorymibrequest-min
         */
        readonly min?: number;
    }
}
/**
 * A CloudFormation `AWS::EC2::EC2Fleet`.
 *
 * @external
 * @cloudformationResource AWS::EC2::EC2Fleet
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-ec2fleet.html
 */
export declare namespace CfnEC2Fleet {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-baselineebsbandwidthmbpsrequest.html
     */
    interface BaselineEbsBandwidthMbpsRequestProperty {
        /**
         * `CfnEC2Fleet.BaselineEbsBandwidthMbpsRequestProperty.Max`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-baselineebsbandwidthmbpsrequest.html#cfn-ec2-ec2fleet-baselineebsbandwidthmbpsrequest-max
         */
        readonly max?: number;
        /**
         * `CfnEC2Fleet.BaselineEbsBandwidthMbpsRequestProperty.Min`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-baselineebsbandwidthmbpsrequest.html#cfn-ec2-ec2fleet-baselineebsbandwidthmbpsrequest-min
         */
        readonly min?: number;
    }
}
/**
 * A CloudFormation `AWS::EC2::EC2Fleet`.
 *
 * @external
 * @cloudformationResource AWS::EC2::EC2Fleet
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-ec2fleet.html
 */
export declare namespace CfnEC2Fleet {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-capacityrebalance.html
     */
    interface CapacityRebalanceProperty {
        /**
         * `CfnEC2Fleet.CapacityRebalanceProperty.ReplacementStrategy`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-capacityrebalance.html#cfn-ec2-ec2fleet-capacityrebalance-replacementstrategy
         */
        readonly replacementStrategy?: string;
        /**
         * `CfnEC2Fleet.CapacityRebalanceProperty.TerminationDelay`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-capacityrebalance.html#cfn-ec2-ec2fleet-capacityrebalance-terminationdelay
         */
        readonly terminationDelay?: number;
    }
}
/**
 * A CloudFormation `AWS::EC2::EC2Fleet`.
 *
 * @external
 * @cloudformationResource AWS::EC2::EC2Fleet
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-ec2fleet.html
 */
export declare namespace CfnEC2Fleet {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-capacityreservationoptionsrequest.html
     */
    interface CapacityReservationOptionsRequestProperty {
        /**
         * `CfnEC2Fleet.CapacityReservationOptionsRequestProperty.UsageStrategy`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-capacityreservationoptionsrequest.html#cfn-ec2-ec2fleet-capacityreservationoptionsrequest-usagestrategy
         */
        readonly usageStrategy?: string;
    }
}
/**
 * A CloudFormation `AWS::EC2::EC2Fleet`.
 *
 * @external
 * @cloudformationResource AWS::EC2::EC2Fleet
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-ec2fleet.html
 */
export declare namespace CfnEC2Fleet {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-fleetlaunchtemplateconfigrequest.html
     */
    interface FleetLaunchTemplateConfigRequestProperty {
        /**
         * `CfnEC2Fleet.FleetLaunchTemplateConfigRequestProperty.LaunchTemplateSpecification`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-fleetlaunchtemplateconfigrequest.html#cfn-ec2-ec2fleet-fleetlaunchtemplateconfigrequest-launchtemplatespecification
         */
        readonly launchTemplateSpecification?: CfnEC2Fleet.FleetLaunchTemplateSpecificationRequestProperty | cdk.IResolvable;
        /**
         * `CfnEC2Fleet.FleetLaunchTemplateConfigRequestProperty.Overrides`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-fleetlaunchtemplateconfigrequest.html#cfn-ec2-ec2fleet-fleetlaunchtemplateconfigrequest-overrides
         */
        readonly overrides?: Array<CfnEC2Fleet.FleetLaunchTemplateOverridesRequestProperty | cdk.IResolvable> | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::EC2::EC2Fleet`.
 *
 * @external
 * @cloudformationResource AWS::EC2::EC2Fleet
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-ec2fleet.html
 */
export declare namespace CfnEC2Fleet {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-fleetlaunchtemplateoverridesrequest.html
     */
    interface FleetLaunchTemplateOverridesRequestProperty {
        /**
         * `CfnEC2Fleet.FleetLaunchTemplateOverridesRequestProperty.AvailabilityZone`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-fleetlaunchtemplateoverridesrequest.html#cfn-ec2-ec2fleet-fleetlaunchtemplateoverridesrequest-availabilityzone
         */
        readonly availabilityZone?: string;
        /**
         * `CfnEC2Fleet.FleetLaunchTemplateOverridesRequestProperty.InstanceRequirements`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-fleetlaunchtemplateoverridesrequest.html#cfn-ec2-ec2fleet-fleetlaunchtemplateoverridesrequest-instancerequirements
         */
        readonly instanceRequirements?: CfnEC2Fleet.InstanceRequirementsRequestProperty | cdk.IResolvable;
        /**
         * `CfnEC2Fleet.FleetLaunchTemplateOverridesRequestProperty.InstanceType`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-fleetlaunchtemplateoverridesrequest.html#cfn-ec2-ec2fleet-fleetlaunchtemplateoverridesrequest-instancetype
         */
        readonly instanceType?: string;
        /**
         * `CfnEC2Fleet.FleetLaunchTemplateOverridesRequestProperty.MaxPrice`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-fleetlaunchtemplateoverridesrequest.html#cfn-ec2-ec2fleet-fleetlaunchtemplateoverridesrequest-maxprice
         */
        readonly maxPrice?: string;
        /**
         * `CfnEC2Fleet.FleetLaunchTemplateOverridesRequestProperty.Placement`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-fleetlaunchtemplateoverridesrequest.html#cfn-ec2-ec2fleet-fleetlaunchtemplateoverridesrequest-placement
         */
        readonly placement?: CfnEC2Fleet.PlacementProperty | cdk.IResolvable;
        /**
         * `CfnEC2Fleet.FleetLaunchTemplateOverridesRequestProperty.Priority`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-fleetlaunchtemplateoverridesrequest.html#cfn-ec2-ec2fleet-fleetlaunchtemplateoverridesrequest-priority
         */
        readonly priority?: number;
        /**
         * `CfnEC2Fleet.FleetLaunchTemplateOverridesRequestProperty.SubnetId`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-fleetlaunchtemplateoverridesrequest.html#cfn-ec2-ec2fleet-fleetlaunchtemplateoverridesrequest-subnetid
         */
        readonly subnetId?: string;
        /**
         * `CfnEC2Fleet.FleetLaunchTemplateOverridesRequestProperty.WeightedCapacity`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-fleetlaunchtemplateoverridesrequest.html#cfn-ec2-ec2fleet-fleetlaunchtemplateoverridesrequest-weightedcapacity
         */
        readonly weightedCapacity?: number;
    }
}
/**
 * A CloudFormation `AWS::EC2::EC2Fleet`.
 *
 * @external
 * @cloudformationResource AWS::EC2::EC2Fleet
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-ec2fleet.html
 */
export declare namespace CfnEC2Fleet {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-fleetlaunchtemplatespecificationrequest.html
     */
    interface FleetLaunchTemplateSpecificationRequestProperty {
        /**
         * `CfnEC2Fleet.FleetLaunchTemplateSpecificationRequestProperty.LaunchTemplateId`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-fleetlaunchtemplatespecificationrequest.html#cfn-ec2-ec2fleet-fleetlaunchtemplatespecificationrequest-launchtemplateid
         */
        readonly launchTemplateId?: string;
        /**
         * `CfnEC2Fleet.FleetLaunchTemplateSpecificationRequestProperty.LaunchTemplateName`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-fleetlaunchtemplatespecificationrequest.html#cfn-ec2-ec2fleet-fleetlaunchtemplatespecificationrequest-launchtemplatename
         */
        readonly launchTemplateName?: string;
        /**
         * `CfnEC2Fleet.FleetLaunchTemplateSpecificationRequestProperty.Version`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-fleetlaunchtemplatespecificationrequest.html#cfn-ec2-ec2fleet-fleetlaunchtemplatespecificationrequest-version
         */
        readonly version?: string;
    }
}
/**
 * A CloudFormation `AWS::EC2::EC2Fleet`.
 *
 * @external
 * @cloudformationResource AWS::EC2::EC2Fleet
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-ec2fleet.html
 */
export declare namespace CfnEC2Fleet {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-instancerequirementsrequest.html
     */
    interface InstanceRequirementsRequestProperty {
        /**
         * `CfnEC2Fleet.InstanceRequirementsRequestProperty.AcceleratorCount`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-instancerequirementsrequest.html#cfn-ec2-ec2fleet-instancerequirementsrequest-acceleratorcount
         */
        readonly acceleratorCount?: CfnEC2Fleet.AcceleratorCountRequestProperty | cdk.IResolvable;
        /**
         * `CfnEC2Fleet.InstanceRequirementsRequestProperty.AcceleratorManufacturers`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-instancerequirementsrequest.html#cfn-ec2-ec2fleet-instancerequirementsrequest-acceleratormanufacturers
         */
        readonly acceleratorManufacturers?: string[];
        /**
         * `CfnEC2Fleet.InstanceRequirementsRequestProperty.AcceleratorNames`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-instancerequirementsrequest.html#cfn-ec2-ec2fleet-instancerequirementsrequest-acceleratornames
         */
        readonly acceleratorNames?: string[];
        /**
         * `CfnEC2Fleet.InstanceRequirementsRequestProperty.AcceleratorTotalMemoryMiB`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-instancerequirementsrequest.html#cfn-ec2-ec2fleet-instancerequirementsrequest-acceleratortotalmemorymib
         */
        readonly acceleratorTotalMemoryMiB?: CfnEC2Fleet.AcceleratorTotalMemoryMiBRequestProperty | cdk.IResolvable;
        /**
         * `CfnEC2Fleet.InstanceRequirementsRequestProperty.AcceleratorTypes`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-instancerequirementsrequest.html#cfn-ec2-ec2fleet-instancerequirementsrequest-acceleratortypes
         */
        readonly acceleratorTypes?: string[];
        /**
         * `CfnEC2Fleet.InstanceRequirementsRequestProperty.BareMetal`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-instancerequirementsrequest.html#cfn-ec2-ec2fleet-instancerequirementsrequest-baremetal
         */
        readonly bareMetal?: string;
        /**
         * `CfnEC2Fleet.InstanceRequirementsRequestProperty.BaselineEbsBandwidthMbps`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-instancerequirementsrequest.html#cfn-ec2-ec2fleet-instancerequirementsrequest-baselineebsbandwidthmbps
         */
        readonly baselineEbsBandwidthMbps?: CfnEC2Fleet.BaselineEbsBandwidthMbpsRequestProperty | cdk.IResolvable;
        /**
         * `CfnEC2Fleet.InstanceRequirementsRequestProperty.BurstablePerformance`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-instancerequirementsrequest.html#cfn-ec2-ec2fleet-instancerequirementsrequest-burstableperformance
         */
        readonly burstablePerformance?: string;
        /**
         * `CfnEC2Fleet.InstanceRequirementsRequestProperty.CpuManufacturers`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-instancerequirementsrequest.html#cfn-ec2-ec2fleet-instancerequirementsrequest-cpumanufacturers
         */
        readonly cpuManufacturers?: string[];
        /**
         * `CfnEC2Fleet.InstanceRequirementsRequestProperty.ExcludedInstanceTypes`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-instancerequirementsrequest.html#cfn-ec2-ec2fleet-instancerequirementsrequest-excludedinstancetypes
         */
        readonly excludedInstanceTypes?: string[];
        /**
         * `CfnEC2Fleet.InstanceRequirementsRequestProperty.InstanceGenerations`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-instancerequirementsrequest.html#cfn-ec2-ec2fleet-instancerequirementsrequest-instancegenerations
         */
        readonly instanceGenerations?: string[];
        /**
         * `CfnEC2Fleet.InstanceRequirementsRequestProperty.LocalStorage`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-instancerequirementsrequest.html#cfn-ec2-ec2fleet-instancerequirementsrequest-localstorage
         */
        readonly localStorage?: string;
        /**
         * `CfnEC2Fleet.InstanceRequirementsRequestProperty.LocalStorageTypes`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-instancerequirementsrequest.html#cfn-ec2-ec2fleet-instancerequirementsrequest-localstoragetypes
         */
        readonly localStorageTypes?: string[];
        /**
         * `CfnEC2Fleet.InstanceRequirementsRequestProperty.MemoryGiBPerVCpu`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-instancerequirementsrequest.html#cfn-ec2-ec2fleet-instancerequirementsrequest-memorygibpervcpu
         */
        readonly memoryGiBPerVCpu?: CfnEC2Fleet.MemoryGiBPerVCpuRequestProperty | cdk.IResolvable;
        /**
         * `CfnEC2Fleet.InstanceRequirementsRequestProperty.MemoryMiB`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-instancerequirementsrequest.html#cfn-ec2-ec2fleet-instancerequirementsrequest-memorymib
         */
        readonly memoryMiB?: CfnEC2Fleet.MemoryMiBRequestProperty | cdk.IResolvable;
        /**
         * `CfnEC2Fleet.InstanceRequirementsRequestProperty.NetworkInterfaceCount`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-instancerequirementsrequest.html#cfn-ec2-ec2fleet-instancerequirementsrequest-networkinterfacecount
         */
        readonly networkInterfaceCount?: CfnEC2Fleet.NetworkInterfaceCountRequestProperty | cdk.IResolvable;
        /**
         * `CfnEC2Fleet.InstanceRequirementsRequestProperty.OnDemandMaxPricePercentageOverLowestPrice`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-instancerequirementsrequest.html#cfn-ec2-ec2fleet-instancerequirementsrequest-ondemandmaxpricepercentageoverlowestprice
         */
        readonly onDemandMaxPricePercentageOverLowestPrice?: number;
        /**
         * `CfnEC2Fleet.InstanceRequirementsRequestProperty.RequireHibernateSupport`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-instancerequirementsrequest.html#cfn-ec2-ec2fleet-instancerequirementsrequest-requirehibernatesupport
         */
        readonly requireHibernateSupport?: boolean | cdk.IResolvable;
        /**
         * `CfnEC2Fleet.InstanceRequirementsRequestProperty.SpotMaxPricePercentageOverLowestPrice`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-instancerequirementsrequest.html#cfn-ec2-ec2fleet-instancerequirementsrequest-spotmaxpricepercentageoverlowestprice
         */
        readonly spotMaxPricePercentageOverLowestPrice?: number;
        /**
         * `CfnEC2Fleet.InstanceRequirementsRequestProperty.TotalLocalStorageGB`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-instancerequirementsrequest.html#cfn-ec2-ec2fleet-instancerequirementsrequest-totallocalstoragegb
         */
        readonly totalLocalStorageGb?: CfnEC2Fleet.TotalLocalStorageGBRequestProperty | cdk.IResolvable;
        /**
         * `CfnEC2Fleet.InstanceRequirementsRequestProperty.VCpuCount`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-instancerequirementsrequest.html#cfn-ec2-ec2fleet-instancerequirementsrequest-vcpucount
         */
        readonly vCpuCount?: CfnEC2Fleet.VCpuCountRangeRequestProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::EC2::EC2Fleet`.
 *
 * @external
 * @cloudformationResource AWS::EC2::EC2Fleet
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-ec2fleet.html
 */
export declare namespace CfnEC2Fleet {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-maintenancestrategies.html
     */
    interface MaintenanceStrategiesProperty {
        /**
         * `CfnEC2Fleet.MaintenanceStrategiesProperty.CapacityRebalance`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-maintenancestrategies.html#cfn-ec2-ec2fleet-maintenancestrategies-capacityrebalance
         */
        readonly capacityRebalance?: CfnEC2Fleet.CapacityRebalanceProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::EC2::EC2Fleet`.
 *
 * @external
 * @cloudformationResource AWS::EC2::EC2Fleet
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-ec2fleet.html
 */
export declare namespace CfnEC2Fleet {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-memorygibpervcpurequest.html
     */
    interface MemoryGiBPerVCpuRequestProperty {
        /**
         * `CfnEC2Fleet.MemoryGiBPerVCpuRequestProperty.Max`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-memorygibpervcpurequest.html#cfn-ec2-ec2fleet-memorygibpervcpurequest-max
         */
        readonly max?: number;
        /**
         * `CfnEC2Fleet.MemoryGiBPerVCpuRequestProperty.Min`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-memorygibpervcpurequest.html#cfn-ec2-ec2fleet-memorygibpervcpurequest-min
         */
        readonly min?: number;
    }
}
/**
 * A CloudFormation `AWS::EC2::EC2Fleet`.
 *
 * @external
 * @cloudformationResource AWS::EC2::EC2Fleet
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-ec2fleet.html
 */
export declare namespace CfnEC2Fleet {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-memorymibrequest.html
     */
    interface MemoryMiBRequestProperty {
        /**
         * `CfnEC2Fleet.MemoryMiBRequestProperty.Max`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-memorymibrequest.html#cfn-ec2-ec2fleet-memorymibrequest-max
         */
        readonly max?: number;
        /**
         * `CfnEC2Fleet.MemoryMiBRequestProperty.Min`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-memorymibrequest.html#cfn-ec2-ec2fleet-memorymibrequest-min
         */
        readonly min?: number;
    }
}
/**
 * A CloudFormation `AWS::EC2::EC2Fleet`.
 *
 * @external
 * @cloudformationResource AWS::EC2::EC2Fleet
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-ec2fleet.html
 */
export declare namespace CfnEC2Fleet {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-networkinterfacecountrequest.html
     */
    interface NetworkInterfaceCountRequestProperty {
        /**
         * `CfnEC2Fleet.NetworkInterfaceCountRequestProperty.Max`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-networkinterfacecountrequest.html#cfn-ec2-ec2fleet-networkinterfacecountrequest-max
         */
        readonly max?: number;
        /**
         * `CfnEC2Fleet.NetworkInterfaceCountRequestProperty.Min`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-networkinterfacecountrequest.html#cfn-ec2-ec2fleet-networkinterfacecountrequest-min
         */
        readonly min?: number;
    }
}
/**
 * A CloudFormation `AWS::EC2::EC2Fleet`.
 *
 * @external
 * @cloudformationResource AWS::EC2::EC2Fleet
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-ec2fleet.html
 */
export declare namespace CfnEC2Fleet {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-ondemandoptionsrequest.html
     */
    interface OnDemandOptionsRequestProperty {
        /**
         * `CfnEC2Fleet.OnDemandOptionsRequestProperty.AllocationStrategy`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-ondemandoptionsrequest.html#cfn-ec2-ec2fleet-ondemandoptionsrequest-allocationstrategy
         */
        readonly allocationStrategy?: string;
        /**
         * `CfnEC2Fleet.OnDemandOptionsRequestProperty.CapacityReservationOptions`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-ondemandoptionsrequest.html#cfn-ec2-ec2fleet-ondemandoptionsrequest-capacityreservationoptions
         */
        readonly capacityReservationOptions?: CfnEC2Fleet.CapacityReservationOptionsRequestProperty | cdk.IResolvable;
        /**
         * `CfnEC2Fleet.OnDemandOptionsRequestProperty.MaxTotalPrice`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-ondemandoptionsrequest.html#cfn-ec2-ec2fleet-ondemandoptionsrequest-maxtotalprice
         */
        readonly maxTotalPrice?: string;
        /**
         * `CfnEC2Fleet.OnDemandOptionsRequestProperty.MinTargetCapacity`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-ondemandoptionsrequest.html#cfn-ec2-ec2fleet-ondemandoptionsrequest-mintargetcapacity
         */
        readonly minTargetCapacity?: number;
        /**
         * `CfnEC2Fleet.OnDemandOptionsRequestProperty.SingleAvailabilityZone`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-ondemandoptionsrequest.html#cfn-ec2-ec2fleet-ondemandoptionsrequest-singleavailabilityzone
         */
        readonly singleAvailabilityZone?: boolean | cdk.IResolvable;
        /**
         * `CfnEC2Fleet.OnDemandOptionsRequestProperty.SingleInstanceType`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-ondemandoptionsrequest.html#cfn-ec2-ec2fleet-ondemandoptionsrequest-singleinstancetype
         */
        readonly singleInstanceType?: boolean | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::EC2::EC2Fleet`.
 *
 * @external
 * @cloudformationResource AWS::EC2::EC2Fleet
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-ec2fleet.html
 */
export declare namespace CfnEC2Fleet {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-placement.html
     */
    interface PlacementProperty {
        /**
         * `CfnEC2Fleet.PlacementProperty.Affinity`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-placement.html#cfn-ec2-ec2fleet-placement-affinity
         */
        readonly affinity?: string;
        /**
         * `CfnEC2Fleet.PlacementProperty.AvailabilityZone`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-placement.html#cfn-ec2-ec2fleet-placement-availabilityzone
         */
        readonly availabilityZone?: string;
        /**
         * `CfnEC2Fleet.PlacementProperty.GroupName`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-placement.html#cfn-ec2-ec2fleet-placement-groupname
         */
        readonly groupName?: string;
        /**
         * `CfnEC2Fleet.PlacementProperty.HostId`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-placement.html#cfn-ec2-ec2fleet-placement-hostid
         */
        readonly hostId?: string;
        /**
         * `CfnEC2Fleet.PlacementProperty.HostResourceGroupArn`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-placement.html#cfn-ec2-ec2fleet-placement-hostresourcegrouparn
         */
        readonly hostResourceGroupArn?: string;
        /**
         * `CfnEC2Fleet.PlacementProperty.PartitionNumber`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-placement.html#cfn-ec2-ec2fleet-placement-partitionnumber
         */
        readonly partitionNumber?: number;
        /**
         * `CfnEC2Fleet.PlacementProperty.SpreadDomain`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-placement.html#cfn-ec2-ec2fleet-placement-spreaddomain
         */
        readonly spreadDomain?: string;
        /**
         * `CfnEC2Fleet.PlacementProperty.Tenancy`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-placement.html#cfn-ec2-ec2fleet-placement-tenancy
         */
        readonly tenancy?: string;
    }
}
/**
 * A CloudFormation `AWS::EC2::EC2Fleet`.
 *
 * @external
 * @cloudformationResource AWS::EC2::EC2Fleet
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-ec2fleet.html
 */
export declare namespace CfnEC2Fleet {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-spotoptionsrequest.html
     */
    interface SpotOptionsRequestProperty {
        /**
         * `CfnEC2Fleet.SpotOptionsRequestProperty.AllocationStrategy`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-spotoptionsrequest.html#cfn-ec2-ec2fleet-spotoptionsrequest-allocationstrategy
         */
        readonly allocationStrategy?: string;
        /**
         * `CfnEC2Fleet.SpotOptionsRequestProperty.InstanceInterruptionBehavior`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-spotoptionsrequest.html#cfn-ec2-ec2fleet-spotoptionsrequest-instanceinterruptionbehavior
         */
        readonly instanceInterruptionBehavior?: string;
        /**
         * `CfnEC2Fleet.SpotOptionsRequestProperty.InstancePoolsToUseCount`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-spotoptionsrequest.html#cfn-ec2-ec2fleet-spotoptionsrequest-instancepoolstousecount
         */
        readonly instancePoolsToUseCount?: number;
        /**
         * `CfnEC2Fleet.SpotOptionsRequestProperty.MaintenanceStrategies`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-spotoptionsrequest.html#cfn-ec2-ec2fleet-spotoptionsrequest-maintenancestrategies
         */
        readonly maintenanceStrategies?: CfnEC2Fleet.MaintenanceStrategiesProperty | cdk.IResolvable;
        /**
         * `CfnEC2Fleet.SpotOptionsRequestProperty.MaxTotalPrice`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-spotoptionsrequest.html#cfn-ec2-ec2fleet-spotoptionsrequest-maxtotalprice
         */
        readonly maxTotalPrice?: string;
        /**
         * `CfnEC2Fleet.SpotOptionsRequestProperty.MinTargetCapacity`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-spotoptionsrequest.html#cfn-ec2-ec2fleet-spotoptionsrequest-mintargetcapacity
         */
        readonly minTargetCapacity?: number;
        /**
         * `CfnEC2Fleet.SpotOptionsRequestProperty.SingleAvailabilityZone`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-spotoptionsrequest.html#cfn-ec2-ec2fleet-spotoptionsrequest-singleavailabilityzone
         */
        readonly singleAvailabilityZone?: boolean | cdk.IResolvable;
        /**
         * `CfnEC2Fleet.SpotOptionsRequestProperty.SingleInstanceType`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-spotoptionsrequest.html#cfn-ec2-ec2fleet-spotoptionsrequest-singleinstancetype
         */
        readonly singleInstanceType?: boolean | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::EC2::EC2Fleet`.
 *
 * @external
 * @cloudformationResource AWS::EC2::EC2Fleet
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-ec2fleet.html
 */
export declare namespace CfnEC2Fleet {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-tagspecification.html
     */
    interface TagSpecificationProperty {
        /**
         * `CfnEC2Fleet.TagSpecificationProperty.ResourceType`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-tagspecification.html#cfn-ec2-ec2fleet-tagspecification-resourcetype
         */
        readonly resourceType?: string;
        /**
         * `CfnEC2Fleet.TagSpecificationProperty.Tags`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-tagspecification.html#cfn-ec2-ec2fleet-tagspecification-tags
         */
        readonly tags?: cdk.CfnTag[];
    }
}
/**
 * A CloudFormation `AWS::EC2::EC2Fleet`.
 *
 * @external
 * @cloudformationResource AWS::EC2::EC2Fleet
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-ec2fleet.html
 */
export declare namespace CfnEC2Fleet {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-targetcapacityspecificationrequest.html
     */
    interface TargetCapacitySpecificationRequestProperty {
        /**
         * `CfnEC2Fleet.TargetCapacitySpecificationRequestProperty.DefaultTargetCapacityType`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-targetcapacityspecificationrequest.html#cfn-ec2-ec2fleet-targetcapacityspecificationrequest-defaulttargetcapacitytype
         */
        readonly defaultTargetCapacityType?: string;
        /**
         * `CfnEC2Fleet.TargetCapacitySpecificationRequestProperty.OnDemandTargetCapacity`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-targetcapacityspecificationrequest.html#cfn-ec2-ec2fleet-targetcapacityspecificationrequest-ondemandtargetcapacity
         */
        readonly onDemandTargetCapacity?: number;
        /**
         * `CfnEC2Fleet.TargetCapacitySpecificationRequestProperty.SpotTargetCapacity`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-targetcapacityspecificationrequest.html#cfn-ec2-ec2fleet-targetcapacityspecificationrequest-spottargetcapacity
         */
        readonly spotTargetCapacity?: number;
        /**
         * `CfnEC2Fleet.TargetCapacitySpecificationRequestProperty.TargetCapacityUnitType`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-targetcapacityspecificationrequest.html#cfn-ec2-ec2fleet-targetcapacityspecificationrequest-targetcapacityunittype
         */
        readonly targetCapacityUnitType?: string;
        /**
         * `CfnEC2Fleet.TargetCapacitySpecificationRequestProperty.TotalTargetCapacity`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-targetcapacityspecificationrequest.html#cfn-ec2-ec2fleet-targetcapacityspecificationrequest-totaltargetcapacity
         */
        readonly totalTargetCapacity: number;
    }
}
/**
 * A CloudFormation `AWS::EC2::EC2Fleet`.
 *
 * @external
 * @cloudformationResource AWS::EC2::EC2Fleet
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-ec2fleet.html
 */
export declare namespace CfnEC2Fleet {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-totallocalstoragegbrequest.html
     */
    interface TotalLocalStorageGBRequestProperty {
        /**
         * `CfnEC2Fleet.TotalLocalStorageGBRequestProperty.Max`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-totallocalstoragegbrequest.html#cfn-ec2-ec2fleet-totallocalstoragegbrequest-max
         */
        readonly max?: number;
        /**
         * `CfnEC2Fleet.TotalLocalStorageGBRequestProperty.Min`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-totallocalstoragegbrequest.html#cfn-ec2-ec2fleet-totallocalstoragegbrequest-min
         */
        readonly min?: number;
    }
}
/**
 * A CloudFormation `AWS::EC2::EC2Fleet`.
 *
 * @external
 * @cloudformationResource AWS::EC2::EC2Fleet
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-ec2fleet.html
 */
export declare namespace CfnEC2Fleet {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-vcpucountrangerequest.html
     */
    interface VCpuCountRangeRequestProperty {
        /**
         * `CfnEC2Fleet.VCpuCountRangeRequestProperty.Max`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-vcpucountrangerequest.html#cfn-ec2-ec2fleet-vcpucountrangerequest-max
         */
        readonly max?: number;
        /**
         * `CfnEC2Fleet.VCpuCountRangeRequestProperty.Min`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-vcpucountrangerequest.html#cfn-ec2-ec2fleet-vcpucountrangerequest-min
         */
        readonly min?: number;
    }
}
/**
 * Properties for defining a `AWS::EC2::EIP`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-eip.html
 */
export interface CfnEIPProps {
    /**
     * `AWS::EC2::EIP.Domain`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-eip.html#cfn-ec2-eip-domain
     */
    readonly domain?: string;
    /**
     * `AWS::EC2::EIP.InstanceId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-eip.html#cfn-ec2-eip-instanceid
     */
    readonly instanceId?: string;
    /**
     * `AWS::EC2::EIP.PublicIpv4Pool`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-eip.html#cfn-ec2-eip-publicipv4pool
     */
    readonly publicIpv4Pool?: string;
    /**
     * `AWS::EC2::EIP.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-eip.html#cfn-ec2-eip-tags
     */
    readonly tags?: cdk.CfnTag[];
}
/**
 * A CloudFormation `AWS::EC2::EIP`.
 *
 * @external
 * @cloudformationResource AWS::EC2::EIP
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-eip.html
 */
export declare class CfnEIP extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::EC2::EIP";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnEIP;
    /**
     * @external
     * @cloudformationAttribute AllocationId
     */
    readonly attrAllocationId: string;
    /**
     * `AWS::EC2::EIP.Domain`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-eip.html#cfn-ec2-eip-domain
     */
    domain: string | undefined;
    /**
     * `AWS::EC2::EIP.InstanceId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-eip.html#cfn-ec2-eip-instanceid
     */
    instanceId: string | undefined;
    /**
     * `AWS::EC2::EIP.PublicIpv4Pool`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-eip.html#cfn-ec2-eip-publicipv4pool
     */
    publicIpv4Pool: string | undefined;
    /**
     * `AWS::EC2::EIP.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-eip.html#cfn-ec2-eip-tags
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::EC2::EIP`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props?: CfnEIPProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @external
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::EC2::EIPAssociation`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-eip-association.html
 */
export interface CfnEIPAssociationProps {
    /**
     * `AWS::EC2::EIPAssociation.AllocationId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-eip-association.html#cfn-ec2-eipassociation-allocationid
     */
    readonly allocationId?: string;
    /**
     * `AWS::EC2::EIPAssociation.EIP`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-eip-association.html#cfn-ec2-eipassociation-eip
     */
    readonly eip?: string;
    /**
     * `AWS::EC2::EIPAssociation.InstanceId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-eip-association.html#cfn-ec2-eipassociation-instanceid
     */
    readonly instanceId?: string;
    /**
     * `AWS::EC2::EIPAssociation.NetworkInterfaceId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-eip-association.html#cfn-ec2-eipassociation-networkinterfaceid
     */
    readonly networkInterfaceId?: string;
    /**
     * `AWS::EC2::EIPAssociation.PrivateIpAddress`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-eip-association.html#cfn-ec2-eipassociation-PrivateIpAddress
     */
    readonly privateIpAddress?: string;
}
/**
 * A CloudFormation `AWS::EC2::EIPAssociation`.
 *
 * @external
 * @cloudformationResource AWS::EC2::EIPAssociation
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-eip-association.html
 */
export declare class CfnEIPAssociation extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::EC2::EIPAssociation";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnEIPAssociation;
    /**
     * `AWS::EC2::EIPAssociation.AllocationId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-eip-association.html#cfn-ec2-eipassociation-allocationid
     */
    allocationId: string | undefined;
    /**
     * `AWS::EC2::EIPAssociation.EIP`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-eip-association.html#cfn-ec2-eipassociation-eip
     */
    eip: string | undefined;
    /**
     * `AWS::EC2::EIPAssociation.InstanceId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-eip-association.html#cfn-ec2-eipassociation-instanceid
     */
    instanceId: string | undefined;
    /**
     * `AWS::EC2::EIPAssociation.NetworkInterfaceId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-eip-association.html#cfn-ec2-eipassociation-networkinterfaceid
     */
    networkInterfaceId: string | undefined;
    /**
     * `AWS::EC2::EIPAssociation.PrivateIpAddress`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-eip-association.html#cfn-ec2-eipassociation-PrivateIpAddress
     */
    privateIpAddress: string | undefined;
    /**
     * Create a new `AWS::EC2::EIPAssociation`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props?: CfnEIPAssociationProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @external
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::EC2::EgressOnlyInternetGateway`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-egressonlyinternetgateway.html
 */
export interface CfnEgressOnlyInternetGatewayProps {
    /**
     * `AWS::EC2::EgressOnlyInternetGateway.VpcId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-egressonlyinternetgateway.html#cfn-ec2-egressonlyinternetgateway-vpcid
     */
    readonly vpcId: string;
}
/**
 * A CloudFormation `AWS::EC2::EgressOnlyInternetGateway`.
 *
 * @external
 * @cloudformationResource AWS::EC2::EgressOnlyInternetGateway
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-egressonlyinternetgateway.html
 */
export declare class CfnEgressOnlyInternetGateway extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::EC2::EgressOnlyInternetGateway";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnEgressOnlyInternetGateway;
    /**
     * @external
     * @cloudformationAttribute Id
     */
    readonly attrId: string;
    /**
     * `AWS::EC2::EgressOnlyInternetGateway.VpcId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-egressonlyinternetgateway.html#cfn-ec2-egressonlyinternetgateway-vpcid
     */
    vpcId: string;
    /**
     * Create a new `AWS::EC2::EgressOnlyInternetGateway`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnEgressOnlyInternetGatewayProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @external
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::EC2::EnclaveCertificateIamRoleAssociation`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-enclavecertificateiamroleassociation.html
 */
export interface CfnEnclaveCertificateIamRoleAssociationProps {
    /**
     * `AWS::EC2::EnclaveCertificateIamRoleAssociation.CertificateArn`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-enclavecertificateiamroleassociation.html#cfn-ec2-enclavecertificateiamroleassociation-certificatearn
     */
    readonly certificateArn: string;
    /**
     * `AWS::EC2::EnclaveCertificateIamRoleAssociation.RoleArn`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-enclavecertificateiamroleassociation.html#cfn-ec2-enclavecertificateiamroleassociation-rolearn
     */
    readonly roleArn: string;
}
/**
 * A CloudFormation `AWS::EC2::EnclaveCertificateIamRoleAssociation`.
 *
 * @external
 * @cloudformationResource AWS::EC2::EnclaveCertificateIamRoleAssociation
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-enclavecertificateiamroleassociation.html
 */
export declare class CfnEnclaveCertificateIamRoleAssociation extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::EC2::EnclaveCertificateIamRoleAssociation";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnEnclaveCertificateIamRoleAssociation;
    /**
     * @external
     * @cloudformationAttribute CertificateS3BucketName
     */
    readonly attrCertificateS3BucketName: string;
    /**
     * @external
     * @cloudformationAttribute CertificateS3ObjectKey
     */
    readonly attrCertificateS3ObjectKey: string;
    /**
     * @external
     * @cloudformationAttribute EncryptionKmsKeyId
     */
    readonly attrEncryptionKmsKeyId: string;
    /**
     * `AWS::EC2::EnclaveCertificateIamRoleAssociation.CertificateArn`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-enclavecertificateiamroleassociation.html#cfn-ec2-enclavecertificateiamroleassociation-certificatearn
     */
    certificateArn: string;
    /**
     * `AWS::EC2::EnclaveCertificateIamRoleAssociation.RoleArn`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-enclavecertificateiamroleassociation.html#cfn-ec2-enclavecertificateiamroleassociation-rolearn
     */
    roleArn: string;
    /**
     * Create a new `AWS::EC2::EnclaveCertificateIamRoleAssociation`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnEnclaveCertificateIamRoleAssociationProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @external
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::EC2::FlowLog`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-flowlog.html
 */
export interface CfnFlowLogProps {
    /**
     * `AWS::EC2::FlowLog.ResourceId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-flowlog.html#cfn-ec2-flowlog-resourceid
     */
    readonly resourceId: string;
    /**
     * `AWS::EC2::FlowLog.ResourceType`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-flowlog.html#cfn-ec2-flowlog-resourcetype
     */
    readonly resourceType: string;
    /**
     * `AWS::EC2::FlowLog.TrafficType`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-flowlog.html#cfn-ec2-flowlog-traffictype
     */
    readonly trafficType: string;
    /**
     * `AWS::EC2::FlowLog.DeliverLogsPermissionArn`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-flowlog.html#cfn-ec2-flowlog-deliverlogspermissionarn
     */
    readonly deliverLogsPermissionArn?: string;
    /**
     * `AWS::EC2::FlowLog.LogDestination`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-flowlog.html#cfn-ec2-flowlog-logdestination
     */
    readonly logDestination?: string;
    /**
     * `AWS::EC2::FlowLog.LogDestinationType`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-flowlog.html#cfn-ec2-flowlog-logdestinationtype
     */
    readonly logDestinationType?: string;
    /**
     * `AWS::EC2::FlowLog.LogFormat`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-flowlog.html#cfn-ec2-flowlog-logformat
     */
    readonly logFormat?: string;
    /**
     * `AWS::EC2::FlowLog.LogGroupName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-flowlog.html#cfn-ec2-flowlog-loggroupname
     */
    readonly logGroupName?: string;
    /**
     * `AWS::EC2::FlowLog.MaxAggregationInterval`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-flowlog.html#cfn-ec2-flowlog-maxaggregationinterval
     */
    readonly maxAggregationInterval?: number;
    /**
     * `AWS::EC2::FlowLog.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-flowlog.html#cfn-ec2-flowlog-tags
     */
    readonly tags?: cdk.CfnTag[];
}
/**
 * A CloudFormation `AWS::EC2::FlowLog`.
 *
 * @external
 * @cloudformationResource AWS::EC2::FlowLog
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-flowlog.html
 */
export declare class CfnFlowLog extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::EC2::FlowLog";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnFlowLog;
    /**
     * @external
     * @cloudformationAttribute Id
     */
    readonly attrId: string;
    /**
     * `AWS::EC2::FlowLog.ResourceId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-flowlog.html#cfn-ec2-flowlog-resourceid
     */
    resourceId: string;
    /**
     * `AWS::EC2::FlowLog.ResourceType`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-flowlog.html#cfn-ec2-flowlog-resourcetype
     */
    resourceType: string;
    /**
     * `AWS::EC2::FlowLog.TrafficType`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-flowlog.html#cfn-ec2-flowlog-traffictype
     */
    trafficType: string;
    /**
     * `AWS::EC2::FlowLog.DeliverLogsPermissionArn`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-flowlog.html#cfn-ec2-flowlog-deliverlogspermissionarn
     */
    deliverLogsPermissionArn: string | undefined;
    /**
     * `AWS::EC2::FlowLog.LogDestination`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-flowlog.html#cfn-ec2-flowlog-logdestination
     */
    logDestination: string | undefined;
    /**
     * `AWS::EC2::FlowLog.LogDestinationType`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-flowlog.html#cfn-ec2-flowlog-logdestinationtype
     */
    logDestinationType: string | undefined;
    /**
     * `AWS::EC2::FlowLog.LogFormat`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-flowlog.html#cfn-ec2-flowlog-logformat
     */
    logFormat: string | undefined;
    /**
     * `AWS::EC2::FlowLog.LogGroupName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-flowlog.html#cfn-ec2-flowlog-loggroupname
     */
    logGroupName: string | undefined;
    /**
     * `AWS::EC2::FlowLog.MaxAggregationInterval`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-flowlog.html#cfn-ec2-flowlog-maxaggregationinterval
     */
    maxAggregationInterval: number | undefined;
    /**
     * `AWS::EC2::FlowLog.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-flowlog.html#cfn-ec2-flowlog-tags
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::EC2::FlowLog`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnFlowLogProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @external
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::EC2::GatewayRouteTableAssociation`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-gatewayroutetableassociation.html
 */
export interface CfnGatewayRouteTableAssociationProps {
    /**
     * `AWS::EC2::GatewayRouteTableAssociation.GatewayId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-gatewayroutetableassociation.html#cfn-ec2-gatewayroutetableassociation-gatewayid
     */
    readonly gatewayId: string;
    /**
     * `AWS::EC2::GatewayRouteTableAssociation.RouteTableId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-gatewayroutetableassociation.html#cfn-ec2-gatewayroutetableassociation-routetableid
     */
    readonly routeTableId: string;
}
/**
 * A CloudFormation `AWS::EC2::GatewayRouteTableAssociation`.
 *
 * @external
 * @cloudformationResource AWS::EC2::GatewayRouteTableAssociation
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-gatewayroutetableassociation.html
 */
export declare class CfnGatewayRouteTableAssociation extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::EC2::GatewayRouteTableAssociation";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnGatewayRouteTableAssociation;
    /**
     * @external
     * @cloudformationAttribute AssociationId
     */
    readonly attrAssociationId: string;
    /**
     * `AWS::EC2::GatewayRouteTableAssociation.GatewayId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-gatewayroutetableassociation.html#cfn-ec2-gatewayroutetableassociation-gatewayid
     */
    gatewayId: string;
    /**
     * `AWS::EC2::GatewayRouteTableAssociation.RouteTableId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-gatewayroutetableassociation.html#cfn-ec2-gatewayroutetableassociation-routetableid
     */
    routeTableId: string;
    /**
     * Create a new `AWS::EC2::GatewayRouteTableAssociation`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnGatewayRouteTableAssociationProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @external
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::EC2::Host`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-host.html
 */
export interface CfnHostProps {
    /**
     * `AWS::EC2::Host.AvailabilityZone`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-host.html#cfn-ec2-host-availabilityzone
     */
    readonly availabilityZone: string;
    /**
     * `AWS::EC2::Host.InstanceType`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-host.html#cfn-ec2-host-instancetype
     */
    readonly instanceType: string;
    /**
     * `AWS::EC2::Host.AutoPlacement`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-host.html#cfn-ec2-host-autoplacement
     */
    readonly autoPlacement?: string;
    /**
     * `AWS::EC2::Host.HostRecovery`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-host.html#cfn-ec2-host-hostrecovery
     */
    readonly hostRecovery?: string;
}
/**
 * A CloudFormation `AWS::EC2::Host`.
 *
 * @external
 * @cloudformationResource AWS::EC2::Host
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-host.html
 */
export declare class CfnHost extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::EC2::Host";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnHost;
    /**
     * `AWS::EC2::Host.AvailabilityZone`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-host.html#cfn-ec2-host-availabilityzone
     */
    availabilityZone: string;
    /**
     * `AWS::EC2::Host.InstanceType`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-host.html#cfn-ec2-host-instancetype
     */
    instanceType: string;
    /**
     * `AWS::EC2::Host.AutoPlacement`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-host.html#cfn-ec2-host-autoplacement
     */
    autoPlacement: string | undefined;
    /**
     * `AWS::EC2::Host.HostRecovery`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-host.html#cfn-ec2-host-hostrecovery
     */
    hostRecovery: string | undefined;
    /**
     * Create a new `AWS::EC2::Host`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnHostProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @external
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::EC2::Instance`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html
 */
export interface CfnInstanceProps {
    /**
     * `AWS::EC2::Instance.AdditionalInfo`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-additionalinfo
     */
    readonly additionalInfo?: string;
    /**
     * `AWS::EC2::Instance.Affinity`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-affinity
     */
    readonly affinity?: string;
    /**
     * `AWS::EC2::Instance.AvailabilityZone`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-availabilityzone
     */
    readonly availabilityZone?: string;
    /**
     * `AWS::EC2::Instance.BlockDeviceMappings`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-blockdevicemappings
     */
    readonly blockDeviceMappings?: Array<CfnInstance.BlockDeviceMappingProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::EC2::Instance.CpuOptions`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-cpuoptions
     */
    readonly cpuOptions?: CfnInstance.CpuOptionsProperty | cdk.IResolvable;
    /**
     * `AWS::EC2::Instance.CreditSpecification`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-creditspecification
     */
    readonly creditSpecification?: CfnInstance.CreditSpecificationProperty | cdk.IResolvable;
    /**
     * `AWS::EC2::Instance.DisableApiTermination`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-disableapitermination
     */
    readonly disableApiTermination?: boolean | cdk.IResolvable;
    /**
     * `AWS::EC2::Instance.EbsOptimized`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-ebsoptimized
     */
    readonly ebsOptimized?: boolean | cdk.IResolvable;
    /**
     * `AWS::EC2::Instance.ElasticGpuSpecifications`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-elasticgpuspecifications
     */
    readonly elasticGpuSpecifications?: Array<CfnInstance.ElasticGpuSpecificationProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::EC2::Instance.ElasticInferenceAccelerators`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-elasticinferenceaccelerators
     */
    readonly elasticInferenceAccelerators?: Array<CfnInstance.ElasticInferenceAcceleratorProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::EC2::Instance.EnclaveOptions`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-enclaveoptions
     */
    readonly enclaveOptions?: CfnInstance.EnclaveOptionsProperty | cdk.IResolvable;
    /**
     * `AWS::EC2::Instance.HibernationOptions`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-hibernationoptions
     */
    readonly hibernationOptions?: CfnInstance.HibernationOptionsProperty | cdk.IResolvable;
    /**
     * `AWS::EC2::Instance.HostId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-hostid
     */
    readonly hostId?: string;
    /**
     * `AWS::EC2::Instance.HostResourceGroupArn`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-hostresourcegrouparn
     */
    readonly hostResourceGroupArn?: string;
    /**
     * `AWS::EC2::Instance.IamInstanceProfile`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-iaminstanceprofile
     */
    readonly iamInstanceProfile?: string;
    /**
     * `AWS::EC2::Instance.ImageId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-imageid
     */
    readonly imageId?: string;
    /**
     * `AWS::EC2::Instance.InstanceInitiatedShutdownBehavior`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-instanceinitiatedshutdownbehavior
     */
    readonly instanceInitiatedShutdownBehavior?: string;
    /**
     * `AWS::EC2::Instance.InstanceType`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-instancetype
     */
    readonly instanceType?: string;
    /**
     * `AWS::EC2::Instance.Ipv6AddressCount`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-ipv6addresscount
     */
    readonly ipv6AddressCount?: number;
    /**
     * `AWS::EC2::Instance.Ipv6Addresses`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-ipv6addresses
     */
    readonly ipv6Addresses?: Array<CfnInstance.InstanceIpv6AddressProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::EC2::Instance.KernelId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-kernelid
     */
    readonly kernelId?: string;
    /**
     * `AWS::EC2::Instance.KeyName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-keyname
     */
    readonly keyName?: string;
    /**
     * `AWS::EC2::Instance.LaunchTemplate`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-launchtemplate
     */
    readonly launchTemplate?: CfnInstance.LaunchTemplateSpecificationProperty | cdk.IResolvable;
    /**
     * `AWS::EC2::Instance.LicenseSpecifications`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-licensespecifications
     */
    readonly licenseSpecifications?: Array<CfnInstance.LicenseSpecificationProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::EC2::Instance.Monitoring`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-monitoring
     */
    readonly monitoring?: boolean | cdk.IResolvable;
    /**
     * `AWS::EC2::Instance.NetworkInterfaces`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-networkinterfaces
     */
    readonly networkInterfaces?: Array<CfnInstance.NetworkInterfaceProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::EC2::Instance.PlacementGroupName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-placementgroupname
     */
    readonly placementGroupName?: string;
    /**
     * `AWS::EC2::Instance.PrivateIpAddress`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-privateipaddress
     */
    readonly privateIpAddress?: string;
    /**
     * `AWS::EC2::Instance.RamdiskId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-ramdiskid
     */
    readonly ramdiskId?: string;
    /**
     * `AWS::EC2::Instance.SecurityGroupIds`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-securitygroupids
     */
    readonly securityGroupIds?: string[];
    /**
     * `AWS::EC2::Instance.SecurityGroups`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-securitygroups
     */
    readonly securityGroups?: string[];
    /**
     * `AWS::EC2::Instance.SourceDestCheck`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-sourcedestcheck
     */
    readonly sourceDestCheck?: boolean | cdk.IResolvable;
    /**
     * `AWS::EC2::Instance.SsmAssociations`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-ssmassociations
     */
    readonly ssmAssociations?: Array<CfnInstance.SsmAssociationProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::EC2::Instance.SubnetId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-subnetid
     */
    readonly subnetId?: string;
    /**
     * `AWS::EC2::Instance.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-tags
     */
    readonly tags?: cdk.CfnTag[];
    /**
     * `AWS::EC2::Instance.Tenancy`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-tenancy
     */
    readonly tenancy?: string;
    /**
     * `AWS::EC2::Instance.UserData`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-userdata
     */
    readonly userData?: string;
    /**
     * `AWS::EC2::Instance.Volumes`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-volumes
     */
    readonly volumes?: Array<CfnInstance.VolumeProperty | cdk.IResolvable> | cdk.IResolvable;
}
/**
 * A CloudFormation `AWS::EC2::Instance`.
 *
 * @external
 * @cloudformationResource AWS::EC2::Instance
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html
 */
export declare class CfnInstance extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::EC2::Instance";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnInstance;
    /**
     * @external
     * @cloudformationAttribute AvailabilityZone
     */
    readonly attrAvailabilityZone: string;
    /**
     * @external
     * @cloudformationAttribute PrivateDnsName
     */
    readonly attrPrivateDnsName: string;
    /**
     * @external
     * @cloudformationAttribute PrivateIp
     */
    readonly attrPrivateIp: string;
    /**
     * @external
     * @cloudformationAttribute PublicDnsName
     */
    readonly attrPublicDnsName: string;
    /**
     * @external
     * @cloudformationAttribute PublicIp
     */
    readonly attrPublicIp: string;
    /**
     * `AWS::EC2::Instance.AdditionalInfo`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-additionalinfo
     */
    additionalInfo: string | undefined;
    /**
     * `AWS::EC2::Instance.Affinity`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-affinity
     */
    affinity: string | undefined;
    /**
     * `AWS::EC2::Instance.AvailabilityZone`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-availabilityzone
     */
    availabilityZone: string | undefined;
    /**
     * `AWS::EC2::Instance.BlockDeviceMappings`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-blockdevicemappings
     */
    blockDeviceMappings: Array<CfnInstance.BlockDeviceMappingProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * `AWS::EC2::Instance.CpuOptions`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-cpuoptions
     */
    cpuOptions: CfnInstance.CpuOptionsProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::EC2::Instance.CreditSpecification`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-creditspecification
     */
    creditSpecification: CfnInstance.CreditSpecificationProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::EC2::Instance.DisableApiTermination`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-disableapitermination
     */
    disableApiTermination: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::EC2::Instance.EbsOptimized`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-ebsoptimized
     */
    ebsOptimized: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::EC2::Instance.ElasticGpuSpecifications`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-elasticgpuspecifications
     */
    elasticGpuSpecifications: Array<CfnInstance.ElasticGpuSpecificationProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * `AWS::EC2::Instance.ElasticInferenceAccelerators`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-elasticinferenceaccelerators
     */
    elasticInferenceAccelerators: Array<CfnInstance.ElasticInferenceAcceleratorProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * `AWS::EC2::Instance.EnclaveOptions`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-enclaveoptions
     */
    enclaveOptions: CfnInstance.EnclaveOptionsProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::EC2::Instance.HibernationOptions`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-hibernationoptions
     */
    hibernationOptions: CfnInstance.HibernationOptionsProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::EC2::Instance.HostId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-hostid
     */
    hostId: string | undefined;
    /**
     * `AWS::EC2::Instance.HostResourceGroupArn`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-hostresourcegrouparn
     */
    hostResourceGroupArn: string | undefined;
    /**
     * `AWS::EC2::Instance.IamInstanceProfile`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-iaminstanceprofile
     */
    iamInstanceProfile: string | undefined;
    /**
     * `AWS::EC2::Instance.ImageId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-imageid
     */
    imageId: string | undefined;
    /**
     * `AWS::EC2::Instance.InstanceInitiatedShutdownBehavior`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-instanceinitiatedshutdownbehavior
     */
    instanceInitiatedShutdownBehavior: string | undefined;
    /**
     * `AWS::EC2::Instance.InstanceType`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-instancetype
     */
    instanceType: string | undefined;
    /**
     * `AWS::EC2::Instance.Ipv6AddressCount`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-ipv6addresscount
     */
    ipv6AddressCount: number | undefined;
    /**
     * `AWS::EC2::Instance.Ipv6Addresses`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-ipv6addresses
     */
    ipv6Addresses: Array<CfnInstance.InstanceIpv6AddressProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * `AWS::EC2::Instance.KernelId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-kernelid
     */
    kernelId: string | undefined;
    /**
     * `AWS::EC2::Instance.KeyName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-keyname
     */
    keyName: string | undefined;
    /**
     * `AWS::EC2::Instance.LaunchTemplate`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-launchtemplate
     */
    launchTemplate: CfnInstance.LaunchTemplateSpecificationProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::EC2::Instance.LicenseSpecifications`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-licensespecifications
     */
    licenseSpecifications: Array<CfnInstance.LicenseSpecificationProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * `AWS::EC2::Instance.Monitoring`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-monitoring
     */
    monitoring: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::EC2::Instance.NetworkInterfaces`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-networkinterfaces
     */
    networkInterfaces: Array<CfnInstance.NetworkInterfaceProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * `AWS::EC2::Instance.PlacementGroupName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-placementgroupname
     */
    placementGroupName: string | undefined;
    /**
     * `AWS::EC2::Instance.PrivateIpAddress`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-privateipaddress
     */
    privateIpAddress: string | undefined;
    /**
     * `AWS::EC2::Instance.RamdiskId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-ramdiskid
     */
    ramdiskId: string | undefined;
    /**
     * `AWS::EC2::Instance.SecurityGroupIds`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-securitygroupids
     */
    securityGroupIds: string[] | undefined;
    /**
     * `AWS::EC2::Instance.SecurityGroups`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-securitygroups
     */
    securityGroups: string[] | undefined;
    /**
     * `AWS::EC2::Instance.SourceDestCheck`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-sourcedestcheck
     */
    sourceDestCheck: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::EC2::Instance.SsmAssociations`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-ssmassociations
     */
    ssmAssociations: Array<CfnInstance.SsmAssociationProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * `AWS::EC2::Instance.SubnetId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-subnetid
     */
    subnetId: string | undefined;
    /**
     * `AWS::EC2::Instance.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-tags
     */
    readonly tags: cdk.TagManager;
    /**
     * `AWS::EC2::Instance.Tenancy`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-tenancy
     */
    tenancy: string | undefined;
    /**
     * `AWS::EC2::Instance.UserData`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-userdata
     */
    userData: string | undefined;
    /**
     * `AWS::EC2::Instance.Volumes`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-volumes
     */
    volumes: Array<CfnInstance.VolumeProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * Create a new `AWS::EC2::Instance`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props?: CfnInstanceProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @external
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::EC2::Instance`.
 *
 * @external
 * @cloudformationResource AWS::EC2::Instance
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html
 */
export declare namespace CfnInstance {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-ssmassociations-associationparameters.html
     */
    interface AssociationParameterProperty {
        /**
         * `CfnInstance.AssociationParameterProperty.Key`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-ssmassociations-associationparameters.html#cfn-ec2-instance-ssmassociations-associationparameters-key
         */
        readonly key: string;
        /**
         * `CfnInstance.AssociationParameterProperty.Value`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-ssmassociations-associationparameters.html#cfn-ec2-instance-ssmassociations-associationparameters-value
         */
        readonly value: string[];
    }
}
/**
 * A CloudFormation `AWS::EC2::Instance`.
 *
 * @external
 * @cloudformationResource AWS::EC2::Instance
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html
 */
export declare namespace CfnInstance {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-blockdev-mapping.html
     */
    interface BlockDeviceMappingProperty {
        /**
         * `CfnInstance.BlockDeviceMappingProperty.DeviceName`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-blockdev-mapping.html#cfn-ec2-blockdev-mapping-devicename
         */
        readonly deviceName: string;
        /**
         * `CfnInstance.BlockDeviceMappingProperty.Ebs`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-blockdev-mapping.html#cfn-ec2-blockdev-mapping-ebs
         */
        readonly ebs?: CfnInstance.EbsProperty | cdk.IResolvable;
        /**
         * `CfnInstance.BlockDeviceMappingProperty.NoDevice`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-blockdev-mapping.html#cfn-ec2-blockdev-mapping-nodevice
         */
        readonly noDevice?: CfnInstance.NoDeviceProperty | cdk.IResolvable;
        /**
         * `CfnInstance.BlockDeviceMappingProperty.VirtualName`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-blockdev-mapping.html#cfn-ec2-blockdev-mapping-virtualname
         */
        readonly virtualName?: string;
    }
}
/**
 * A CloudFormation `AWS::EC2::Instance`.
 *
 * @external
 * @cloudformationResource AWS::EC2::Instance
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html
 */
export declare namespace CfnInstance {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-cpuoptions.html
     */
    interface CpuOptionsProperty {
        /**
         * `CfnInstance.CpuOptionsProperty.CoreCount`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-cpuoptions.html#cfn-ec2-instance-cpuoptions-corecount
         */
        readonly coreCount?: number;
        /**
         * `CfnInstance.CpuOptionsProperty.ThreadsPerCore`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-cpuoptions.html#cfn-ec2-instance-cpuoptions-threadspercore
         */
        readonly threadsPerCore?: number;
    }
}
/**
 * A CloudFormation `AWS::EC2::Instance`.
 *
 * @external
 * @cloudformationResource AWS::EC2::Instance
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html
 */
export declare namespace CfnInstance {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-creditspecification.html
     */
    interface CreditSpecificationProperty {
        /**
         * `CfnInstance.CreditSpecificationProperty.CPUCredits`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-creditspecification.html#cfn-ec2-instance-creditspecification-cpucredits
         */
        readonly cpuCredits?: string;
    }
}
/**
 * A CloudFormation `AWS::EC2::Instance`.
 *
 * @external
 * @cloudformationResource AWS::EC2::Instance
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html
 */
export declare namespace CfnInstance {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-blockdev-template.html
     */
    interface EbsProperty {
        /**
         * `CfnInstance.EbsProperty.DeleteOnTermination`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-blockdev-template.html#cfn-ec2-blockdev-template-deleteontermination
         */
        readonly deleteOnTermination?: boolean | cdk.IResolvable;
        /**
         * `CfnInstance.EbsProperty.Encrypted`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-blockdev-template.html#cfn-ec2-blockdev-template-encrypted
         */
        readonly encrypted?: boolean | cdk.IResolvable;
        /**
         * `CfnInstance.EbsProperty.Iops`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-blockdev-template.html#cfn-ec2-blockdev-template-iops
         */
        readonly iops?: number;
        /**
         * `CfnInstance.EbsProperty.KmsKeyId`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-blockdev-template.html#cfn-ec2-instance-ebs-kmskeyid
         */
        readonly kmsKeyId?: string;
        /**
         * `CfnInstance.EbsProperty.SnapshotId`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-blockdev-template.html#cfn-ec2-blockdev-template-snapshotid
         */
        readonly snapshotId?: string;
        /**
         * `CfnInstance.EbsProperty.VolumeSize`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-blockdev-template.html#cfn-ec2-blockdev-template-volumesize
         */
        readonly volumeSize?: number;
        /**
         * `CfnInstance.EbsProperty.VolumeType`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-blockdev-template.html#cfn-ec2-blockdev-template-volumetype
         */
        readonly volumeType?: string;
    }
}
/**
 * A CloudFormation `AWS::EC2::Instance`.
 *
 * @external
 * @cloudformationResource AWS::EC2::Instance
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html
 */
export declare namespace CfnInstance {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-elasticgpuspecification.html
     */
    interface ElasticGpuSpecificationProperty {
        /**
         * `CfnInstance.ElasticGpuSpecificationProperty.Type`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-elasticgpuspecification.html#cfn-ec2-instance-elasticgpuspecification-type
         */
        readonly type: string;
    }
}
/**
 * A CloudFormation `AWS::EC2::Instance`.
 *
 * @external
 * @cloudformationResource AWS::EC2::Instance
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html
 */
export declare namespace CfnInstance {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-elasticinferenceaccelerator.html
     */
    interface ElasticInferenceAcceleratorProperty {
        /**
         * `CfnInstance.ElasticInferenceAcceleratorProperty.Count`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-elasticinferenceaccelerator.html#cfn-ec2-instance-elasticinferenceaccelerator-count
         */
        readonly count?: number;
        /**
         * `CfnInstance.ElasticInferenceAcceleratorProperty.Type`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-elasticinferenceaccelerator.html#cfn-ec2-instance-elasticinferenceaccelerator-type
         */
        readonly type: string;
    }
}
/**
 * A CloudFormation `AWS::EC2::Instance`.
 *
 * @external
 * @cloudformationResource AWS::EC2::Instance
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html
 */
export declare namespace CfnInstance {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-enclaveoptions.html
     */
    interface EnclaveOptionsProperty {
        /**
         * `CfnInstance.EnclaveOptionsProperty.Enabled`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-enclaveoptions.html#cfn-ec2-instance-enclaveoptions-enabled
         */
        readonly enabled?: boolean | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::EC2::Instance`.
 *
 * @external
 * @cloudformationResource AWS::EC2::Instance
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html
 */
export declare namespace CfnInstance {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-hibernationoptions.html
     */
    interface HibernationOptionsProperty {
        /**
         * `CfnInstance.HibernationOptionsProperty.Configured`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-hibernationoptions.html#cfn-ec2-instance-hibernationoptions-configured
         */
        readonly configured?: boolean | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::EC2::Instance`.
 *
 * @external
 * @cloudformationResource AWS::EC2::Instance
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html
 */
export declare namespace CfnInstance {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-instanceipv6address.html
     */
    interface InstanceIpv6AddressProperty {
        /**
         * `CfnInstance.InstanceIpv6AddressProperty.Ipv6Address`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-instanceipv6address.html#cfn-ec2-instance-instanceipv6address-ipv6address
         */
        readonly ipv6Address: string;
    }
}
/**
 * A CloudFormation `AWS::EC2::Instance`.
 *
 * @external
 * @cloudformationResource AWS::EC2::Instance
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html
 */
export declare namespace CfnInstance {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-launchtemplatespecification.html
     */
    interface LaunchTemplateSpecificationProperty {
        /**
         * `CfnInstance.LaunchTemplateSpecificationProperty.LaunchTemplateId`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-launchtemplatespecification.html#cfn-ec2-instance-launchtemplatespecification-launchtemplateid
         */
        readonly launchTemplateId?: string;
        /**
         * `CfnInstance.LaunchTemplateSpecificationProperty.LaunchTemplateName`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-launchtemplatespecification.html#cfn-ec2-instance-launchtemplatespecification-launchtemplatename
         */
        readonly launchTemplateName?: string;
        /**
         * `CfnInstance.LaunchTemplateSpecificationProperty.Version`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-launchtemplatespecification.html#cfn-ec2-instance-launchtemplatespecification-version
         */
        readonly version: string;
    }
}
/**
 * A CloudFormation `AWS::EC2::Instance`.
 *
 * @external
 * @cloudformationResource AWS::EC2::Instance
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html
 */
export declare namespace CfnInstance {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-licensespecification.html
     */
    interface LicenseSpecificationProperty {
        /**
         * `CfnInstance.LicenseSpecificationProperty.LicenseConfigurationArn`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-licensespecification.html#cfn-ec2-instance-licensespecification-licenseconfigurationarn
         */
        readonly licenseConfigurationArn: string;
    }
}
/**
 * A CloudFormation `AWS::EC2::Instance`.
 *
 * @external
 * @cloudformationResource AWS::EC2::Instance
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html
 */
export declare namespace CfnInstance {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-iface-embedded.html
     */
    interface NetworkInterfaceProperty {
        /**
         * `CfnInstance.NetworkInterfaceProperty.AssociatePublicIpAddress`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-iface-embedded.html#aws-properties-ec2-network-iface-embedded-associatepubip
         */
        readonly associatePublicIpAddress?: boolean | cdk.IResolvable;
        /**
         * `CfnInstance.NetworkInterfaceProperty.DeleteOnTermination`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-iface-embedded.html#aws-properties-ec2-network-iface-embedded-delete
         */
        readonly deleteOnTermination?: boolean | cdk.IResolvable;
        /**
         * `CfnInstance.NetworkInterfaceProperty.Description`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-iface-embedded.html#aws-properties-ec2-network-iface-embedded-description
         */
        readonly description?: string;
        /**
         * `CfnInstance.NetworkInterfaceProperty.DeviceIndex`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-iface-embedded.html#aws-properties-ec2-network-iface-embedded-deviceindex
         */
        readonly deviceIndex: string;
        /**
         * `CfnInstance.NetworkInterfaceProperty.GroupSet`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-iface-embedded.html#aws-properties-ec2-network-iface-embedded-groupset
         */
        readonly groupSet?: string[];
        /**
         * `CfnInstance.NetworkInterfaceProperty.Ipv6AddressCount`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-iface-embedded.html#cfn-ec2-instance-networkinterface-ipv6addresscount
         */
        readonly ipv6AddressCount?: number;
        /**
         * `CfnInstance.NetworkInterfaceProperty.Ipv6Addresses`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-iface-embedded.html#cfn-ec2-instance-networkinterface-ipv6addresses
         */
        readonly ipv6Addresses?: Array<CfnInstance.InstanceIpv6AddressProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnInstance.NetworkInterfaceProperty.NetworkInterfaceId`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-iface-embedded.html#aws-properties-ec2-network-iface-embedded-network-iface
         */
        readonly networkInterfaceId?: string;
        /**
         * `CfnInstance.NetworkInterfaceProperty.PrivateIpAddress`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-iface-embedded.html#aws-properties-ec2-network-iface-embedded-privateipaddress
         */
        readonly privateIpAddress?: string;
        /**
         * `CfnInstance.NetworkInterfaceProperty.PrivateIpAddresses`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-iface-embedded.html#aws-properties-ec2-network-iface-embedded-privateipaddresses
         */
        readonly privateIpAddresses?: Array<CfnInstance.PrivateIpAddressSpecificationProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnInstance.NetworkInterfaceProperty.SecondaryPrivateIpAddressCount`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-iface-embedded.html#aws-properties-ec2-network-iface-embedded-secondprivateip
         */
        readonly secondaryPrivateIpAddressCount?: number;
        /**
         * `CfnInstance.NetworkInterfaceProperty.SubnetId`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-iface-embedded.html#aws-properties-ec2-network-iface-embedded-subnetid
         */
        readonly subnetId?: string;
    }
}
/**
 * A CloudFormation `AWS::EC2::Instance`.
 *
 * @external
 * @cloudformationResource AWS::EC2::Instance
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html
 */
export declare namespace CfnInstance {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-nodevice.html
     */
    interface NoDeviceProperty {
    }
}
/**
 * A CloudFormation `AWS::EC2::Instance`.
 *
 * @external
 * @cloudformationResource AWS::EC2::Instance
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html
 */
export declare namespace CfnInstance {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-interface-privateipspec.html
     */
    interface PrivateIpAddressSpecificationProperty {
        /**
         * `CfnInstance.PrivateIpAddressSpecificationProperty.Primary`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-interface-privateipspec.html#cfn-ec2-networkinterface-privateipspecification-primary
         */
        readonly primary: boolean | cdk.IResolvable;
        /**
         * `CfnInstance.PrivateIpAddressSpecificationProperty.PrivateIpAddress`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-interface-privateipspec.html#cfn-ec2-networkinterface-privateipspecification-privateipaddress
         */
        readonly privateIpAddress: string;
    }
}
/**
 * A CloudFormation `AWS::EC2::Instance`.
 *
 * @external
 * @cloudformationResource AWS::EC2::Instance
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html
 */
export declare namespace CfnInstance {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-ssmassociations.html
     */
    interface SsmAssociationProperty {
        /**
         * `CfnInstance.SsmAssociationProperty.AssociationParameters`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-ssmassociations.html#cfn-ec2-instance-ssmassociations-associationparameters
         */
        readonly associationParameters?: Array<CfnInstance.AssociationParameterProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnInstance.SsmAssociationProperty.DocumentName`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-ssmassociations.html#cfn-ec2-instance-ssmassociations-documentname
         */
        readonly documentName: string;
    }
}
/**
 * A CloudFormation `AWS::EC2::Instance`.
 *
 * @external
 * @cloudformationResource AWS::EC2::Instance
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html
 */
export declare namespace CfnInstance {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-mount-point.html
     */
    interface VolumeProperty {
        /**
         * `CfnInstance.VolumeProperty.Device`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-mount-point.html#cfn-ec2-mountpoint-device
         */
        readonly device: string;
        /**
         * `CfnInstance.VolumeProperty.VolumeId`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-mount-point.html#cfn-ec2-mountpoint-volumeid
         */
        readonly volumeId: string;
    }
}
/**
 * Properties for defining a `AWS::EC2::InternetGateway`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-internetgateway.html
 */
export interface CfnInternetGatewayProps {
    /**
     * `AWS::EC2::InternetGateway.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-internetgateway.html#cfn-ec2-internetgateway-tags
     */
    readonly tags?: cdk.CfnTag[];
}
/**
 * A CloudFormation `AWS::EC2::InternetGateway`.
 *
 * @external
 * @cloudformationResource AWS::EC2::InternetGateway
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-internetgateway.html
 */
export declare class CfnInternetGateway extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::EC2::InternetGateway";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnInternetGateway;
    /**
     * @external
     * @cloudformationAttribute InternetGatewayId
     */
    readonly attrInternetGatewayId: string;
    /**
     * `AWS::EC2::InternetGateway.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-internetgateway.html#cfn-ec2-internetgateway-tags
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::EC2::InternetGateway`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props?: CfnInternetGatewayProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @external
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::EC2::LaunchTemplate`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-launchtemplate.html
 */
export interface CfnLaunchTemplateProps {
    /**
     * `AWS::EC2::LaunchTemplate.LaunchTemplateData`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-launchtemplate.html#cfn-ec2-launchtemplate-launchtemplatedata
     */
    readonly launchTemplateData?: CfnLaunchTemplate.LaunchTemplateDataProperty | cdk.IResolvable;
    /**
     * `AWS::EC2::LaunchTemplate.LaunchTemplateName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-launchtemplate.html#cfn-ec2-launchtemplate-launchtemplatename
     */
    readonly launchTemplateName?: string;
    /**
     * `AWS::EC2::LaunchTemplate.TagSpecifications`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-launchtemplate.html#cfn-ec2-launchtemplate-tagspecifications
     */
    readonly tagSpecifications?: Array<CfnLaunchTemplate.LaunchTemplateTagSpecificationProperty | cdk.IResolvable> | cdk.IResolvable;
}
/**
 * A CloudFormation `AWS::EC2::LaunchTemplate`.
 *
 * @external
 * @cloudformationResource AWS::EC2::LaunchTemplate
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-launchtemplate.html
 */
export declare class CfnLaunchTemplate extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::EC2::LaunchTemplate";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnLaunchTemplate;
    /**
     * @external
     * @cloudformationAttribute DefaultVersionNumber
     */
    readonly attrDefaultVersionNumber: string;
    /**
     * @external
     * @cloudformationAttribute LatestVersionNumber
     */
    readonly attrLatestVersionNumber: string;
    /**
     * `AWS::EC2::LaunchTemplate.LaunchTemplateData`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-launchtemplate.html#cfn-ec2-launchtemplate-launchtemplatedata
     */
    launchTemplateData: CfnLaunchTemplate.LaunchTemplateDataProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::EC2::LaunchTemplate.LaunchTemplateName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-launchtemplate.html#cfn-ec2-launchtemplate-launchtemplatename
     */
    launchTemplateName: string | undefined;
    /**
     * `AWS::EC2::LaunchTemplate.TagSpecifications`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-launchtemplate.html#cfn-ec2-launchtemplate-tagspecifications
     */
    tagSpecifications: Array<CfnLaunchTemplate.LaunchTemplateTagSpecificationProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * Create a new `AWS::EC2::LaunchTemplate`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props?: CfnLaunchTemplateProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @external
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::EC2::LaunchTemplate`.
 *
 * @external
 * @cloudformationResource AWS::EC2::LaunchTemplate
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-launchtemplate.html
 */
export declare namespace CfnLaunchTemplate {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-acceleratorcount.html
     */
    interface AcceleratorCountProperty {
        /**
         * `CfnLaunchTemplate.AcceleratorCountProperty.Max`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-acceleratorcount.html#cfn-ec2-launchtemplate-acceleratorcount-max
         */
        readonly max?: number;
        /**
         * `CfnLaunchTemplate.AcceleratorCountProperty.Min`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-acceleratorcount.html#cfn-ec2-launchtemplate-acceleratorcount-min
         */
        readonly min?: number;
    }
}
/**
 * A CloudFormation `AWS::EC2::LaunchTemplate`.
 *
 * @external
 * @cloudformationResource AWS::EC2::LaunchTemplate
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-launchtemplate.html
 */
export declare namespace CfnLaunchTemplate {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-acceleratortotalmemorymib.html
     */
    interface AcceleratorTotalMemoryMiBProperty {
        /**
         * `CfnLaunchTemplate.AcceleratorTotalMemoryMiBProperty.Max`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-acceleratortotalmemorymib.html#cfn-ec2-launchtemplate-acceleratortotalmemorymib-max
         */
        readonly max?: number;
        /**
         * `CfnLaunchTemplate.AcceleratorTotalMemoryMiBProperty.Min`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-acceleratortotalmemorymib.html#cfn-ec2-launchtemplate-acceleratortotalmemorymib-min
         */
        readonly min?: number;
    }
}
/**
 * A CloudFormation `AWS::EC2::LaunchTemplate`.
 *
 * @external
 * @cloudformationResource AWS::EC2::LaunchTemplate
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-launchtemplate.html
 */
export declare namespace CfnLaunchTemplate {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-baselineebsbandwidthmbps.html
     */
    interface BaselineEbsBandwidthMbpsProperty {
        /**
         * `CfnLaunchTemplate.BaselineEbsBandwidthMbpsProperty.Max`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-baselineebsbandwidthmbps.html#cfn-ec2-launchtemplate-baselineebsbandwidthmbps-max
         */
        readonly max?: number;
        /**
         * `CfnLaunchTemplate.BaselineEbsBandwidthMbpsProperty.Min`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-baselineebsbandwidthmbps.html#cfn-ec2-launchtemplate-baselineebsbandwidthmbps-min
         */
        readonly min?: number;
    }
}
/**
 * A CloudFormation `AWS::EC2::LaunchTemplate`.
 *
 * @external
 * @cloudformationResource AWS::EC2::LaunchTemplate
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-launchtemplate.html
 */
export declare namespace CfnLaunchTemplate {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-blockdevicemapping.html
     */
    interface BlockDeviceMappingProperty {
        /**
         * `CfnLaunchTemplate.BlockDeviceMappingProperty.DeviceName`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-blockdevicemapping.html#cfn-ec2-launchtemplate-blockdevicemapping-devicename
         */
        readonly deviceName?: string;
        /**
         * `CfnLaunchTemplate.BlockDeviceMappingProperty.Ebs`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-blockdevicemapping.html#cfn-ec2-launchtemplate-blockdevicemapping-ebs
         */
        readonly ebs?: CfnLaunchTemplate.EbsProperty | cdk.IResolvable;
        /**
         * `CfnLaunchTemplate.BlockDeviceMappingProperty.NoDevice`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-blockdevicemapping.html#cfn-ec2-launchtemplate-blockdevicemapping-nodevice
         */
        readonly noDevice?: string;
        /**
         * `CfnLaunchTemplate.BlockDeviceMappingProperty.VirtualName`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-blockdevicemapping.html#cfn-ec2-launchtemplate-blockdevicemapping-virtualname
         */
        readonly virtualName?: string;
    }
}
/**
 * A CloudFormation `AWS::EC2::LaunchTemplate`.
 *
 * @external
 * @cloudformationResource AWS::EC2::LaunchTemplate
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-launchtemplate.html
 */
export declare namespace CfnLaunchTemplate {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-capacityreservationspecification.html
     */
    interface CapacityReservationSpecificationProperty {
        /**
         * `CfnLaunchTemplate.CapacityReservationSpecificationProperty.CapacityReservationPreference`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-capacityreservationspecification.html#cfn-ec2-launchtemplate-launchtemplatedata-capacityreservationspecification-capacityreservationpreference
         */
        readonly capacityReservationPreference?: string;
        /**
         * `CfnLaunchTemplate.CapacityReservationSpecificationProperty.CapacityReservationTarget`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-capacityreservationspecification.html#cfn-ec2-launchtemplate-launchtemplatedata-capacityreservationspecification-capacityreservationtarget
         */
        readonly capacityReservationTarget?: CfnLaunchTemplate.CapacityReservationTargetProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::EC2::LaunchTemplate`.
 *
 * @external
 * @cloudformationResource AWS::EC2::LaunchTemplate
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-launchtemplate.html
 */
export declare namespace CfnLaunchTemplate {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-capacityreservationtarget.html
     */
    interface CapacityReservationTargetProperty {
        /**
         * `CfnLaunchTemplate.CapacityReservationTargetProperty.CapacityReservationId`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-capacityreservationtarget.html#cfn-ec2-launchtemplate-capacityreservationtarget-capacityreservationid
         */
        readonly capacityReservationId?: string;
        /**
         * `CfnLaunchTemplate.CapacityReservationTargetProperty.CapacityReservationResourceGroupArn`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-capacityreservationtarget.html#cfn-ec2-launchtemplate-capacityreservationtarget-capacityreservationresourcegrouparn
         */
        readonly capacityReservationResourceGroupArn?: string;
    }
}
/**
 * A CloudFormation `AWS::EC2::LaunchTemplate`.
 *
 * @external
 * @cloudformationResource AWS::EC2::LaunchTemplate
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-launchtemplate.html
 */
export declare namespace CfnLaunchTemplate {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-cpuoptions.html
     */
    interface CpuOptionsProperty {
        /**
         * `CfnLaunchTemplate.CpuOptionsProperty.CoreCount`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-cpuoptions.html#cfn-ec2-launchtemplate-launchtemplatedata-cpuoptions-corecount
         */
        readonly coreCount?: number;
        /**
         * `CfnLaunchTemplate.CpuOptionsProperty.ThreadsPerCore`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-cpuoptions.html#cfn-ec2-launchtemplate-launchtemplatedata-cpuoptions-threadspercore
         */
        readonly threadsPerCore?: number;
    }
}
/**
 * A CloudFormation `AWS::EC2::LaunchTemplate`.
 *
 * @external
 * @cloudformationResource AWS::EC2::LaunchTemplate
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-launchtemplate.html
 */
export declare namespace CfnLaunchTemplate {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-creditspecification.html
     */
    interface CreditSpecificationProperty {
        /**
         * `CfnLaunchTemplate.CreditSpecificationProperty.CpuCredits`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-creditspecification.html#cfn-ec2-launchtemplate-launchtemplatedata-creditspecification-cpucredits
         */
        readonly cpuCredits?: string;
    }
}
/**
 * A CloudFormation `AWS::EC2::LaunchTemplate`.
 *
 * @external
 * @cloudformationResource AWS::EC2::LaunchTemplate
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-launchtemplate.html
 */
export declare namespace CfnLaunchTemplate {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-blockdevicemapping-ebs.html
     */
    interface EbsProperty {
        /**
         * `CfnLaunchTemplate.EbsProperty.DeleteOnTermination`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-blockdevicemapping-ebs.html#cfn-ec2-launchtemplate-blockdevicemapping-ebs-deleteontermination
         */
        readonly deleteOnTermination?: boolean | cdk.IResolvable;
        /**
         * `CfnLaunchTemplate.EbsProperty.Encrypted`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-blockdevicemapping-ebs.html#cfn-ec2-launchtemplate-blockdevicemapping-ebs-encrypted
         */
        readonly encrypted?: boolean | cdk.IResolvable;
        /**
         * `CfnLaunchTemplate.EbsProperty.Iops`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-blockdevicemapping-ebs.html#cfn-ec2-launchtemplate-blockdevicemapping-ebs-iops
         */
        readonly iops?: number;
        /**
         * `CfnLaunchTemplate.EbsProperty.KmsKeyId`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-blockdevicemapping-ebs.html#cfn-ec2-launchtemplate-blockdevicemapping-ebs-kmskeyid
         */
        readonly kmsKeyId?: string;
        /**
         * `CfnLaunchTemplate.EbsProperty.SnapshotId`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-blockdevicemapping-ebs.html#cfn-ec2-launchtemplate-blockdevicemapping-ebs-snapshotid
         */
        readonly snapshotId?: string;
        /**
         * `CfnLaunchTemplate.EbsProperty.Throughput`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-blockdevicemapping-ebs.html#cfn-ec2-launchtemplate-blockdevicemapping-ebs-throughput
         */
        readonly throughput?: number;
        /**
         * `CfnLaunchTemplate.EbsProperty.VolumeSize`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-blockdevicemapping-ebs.html#cfn-ec2-launchtemplate-blockdevicemapping-ebs-volumesize
         */
        readonly volumeSize?: number;
        /**
         * `CfnLaunchTemplate.EbsProperty.VolumeType`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-blockdevicemapping-ebs.html#cfn-ec2-launchtemplate-blockdevicemapping-ebs-volumetype
         */
        readonly volumeType?: string;
    }
}
/**
 * A CloudFormation `AWS::EC2::LaunchTemplate`.
 *
 * @external
 * @cloudformationResource AWS::EC2::LaunchTemplate
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-launchtemplate.html
 */
export declare namespace CfnLaunchTemplate {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-elasticgpuspecification.html
     */
    interface ElasticGpuSpecificationProperty {
        /**
         * `CfnLaunchTemplate.ElasticGpuSpecificationProperty.Type`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-elasticgpuspecification.html#cfn-ec2-launchtemplate-elasticgpuspecification-type
         */
        readonly type?: string;
    }
}
/**
 * A CloudFormation `AWS::EC2::LaunchTemplate`.
 *
 * @external
 * @cloudformationResource AWS::EC2::LaunchTemplate
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-launchtemplate.html
 */
export declare namespace CfnLaunchTemplate {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-enclaveoptions.html
     */
    interface EnclaveOptionsProperty {
        /**
         * `CfnLaunchTemplate.EnclaveOptionsProperty.Enabled`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-enclaveoptions.html#cfn-ec2-launchtemplate-launchtemplatedata-enclaveoptions-enabled
         */
        readonly enabled?: boolean | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::EC2::LaunchTemplate`.
 *
 * @external
 * @cloudformationResource AWS::EC2::LaunchTemplate
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-launchtemplate.html
 */
export declare namespace CfnLaunchTemplate {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-hibernationoptions.html
     */
    interface HibernationOptionsProperty {
        /**
         * `CfnLaunchTemplate.HibernationOptionsProperty.Configured`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-hibernationoptions.html#cfn-ec2-launchtemplate-launchtemplatedata-hibernationoptions-configured
         */
        readonly configured?: boolean | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::EC2::LaunchTemplate`.
 *
 * @external
 * @cloudformationResource AWS::EC2::LaunchTemplate
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-launchtemplate.html
 */
export declare namespace CfnLaunchTemplate {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-iaminstanceprofile.html
     */
    interface IamInstanceProfileProperty {
        /**
         * `CfnLaunchTemplate.IamInstanceProfileProperty.Arn`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-iaminstanceprofile.html#cfn-ec2-launchtemplate-launchtemplatedata-iaminstanceprofile-arn
         */
        readonly arn?: string;
        /**
         * `CfnLaunchTemplate.IamInstanceProfileProperty.Name`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-iaminstanceprofile.html#cfn-ec2-launchtemplate-launchtemplatedata-iaminstanceprofile-name
         */
        readonly name?: string;
    }
}
/**
 * A CloudFormation `AWS::EC2::LaunchTemplate`.
 *
 * @external
 * @cloudformationResource AWS::EC2::LaunchTemplate
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-launchtemplate.html
 */
export declare namespace CfnLaunchTemplate {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-instancemarketoptions.html
     */
    interface InstanceMarketOptionsProperty {
        /**
         * `CfnLaunchTemplate.InstanceMarketOptionsProperty.MarketType`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-instancemarketoptions.html#cfn-ec2-launchtemplate-launchtemplatedata-instancemarketoptions-markettype
         */
        readonly marketType?: string;
        /**
         * `CfnLaunchTemplate.InstanceMarketOptionsProperty.SpotOptions`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-instancemarketoptions.html#cfn-ec2-launchtemplate-launchtemplatedata-instancemarketoptions-spotoptions
         */
        readonly spotOptions?: CfnLaunchTemplate.SpotOptionsProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::EC2::LaunchTemplate`.
 *
 * @external
 * @cloudformationResource AWS::EC2::LaunchTemplate
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-launchtemplate.html
 */
export declare namespace CfnLaunchTemplate {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-ipv6add.html
     */
    interface Ipv6AddProperty {
        /**
         * `CfnLaunchTemplate.Ipv6AddProperty.Ipv6Address`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-ipv6add.html#cfn-ec2-launchtemplate-ipv6add-ipv6address
         */
        readonly ipv6Address?: string;
    }
}
/**
 * A CloudFormation `AWS::EC2::LaunchTemplate`.
 *
 * @external
 * @cloudformationResource AWS::EC2::LaunchTemplate
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-launchtemplate.html
 */
export declare namespace CfnLaunchTemplate {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html
     */
    interface LaunchTemplateDataProperty {
        /**
         * `CfnLaunchTemplate.LaunchTemplateDataProperty.BlockDeviceMappings`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-blockdevicemappings
         */
        readonly blockDeviceMappings?: Array<CfnLaunchTemplate.BlockDeviceMappingProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnLaunchTemplate.LaunchTemplateDataProperty.CapacityReservationSpecification`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-capacityreservationspecification
         */
        readonly capacityReservationSpecification?: CfnLaunchTemplate.CapacityReservationSpecificationProperty | cdk.IResolvable;
        /**
         * `CfnLaunchTemplate.LaunchTemplateDataProperty.CpuOptions`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-cpuoptions
         */
        readonly cpuOptions?: CfnLaunchTemplate.CpuOptionsProperty | cdk.IResolvable;
        /**
         * `CfnLaunchTemplate.LaunchTemplateDataProperty.CreditSpecification`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-creditspecification
         */
        readonly creditSpecification?: CfnLaunchTemplate.CreditSpecificationProperty | cdk.IResolvable;
        /**
         * `CfnLaunchTemplate.LaunchTemplateDataProperty.DisableApiTermination`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-disableapitermination
         */
        readonly disableApiTermination?: boolean | cdk.IResolvable;
        /**
         * `CfnLaunchTemplate.LaunchTemplateDataProperty.EbsOptimized`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-ebsoptimized
         */
        readonly ebsOptimized?: boolean | cdk.IResolvable;
        /**
         * `CfnLaunchTemplate.LaunchTemplateDataProperty.ElasticGpuSpecifications`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-elasticgpuspecifications
         */
        readonly elasticGpuSpecifications?: Array<CfnLaunchTemplate.ElasticGpuSpecificationProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnLaunchTemplate.LaunchTemplateDataProperty.ElasticInferenceAccelerators`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-elasticinferenceaccelerators
         */
        readonly elasticInferenceAccelerators?: Array<CfnLaunchTemplate.LaunchTemplateElasticInferenceAcceleratorProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnLaunchTemplate.LaunchTemplateDataProperty.EnclaveOptions`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-enclaveoptions
         */
        readonly enclaveOptions?: CfnLaunchTemplate.EnclaveOptionsProperty | cdk.IResolvable;
        /**
         * `CfnLaunchTemplate.LaunchTemplateDataProperty.HibernationOptions`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-hibernationoptions
         */
        readonly hibernationOptions?: CfnLaunchTemplate.HibernationOptionsProperty | cdk.IResolvable;
        /**
         * `CfnLaunchTemplate.LaunchTemplateDataProperty.IamInstanceProfile`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-iaminstanceprofile
         */
        readonly iamInstanceProfile?: CfnLaunchTemplate.IamInstanceProfileProperty | cdk.IResolvable;
        /**
         * `CfnLaunchTemplate.LaunchTemplateDataProperty.ImageId`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-imageid
         */
        readonly imageId?: string;
        /**
         * `CfnLaunchTemplate.LaunchTemplateDataProperty.InstanceInitiatedShutdownBehavior`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-instanceinitiatedshutdownbehavior
         */
        readonly instanceInitiatedShutdownBehavior?: string;
        /**
         * `CfnLaunchTemplate.LaunchTemplateDataProperty.InstanceMarketOptions`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-instancemarketoptions
         */
        readonly instanceMarketOptions?: CfnLaunchTemplate.InstanceMarketOptionsProperty | cdk.IResolvable;
        /**
         * `CfnLaunchTemplate.LaunchTemplateDataProperty.InstanceType`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-instancetype
         */
        readonly instanceType?: string;
        /**
         * `CfnLaunchTemplate.LaunchTemplateDataProperty.KernelId`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-kernelid
         */
        readonly kernelId?: string;
        /**
         * `CfnLaunchTemplate.LaunchTemplateDataProperty.KeyName`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-keyname
         */
        readonly keyName?: string;
        /**
         * `CfnLaunchTemplate.LaunchTemplateDataProperty.LicenseSpecifications`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-licensespecifications
         */
        readonly licenseSpecifications?: Array<CfnLaunchTemplate.LicenseSpecificationProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnLaunchTemplate.LaunchTemplateDataProperty.MetadataOptions`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-metadataoptions
         */
        readonly metadataOptions?: CfnLaunchTemplate.MetadataOptionsProperty | cdk.IResolvable;
        /**
         * `CfnLaunchTemplate.LaunchTemplateDataProperty.Monitoring`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-monitoring
         */
        readonly monitoring?: CfnLaunchTemplate.MonitoringProperty | cdk.IResolvable;
        /**
         * `CfnLaunchTemplate.LaunchTemplateDataProperty.NetworkInterfaces`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-networkinterfaces
         */
        readonly networkInterfaces?: Array<CfnLaunchTemplate.NetworkInterfaceProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnLaunchTemplate.LaunchTemplateDataProperty.Placement`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-placement
         */
        readonly placement?: CfnLaunchTemplate.PlacementProperty | cdk.IResolvable;
        /**
         * `CfnLaunchTemplate.LaunchTemplateDataProperty.RamDiskId`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-ramdiskid
         */
        readonly ramDiskId?: string;
        /**
         * `CfnLaunchTemplate.LaunchTemplateDataProperty.SecurityGroupIds`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-securitygroupids
         */
        readonly securityGroupIds?: string[];
        /**
         * `CfnLaunchTemplate.LaunchTemplateDataProperty.SecurityGroups`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-securitygroups
         */
        readonly securityGroups?: string[];
        /**
         * `CfnLaunchTemplate.LaunchTemplateDataProperty.TagSpecifications`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-tagspecifications
         */
        readonly tagSpecifications?: Array<CfnLaunchTemplate.TagSpecificationProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnLaunchTemplate.LaunchTemplateDataProperty.UserData`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-userdata
         */
        readonly userData?: string;
    }
}
/**
 * A CloudFormation `AWS::EC2::LaunchTemplate`.
 *
 * @external
 * @cloudformationResource AWS::EC2::LaunchTemplate
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-launchtemplate.html
 */
export declare namespace CfnLaunchTemplate {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplateelasticinferenceaccelerator.html
     */
    interface LaunchTemplateElasticInferenceAcceleratorProperty {
        /**
         * `CfnLaunchTemplate.LaunchTemplateElasticInferenceAcceleratorProperty.Count`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplateelasticinferenceaccelerator.html#cfn-ec2-launchtemplate-launchtemplateelasticinferenceaccelerator-count
         */
        readonly count?: number;
        /**
         * `CfnLaunchTemplate.LaunchTemplateElasticInferenceAcceleratorProperty.Type`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplateelasticinferenceaccelerator.html#cfn-ec2-launchtemplate-launchtemplateelasticinferenceaccelerator-type
         */
        readonly type?: string;
    }
}
/**
 * A CloudFormation `AWS::EC2::LaunchTemplate`.
 *
 * @external
 * @cloudformationResource AWS::EC2::LaunchTemplate
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-launchtemplate.html
 */
export declare namespace CfnLaunchTemplate {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatetagspecification.html
     */
    interface LaunchTemplateTagSpecificationProperty {
        /**
         * `CfnLaunchTemplate.LaunchTemplateTagSpecificationProperty.ResourceType`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatetagspecification.html#cfn-ec2-launchtemplate-launchtemplatetagspecification-resourcetype
         */
        readonly resourceType?: string;
        /**
         * `CfnLaunchTemplate.LaunchTemplateTagSpecificationProperty.Tags`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatetagspecification.html#cfn-ec2-launchtemplate-launchtemplatetagspecification-tags
         */
        readonly tags?: cdk.CfnTag[];
    }
}
/**
 * A CloudFormation `AWS::EC2::LaunchTemplate`.
 *
 * @external
 * @cloudformationResource AWS::EC2::LaunchTemplate
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-launchtemplate.html
 */
export declare namespace CfnLaunchTemplate {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-licensespecification.html
     */
    interface LicenseSpecificationProperty {
        /**
         * `CfnLaunchTemplate.LicenseSpecificationProperty.LicenseConfigurationArn`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-licensespecification.html#cfn-ec2-launchtemplate-licensespecification-licenseconfigurationarn
         */
        readonly licenseConfigurationArn?: string;
    }
}
/**
 * A CloudFormation `AWS::EC2::LaunchTemplate`.
 *
 * @external
 * @cloudformationResource AWS::EC2::LaunchTemplate
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-launchtemplate.html
 */
export declare namespace CfnLaunchTemplate {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-memorygibpervcpu.html
     */
    interface MemoryGiBPerVCpuProperty {
        /**
         * `CfnLaunchTemplate.MemoryGiBPerVCpuProperty.Max`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-memorygibpervcpu.html#cfn-ec2-launchtemplate-memorygibpervcpu-max
         */
        readonly max?: number;
        /**
         * `CfnLaunchTemplate.MemoryGiBPerVCpuProperty.Min`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-memorygibpervcpu.html#cfn-ec2-launchtemplate-memorygibpervcpu-min
         */
        readonly min?: number;
    }
}
/**
 * A CloudFormation `AWS::EC2::LaunchTemplate`.
 *
 * @external
 * @cloudformationResource AWS::EC2::LaunchTemplate
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-launchtemplate.html
 */
export declare namespace CfnLaunchTemplate {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-memorymib.html
     */
    interface MemoryMiBProperty {
        /**
         * `CfnLaunchTemplate.MemoryMiBProperty.Max`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-memorymib.html#cfn-ec2-launchtemplate-memorymib-max
         */
        readonly max?: number;
        /**
         * `CfnLaunchTemplate.MemoryMiBProperty.Min`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-memorymib.html#cfn-ec2-launchtemplate-memorymib-min
         */
        readonly min?: number;
    }
}
/**
 * A CloudFormation `AWS::EC2::LaunchTemplate`.
 *
 * @external
 * @cloudformationResource AWS::EC2::LaunchTemplate
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-launchtemplate.html
 */
export declare namespace CfnLaunchTemplate {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-metadataoptions.html
     */
    interface MetadataOptionsProperty {
        /**
         * `CfnLaunchTemplate.MetadataOptionsProperty.HttpEndpoint`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-metadataoptions.html#cfn-ec2-launchtemplate-launchtemplatedata-metadataoptions-httpendpoint
         */
        readonly httpEndpoint?: string;
        /**
         * `CfnLaunchTemplate.MetadataOptionsProperty.HttpProtocolIpv6`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-metadataoptions.html#cfn-ec2-launchtemplate-launchtemplatedata-metadataoptions-httpprotocolipv6
         */
        readonly httpProtocolIpv6?: string;
        /**
         * `CfnLaunchTemplate.MetadataOptionsProperty.HttpPutResponseHopLimit`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-metadataoptions.html#cfn-ec2-launchtemplate-launchtemplatedata-metadataoptions-httpputresponsehoplimit
         */
        readonly httpPutResponseHopLimit?: number;
        /**
         * `CfnLaunchTemplate.MetadataOptionsProperty.HttpTokens`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-metadataoptions.html#cfn-ec2-launchtemplate-launchtemplatedata-metadataoptions-httptokens
         */
        readonly httpTokens?: string;
    }
}
/**
 * A CloudFormation `AWS::EC2::LaunchTemplate`.
 *
 * @external
 * @cloudformationResource AWS::EC2::LaunchTemplate
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-launchtemplate.html
 */
export declare namespace CfnLaunchTemplate {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-monitoring.html
     */
    interface MonitoringProperty {
        /**
         * `CfnLaunchTemplate.MonitoringProperty.Enabled`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-monitoring.html#cfn-ec2-launchtemplate-launchtemplatedata-monitoring-enabled
         */
        readonly enabled?: boolean | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::EC2::LaunchTemplate`.
 *
 * @external
 * @cloudformationResource AWS::EC2::LaunchTemplate
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-launchtemplate.html
 */
export declare namespace CfnLaunchTemplate {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-networkinterface.html
     */
    interface NetworkInterfaceProperty {
        /**
         * `CfnLaunchTemplate.NetworkInterfaceProperty.AssociateCarrierIpAddress`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-networkinterface.html#cfn-ec2-launchtemplate-networkinterface-associatecarrieripaddress
         */
        readonly associateCarrierIpAddress?: boolean | cdk.IResolvable;
        /**
         * `CfnLaunchTemplate.NetworkInterfaceProperty.AssociatePublicIpAddress`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-networkinterface.html#cfn-ec2-launchtemplate-networkinterface-associatepublicipaddress
         */
        readonly associatePublicIpAddress?: boolean | cdk.IResolvable;
        /**
         * `CfnLaunchTemplate.NetworkInterfaceProperty.DeleteOnTermination`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-networkinterface.html#cfn-ec2-launchtemplate-networkinterface-deleteontermination
         */
        readonly deleteOnTermination?: boolean | cdk.IResolvable;
        /**
         * `CfnLaunchTemplate.NetworkInterfaceProperty.Description`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-networkinterface.html#cfn-ec2-launchtemplate-networkinterface-description
         */
        readonly description?: string;
        /**
         * `CfnLaunchTemplate.NetworkInterfaceProperty.DeviceIndex`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-networkinterface.html#cfn-ec2-launchtemplate-networkinterface-deviceindex
         */
        readonly deviceIndex?: number;
        /**
         * `CfnLaunchTemplate.NetworkInterfaceProperty.Groups`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-networkinterface.html#cfn-ec2-launchtemplate-networkinterface-groups
         */
        readonly groups?: string[];
        /**
         * `CfnLaunchTemplate.NetworkInterfaceProperty.InterfaceType`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-networkinterface.html#cfn-ec2-launchtemplate-networkinterface-interfacetype
         */
        readonly interfaceType?: string;
        /**
         * `CfnLaunchTemplate.NetworkInterfaceProperty.Ipv6AddressCount`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-networkinterface.html#cfn-ec2-launchtemplate-networkinterface-ipv6addresscount
         */
        readonly ipv6AddressCount?: number;
        /**
         * `CfnLaunchTemplate.NetworkInterfaceProperty.Ipv6Addresses`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-networkinterface.html#cfn-ec2-launchtemplate-networkinterface-ipv6addresses
         */
        readonly ipv6Addresses?: Array<CfnLaunchTemplate.Ipv6AddProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnLaunchTemplate.NetworkInterfaceProperty.NetworkCardIndex`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-networkinterface.html#cfn-ec2-launchtemplate-networkinterface-networkcardindex
         */
        readonly networkCardIndex?: number;
        /**
         * `CfnLaunchTemplate.NetworkInterfaceProperty.NetworkInterfaceId`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-networkinterface.html#cfn-ec2-launchtemplate-networkinterface-networkinterfaceid
         */
        readonly networkInterfaceId?: string;
        /**
         * `CfnLaunchTemplate.NetworkInterfaceProperty.PrivateIpAddress`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-networkinterface.html#cfn-ec2-launchtemplate-networkinterface-privateipaddress
         */
        readonly privateIpAddress?: string;
        /**
         * `CfnLaunchTemplate.NetworkInterfaceProperty.PrivateIpAddresses`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-networkinterface.html#cfn-ec2-launchtemplate-networkinterface-privateipaddresses
         */
        readonly privateIpAddresses?: Array<CfnLaunchTemplate.PrivateIpAddProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnLaunchTemplate.NetworkInterfaceProperty.SecondaryPrivateIpAddressCount`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-networkinterface.html#cfn-ec2-launchtemplate-networkinterface-secondaryprivateipaddresscount
         */
        readonly secondaryPrivateIpAddressCount?: number;
        /**
         * `CfnLaunchTemplate.NetworkInterfaceProperty.SubnetId`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-networkinterface.html#cfn-ec2-launchtemplate-networkinterface-subnetid
         */
        readonly subnetId?: string;
    }
}
/**
 * A CloudFormation `AWS::EC2::LaunchTemplate`.
 *
 * @external
 * @cloudformationResource AWS::EC2::LaunchTemplate
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-launchtemplate.html
 */
export declare namespace CfnLaunchTemplate {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-networkinterfacecount.html
     */
    interface NetworkInterfaceCountProperty {
        /**
         * `CfnLaunchTemplate.NetworkInterfaceCountProperty.Max`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-networkinterfacecount.html#cfn-ec2-launchtemplate-networkinterfacecount-max
         */
        readonly max?: number;
        /**
         * `CfnLaunchTemplate.NetworkInterfaceCountProperty.Min`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-networkinterfacecount.html#cfn-ec2-launchtemplate-networkinterfacecount-min
         */
        readonly min?: number;
    }
}
/**
 * A CloudFormation `AWS::EC2::LaunchTemplate`.
 *
 * @external
 * @cloudformationResource AWS::EC2::LaunchTemplate
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-launchtemplate.html
 */
export declare namespace CfnLaunchTemplate {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-placement.html
     */
    interface PlacementProperty {
        /**
         * `CfnLaunchTemplate.PlacementProperty.Affinity`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-placement.html#cfn-ec2-launchtemplate-launchtemplatedata-placement-affinity
         */
        readonly affinity?: string;
        /**
         * `CfnLaunchTemplate.PlacementProperty.AvailabilityZone`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-placement.html#cfn-ec2-launchtemplate-launchtemplatedata-placement-availabilityzone
         */
        readonly availabilityZone?: string;
        /**
         * `CfnLaunchTemplate.PlacementProperty.GroupName`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-placement.html#cfn-ec2-launchtemplate-launchtemplatedata-placement-groupname
         */
        readonly groupName?: string;
        /**
         * `CfnLaunchTemplate.PlacementProperty.HostId`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-placement.html#cfn-ec2-launchtemplate-launchtemplatedata-placement-hostid
         */
        readonly hostId?: string;
        /**
         * `CfnLaunchTemplate.PlacementProperty.HostResourceGroupArn`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-placement.html#cfn-ec2-launchtemplate-launchtemplatedata-placement-hostresourcegrouparn
         */
        readonly hostResourceGroupArn?: string;
        /**
         * `CfnLaunchTemplate.PlacementProperty.PartitionNumber`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-placement.html#cfn-ec2-launchtemplate-launchtemplatedata-placement-partitionnumber
         */
        readonly partitionNumber?: number;
        /**
         * `CfnLaunchTemplate.PlacementProperty.SpreadDomain`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-placement.html#cfn-ec2-launchtemplate-launchtemplatedata-placement-spreaddomain
         */
        readonly spreadDomain?: string;
        /**
         * `CfnLaunchTemplate.PlacementProperty.Tenancy`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-placement.html#cfn-ec2-launchtemplate-launchtemplatedata-placement-tenancy
         */
        readonly tenancy?: string;
    }
}
/**
 * A CloudFormation `AWS::EC2::LaunchTemplate`.
 *
 * @external
 * @cloudformationResource AWS::EC2::LaunchTemplate
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-launchtemplate.html
 */
export declare namespace CfnLaunchTemplate {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-privateipadd.html
     */
    interface PrivateIpAddProperty {
        /**
         * `CfnLaunchTemplate.PrivateIpAddProperty.Primary`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-privateipadd.html#cfn-ec2-launchtemplate-privateipadd-primary
         */
        readonly primary?: boolean | cdk.IResolvable;
        /**
         * `CfnLaunchTemplate.PrivateIpAddProperty.PrivateIpAddress`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-privateipadd.html#cfn-ec2-launchtemplate-privateipadd-privateipaddress
         */
        readonly privateIpAddress?: string;
    }
}
/**
 * A CloudFormation `AWS::EC2::LaunchTemplate`.
 *
 * @external
 * @cloudformationResource AWS::EC2::LaunchTemplate
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-launchtemplate.html
 */
export declare namespace CfnLaunchTemplate {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-instancemarketoptions-spotoptions.html
     */
    interface SpotOptionsProperty {
        /**
         * `CfnLaunchTemplate.SpotOptionsProperty.BlockDurationMinutes`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-instancemarketoptions-spotoptions.html#cfn-ec2-launchtemplate-launchtemplatedata-instancemarketoptions-spotoptions-blockdurationminutes
         */
        readonly blockDurationMinutes?: number;
        /**
         * `CfnLaunchTemplate.SpotOptionsProperty.InstanceInterruptionBehavior`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-instancemarketoptions-spotoptions.html#cfn-ec2-launchtemplate-launchtemplatedata-instancemarketoptions-spotoptions-instanceinterruptionbehavior
         */
        readonly instanceInterruptionBehavior?: string;
        /**
         * `CfnLaunchTemplate.SpotOptionsProperty.MaxPrice`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-instancemarketoptions-spotoptions.html#cfn-ec2-launchtemplate-launchtemplatedata-instancemarketoptions-spotoptions-maxprice
         */
        readonly maxPrice?: string;
        /**
         * `CfnLaunchTemplate.SpotOptionsProperty.SpotInstanceType`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-instancemarketoptions-spotoptions.html#cfn-ec2-launchtemplate-launchtemplatedata-instancemarketoptions-spotoptions-spotinstancetype
         */
        readonly spotInstanceType?: string;
        /**
         * `CfnLaunchTemplate.SpotOptionsProperty.ValidUntil`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-instancemarketoptions-spotoptions.html#cfn-ec2-launchtemplate-launchtemplatedata-instancemarketoptions-spotoptions-validuntil
         */
        readonly validUntil?: string;
    }
}
/**
 * A CloudFormation `AWS::EC2::LaunchTemplate`.
 *
 * @external
 * @cloudformationResource AWS::EC2::LaunchTemplate
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-launchtemplate.html
 */
export declare namespace CfnLaunchTemplate {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-tagspecification.html
     */
    interface TagSpecificationProperty {
        /**
         * `CfnLaunchTemplate.TagSpecificationProperty.ResourceType`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-tagspecification.html#cfn-ec2-launchtemplate-tagspecification-resourcetype
         */
        readonly resourceType?: string;
        /**
         * `CfnLaunchTemplate.TagSpecificationProperty.Tags`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-tagspecification.html#cfn-ec2-launchtemplate-tagspecification-tags
         */
        readonly tags?: cdk.CfnTag[];
    }
}
/**
 * A CloudFormation `AWS::EC2::LaunchTemplate`.
 *
 * @external
 * @cloudformationResource AWS::EC2::LaunchTemplate
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-launchtemplate.html
 */
export declare namespace CfnLaunchTemplate {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-totallocalstoragegb.html
     */
    interface TotalLocalStorageGBProperty {
        /**
         * `CfnLaunchTemplate.TotalLocalStorageGBProperty.Max`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-totallocalstoragegb.html#cfn-ec2-launchtemplate-totallocalstoragegb-max
         */
        readonly max?: number;
        /**
         * `CfnLaunchTemplate.TotalLocalStorageGBProperty.Min`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-totallocalstoragegb.html#cfn-ec2-launchtemplate-totallocalstoragegb-min
         */
        readonly min?: number;
    }
}
/**
 * A CloudFormation `AWS::EC2::LaunchTemplate`.
 *
 * @external
 * @cloudformationResource AWS::EC2::LaunchTemplate
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-launchtemplate.html
 */
export declare namespace CfnLaunchTemplate {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-vcpucount.html
     */
    interface VCpuCountProperty {
        /**
         * `CfnLaunchTemplate.VCpuCountProperty.Max`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-vcpucount.html#cfn-ec2-launchtemplate-vcpucount-max
         */
        readonly max?: number;
        /**
         * `CfnLaunchTemplate.VCpuCountProperty.Min`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-vcpucount.html#cfn-ec2-launchtemplate-vcpucount-min
         */
        readonly min?: number;
    }
}
/**
 * Properties for defining a `AWS::EC2::LocalGatewayRoute`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-localgatewayroute.html
 */
export interface CfnLocalGatewayRouteProps {
    /**
     * `AWS::EC2::LocalGatewayRoute.DestinationCidrBlock`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-localgatewayroute.html#cfn-ec2-localgatewayroute-destinationcidrblock
     */
    readonly destinationCidrBlock: string;
    /**
     * `AWS::EC2::LocalGatewayRoute.LocalGatewayRouteTableId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-localgatewayroute.html#cfn-ec2-localgatewayroute-localgatewayroutetableid
     */
    readonly localGatewayRouteTableId: string;
    /**
     * `AWS::EC2::LocalGatewayRoute.LocalGatewayVirtualInterfaceGroupId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-localgatewayroute.html#cfn-ec2-localgatewayroute-localgatewayvirtualinterfacegroupid
     */
    readonly localGatewayVirtualInterfaceGroupId: string;
}
/**
 * A CloudFormation `AWS::EC2::LocalGatewayRoute`.
 *
 * @external
 * @cloudformationResource AWS::EC2::LocalGatewayRoute
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-localgatewayroute.html
 */
export declare class CfnLocalGatewayRoute extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::EC2::LocalGatewayRoute";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnLocalGatewayRoute;
    /**
     * @external
     * @cloudformationAttribute State
     */
    readonly attrState: string;
    /**
     * @external
     * @cloudformationAttribute Type
     */
    readonly attrType: string;
    /**
     * `AWS::EC2::LocalGatewayRoute.DestinationCidrBlock`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-localgatewayroute.html#cfn-ec2-localgatewayroute-destinationcidrblock
     */
    destinationCidrBlock: string;
    /**
     * `AWS::EC2::LocalGatewayRoute.LocalGatewayRouteTableId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-localgatewayroute.html#cfn-ec2-localgatewayroute-localgatewayroutetableid
     */
    localGatewayRouteTableId: string;
    /**
     * `AWS::EC2::LocalGatewayRoute.LocalGatewayVirtualInterfaceGroupId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-localgatewayroute.html#cfn-ec2-localgatewayroute-localgatewayvirtualinterfacegroupid
     */
    localGatewayVirtualInterfaceGroupId: string;
    /**
     * Create a new `AWS::EC2::LocalGatewayRoute`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnLocalGatewayRouteProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @external
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::EC2::LocalGatewayRouteTableVPCAssociation`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-localgatewayroutetablevpcassociation.html
 */
export interface CfnLocalGatewayRouteTableVPCAssociationProps {
    /**
     * `AWS::EC2::LocalGatewayRouteTableVPCAssociation.LocalGatewayRouteTableId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-localgatewayroutetablevpcassociation.html#cfn-ec2-localgatewayroutetablevpcassociation-localgatewayroutetableid
     */
    readonly localGatewayRouteTableId: string;
    /**
     * `AWS::EC2::LocalGatewayRouteTableVPCAssociation.VpcId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-localgatewayroutetablevpcassociation.html#cfn-ec2-localgatewayroutetablevpcassociation-vpcid
     */
    readonly vpcId: string;
    /**
     * `AWS::EC2::LocalGatewayRouteTableVPCAssociation.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-localgatewayroutetablevpcassociation.html#cfn-ec2-localgatewayroutetablevpcassociation-tags
     */
    readonly tags?: cdk.CfnTag[];
}
/**
 * A CloudFormation `AWS::EC2::LocalGatewayRouteTableVPCAssociation`.
 *
 * @external
 * @cloudformationResource AWS::EC2::LocalGatewayRouteTableVPCAssociation
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-localgatewayroutetablevpcassociation.html
 */
export declare class CfnLocalGatewayRouteTableVPCAssociation extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::EC2::LocalGatewayRouteTableVPCAssociation";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnLocalGatewayRouteTableVPCAssociation;
    /**
     * @external
     * @cloudformationAttribute LocalGatewayId
     */
    readonly attrLocalGatewayId: string;
    /**
     * @external
     * @cloudformationAttribute LocalGatewayRouteTableVpcAssociationId
     */
    readonly attrLocalGatewayRouteTableVpcAssociationId: string;
    /**
     * @external
     * @cloudformationAttribute State
     */
    readonly attrState: string;
    /**
     * `AWS::EC2::LocalGatewayRouteTableVPCAssociation.LocalGatewayRouteTableId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-localgatewayroutetablevpcassociation.html#cfn-ec2-localgatewayroutetablevpcassociation-localgatewayroutetableid
     */
    localGatewayRouteTableId: string;
    /**
     * `AWS::EC2::LocalGatewayRouteTableVPCAssociation.VpcId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-localgatewayroutetablevpcassociation.html#cfn-ec2-localgatewayroutetablevpcassociation-vpcid
     */
    vpcId: string;
    /**
     * `AWS::EC2::LocalGatewayRouteTableVPCAssociation.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-localgatewayroutetablevpcassociation.html#cfn-ec2-localgatewayroutetablevpcassociation-tags
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::EC2::LocalGatewayRouteTableVPCAssociation`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnLocalGatewayRouteTableVPCAssociationProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @external
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::EC2::NatGateway`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-natgateway.html
 */
export interface CfnNatGatewayProps {
    /**
     * `AWS::EC2::NatGateway.SubnetId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-natgateway.html#cfn-ec2-natgateway-subnetid
     */
    readonly subnetId: string;
    /**
     * `AWS::EC2::NatGateway.AllocationId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-natgateway.html#cfn-ec2-natgateway-allocationid
     */
    readonly allocationId?: string;
    /**
     * `AWS::EC2::NatGateway.ConnectivityType`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-natgateway.html#cfn-ec2-natgateway-connectivitytype
     */
    readonly connectivityType?: string;
    /**
     * `AWS::EC2::NatGateway.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-natgateway.html#cfn-ec2-natgateway-tags
     */
    readonly tags?: cdk.CfnTag[];
}
/**
 * A CloudFormation `AWS::EC2::NatGateway`.
 *
 * @external
 * @cloudformationResource AWS::EC2::NatGateway
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-natgateway.html
 */
export declare class CfnNatGateway extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::EC2::NatGateway";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnNatGateway;
    /**
     * `AWS::EC2::NatGateway.SubnetId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-natgateway.html#cfn-ec2-natgateway-subnetid
     */
    subnetId: string;
    /**
     * `AWS::EC2::NatGateway.AllocationId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-natgateway.html#cfn-ec2-natgateway-allocationid
     */
    allocationId: string | undefined;
    /**
     * `AWS::EC2::NatGateway.ConnectivityType`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-natgateway.html#cfn-ec2-natgateway-connectivitytype
     */
    connectivityType: string | undefined;
    /**
     * `AWS::EC2::NatGateway.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-natgateway.html#cfn-ec2-natgateway-tags
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::EC2::NatGateway`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnNatGatewayProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @external
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::EC2::NetworkAcl`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-networkacl.html
 */
export interface CfnNetworkAclProps {
    /**
     * `AWS::EC2::NetworkAcl.VpcId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-networkacl.html#cfn-ec2-networkacl-vpcid
     */
    readonly vpcId: string;
    /**
     * `AWS::EC2::NetworkAcl.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-networkacl.html#cfn-ec2-networkacl-tags
     */
    readonly tags?: cdk.CfnTag[];
}
/**
 * A CloudFormation `AWS::EC2::NetworkAcl`.
 *
 * @external
 * @cloudformationResource AWS::EC2::NetworkAcl
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-networkacl.html
 */
export declare class CfnNetworkAcl extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::EC2::NetworkAcl";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnNetworkAcl;
    /**
     * @external
     * @cloudformationAttribute Id
     */
    readonly attrId: string;
    /**
     * `AWS::EC2::NetworkAcl.VpcId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-networkacl.html#cfn-ec2-networkacl-vpcid
     */
    vpcId: string;
    /**
     * `AWS::EC2::NetworkAcl.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-networkacl.html#cfn-ec2-networkacl-tags
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::EC2::NetworkAcl`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnNetworkAclProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @external
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::EC2::NetworkAclEntry`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-networkaclentry.html
 */
export interface CfnNetworkAclEntryProps {
    /**
     * `AWS::EC2::NetworkAclEntry.NetworkAclId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-networkaclentry.html#cfn-ec2-networkaclentry-networkaclid
     */
    readonly networkAclId: string;
    /**
     * `AWS::EC2::NetworkAclEntry.Protocol`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-networkaclentry.html#cfn-ec2-networkaclentry-protocol
     */
    readonly protocol: number;
    /**
     * `AWS::EC2::NetworkAclEntry.RuleAction`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-networkaclentry.html#cfn-ec2-networkaclentry-ruleaction
     */
    readonly ruleAction: string;
    /**
     * `AWS::EC2::NetworkAclEntry.RuleNumber`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-networkaclentry.html#cfn-ec2-networkaclentry-rulenumber
     */
    readonly ruleNumber: number;
    /**
     * `AWS::EC2::NetworkAclEntry.CidrBlock`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-networkaclentry.html#cfn-ec2-networkaclentry-cidrblock
     */
    readonly cidrBlock?: string;
    /**
     * `AWS::EC2::NetworkAclEntry.Egress`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-networkaclentry.html#cfn-ec2-networkaclentry-egress
     */
    readonly egress?: boolean | cdk.IResolvable;
    /**
     * `AWS::EC2::NetworkAclEntry.Icmp`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-networkaclentry.html#cfn-ec2-networkaclentry-icmp
     */
    readonly icmp?: CfnNetworkAclEntry.IcmpProperty | cdk.IResolvable;
    /**
     * `AWS::EC2::NetworkAclEntry.Ipv6CidrBlock`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-networkaclentry.html#cfn-ec2-networkaclentry-ipv6cidrblock
     */
    readonly ipv6CidrBlock?: string;
    /**
     * `AWS::EC2::NetworkAclEntry.PortRange`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-networkaclentry.html#cfn-ec2-networkaclentry-portrange
     */
    readonly portRange?: CfnNetworkAclEntry.PortRangeProperty | cdk.IResolvable;
}
/**
 * A CloudFormation `AWS::EC2::NetworkAclEntry`.
 *
 * @external
 * @cloudformationResource AWS::EC2::NetworkAclEntry
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-networkaclentry.html
 */
export declare class CfnNetworkAclEntry extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::EC2::NetworkAclEntry";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnNetworkAclEntry;
    /**
     * @external
     * @cloudformationAttribute Id
     */
    readonly attrId: string;
    /**
     * `AWS::EC2::NetworkAclEntry.NetworkAclId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-networkaclentry.html#cfn-ec2-networkaclentry-networkaclid
     */
    networkAclId: string;
    /**
     * `AWS::EC2::NetworkAclEntry.Protocol`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-networkaclentry.html#cfn-ec2-networkaclentry-protocol
     */
    protocol: number;
    /**
     * `AWS::EC2::NetworkAclEntry.RuleAction`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-networkaclentry.html#cfn-ec2-networkaclentry-ruleaction
     */
    ruleAction: string;
    /**
     * `AWS::EC2::NetworkAclEntry.RuleNumber`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-networkaclentry.html#cfn-ec2-networkaclentry-rulenumber
     */
    ruleNumber: number;
    /**
     * `AWS::EC2::NetworkAclEntry.CidrBlock`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-networkaclentry.html#cfn-ec2-networkaclentry-cidrblock
     */
    cidrBlock: string | undefined;
    /**
     * `AWS::EC2::NetworkAclEntry.Egress`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-networkaclentry.html#cfn-ec2-networkaclentry-egress
     */
    egress: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::EC2::NetworkAclEntry.Icmp`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-networkaclentry.html#cfn-ec2-networkaclentry-icmp
     */
    icmp: CfnNetworkAclEntry.IcmpProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::EC2::NetworkAclEntry.Ipv6CidrBlock`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-networkaclentry.html#cfn-ec2-networkaclentry-ipv6cidrblock
     */
    ipv6CidrBlock: string | undefined;
    /**
     * `AWS::EC2::NetworkAclEntry.PortRange`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-networkaclentry.html#cfn-ec2-networkaclentry-portrange
     */
    portRange: CfnNetworkAclEntry.PortRangeProperty | cdk.IResolvable | undefined;
    /**
     * Create a new `AWS::EC2::NetworkAclEntry`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnNetworkAclEntryProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @external
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::EC2::NetworkAclEntry`.
 *
 * @external
 * @cloudformationResource AWS::EC2::NetworkAclEntry
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-networkaclentry.html
 */
export declare namespace CfnNetworkAclEntry {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkaclentry-icmp.html
     */
    interface IcmpProperty {
        /**
         * `CfnNetworkAclEntry.IcmpProperty.Code`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkaclentry-icmp.html#cfn-ec2-networkaclentry-icmp-code
         */
        readonly code?: number;
        /**
         * `CfnNetworkAclEntry.IcmpProperty.Type`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkaclentry-icmp.html#cfn-ec2-networkaclentry-icmp-type
         */
        readonly type?: number;
    }
}
/**
 * A CloudFormation `AWS::EC2::NetworkAclEntry`.
 *
 * @external
 * @cloudformationResource AWS::EC2::NetworkAclEntry
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-networkaclentry.html
 */
export declare namespace CfnNetworkAclEntry {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkaclentry-portrange.html
     */
    interface PortRangeProperty {
        /**
         * `CfnNetworkAclEntry.PortRangeProperty.From`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkaclentry-portrange.html#cfn-ec2-networkaclentry-portrange-from
         */
        readonly from?: number;
        /**
         * `CfnNetworkAclEntry.PortRangeProperty.To`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkaclentry-portrange.html#cfn-ec2-networkaclentry-portrange-to
         */
        readonly to?: number;
    }
}
/**
 * Properties for defining a `AWS::EC2::NetworkInsightsAnalysis`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-networkinsightsanalysis.html
 */
export interface CfnNetworkInsightsAnalysisProps {
    /**
     * `AWS::EC2::NetworkInsightsAnalysis.NetworkInsightsPathId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-networkinsightsanalysis.html#cfn-ec2-networkinsightsanalysis-networkinsightspathid
     */
    readonly networkInsightsPathId: string;
    /**
     * `AWS::EC2::NetworkInsightsAnalysis.FilterInArns`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-networkinsightsanalysis.html#cfn-ec2-networkinsightsanalysis-filterinarns
     */
    readonly filterInArns?: string[];
    /**
     * `AWS::EC2::NetworkInsightsAnalysis.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-networkinsightsanalysis.html#cfn-ec2-networkinsightsanalysis-tags
     */
    readonly tags?: cdk.CfnTag[];
}
/**
 * A CloudFormation `AWS::EC2::NetworkInsightsAnalysis`.
 *
 * @external
 * @cloudformationResource AWS::EC2::NetworkInsightsAnalysis
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-networkinsightsanalysis.html
 */
export declare class CfnNetworkInsightsAnalysis extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::EC2::NetworkInsightsAnalysis";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnNetworkInsightsAnalysis;
    /**
     * @external
     * @cloudformationAttribute AlternatePathHints
     */
    readonly attrAlternatePathHints: cdk.IResolvable;
    /**
     * @external
     * @cloudformationAttribute Explanations
     */
    readonly attrExplanations: cdk.IResolvable;
    /**
     * @external
     * @cloudformationAttribute ForwardPathComponents
     */
    readonly attrForwardPathComponents: cdk.IResolvable;
    /**
     * @external
     * @cloudformationAttribute NetworkInsightsAnalysisArn
     */
    readonly attrNetworkInsightsAnalysisArn: string;
    /**
     * @external
     * @cloudformationAttribute NetworkInsightsAnalysisId
     */
    readonly attrNetworkInsightsAnalysisId: string;
    /**
     * @external
     * @cloudformationAttribute NetworkPathFound
     */
    readonly attrNetworkPathFound: cdk.IResolvable;
    /**
     * @external
     * @cloudformationAttribute ReturnPathComponents
     */
    readonly attrReturnPathComponents: cdk.IResolvable;
    /**
     * @external
     * @cloudformationAttribute StartDate
     */
    readonly attrStartDate: string;
    /**
     * @external
     * @cloudformationAttribute Status
     */
    readonly attrStatus: string;
    /**
     * @external
     * @cloudformationAttribute StatusMessage
     */
    readonly attrStatusMessage: string;
    /**
     * `AWS::EC2::NetworkInsightsAnalysis.NetworkInsightsPathId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-networkinsightsanalysis.html#cfn-ec2-networkinsightsanalysis-networkinsightspathid
     */
    networkInsightsPathId: string;
    /**
     * `AWS::EC2::NetworkInsightsAnalysis.FilterInArns`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-networkinsightsanalysis.html#cfn-ec2-networkinsightsanalysis-filterinarns
     */
    filterInArns: string[] | undefined;
    /**
     * `AWS::EC2::NetworkInsightsAnalysis.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-networkinsightsanalysis.html#cfn-ec2-networkinsightsanalysis-tags
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::EC2::NetworkInsightsAnalysis`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnNetworkInsightsAnalysisProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @external
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::EC2::NetworkInsightsAnalysis`.
 *
 * @external
 * @cloudformationResource AWS::EC2::NetworkInsightsAnalysis
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-networkinsightsanalysis.html
 */
export declare namespace CfnNetworkInsightsAnalysis {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-alternatepathhint.html
     */
    interface AlternatePathHintProperty {
        /**
         * `CfnNetworkInsightsAnalysis.AlternatePathHintProperty.ComponentArn`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-alternatepathhint.html#cfn-ec2-networkinsightsanalysis-alternatepathhint-componentarn
         */
        readonly componentArn?: string;
        /**
         * `CfnNetworkInsightsAnalysis.AlternatePathHintProperty.ComponentId`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-alternatepathhint.html#cfn-ec2-networkinsightsanalysis-alternatepathhint-componentid
         */
        readonly componentId?: string;
    }
}
/**
 * A CloudFormation `AWS::EC2::NetworkInsightsAnalysis`.
 *
 * @external
 * @cloudformationResource AWS::EC2::NetworkInsightsAnalysis
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-networkinsightsanalysis.html
 */
export declare namespace CfnNetworkInsightsAnalysis {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-analysisaclrule.html
     */
    interface AnalysisAclRuleProperty {
        /**
         * `CfnNetworkInsightsAnalysis.AnalysisAclRuleProperty.Cidr`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-analysisaclrule.html#cfn-ec2-networkinsightsanalysis-analysisaclrule-cidr
         */
        readonly cidr?: string;
        /**
         * `CfnNetworkInsightsAnalysis.AnalysisAclRuleProperty.Egress`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-analysisaclrule.html#cfn-ec2-networkinsightsanalysis-analysisaclrule-egress
         */
        readonly egress?: boolean | cdk.IResolvable;
        /**
         * `CfnNetworkInsightsAnalysis.AnalysisAclRuleProperty.PortRange`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-analysisaclrule.html#cfn-ec2-networkinsightsanalysis-analysisaclrule-portrange
         */
        readonly portRange?: CfnNetworkInsightsAnalysis.PortRangeProperty | cdk.IResolvable;
        /**
         * `CfnNetworkInsightsAnalysis.AnalysisAclRuleProperty.Protocol`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-analysisaclrule.html#cfn-ec2-networkinsightsanalysis-analysisaclrule-protocol
         */
        readonly protocol?: string;
        /**
         * `CfnNetworkInsightsAnalysis.AnalysisAclRuleProperty.RuleAction`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-analysisaclrule.html#cfn-ec2-networkinsightsanalysis-analysisaclrule-ruleaction
         */
        readonly ruleAction?: string;
        /**
         * `CfnNetworkInsightsAnalysis.AnalysisAclRuleProperty.RuleNumber`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-analysisaclrule.html#cfn-ec2-networkinsightsanalysis-analysisaclrule-rulenumber
         */
        readonly ruleNumber?: number;
    }
}
/**
 * A CloudFormation `AWS::EC2::NetworkInsightsAnalysis`.
 *
 * @external
 * @cloudformationResource AWS::EC2::NetworkInsightsAnalysis
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-networkinsightsanalysis.html
 */
export declare namespace CfnNetworkInsightsAnalysis {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-analysiscomponent.html
     */
    interface AnalysisComponentProperty {
        /**
         * `CfnNetworkInsightsAnalysis.AnalysisComponentProperty.Arn`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-analysiscomponent.html#cfn-ec2-networkinsightsanalysis-analysiscomponent-arn
         */
        readonly arn?: string;
        /**
         * `CfnNetworkInsightsAnalysis.AnalysisComponentProperty.Id`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-analysiscomponent.html#cfn-ec2-networkinsightsanalysis-analysiscomponent-id
         */
        readonly id?: string;
    }
}
/**
 * A CloudFormation `AWS::EC2::NetworkInsightsAnalysis`.
 *
 * @external
 * @cloudformationResource AWS::EC2::NetworkInsightsAnalysis
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-networkinsightsanalysis.html
 */
export declare namespace CfnNetworkInsightsAnalysis {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-analysisloadbalancerlistener.html
     */
    interface AnalysisLoadBalancerListenerProperty {
        /**
         * `CfnNetworkInsightsAnalysis.AnalysisLoadBalancerListenerProperty.InstancePort`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-analysisloadbalancerlistener.html#cfn-ec2-networkinsightsanalysis-analysisloadbalancerlistener-instanceport
         */
        readonly instancePort?: number;
        /**
         * `CfnNetworkInsightsAnalysis.AnalysisLoadBalancerListenerProperty.LoadBalancerPort`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-analysisloadbalancerlistener.html#cfn-ec2-networkinsightsanalysis-analysisloadbalancerlistener-loadbalancerport
         */
        readonly loadBalancerPort?: number;
    }
}
/**
 * A CloudFormation `AWS::EC2::NetworkInsightsAnalysis`.
 *
 * @external
 * @cloudformationResource AWS::EC2::NetworkInsightsAnalysis
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-networkinsightsanalysis.html
 */
export declare namespace CfnNetworkInsightsAnalysis {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-analysisloadbalancertarget.html
     */
    interface AnalysisLoadBalancerTargetProperty {
        /**
         * `CfnNetworkInsightsAnalysis.AnalysisLoadBalancerTargetProperty.Address`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-analysisloadbalancertarget.html#cfn-ec2-networkinsightsanalysis-analysisloadbalancertarget-address
         */
        readonly address?: string;
        /**
         * `CfnNetworkInsightsAnalysis.AnalysisLoadBalancerTargetProperty.AvailabilityZone`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-analysisloadbalancertarget.html#cfn-ec2-networkinsightsanalysis-analysisloadbalancertarget-availabilityzone
         */
        readonly availabilityZone?: string;
        /**
         * `CfnNetworkInsightsAnalysis.AnalysisLoadBalancerTargetProperty.Instance`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-analysisloadbalancertarget.html#cfn-ec2-networkinsightsanalysis-analysisloadbalancertarget-instance
         */
        readonly instance?: CfnNetworkInsightsAnalysis.AnalysisComponentProperty | cdk.IResolvable;
        /**
         * `CfnNetworkInsightsAnalysis.AnalysisLoadBalancerTargetProperty.Port`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-analysisloadbalancertarget.html#cfn-ec2-networkinsightsanalysis-analysisloadbalancertarget-port
         */
        readonly port?: number;
    }
}
/**
 * A CloudFormation `AWS::EC2::NetworkInsightsAnalysis`.
 *
 * @external
 * @cloudformationResource AWS::EC2::NetworkInsightsAnalysis
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-networkinsightsanalysis.html
 */
export declare namespace CfnNetworkInsightsAnalysis {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-analysispacketheader.html
     */
    interface AnalysisPacketHeaderProperty {
        /**
         * `CfnNetworkInsightsAnalysis.AnalysisPacketHeaderProperty.DestinationAddresses`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-analysispacketheader.html#cfn-ec2-networkinsightsanalysis-analysispacketheader-destinationaddresses
         */
        readonly destinationAddresses?: string[];
        /**
         * `CfnNetworkInsightsAnalysis.AnalysisPacketHeaderProperty.DestinationPortRanges`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-analysispacketheader.html#cfn-ec2-networkinsightsanalysis-analysispacketheader-destinationportranges
         */
        readonly destinationPortRanges?: Array<CfnNetworkInsightsAnalysis.PortRangeProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnNetworkInsightsAnalysis.AnalysisPacketHeaderProperty.Protocol`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-analysispacketheader.html#cfn-ec2-networkinsightsanalysis-analysispacketheader-protocol
         */
        readonly protocol?: string;
        /**
         * `CfnNetworkInsightsAnalysis.AnalysisPacketHeaderProperty.SourceAddresses`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-analysispacketheader.html#cfn-ec2-networkinsightsanalysis-analysispacketheader-sourceaddresses
         */
        readonly sourceAddresses?: string[];
        /**
         * `CfnNetworkInsightsAnalysis.AnalysisPacketHeaderProperty.SourcePortRanges`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-analysispacketheader.html#cfn-ec2-networkinsightsanalysis-analysispacketheader-sourceportranges
         */
        readonly sourcePortRanges?: Array<CfnNetworkInsightsAnalysis.PortRangeProperty | cdk.IResolvable> | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::EC2::NetworkInsightsAnalysis`.
 *
 * @external
 * @cloudformationResource AWS::EC2::NetworkInsightsAnalysis
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-networkinsightsanalysis.html
 */
export declare namespace CfnNetworkInsightsAnalysis {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-analysisroutetableroute.html
     */
    interface AnalysisRouteTableRouteProperty {
        /**
         * `CfnNetworkInsightsAnalysis.AnalysisRouteTableRouteProperty.NatGatewayId`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-analysisroutetableroute.html#cfn-ec2-networkinsightsanalysis-analysisroutetableroute-natgatewayid
         */
        readonly natGatewayId?: string;
        /**
         * `CfnNetworkInsightsAnalysis.AnalysisRouteTableRouteProperty.NetworkInterfaceId`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-analysisroutetableroute.html#cfn-ec2-networkinsightsanalysis-analysisroutetableroute-networkinterfaceid
         */
        readonly networkInterfaceId?: string;
        /**
         * `CfnNetworkInsightsAnalysis.AnalysisRouteTableRouteProperty.Origin`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-analysisroutetableroute.html#cfn-ec2-networkinsightsanalysis-analysisroutetableroute-origin
         */
        readonly origin?: string;
        /**
         * `CfnNetworkInsightsAnalysis.AnalysisRouteTableRouteProperty.TransitGatewayId`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-analysisroutetableroute.html#cfn-ec2-networkinsightsanalysis-analysisroutetableroute-transitgatewayid
         */
        readonly transitGatewayId?: string;
        /**
         * `CfnNetworkInsightsAnalysis.AnalysisRouteTableRouteProperty.VpcPeeringConnectionId`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-analysisroutetableroute.html#cfn-ec2-networkinsightsanalysis-analysisroutetableroute-vpcpeeringconnectionid
         */
        readonly vpcPeeringConnectionId?: string;
        /**
         * `CfnNetworkInsightsAnalysis.AnalysisRouteTableRouteProperty.destinationCidr`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-analysisroutetableroute.html#cfn-ec2-networkinsightsanalysis-analysisroutetableroute-destinationcidr
         */
        readonly destinationCidr?: string;
        /**
         * `CfnNetworkInsightsAnalysis.AnalysisRouteTableRouteProperty.destinationPrefixListId`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-analysisroutetableroute.html#cfn-ec2-networkinsightsanalysis-analysisroutetableroute-destinationprefixlistid
         */
        readonly destinationPrefixListId?: string;
        /**
         * `CfnNetworkInsightsAnalysis.AnalysisRouteTableRouteProperty.egressOnlyInternetGatewayId`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-analysisroutetableroute.html#cfn-ec2-networkinsightsanalysis-analysisroutetableroute-egressonlyinternetgatewayid
         */
        readonly egressOnlyInternetGatewayId?: string;
        /**
         * `CfnNetworkInsightsAnalysis.AnalysisRouteTableRouteProperty.gatewayId`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-analysisroutetableroute.html#cfn-ec2-networkinsightsanalysis-analysisroutetableroute-gatewayid
         */
        readonly gatewayId?: string;
        /**
         * `CfnNetworkInsightsAnalysis.AnalysisRouteTableRouteProperty.instanceId`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-analysisroutetableroute.html#cfn-ec2-networkinsightsanalysis-analysisroutetableroute-instanceid
         */
        readonly instanceId?: string;
    }
}
/**
 * A CloudFormation `AWS::EC2::NetworkInsightsAnalysis`.
 *
 * @external
 * @cloudformationResource AWS::EC2::NetworkInsightsAnalysis
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-networkinsightsanalysis.html
 */
export declare namespace CfnNetworkInsightsAnalysis {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-analysissecuritygrouprule.html
     */
    interface AnalysisSecurityGroupRuleProperty {
        /**
         * `CfnNetworkInsightsAnalysis.AnalysisSecurityGroupRuleProperty.Cidr`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-analysissecuritygrouprule.html#cfn-ec2-networkinsightsanalysis-analysissecuritygrouprule-cidr
         */
        readonly cidr?: string;
        /**
         * `CfnNetworkInsightsAnalysis.AnalysisSecurityGroupRuleProperty.Direction`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-analysissecuritygrouprule.html#cfn-ec2-networkinsightsanalysis-analysissecuritygrouprule-direction
         */
        readonly direction?: string;
        /**
         * `CfnNetworkInsightsAnalysis.AnalysisSecurityGroupRuleProperty.PortRange`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-analysissecuritygrouprule.html#cfn-ec2-networkinsightsanalysis-analysissecuritygrouprule-portrange
         */
        readonly portRange?: CfnNetworkInsightsAnalysis.PortRangeProperty | cdk.IResolvable;
        /**
         * `CfnNetworkInsightsAnalysis.AnalysisSecurityGroupRuleProperty.PrefixListId`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-analysissecuritygrouprule.html#cfn-ec2-networkinsightsanalysis-analysissecuritygrouprule-prefixlistid
         */
        readonly prefixListId?: string;
        /**
         * `CfnNetworkInsightsAnalysis.AnalysisSecurityGroupRuleProperty.Protocol`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-analysissecuritygrouprule.html#cfn-ec2-networkinsightsanalysis-analysissecuritygrouprule-protocol
         */
        readonly protocol?: string;
        /**
         * `CfnNetworkInsightsAnalysis.AnalysisSecurityGroupRuleProperty.SecurityGroupId`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-analysissecuritygrouprule.html#cfn-ec2-networkinsightsanalysis-analysissecuritygrouprule-securitygroupid
         */
        readonly securityGroupId?: string;
    }
}
/**
 * A CloudFormation `AWS::EC2::NetworkInsightsAnalysis`.
 *
 * @external
 * @cloudformationResource AWS::EC2::NetworkInsightsAnalysis
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-networkinsightsanalysis.html
 */
export declare namespace CfnNetworkInsightsAnalysis {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-explanation.html
     */
    interface ExplanationProperty {
        /**
         * `CfnNetworkInsightsAnalysis.ExplanationProperty.Acl`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-explanation.html#cfn-ec2-networkinsightsanalysis-explanation-acl
         */
        readonly acl?: CfnNetworkInsightsAnalysis.AnalysisComponentProperty | cdk.IResolvable;
        /**
         * `CfnNetworkInsightsAnalysis.ExplanationProperty.AclRule`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-explanation.html#cfn-ec2-networkinsightsanalysis-explanation-aclrule
         */
        readonly aclRule?: CfnNetworkInsightsAnalysis.AnalysisAclRuleProperty | cdk.IResolvable;
        /**
         * `CfnNetworkInsightsAnalysis.ExplanationProperty.Address`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-explanation.html#cfn-ec2-networkinsightsanalysis-explanation-address
         */
        readonly address?: string;
        /**
         * `CfnNetworkInsightsAnalysis.ExplanationProperty.Addresses`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-explanation.html#cfn-ec2-networkinsightsanalysis-explanation-addresses
         */
        readonly addresses?: string[];
        /**
         * `CfnNetworkInsightsAnalysis.ExplanationProperty.AttachedTo`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-explanation.html#cfn-ec2-networkinsightsanalysis-explanation-attachedto
         */
        readonly attachedTo?: CfnNetworkInsightsAnalysis.AnalysisComponentProperty | cdk.IResolvable;
        /**
         * `CfnNetworkInsightsAnalysis.ExplanationProperty.AvailabilityZones`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-explanation.html#cfn-ec2-networkinsightsanalysis-explanation-availabilityzones
         */
        readonly availabilityZones?: string[];
        /**
         * `CfnNetworkInsightsAnalysis.ExplanationProperty.Cidrs`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-explanation.html#cfn-ec2-networkinsightsanalysis-explanation-cidrs
         */
        readonly cidrs?: string[];
        /**
         * `CfnNetworkInsightsAnalysis.ExplanationProperty.ClassicLoadBalancerListener`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-explanation.html#cfn-ec2-networkinsightsanalysis-explanation-classicloadbalancerlistener
         */
        readonly classicLoadBalancerListener?: CfnNetworkInsightsAnalysis.AnalysisLoadBalancerListenerProperty | cdk.IResolvable;
        /**
         * `CfnNetworkInsightsAnalysis.ExplanationProperty.Component`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-explanation.html#cfn-ec2-networkinsightsanalysis-explanation-component
         */
        readonly component?: CfnNetworkInsightsAnalysis.AnalysisComponentProperty | cdk.IResolvable;
        /**
         * `CfnNetworkInsightsAnalysis.ExplanationProperty.CustomerGateway`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-explanation.html#cfn-ec2-networkinsightsanalysis-explanation-customergateway
         */
        readonly customerGateway?: CfnNetworkInsightsAnalysis.AnalysisComponentProperty | cdk.IResolvable;
        /**
         * `CfnNetworkInsightsAnalysis.ExplanationProperty.Destination`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-explanation.html#cfn-ec2-networkinsightsanalysis-explanation-destination
         */
        readonly destination?: CfnNetworkInsightsAnalysis.AnalysisComponentProperty | cdk.IResolvable;
        /**
         * `CfnNetworkInsightsAnalysis.ExplanationProperty.DestinationVpc`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-explanation.html#cfn-ec2-networkinsightsanalysis-explanation-destinationvpc
         */
        readonly destinationVpc?: CfnNetworkInsightsAnalysis.AnalysisComponentProperty | cdk.IResolvable;
        /**
         * `CfnNetworkInsightsAnalysis.ExplanationProperty.Direction`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-explanation.html#cfn-ec2-networkinsightsanalysis-explanation-direction
         */
        readonly direction?: string;
        /**
         * `CfnNetworkInsightsAnalysis.ExplanationProperty.ElasticLoadBalancerListener`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-explanation.html#cfn-ec2-networkinsightsanalysis-explanation-elasticloadbalancerlistener
         */
        readonly elasticLoadBalancerListener?: CfnNetworkInsightsAnalysis.AnalysisComponentProperty | cdk.IResolvable;
        /**
         * `CfnNetworkInsightsAnalysis.ExplanationProperty.ExplanationCode`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-explanation.html#cfn-ec2-networkinsightsanalysis-explanation-explanationcode
         */
        readonly explanationCode?: string;
        /**
         * `CfnNetworkInsightsAnalysis.ExplanationProperty.IngressRouteTable`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-explanation.html#cfn-ec2-networkinsightsanalysis-explanation-ingressroutetable
         */
        readonly ingressRouteTable?: CfnNetworkInsightsAnalysis.AnalysisComponentProperty | cdk.IResolvable;
        /**
         * `CfnNetworkInsightsAnalysis.ExplanationProperty.InternetGateway`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-explanation.html#cfn-ec2-networkinsightsanalysis-explanation-internetgateway
         */
        readonly internetGateway?: CfnNetworkInsightsAnalysis.AnalysisComponentProperty | cdk.IResolvable;
        /**
         * `CfnNetworkInsightsAnalysis.ExplanationProperty.LoadBalancerArn`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-explanation.html#cfn-ec2-networkinsightsanalysis-explanation-loadbalancerarn
         */
        readonly loadBalancerArn?: string;
        /**
         * `CfnNetworkInsightsAnalysis.ExplanationProperty.LoadBalancerListenerPort`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-explanation.html#cfn-ec2-networkinsightsanalysis-explanation-loadbalancerlistenerport
         */
        readonly loadBalancerListenerPort?: number;
        /**
         * `CfnNetworkInsightsAnalysis.ExplanationProperty.LoadBalancerTarget`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-explanation.html#cfn-ec2-networkinsightsanalysis-explanation-loadbalancertarget
         */
        readonly loadBalancerTarget?: CfnNetworkInsightsAnalysis.AnalysisLoadBalancerTargetProperty | cdk.IResolvable;
        /**
         * `CfnNetworkInsightsAnalysis.ExplanationProperty.LoadBalancerTargetGroup`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-explanation.html#cfn-ec2-networkinsightsanalysis-explanation-loadbalancertargetgroup
         */
        readonly loadBalancerTargetGroup?: CfnNetworkInsightsAnalysis.AnalysisComponentProperty | cdk.IResolvable;
        /**
         * `CfnNetworkInsightsAnalysis.ExplanationProperty.LoadBalancerTargetGroups`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-explanation.html#cfn-ec2-networkinsightsanalysis-explanation-loadbalancertargetgroups
         */
        readonly loadBalancerTargetGroups?: Array<CfnNetworkInsightsAnalysis.AnalysisComponentProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnNetworkInsightsAnalysis.ExplanationProperty.LoadBalancerTargetPort`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-explanation.html#cfn-ec2-networkinsightsanalysis-explanation-loadbalancertargetport
         */
        readonly loadBalancerTargetPort?: number;
        /**
         * `CfnNetworkInsightsAnalysis.ExplanationProperty.MissingComponent`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-explanation.html#cfn-ec2-networkinsightsanalysis-explanation-missingcomponent
         */
        readonly missingComponent?: string;
        /**
         * `CfnNetworkInsightsAnalysis.ExplanationProperty.NatGateway`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-explanation.html#cfn-ec2-networkinsightsanalysis-explanation-natgateway
         */
        readonly natGateway?: CfnNetworkInsightsAnalysis.AnalysisComponentProperty | cdk.IResolvable;
        /**
         * `CfnNetworkInsightsAnalysis.ExplanationProperty.NetworkInterface`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-explanation.html#cfn-ec2-networkinsightsanalysis-explanation-networkinterface
         */
        readonly networkInterface?: CfnNetworkInsightsAnalysis.AnalysisComponentProperty | cdk.IResolvable;
        /**
         * `CfnNetworkInsightsAnalysis.ExplanationProperty.PacketField`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-explanation.html#cfn-ec2-networkinsightsanalysis-explanation-packetfield
         */
        readonly packetField?: string;
        /**
         * `CfnNetworkInsightsAnalysis.ExplanationProperty.Port`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-explanation.html#cfn-ec2-networkinsightsanalysis-explanation-port
         */
        readonly port?: number;
        /**
         * `CfnNetworkInsightsAnalysis.ExplanationProperty.PortRanges`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-explanation.html#cfn-ec2-networkinsightsanalysis-explanation-portranges
         */
        readonly portRanges?: Array<CfnNetworkInsightsAnalysis.PortRangeProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnNetworkInsightsAnalysis.ExplanationProperty.PrefixList`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-explanation.html#cfn-ec2-networkinsightsanalysis-explanation-prefixlist
         */
        readonly prefixList?: CfnNetworkInsightsAnalysis.AnalysisComponentProperty | cdk.IResolvable;
        /**
         * `CfnNetworkInsightsAnalysis.ExplanationProperty.Protocols`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-explanation.html#cfn-ec2-networkinsightsanalysis-explanation-protocols
         */
        readonly protocols?: string[];
        /**
         * `CfnNetworkInsightsAnalysis.ExplanationProperty.RouteTable`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-explanation.html#cfn-ec2-networkinsightsanalysis-explanation-routetable
         */
        readonly routeTable?: CfnNetworkInsightsAnalysis.AnalysisComponentProperty | cdk.IResolvable;
        /**
         * `CfnNetworkInsightsAnalysis.ExplanationProperty.RouteTableRoute`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-explanation.html#cfn-ec2-networkinsightsanalysis-explanation-routetableroute
         */
        readonly routeTableRoute?: CfnNetworkInsightsAnalysis.AnalysisRouteTableRouteProperty | cdk.IResolvable;
        /**
         * `CfnNetworkInsightsAnalysis.ExplanationProperty.SecurityGroup`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-explanation.html#cfn-ec2-networkinsightsanalysis-explanation-securitygroup
         */
        readonly securityGroup?: CfnNetworkInsightsAnalysis.AnalysisComponentProperty | cdk.IResolvable;
        /**
         * `CfnNetworkInsightsAnalysis.ExplanationProperty.SecurityGroupRule`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-explanation.html#cfn-ec2-networkinsightsanalysis-explanation-securitygrouprule
         */
        readonly securityGroupRule?: CfnNetworkInsightsAnalysis.AnalysisSecurityGroupRuleProperty | cdk.IResolvable;
        /**
         * `CfnNetworkInsightsAnalysis.ExplanationProperty.SecurityGroups`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-explanation.html#cfn-ec2-networkinsightsanalysis-explanation-securitygroups
         */
        readonly securityGroups?: Array<CfnNetworkInsightsAnalysis.AnalysisComponentProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnNetworkInsightsAnalysis.ExplanationProperty.SourceVpc`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-explanation.html#cfn-ec2-networkinsightsanalysis-explanation-sourcevpc
         */
        readonly sourceVpc?: CfnNetworkInsightsAnalysis.AnalysisComponentProperty | cdk.IResolvable;
        /**
         * `CfnNetworkInsightsAnalysis.ExplanationProperty.State`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-explanation.html#cfn-ec2-networkinsightsanalysis-explanation-state
         */
        readonly state?: string;
        /**
         * `CfnNetworkInsightsAnalysis.ExplanationProperty.Subnet`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-explanation.html#cfn-ec2-networkinsightsanalysis-explanation-subnet
         */
        readonly subnet?: CfnNetworkInsightsAnalysis.AnalysisComponentProperty | cdk.IResolvable;
        /**
         * `CfnNetworkInsightsAnalysis.ExplanationProperty.SubnetRouteTable`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-explanation.html#cfn-ec2-networkinsightsanalysis-explanation-subnetroutetable
         */
        readonly subnetRouteTable?: CfnNetworkInsightsAnalysis.AnalysisComponentProperty | cdk.IResolvable;
        /**
         * `CfnNetworkInsightsAnalysis.ExplanationProperty.Vpc`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-explanation.html#cfn-ec2-networkinsightsanalysis-explanation-vpc
         */
        readonly vpc?: CfnNetworkInsightsAnalysis.AnalysisComponentProperty | cdk.IResolvable;
        /**
         * `CfnNetworkInsightsAnalysis.ExplanationProperty.VpcPeeringConnection`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-explanation.html#cfn-ec2-networkinsightsanalysis-explanation-vpcpeeringconnection
         */
        readonly vpcPeeringConnection?: CfnNetworkInsightsAnalysis.AnalysisComponentProperty | cdk.IResolvable;
        /**
         * `CfnNetworkInsightsAnalysis.ExplanationProperty.VpnConnection`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-explanation.html#cfn-ec2-networkinsightsanalysis-explanation-vpnconnection
         */
        readonly vpnConnection?: CfnNetworkInsightsAnalysis.AnalysisComponentProperty | cdk.IResolvable;
        /**
         * `CfnNetworkInsightsAnalysis.ExplanationProperty.VpnGateway`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-explanation.html#cfn-ec2-networkinsightsanalysis-explanation-vpngateway
         */
        readonly vpnGateway?: CfnNetworkInsightsAnalysis.AnalysisComponentProperty | cdk.IResolvable;
        /**
         * `CfnNetworkInsightsAnalysis.ExplanationProperty.vpcEndpoint`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-explanation.html#cfn-ec2-networkinsightsanalysis-explanation-vpcendpoint
         */
        readonly vpcEndpoint?: CfnNetworkInsightsAnalysis.AnalysisComponentProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::EC2::NetworkInsightsAnalysis`.
 *
 * @external
 * @cloudformationResource AWS::EC2::NetworkInsightsAnalysis
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-networkinsightsanalysis.html
 */
export declare namespace CfnNetworkInsightsAnalysis {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-pathcomponent.html
     */
    interface PathComponentProperty {
        /**
         * `CfnNetworkInsightsAnalysis.PathComponentProperty.AclRule`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-pathcomponent.html#cfn-ec2-networkinsightsanalysis-pathcomponent-aclrule
         */
        readonly aclRule?: CfnNetworkInsightsAnalysis.AnalysisAclRuleProperty | cdk.IResolvable;
        /**
         * `CfnNetworkInsightsAnalysis.PathComponentProperty.Component`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-pathcomponent.html#cfn-ec2-networkinsightsanalysis-pathcomponent-component
         */
        readonly component?: CfnNetworkInsightsAnalysis.AnalysisComponentProperty | cdk.IResolvable;
        /**
         * `CfnNetworkInsightsAnalysis.PathComponentProperty.DestinationVpc`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-pathcomponent.html#cfn-ec2-networkinsightsanalysis-pathcomponent-destinationvpc
         */
        readonly destinationVpc?: CfnNetworkInsightsAnalysis.AnalysisComponentProperty | cdk.IResolvable;
        /**
         * `CfnNetworkInsightsAnalysis.PathComponentProperty.InboundHeader`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-pathcomponent.html#cfn-ec2-networkinsightsanalysis-pathcomponent-inboundheader
         */
        readonly inboundHeader?: CfnNetworkInsightsAnalysis.AnalysisPacketHeaderProperty | cdk.IResolvable;
        /**
         * `CfnNetworkInsightsAnalysis.PathComponentProperty.OutboundHeader`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-pathcomponent.html#cfn-ec2-networkinsightsanalysis-pathcomponent-outboundheader
         */
        readonly outboundHeader?: CfnNetworkInsightsAnalysis.AnalysisPacketHeaderProperty | cdk.IResolvable;
        /**
         * `CfnNetworkInsightsAnalysis.PathComponentProperty.RouteTableRoute`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-pathcomponent.html#cfn-ec2-networkinsightsanalysis-pathcomponent-routetableroute
         */
        readonly routeTableRoute?: CfnNetworkInsightsAnalysis.AnalysisRouteTableRouteProperty | cdk.IResolvable;
        /**
         * `CfnNetworkInsightsAnalysis.PathComponentProperty.SecurityGroupRule`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-pathcomponent.html#cfn-ec2-networkinsightsanalysis-pathcomponent-securitygrouprule
         */
        readonly securityGroupRule?: CfnNetworkInsightsAnalysis.AnalysisSecurityGroupRuleProperty | cdk.IResolvable;
        /**
         * `CfnNetworkInsightsAnalysis.PathComponentProperty.SequenceNumber`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-pathcomponent.html#cfn-ec2-networkinsightsanalysis-pathcomponent-sequencenumber
         */
        readonly sequenceNumber?: number;
        /**
         * `CfnNetworkInsightsAnalysis.PathComponentProperty.SourceVpc`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-pathcomponent.html#cfn-ec2-networkinsightsanalysis-pathcomponent-sourcevpc
         */
        readonly sourceVpc?: CfnNetworkInsightsAnalysis.AnalysisComponentProperty | cdk.IResolvable;
        /**
         * `CfnNetworkInsightsAnalysis.PathComponentProperty.Subnet`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-pathcomponent.html#cfn-ec2-networkinsightsanalysis-pathcomponent-subnet
         */
        readonly subnet?: CfnNetworkInsightsAnalysis.AnalysisComponentProperty | cdk.IResolvable;
        /**
         * `CfnNetworkInsightsAnalysis.PathComponentProperty.Vpc`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-pathcomponent.html#cfn-ec2-networkinsightsanalysis-pathcomponent-vpc
         */
        readonly vpc?: CfnNetworkInsightsAnalysis.AnalysisComponentProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::EC2::NetworkInsightsAnalysis`.
 *
 * @external
 * @cloudformationResource AWS::EC2::NetworkInsightsAnalysis
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-networkinsightsanalysis.html
 */
export declare namespace CfnNetworkInsightsAnalysis {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-portrange.html
     */
    interface PortRangeProperty {
        /**
         * `CfnNetworkInsightsAnalysis.PortRangeProperty.From`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-portrange.html#cfn-ec2-networkinsightsanalysis-portrange-from
         */
        readonly from?: number;
        /**
         * `CfnNetworkInsightsAnalysis.PortRangeProperty.To`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinsightsanalysis-portrange.html#cfn-ec2-networkinsightsanalysis-portrange-to
         */
        readonly to?: number;
    }
}
/**
 * Properties for defining a `AWS::EC2::NetworkInsightsPath`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-networkinsightspath.html
 */
export interface CfnNetworkInsightsPathProps {
    /**
     * `AWS::EC2::NetworkInsightsPath.Destination`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-networkinsightspath.html#cfn-ec2-networkinsightspath-destination
     */
    readonly destination: string;
    /**
     * `AWS::EC2::NetworkInsightsPath.Protocol`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-networkinsightspath.html#cfn-ec2-networkinsightspath-protocol
     */
    readonly protocol: string;
    /**
     * `AWS::EC2::NetworkInsightsPath.Source`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-networkinsightspath.html#cfn-ec2-networkinsightspath-source
     */
    readonly source: string;
    /**
     * `AWS::EC2::NetworkInsightsPath.DestinationIp`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-networkinsightspath.html#cfn-ec2-networkinsightspath-destinationip
     */
    readonly destinationIp?: string;
    /**
     * `AWS::EC2::NetworkInsightsPath.DestinationPort`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-networkinsightspath.html#cfn-ec2-networkinsightspath-destinationport
     */
    readonly destinationPort?: number;
    /**
     * `AWS::EC2::NetworkInsightsPath.SourceIp`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-networkinsightspath.html#cfn-ec2-networkinsightspath-sourceip
     */
    readonly sourceIp?: string;
    /**
     * `AWS::EC2::NetworkInsightsPath.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-networkinsightspath.html#cfn-ec2-networkinsightspath-tags
     */
    readonly tags?: cdk.CfnTag[];
}
/**
 * A CloudFormation `AWS::EC2::NetworkInsightsPath`.
 *
 * @external
 * @cloudformationResource AWS::EC2::NetworkInsightsPath
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-networkinsightspath.html
 */
export declare class CfnNetworkInsightsPath extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::EC2::NetworkInsightsPath";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnNetworkInsightsPath;
    /**
     * @external
     * @cloudformationAttribute CreatedDate
     */
    readonly attrCreatedDate: string;
    /**
     * @external
     * @cloudformationAttribute NetworkInsightsPathArn
     */
    readonly attrNetworkInsightsPathArn: string;
    /**
     * @external
     * @cloudformationAttribute NetworkInsightsPathId
     */
    readonly attrNetworkInsightsPathId: string;
    /**
     * `AWS::EC2::NetworkInsightsPath.Destination`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-networkinsightspath.html#cfn-ec2-networkinsightspath-destination
     */
    destination: string;
    /**
     * `AWS::EC2::NetworkInsightsPath.Protocol`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-networkinsightspath.html#cfn-ec2-networkinsightspath-protocol
     */
    protocol: string;
    /**
     * `AWS::EC2::NetworkInsightsPath.Source`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-networkinsightspath.html#cfn-ec2-networkinsightspath-source
     */
    source: string;
    /**
     * `AWS::EC2::NetworkInsightsPath.DestinationIp`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-networkinsightspath.html#cfn-ec2-networkinsightspath-destinationip
     */
    destinationIp: string | undefined;
    /**
     * `AWS::EC2::NetworkInsightsPath.DestinationPort`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-networkinsightspath.html#cfn-ec2-networkinsightspath-destinationport
     */
    destinationPort: number | undefined;
    /**
     * `AWS::EC2::NetworkInsightsPath.SourceIp`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-networkinsightspath.html#cfn-ec2-networkinsightspath-sourceip
     */
    sourceIp: string | undefined;
    /**
     * `AWS::EC2::NetworkInsightsPath.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-networkinsightspath.html#cfn-ec2-networkinsightspath-tags
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::EC2::NetworkInsightsPath`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnNetworkInsightsPathProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @external
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::EC2::NetworkInterface`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-interface.html
 */
export interface CfnNetworkInterfaceProps {
    /**
     * `AWS::EC2::NetworkInterface.SubnetId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-interface.html#cfn-awsec2networkinterface-subnetid
     */
    readonly subnetId: string;
    /**
     * `AWS::EC2::NetworkInterface.Description`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-interface.html#cfn-awsec2networkinterface-description
     */
    readonly description?: string;
    /**
     * `AWS::EC2::NetworkInterface.GroupSet`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-interface.html#cfn-awsec2networkinterface-groupset
     */
    readonly groupSet?: string[];
    /**
     * `AWS::EC2::NetworkInterface.InterfaceType`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-interface.html#cfn-ec2-networkinterface-interfacetype
     */
    readonly interfaceType?: string;
    /**
     * `AWS::EC2::NetworkInterface.Ipv6AddressCount`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-interface.html#cfn-ec2-networkinterface-ipv6addresscount
     */
    readonly ipv6AddressCount?: number;
    /**
     * `AWS::EC2::NetworkInterface.Ipv6Addresses`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-interface.html#cfn-ec2-networkinterface-ipv6addresses
     */
    readonly ipv6Addresses?: Array<CfnNetworkInterface.InstanceIpv6AddressProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::EC2::NetworkInterface.PrivateIpAddress`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-interface.html#cfn-awsec2networkinterface-privateipaddress
     */
    readonly privateIpAddress?: string;
    /**
     * `AWS::EC2::NetworkInterface.PrivateIpAddresses`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-interface.html#cfn-awsec2networkinterface-privateipaddresses
     */
    readonly privateIpAddresses?: Array<CfnNetworkInterface.PrivateIpAddressSpecificationProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::EC2::NetworkInterface.SecondaryPrivateIpAddressCount`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-interface.html#cfn-awsec2networkinterface-secondaryprivateipcount
     */
    readonly secondaryPrivateIpAddressCount?: number;
    /**
     * `AWS::EC2::NetworkInterface.SourceDestCheck`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-interface.html#cfn-awsec2networkinterface-sourcedestcheck
     */
    readonly sourceDestCheck?: boolean | cdk.IResolvable;
    /**
     * `AWS::EC2::NetworkInterface.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-interface.html#cfn-awsec2networkinterface-tags
     */
    readonly tags?: cdk.CfnTag[];
}
/**
 * A CloudFormation `AWS::EC2::NetworkInterface`.
 *
 * @external
 * @cloudformationResource AWS::EC2::NetworkInterface
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-interface.html
 */
export declare class CfnNetworkInterface extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::EC2::NetworkInterface";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnNetworkInterface;
    /**
     * @external
     * @cloudformationAttribute PrimaryPrivateIpAddress
     */
    readonly attrPrimaryPrivateIpAddress: string;
    /**
     * @external
     * @cloudformationAttribute SecondaryPrivateIpAddresses
     */
    readonly attrSecondaryPrivateIpAddresses: string[];
    /**
     * `AWS::EC2::NetworkInterface.SubnetId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-interface.html#cfn-awsec2networkinterface-subnetid
     */
    subnetId: string;
    /**
     * `AWS::EC2::NetworkInterface.Description`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-interface.html#cfn-awsec2networkinterface-description
     */
    description: string | undefined;
    /**
     * `AWS::EC2::NetworkInterface.GroupSet`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-interface.html#cfn-awsec2networkinterface-groupset
     */
    groupSet: string[] | undefined;
    /**
     * `AWS::EC2::NetworkInterface.InterfaceType`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-interface.html#cfn-ec2-networkinterface-interfacetype
     */
    interfaceType: string | undefined;
    /**
     * `AWS::EC2::NetworkInterface.Ipv6AddressCount`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-interface.html#cfn-ec2-networkinterface-ipv6addresscount
     */
    ipv6AddressCount: number | undefined;
    /**
     * `AWS::EC2::NetworkInterface.Ipv6Addresses`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-interface.html#cfn-ec2-networkinterface-ipv6addresses
     */
    ipv6Addresses: Array<CfnNetworkInterface.InstanceIpv6AddressProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * `AWS::EC2::NetworkInterface.PrivateIpAddress`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-interface.html#cfn-awsec2networkinterface-privateipaddress
     */
    privateIpAddress: string | undefined;
    /**
     * `AWS::EC2::NetworkInterface.PrivateIpAddresses`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-interface.html#cfn-awsec2networkinterface-privateipaddresses
     */
    privateIpAddresses: Array<CfnNetworkInterface.PrivateIpAddressSpecificationProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * `AWS::EC2::NetworkInterface.SecondaryPrivateIpAddressCount`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-interface.html#cfn-awsec2networkinterface-secondaryprivateipcount
     */
    secondaryPrivateIpAddressCount: number | undefined;
    /**
     * `AWS::EC2::NetworkInterface.SourceDestCheck`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-interface.html#cfn-awsec2networkinterface-sourcedestcheck
     */
    sourceDestCheck: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::EC2::NetworkInterface.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-interface.html#cfn-awsec2networkinterface-tags
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::EC2::NetworkInterface`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnNetworkInterfaceProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @external
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::EC2::NetworkInterface`.
 *
 * @external
 * @cloudformationResource AWS::EC2::NetworkInterface
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-interface.html
 */
export declare namespace CfnNetworkInterface {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinterface-instanceipv6address.html
     */
    interface InstanceIpv6AddressProperty {
        /**
         * `CfnNetworkInterface.InstanceIpv6AddressProperty.Ipv6Address`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinterface-instanceipv6address.html#cfn-ec2-networkinterface-instanceipv6address-ipv6address
         */
        readonly ipv6Address: string;
    }
}
/**
 * A CloudFormation `AWS::EC2::NetworkInterface`.
 *
 * @external
 * @cloudformationResource AWS::EC2::NetworkInterface
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-interface.html
 */
export declare namespace CfnNetworkInterface {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-interface-privateipspec.html
     */
    interface PrivateIpAddressSpecificationProperty {
        /**
         * `CfnNetworkInterface.PrivateIpAddressSpecificationProperty.Primary`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-interface-privateipspec.html#cfn-ec2-networkinterface-privateipspecification-primary
         */
        readonly primary: boolean | cdk.IResolvable;
        /**
         * `CfnNetworkInterface.PrivateIpAddressSpecificationProperty.PrivateIpAddress`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-interface-privateipspec.html#cfn-ec2-networkinterface-privateipspecification-privateipaddress
         */
        readonly privateIpAddress: string;
    }
}
/**
 * Properties for defining a `AWS::EC2::NetworkInterfaceAttachment`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-interface-attachment.html
 */
export interface CfnNetworkInterfaceAttachmentProps {
    /**
     * `AWS::EC2::NetworkInterfaceAttachment.DeviceIndex`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-interface-attachment.html#cfn-ec2-network-interface-attachment-deviceindex
     */
    readonly deviceIndex: string;
    /**
     * `AWS::EC2::NetworkInterfaceAttachment.InstanceId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-interface-attachment.html#cfn-ec2-network-interface-attachment-instanceid
     */
    readonly instanceId: string;
    /**
     * `AWS::EC2::NetworkInterfaceAttachment.NetworkInterfaceId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-interface-attachment.html#cfn-ec2-network-interface-attachment-networkinterfaceid
     */
    readonly networkInterfaceId: string;
    /**
     * `AWS::EC2::NetworkInterfaceAttachment.DeleteOnTermination`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-interface-attachment.html#cfn-ec2-network-interface-attachment-deleteonterm
     */
    readonly deleteOnTermination?: boolean | cdk.IResolvable;
}
/**
 * A CloudFormation `AWS::EC2::NetworkInterfaceAttachment`.
 *
 * @external
 * @cloudformationResource AWS::EC2::NetworkInterfaceAttachment
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-interface-attachment.html
 */
export declare class CfnNetworkInterfaceAttachment extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::EC2::NetworkInterfaceAttachment";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnNetworkInterfaceAttachment;
    /**
     * `AWS::EC2::NetworkInterfaceAttachment.DeviceIndex`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-interface-attachment.html#cfn-ec2-network-interface-attachment-deviceindex
     */
    deviceIndex: string;
    /**
     * `AWS::EC2::NetworkInterfaceAttachment.InstanceId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-interface-attachment.html#cfn-ec2-network-interface-attachment-instanceid
     */
    instanceId: string;
    /**
     * `AWS::EC2::NetworkInterfaceAttachment.NetworkInterfaceId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-interface-attachment.html#cfn-ec2-network-interface-attachment-networkinterfaceid
     */
    networkInterfaceId: string;
    /**
     * `AWS::EC2::NetworkInterfaceAttachment.DeleteOnTermination`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-interface-attachment.html#cfn-ec2-network-interface-attachment-deleteonterm
     */
    deleteOnTermination: boolean | cdk.IResolvable | undefined;
    /**
     * Create a new `AWS::EC2::NetworkInterfaceAttachment`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnNetworkInterfaceAttachmentProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @external
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::EC2::NetworkInterfacePermission`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-networkinterfacepermission.html
 */
export interface CfnNetworkInterfacePermissionProps {
    /**
     * `AWS::EC2::NetworkInterfacePermission.AwsAccountId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-networkinterfacepermission.html#cfn-ec2-networkinterfacepermission-awsaccountid
     */
    readonly awsAccountId: string;
    /**
     * `AWS::EC2::NetworkInterfacePermission.NetworkInterfaceId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-networkinterfacepermission.html#cfn-ec2-networkinterfacepermission-networkinterfaceid
     */
    readonly networkInterfaceId: string;
    /**
     * `AWS::EC2::NetworkInterfacePermission.Permission`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-networkinterfacepermission.html#cfn-ec2-networkinterfacepermission-permission
     */
    readonly permission: string;
}
/**
 * A CloudFormation `AWS::EC2::NetworkInterfacePermission`.
 *
 * @external
 * @cloudformationResource AWS::EC2::NetworkInterfacePermission
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-networkinterfacepermission.html
 */
export declare class CfnNetworkInterfacePermission extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::EC2::NetworkInterfacePermission";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnNetworkInterfacePermission;
    /**
     * `AWS::EC2::NetworkInterfacePermission.AwsAccountId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-networkinterfacepermission.html#cfn-ec2-networkinterfacepermission-awsaccountid
     */
    awsAccountId: string;
    /**
     * `AWS::EC2::NetworkInterfacePermission.NetworkInterfaceId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-networkinterfacepermission.html#cfn-ec2-networkinterfacepermission-networkinterfaceid
     */
    networkInterfaceId: string;
    /**
     * `AWS::EC2::NetworkInterfacePermission.Permission`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-networkinterfacepermission.html#cfn-ec2-networkinterfacepermission-permission
     */
    permission: string;
    /**
     * Create a new `AWS::EC2::NetworkInterfacePermission`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnNetworkInterfacePermissionProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @external
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::EC2::PlacementGroup`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-placementgroup.html
 */
export interface CfnPlacementGroupProps {
    /**
     * `AWS::EC2::PlacementGroup.Strategy`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-placementgroup.html#cfn-ec2-placementgroup-strategy
     */
    readonly strategy?: string;
}
/**
 * A CloudFormation `AWS::EC2::PlacementGroup`.
 *
 * @external
 * @cloudformationResource AWS::EC2::PlacementGroup
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-placementgroup.html
 */
export declare class CfnPlacementGroup extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::EC2::PlacementGroup";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnPlacementGroup;
    /**
     * `AWS::EC2::PlacementGroup.Strategy`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-placementgroup.html#cfn-ec2-placementgroup-strategy
     */
    strategy: string | undefined;
    /**
     * Create a new `AWS::EC2::PlacementGroup`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props?: CfnPlacementGroupProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @external
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::EC2::PrefixList`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-prefixlist.html
 */
export interface CfnPrefixListProps {
    /**
     * `AWS::EC2::PrefixList.AddressFamily`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-prefixlist.html#cfn-ec2-prefixlist-addressfamily
     */
    readonly addressFamily: string;
    /**
     * `AWS::EC2::PrefixList.MaxEntries`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-prefixlist.html#cfn-ec2-prefixlist-maxentries
     */
    readonly maxEntries: number;
    /**
     * `AWS::EC2::PrefixList.PrefixListName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-prefixlist.html#cfn-ec2-prefixlist-prefixlistname
     */
    readonly prefixListName: string;
    /**
     * `AWS::EC2::PrefixList.Entries`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-prefixlist.html#cfn-ec2-prefixlist-entries
     */
    readonly entries?: Array<CfnPrefixList.EntryProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::EC2::PrefixList.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-prefixlist.html#cfn-ec2-prefixlist-tags
     */
    readonly tags?: cdk.CfnTag[];
}
/**
 * A CloudFormation `AWS::EC2::PrefixList`.
 *
 * @external
 * @cloudformationResource AWS::EC2::PrefixList
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-prefixlist.html
 */
export declare class CfnPrefixList extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::EC2::PrefixList";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnPrefixList;
    /**
     * @external
     * @cloudformationAttribute Arn
     */
    readonly attrArn: string;
    /**
     * @external
     * @cloudformationAttribute OwnerId
     */
    readonly attrOwnerId: string;
    /**
     * @external
     * @cloudformationAttribute PrefixListId
     */
    readonly attrPrefixListId: string;
    /**
     * @external
     * @cloudformationAttribute Version
     */
    readonly attrVersion: number;
    /**
     * `AWS::EC2::PrefixList.AddressFamily`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-prefixlist.html#cfn-ec2-prefixlist-addressfamily
     */
    addressFamily: string;
    /**
     * `AWS::EC2::PrefixList.MaxEntries`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-prefixlist.html#cfn-ec2-prefixlist-maxentries
     */
    maxEntries: number;
    /**
     * `AWS::EC2::PrefixList.PrefixListName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-prefixlist.html#cfn-ec2-prefixlist-prefixlistname
     */
    prefixListName: string;
    /**
     * `AWS::EC2::PrefixList.Entries`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-prefixlist.html#cfn-ec2-prefixlist-entries
     */
    entries: Array<CfnPrefixList.EntryProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * `AWS::EC2::PrefixList.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-prefixlist.html#cfn-ec2-prefixlist-tags
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::EC2::PrefixList`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnPrefixListProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @external
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::EC2::PrefixList`.
 *
 * @external
 * @cloudformationResource AWS::EC2::PrefixList
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-prefixlist.html
 */
export declare namespace CfnPrefixList {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-prefixlist-entry.html
     */
    interface EntryProperty {
        /**
         * `CfnPrefixList.EntryProperty.Cidr`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-prefixlist-entry.html#cfn-ec2-prefixlist-entry-cidr
         */
        readonly cidr: string;
        /**
         * `CfnPrefixList.EntryProperty.Description`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-prefixlist-entry.html#cfn-ec2-prefixlist-entry-description
         */
        readonly description?: string;
    }
}
/**
 * Properties for defining a `AWS::EC2::Route`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-route.html
 */
export interface CfnRouteProps {
    /**
     * `AWS::EC2::Route.RouteTableId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-route.html#cfn-ec2-route-routetableid
     */
    readonly routeTableId: string;
    /**
     * `AWS::EC2::Route.CarrierGatewayId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-route.html#cfn-ec2-route-carriergatewayid
     */
    readonly carrierGatewayId?: string;
    /**
     * `AWS::EC2::Route.DestinationCidrBlock`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-route.html#cfn-ec2-route-destinationcidrblock
     */
    readonly destinationCidrBlock?: string;
    /**
     * `AWS::EC2::Route.DestinationIpv6CidrBlock`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-route.html#cfn-ec2-route-destinationipv6cidrblock
     */
    readonly destinationIpv6CidrBlock?: string;
    /**
     * `AWS::EC2::Route.EgressOnlyInternetGatewayId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-route.html#cfn-ec2-route-egressonlyinternetgatewayid
     */
    readonly egressOnlyInternetGatewayId?: string;
    /**
     * `AWS::EC2::Route.GatewayId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-route.html#cfn-ec2-route-gatewayid
     */
    readonly gatewayId?: string;
    /**
     * `AWS::EC2::Route.InstanceId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-route.html#cfn-ec2-route-instanceid
     */
    readonly instanceId?: string;
    /**
     * `AWS::EC2::Route.LocalGatewayId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-route.html#cfn-ec2-route-localgatewayid
     */
    readonly localGatewayId?: string;
    /**
     * `AWS::EC2::Route.NatGatewayId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-route.html#cfn-ec2-route-natgatewayid
     */
    readonly natGatewayId?: string;
    /**
     * `AWS::EC2::Route.NetworkInterfaceId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-route.html#cfn-ec2-route-networkinterfaceid
     */
    readonly networkInterfaceId?: string;
    /**
     * `AWS::EC2::Route.TransitGatewayId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-route.html#cfn-ec2-route-transitgatewayid
     */
    readonly transitGatewayId?: string;
    /**
     * `AWS::EC2::Route.VpcEndpointId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-route.html#cfn-ec2-route-vpcendpointid
     */
    readonly vpcEndpointId?: string;
    /**
     * `AWS::EC2::Route.VpcPeeringConnectionId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-route.html#cfn-ec2-route-vpcpeeringconnectionid
     */
    readonly vpcPeeringConnectionId?: string;
}
/**
 * A CloudFormation `AWS::EC2::Route`.
 *
 * @external
 * @cloudformationResource AWS::EC2::Route
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-route.html
 */
export declare class CfnRoute extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::EC2::Route";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnRoute;
    /**
     * `AWS::EC2::Route.RouteTableId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-route.html#cfn-ec2-route-routetableid
     */
    routeTableId: string;
    /**
     * `AWS::EC2::Route.CarrierGatewayId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-route.html#cfn-ec2-route-carriergatewayid
     */
    carrierGatewayId: string | undefined;
    /**
     * `AWS::EC2::Route.DestinationCidrBlock`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-route.html#cfn-ec2-route-destinationcidrblock
     */
    destinationCidrBlock: string | undefined;
    /**
     * `AWS::EC2::Route.DestinationIpv6CidrBlock`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-route.html#cfn-ec2-route-destinationipv6cidrblock
     */
    destinationIpv6CidrBlock: string | undefined;
    /**
     * `AWS::EC2::Route.EgressOnlyInternetGatewayId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-route.html#cfn-ec2-route-egressonlyinternetgatewayid
     */
    egressOnlyInternetGatewayId: string | undefined;
    /**
     * `AWS::EC2::Route.GatewayId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-route.html#cfn-ec2-route-gatewayid
     */
    gatewayId: string | undefined;
    /**
     * `AWS::EC2::Route.InstanceId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-route.html#cfn-ec2-route-instanceid
     */
    instanceId: string | undefined;
    /**
     * `AWS::EC2::Route.LocalGatewayId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-route.html#cfn-ec2-route-localgatewayid
     */
    localGatewayId: string | undefined;
    /**
     * `AWS::EC2::Route.NatGatewayId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-route.html#cfn-ec2-route-natgatewayid
     */
    natGatewayId: string | undefined;
    /**
     * `AWS::EC2::Route.NetworkInterfaceId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-route.html#cfn-ec2-route-networkinterfaceid
     */
    networkInterfaceId: string | undefined;
    /**
     * `AWS::EC2::Route.TransitGatewayId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-route.html#cfn-ec2-route-transitgatewayid
     */
    transitGatewayId: string | undefined;
    /**
     * `AWS::EC2::Route.VpcEndpointId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-route.html#cfn-ec2-route-vpcendpointid
     */
    vpcEndpointId: string | undefined;
    /**
     * `AWS::EC2::Route.VpcPeeringConnectionId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-route.html#cfn-ec2-route-vpcpeeringconnectionid
     */
    vpcPeeringConnectionId: string | undefined;
    /**
     * Create a new `AWS::EC2::Route`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnRouteProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @external
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::EC2::RouteTable`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-routetable.html
 */
export interface CfnRouteTableProps {
    /**
     * `AWS::EC2::RouteTable.VpcId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-routetable.html#cfn-ec2-routetable-vpcid
     */
    readonly vpcId: string;
    /**
     * `AWS::EC2::RouteTable.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-routetable.html#cfn-ec2-routetable-tags
     */
    readonly tags?: cdk.CfnTag[];
}
/**
 * A CloudFormation `AWS::EC2::RouteTable`.
 *
 * @external
 * @cloudformationResource AWS::EC2::RouteTable
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-routetable.html
 */
export declare class CfnRouteTable extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::EC2::RouteTable";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnRouteTable;
    /**
     * @external
     * @cloudformationAttribute RouteTableId
     */
    readonly attrRouteTableId: string;
    /**
     * `AWS::EC2::RouteTable.VpcId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-routetable.html#cfn-ec2-routetable-vpcid
     */
    vpcId: string;
    /**
     * `AWS::EC2::RouteTable.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-routetable.html#cfn-ec2-routetable-tags
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::EC2::RouteTable`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnRouteTableProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @external
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::EC2::SecurityGroup`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group.html
 */
export interface CfnSecurityGroupProps {
    /**
     * `AWS::EC2::SecurityGroup.GroupDescription`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group.html#cfn-ec2-securitygroup-groupdescription
     */
    readonly groupDescription: string;
    /**
     * `AWS::EC2::SecurityGroup.GroupName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group.html#cfn-ec2-securitygroup-groupname
     */
    readonly groupName?: string;
    /**
     * `AWS::EC2::SecurityGroup.SecurityGroupEgress`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group.html#cfn-ec2-securitygroup-securitygroupegress
     */
    readonly securityGroupEgress?: Array<CfnSecurityGroup.EgressProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::EC2::SecurityGroup.SecurityGroupIngress`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group.html#cfn-ec2-securitygroup-securitygroupingress
     */
    readonly securityGroupIngress?: Array<CfnSecurityGroup.IngressProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::EC2::SecurityGroup.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group.html#cfn-ec2-securitygroup-tags
     */
    readonly tags?: cdk.CfnTag[];
    /**
     * `AWS::EC2::SecurityGroup.VpcId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group.html#cfn-ec2-securitygroup-vpcid
     */
    readonly vpcId?: string;
}
/**
 * A CloudFormation `AWS::EC2::SecurityGroup`.
 *
 * @external
 * @cloudformationResource AWS::EC2::SecurityGroup
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group.html
 */
export declare class CfnSecurityGroup extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::EC2::SecurityGroup";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnSecurityGroup;
    /**
     * @external
     * @cloudformationAttribute GroupId
     */
    readonly attrGroupId: string;
    /**
     * @external
     * @cloudformationAttribute VpcId
     */
    readonly attrVpcId: string;
    /**
     * `AWS::EC2::SecurityGroup.GroupDescription`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group.html#cfn-ec2-securitygroup-groupdescription
     */
    groupDescription: string;
    /**
     * `AWS::EC2::SecurityGroup.GroupName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group.html#cfn-ec2-securitygroup-groupname
     */
    groupName: string | undefined;
    /**
     * `AWS::EC2::SecurityGroup.SecurityGroupEgress`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group.html#cfn-ec2-securitygroup-securitygroupegress
     */
    securityGroupEgress: Array<CfnSecurityGroup.EgressProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * `AWS::EC2::SecurityGroup.SecurityGroupIngress`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group.html#cfn-ec2-securitygroup-securitygroupingress
     */
    securityGroupIngress: Array<CfnSecurityGroup.IngressProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * `AWS::EC2::SecurityGroup.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group.html#cfn-ec2-securitygroup-tags
     */
    readonly tags: cdk.TagManager;
    /**
     * `AWS::EC2::SecurityGroup.VpcId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group.html#cfn-ec2-securitygroup-vpcid
     */
    vpcId: string | undefined;
    /**
     * Create a new `AWS::EC2::SecurityGroup`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnSecurityGroupProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @external
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::EC2::SecurityGroup`.
 *
 * @external
 * @cloudformationResource AWS::EC2::SecurityGroup
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group.html
 */
export declare namespace CfnSecurityGroup {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html
     */
    interface EgressProperty {
        /**
         * `CfnSecurityGroup.EgressProperty.CidrIp`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-cidrip
         */
        readonly cidrIp?: string;
        /**
         * `CfnSecurityGroup.EgressProperty.CidrIpv6`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-cidripv6
         */
        readonly cidrIpv6?: string;
        /**
         * `CfnSecurityGroup.EgressProperty.Description`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-description
         */
        readonly description?: string;
        /**
         * `CfnSecurityGroup.EgressProperty.DestinationPrefixListId`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-destinationprefixlistid
         */
        readonly destinationPrefixListId?: string;
        /**
         * `CfnSecurityGroup.EgressProperty.DestinationSecurityGroupId`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-destsecgroupid
         */
        readonly destinationSecurityGroupId?: string;
        /**
         * `CfnSecurityGroup.EgressProperty.FromPort`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-fromport
         */
        readonly fromPort?: number;
        /**
         * `CfnSecurityGroup.EgressProperty.IpProtocol`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-ipprotocol
         */
        readonly ipProtocol: string;
        /**
         * `CfnSecurityGroup.EgressProperty.ToPort`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-toport
         */
        readonly toPort?: number;
    }
}
/**
 * A CloudFormation `AWS::EC2::SecurityGroup`.
 *
 * @external
 * @cloudformationResource AWS::EC2::SecurityGroup
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group.html
 */
export declare namespace CfnSecurityGroup {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html
     */
    interface IngressProperty {
        /**
         * `CfnSecurityGroup.IngressProperty.CidrIp`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-cidrip
         */
        readonly cidrIp?: string;
        /**
         * `CfnSecurityGroup.IngressProperty.CidrIpv6`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-cidripv6
         */
        readonly cidrIpv6?: string;
        /**
         * `CfnSecurityGroup.IngressProperty.Description`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-description
         */
        readonly description?: string;
        /**
         * `CfnSecurityGroup.IngressProperty.FromPort`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-fromport
         */
        readonly fromPort?: number;
        /**
         * `CfnSecurityGroup.IngressProperty.IpProtocol`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-ipprotocol
         */
        readonly ipProtocol: string;
        /**
         * `CfnSecurityGroup.IngressProperty.SourcePrefixListId`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-securitygroup-ingress-sourceprefixlistid
         */
        readonly sourcePrefixListId?: string;
        /**
         * `CfnSecurityGroup.IngressProperty.SourceSecurityGroupId`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-sourcesecuritygroupid
         */
        readonly sourceSecurityGroupId?: string;
        /**
         * `CfnSecurityGroup.IngressProperty.SourceSecurityGroupName`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-sourcesecuritygroupname
         */
        readonly sourceSecurityGroupName?: string;
        /**
         * `CfnSecurityGroup.IngressProperty.SourceSecurityGroupOwnerId`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-sourcesecuritygroupownerid
         */
        readonly sourceSecurityGroupOwnerId?: string;
        /**
         * `CfnSecurityGroup.IngressProperty.ToPort`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-toport
         */
        readonly toPort?: number;
    }
}
/**
 * Properties for defining a `AWS::EC2::SecurityGroupEgress`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-security-group-egress.html
 */
export interface CfnSecurityGroupEgressProps {
    /**
     * `AWS::EC2::SecurityGroupEgress.GroupId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-security-group-egress.html#cfn-ec2-securitygroupegress-groupid
     */
    readonly groupId: string;
    /**
     * `AWS::EC2::SecurityGroupEgress.IpProtocol`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-security-group-egress.html#cfn-ec2-securitygroupegress-ipprotocol
     */
    readonly ipProtocol: string;
    /**
     * `AWS::EC2::SecurityGroupEgress.CidrIp`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-security-group-egress.html#cfn-ec2-securitygroupegress-cidrip
     */
    readonly cidrIp?: string;
    /**
     * `AWS::EC2::SecurityGroupEgress.CidrIpv6`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-security-group-egress.html#cfn-ec2-securitygroupegress-cidripv6
     */
    readonly cidrIpv6?: string;
    /**
     * `AWS::EC2::SecurityGroupEgress.Description`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-security-group-egress.html#cfn-ec2-securitygroupegress-description
     */
    readonly description?: string;
    /**
     * `AWS::EC2::SecurityGroupEgress.DestinationPrefixListId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-security-group-egress.html#cfn-ec2-securitygroupegress-destinationprefixlistid
     */
    readonly destinationPrefixListId?: string;
    /**
     * `AWS::EC2::SecurityGroupEgress.DestinationSecurityGroupId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-security-group-egress.html#cfn-ec2-securitygroupegress-destinationsecuritygroupid
     */
    readonly destinationSecurityGroupId?: string;
    /**
     * `AWS::EC2::SecurityGroupEgress.FromPort`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-security-group-egress.html#cfn-ec2-securitygroupegress-fromport
     */
    readonly fromPort?: number;
    /**
     * `AWS::EC2::SecurityGroupEgress.ToPort`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-security-group-egress.html#cfn-ec2-securitygroupegress-toport
     */
    readonly toPort?: number;
}
/**
 * A CloudFormation `AWS::EC2::SecurityGroupEgress`.
 *
 * @external
 * @cloudformationResource AWS::EC2::SecurityGroupEgress
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-security-group-egress.html
 */
export declare class CfnSecurityGroupEgress extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::EC2::SecurityGroupEgress";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnSecurityGroupEgress;
    /**
     * `AWS::EC2::SecurityGroupEgress.GroupId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-security-group-egress.html#cfn-ec2-securitygroupegress-groupid
     */
    groupId: string;
    /**
     * `AWS::EC2::SecurityGroupEgress.IpProtocol`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-security-group-egress.html#cfn-ec2-securitygroupegress-ipprotocol
     */
    ipProtocol: string;
    /**
     * `AWS::EC2::SecurityGroupEgress.CidrIp`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-security-group-egress.html#cfn-ec2-securitygroupegress-cidrip
     */
    cidrIp: string | undefined;
    /**
     * `AWS::EC2::SecurityGroupEgress.CidrIpv6`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-security-group-egress.html#cfn-ec2-securitygroupegress-cidripv6
     */
    cidrIpv6: string | undefined;
    /**
     * `AWS::EC2::SecurityGroupEgress.Description`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-security-group-egress.html#cfn-ec2-securitygroupegress-description
     */
    description: string | undefined;
    /**
     * `AWS::EC2::SecurityGroupEgress.DestinationPrefixListId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-security-group-egress.html#cfn-ec2-securitygroupegress-destinationprefixlistid
     */
    destinationPrefixListId: string | undefined;
    /**
     * `AWS::EC2::SecurityGroupEgress.DestinationSecurityGroupId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-security-group-egress.html#cfn-ec2-securitygroupegress-destinationsecuritygroupid
     */
    destinationSecurityGroupId: string | undefined;
    /**
     * `AWS::EC2::SecurityGroupEgress.FromPort`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-security-group-egress.html#cfn-ec2-securitygroupegress-fromport
     */
    fromPort: number | undefined;
    /**
     * `AWS::EC2::SecurityGroupEgress.ToPort`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-security-group-egress.html#cfn-ec2-securitygroupegress-toport
     */
    toPort: number | undefined;
    /**
     * Create a new `AWS::EC2::SecurityGroupEgress`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnSecurityGroupEgressProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @external
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::EC2::SecurityGroupIngress`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-ingress.html
 */
export interface CfnSecurityGroupIngressProps {
    /**
     * `AWS::EC2::SecurityGroupIngress.IpProtocol`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-ingress.html#cfn-ec2-security-group-ingress-ipprotocol
     */
    readonly ipProtocol: string;
    /**
     * `AWS::EC2::SecurityGroupIngress.CidrIp`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-ingress.html#cfn-ec2-security-group-ingress-cidrip
     */
    readonly cidrIp?: string;
    /**
     * `AWS::EC2::SecurityGroupIngress.CidrIpv6`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-ingress.html#cfn-ec2-security-group-ingress-cidripv6
     */
    readonly cidrIpv6?: string;
    /**
     * `AWS::EC2::SecurityGroupIngress.Description`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-ingress.html#cfn-ec2-security-group-ingress-description
     */
    readonly description?: string;
    /**
     * `AWS::EC2::SecurityGroupIngress.FromPort`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-ingress.html#cfn-ec2-security-group-ingress-fromport
     */
    readonly fromPort?: number;
    /**
     * `AWS::EC2::SecurityGroupIngress.GroupId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-ingress.html#cfn-ec2-security-group-ingress-groupid
     */
    readonly groupId?: string;
    /**
     * `AWS::EC2::SecurityGroupIngress.GroupName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-ingress.html#cfn-ec2-security-group-ingress-groupname
     */
    readonly groupName?: string;
    /**
     * `AWS::EC2::SecurityGroupIngress.SourcePrefixListId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-ingress.html#cfn-ec2-securitygroupingress-sourceprefixlistid
     */
    readonly sourcePrefixListId?: string;
    /**
     * `AWS::EC2::SecurityGroupIngress.SourceSecurityGroupId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-ingress.html#cfn-ec2-security-group-ingress-sourcesecuritygroupid
     */
    readonly sourceSecurityGroupId?: string;
    /**
     * `AWS::EC2::SecurityGroupIngress.SourceSecurityGroupName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-ingress.html#cfn-ec2-security-group-ingress-sourcesecuritygroupname
     */
    readonly sourceSecurityGroupName?: string;
    /**
     * `AWS::EC2::SecurityGroupIngress.SourceSecurityGroupOwnerId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-ingress.html#cfn-ec2-security-group-ingress-sourcesecuritygroupownerid
     */
    readonly sourceSecurityGroupOwnerId?: string;
    /**
     * `AWS::EC2::SecurityGroupIngress.ToPort`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-ingress.html#cfn-ec2-security-group-ingress-toport
     */
    readonly toPort?: number;
}
/**
 * A CloudFormation `AWS::EC2::SecurityGroupIngress`.
 *
 * @external
 * @cloudformationResource AWS::EC2::SecurityGroupIngress
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-ingress.html
 */
export declare class CfnSecurityGroupIngress extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::EC2::SecurityGroupIngress";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnSecurityGroupIngress;
    /**
     * `AWS::EC2::SecurityGroupIngress.IpProtocol`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-ingress.html#cfn-ec2-security-group-ingress-ipprotocol
     */
    ipProtocol: string;
    /**
     * `AWS::EC2::SecurityGroupIngress.CidrIp`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-ingress.html#cfn-ec2-security-group-ingress-cidrip
     */
    cidrIp: string | undefined;
    /**
     * `AWS::EC2::SecurityGroupIngress.CidrIpv6`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-ingress.html#cfn-ec2-security-group-ingress-cidripv6
     */
    cidrIpv6: string | undefined;
    /**
     * `AWS::EC2::SecurityGroupIngress.Description`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-ingress.html#cfn-ec2-security-group-ingress-description
     */
    description: string | undefined;
    /**
     * `AWS::EC2::SecurityGroupIngress.FromPort`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-ingress.html#cfn-ec2-security-group-ingress-fromport
     */
    fromPort: number | undefined;
    /**
     * `AWS::EC2::SecurityGroupIngress.GroupId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-ingress.html#cfn-ec2-security-group-ingress-groupid
     */
    groupId: string | undefined;
    /**
     * `AWS::EC2::SecurityGroupIngress.GroupName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-ingress.html#cfn-ec2-security-group-ingress-groupname
     */
    groupName: string | undefined;
    /**
     * `AWS::EC2::SecurityGroupIngress.SourcePrefixListId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-ingress.html#cfn-ec2-securitygroupingress-sourceprefixlistid
     */
    sourcePrefixListId: string | undefined;
    /**
     * `AWS::EC2::SecurityGroupIngress.SourceSecurityGroupId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-ingress.html#cfn-ec2-security-group-ingress-sourcesecuritygroupid
     */
    sourceSecurityGroupId: string | undefined;
    /**
     * `AWS::EC2::SecurityGroupIngress.SourceSecurityGroupName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-ingress.html#cfn-ec2-security-group-ingress-sourcesecuritygroupname
     */
    sourceSecurityGroupName: string | undefined;
    /**
     * `AWS::EC2::SecurityGroupIngress.SourceSecurityGroupOwnerId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-ingress.html#cfn-ec2-security-group-ingress-sourcesecuritygroupownerid
     */
    sourceSecurityGroupOwnerId: string | undefined;
    /**
     * `AWS::EC2::SecurityGroupIngress.ToPort`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-ingress.html#cfn-ec2-security-group-ingress-toport
     */
    toPort: number | undefined;
    /**
     * Create a new `AWS::EC2::SecurityGroupIngress`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnSecurityGroupIngressProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @external
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::EC2::SpotFleet`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-spotfleet.html
 */
export interface CfnSpotFleetProps {
    /**
     * `AWS::EC2::SpotFleet.SpotFleetRequestConfigData`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-spotfleet.html#cfn-ec2-spotfleet-spotfleetrequestconfigdata
     */
    readonly spotFleetRequestConfigData: CfnSpotFleet.SpotFleetRequestConfigDataProperty | cdk.IResolvable;
}
/**
 * A CloudFormation `AWS::EC2::SpotFleet`.
 *
 * @external
 * @cloudformationResource AWS::EC2::SpotFleet
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-spotfleet.html
 */
export declare class CfnSpotFleet extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::EC2::SpotFleet";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnSpotFleet;
    /**
     * @external
     * @cloudformationAttribute Id
     */
    readonly attrId: string;
    /**
     * `AWS::EC2::SpotFleet.SpotFleetRequestConfigData`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-spotfleet.html#cfn-ec2-spotfleet-spotfleetrequestconfigdata
     */
    spotFleetRequestConfigData: CfnSpotFleet.SpotFleetRequestConfigDataProperty | cdk.IResolvable;
    /**
     * Create a new `AWS::EC2::SpotFleet`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnSpotFleetProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @external
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::EC2::SpotFleet`.
 *
 * @external
 * @cloudformationResource AWS::EC2::SpotFleet
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-spotfleet.html
 */
export declare namespace CfnSpotFleet {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-acceleratorcountrequest.html
     */
    interface AcceleratorCountRequestProperty {
        /**
         * `CfnSpotFleet.AcceleratorCountRequestProperty.Max`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-acceleratorcountrequest.html#cfn-ec2-spotfleet-acceleratorcountrequest-max
         */
        readonly max?: number;
        /**
         * `CfnSpotFleet.AcceleratorCountRequestProperty.Min`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-acceleratorcountrequest.html#cfn-ec2-spotfleet-acceleratorcountrequest-min
         */
        readonly min?: number;
    }
}
/**
 * A CloudFormation `AWS::EC2::SpotFleet`.
 *
 * @external
 * @cloudformationResource AWS::EC2::SpotFleet
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-spotfleet.html
 */
export declare namespace CfnSpotFleet {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-acceleratortotalmemorymibrequest.html
     */
    interface AcceleratorTotalMemoryMiBRequestProperty {
        /**
         * `CfnSpotFleet.AcceleratorTotalMemoryMiBRequestProperty.Max`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-acceleratortotalmemorymibrequest.html#cfn-ec2-spotfleet-acceleratortotalmemorymibrequest-max
         */
        readonly max?: number;
        /**
         * `CfnSpotFleet.AcceleratorTotalMemoryMiBRequestProperty.Min`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-acceleratortotalmemorymibrequest.html#cfn-ec2-spotfleet-acceleratortotalmemorymibrequest-min
         */
        readonly min?: number;
    }
}
/**
 * A CloudFormation `AWS::EC2::SpotFleet`.
 *
 * @external
 * @cloudformationResource AWS::EC2::SpotFleet
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-spotfleet.html
 */
export declare namespace CfnSpotFleet {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-baselineebsbandwidthmbpsrequest.html
     */
    interface BaselineEbsBandwidthMbpsRequestProperty {
        /**
         * `CfnSpotFleet.BaselineEbsBandwidthMbpsRequestProperty.Max`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-baselineebsbandwidthmbpsrequest.html#cfn-ec2-spotfleet-baselineebsbandwidthmbpsrequest-max
         */
        readonly max?: number;
        /**
         * `CfnSpotFleet.BaselineEbsBandwidthMbpsRequestProperty.Min`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-baselineebsbandwidthmbpsrequest.html#cfn-ec2-spotfleet-baselineebsbandwidthmbpsrequest-min
         */
        readonly min?: number;
    }
}
/**
 * A CloudFormation `AWS::EC2::SpotFleet`.
 *
 * @external
 * @cloudformationResource AWS::EC2::SpotFleet
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-spotfleet.html
 */
export declare namespace CfnSpotFleet {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-blockdevicemapping.html
     */
    interface BlockDeviceMappingProperty {
        /**
         * `CfnSpotFleet.BlockDeviceMappingProperty.DeviceName`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-blockdevicemapping.html#cfn-ec2-spotfleet-blockdevicemapping-devicename
         */
        readonly deviceName: string;
        /**
         * `CfnSpotFleet.BlockDeviceMappingProperty.Ebs`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-blockdevicemapping.html#cfn-ec2-spotfleet-blockdevicemapping-ebs
         */
        readonly ebs?: CfnSpotFleet.EbsBlockDeviceProperty | cdk.IResolvable;
        /**
         * `CfnSpotFleet.BlockDeviceMappingProperty.NoDevice`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-blockdevicemapping.html#cfn-ec2-spotfleet-blockdevicemapping-nodevice
         */
        readonly noDevice?: string;
        /**
         * `CfnSpotFleet.BlockDeviceMappingProperty.VirtualName`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-blockdevicemapping.html#cfn-ec2-spotfleet-blockdevicemapping-virtualname
         */
        readonly virtualName?: string;
    }
}
/**
 * A CloudFormation `AWS::EC2::SpotFleet`.
 *
 * @external
 * @cloudformationResource AWS::EC2::SpotFleet
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-spotfleet.html
 */
export declare namespace CfnSpotFleet {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-classicloadbalancer.html
     */
    interface ClassicLoadBalancerProperty {
        /**
         * `CfnSpotFleet.ClassicLoadBalancerProperty.Name`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-classicloadbalancer.html#cfn-ec2-spotfleet-classicloadbalancer-name
         */
        readonly name: string;
    }
}
/**
 * A CloudFormation `AWS::EC2::SpotFleet`.
 *
 * @external
 * @cloudformationResource AWS::EC2::SpotFleet
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-spotfleet.html
 */
export declare namespace CfnSpotFleet {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-classicloadbalancersconfig.html
     */
    interface ClassicLoadBalancersConfigProperty {
        /**
         * `CfnSpotFleet.ClassicLoadBalancersConfigProperty.ClassicLoadBalancers`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-classicloadbalancersconfig.html#cfn-ec2-spotfleet-classicloadbalancersconfig-classicloadbalancers
         */
        readonly classicLoadBalancers: Array<CfnSpotFleet.ClassicLoadBalancerProperty | cdk.IResolvable> | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::EC2::SpotFleet`.
 *
 * @external
 * @cloudformationResource AWS::EC2::SpotFleet
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-spotfleet.html
 */
export declare namespace CfnSpotFleet {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-ebsblockdevice.html
     */
    interface EbsBlockDeviceProperty {
        /**
         * `CfnSpotFleet.EbsBlockDeviceProperty.DeleteOnTermination`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-ebsblockdevice.html#cfn-ec2-spotfleet-ebsblockdevice-deleteontermination
         */
        readonly deleteOnTermination?: boolean | cdk.IResolvable;
        /**
         * `CfnSpotFleet.EbsBlockDeviceProperty.Encrypted`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-ebsblockdevice.html#cfn-ec2-spotfleet-ebsblockdevice-encrypted
         */
        readonly encrypted?: boolean | cdk.IResolvable;
        /**
         * `CfnSpotFleet.EbsBlockDeviceProperty.Iops`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-ebsblockdevice.html#cfn-ec2-spotfleet-ebsblockdevice-iops
         */
        readonly iops?: number;
        /**
         * `CfnSpotFleet.EbsBlockDeviceProperty.SnapshotId`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-ebsblockdevice.html#cfn-ec2-spotfleet-ebsblockdevice-snapshotid
         */
        readonly snapshotId?: string;
        /**
         * `CfnSpotFleet.EbsBlockDeviceProperty.VolumeSize`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-ebsblockdevice.html#cfn-ec2-spotfleet-ebsblockdevice-volumesize
         */
        readonly volumeSize?: number;
        /**
         * `CfnSpotFleet.EbsBlockDeviceProperty.VolumeType`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-ebsblockdevice.html#cfn-ec2-spotfleet-ebsblockdevice-volumetype
         */
        readonly volumeType?: string;
    }
}
/**
 * A CloudFormation `AWS::EC2::SpotFleet`.
 *
 * @external
 * @cloudformationResource AWS::EC2::SpotFleet
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-spotfleet.html
 */
export declare namespace CfnSpotFleet {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-fleetlaunchtemplatespecification.html
     */
    interface FleetLaunchTemplateSpecificationProperty {
        /**
         * `CfnSpotFleet.FleetLaunchTemplateSpecificationProperty.LaunchTemplateId`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-fleetlaunchtemplatespecification.html#cfn-ec2-spotfleet-fleetlaunchtemplatespecification-launchtemplateid
         */
        readonly launchTemplateId?: string;
        /**
         * `CfnSpotFleet.FleetLaunchTemplateSpecificationProperty.LaunchTemplateName`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-fleetlaunchtemplatespecification.html#cfn-ec2-spotfleet-fleetlaunchtemplatespecification-launchtemplatename
         */
        readonly launchTemplateName?: string;
        /**
         * `CfnSpotFleet.FleetLaunchTemplateSpecificationProperty.Version`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-fleetlaunchtemplatespecification.html#cfn-ec2-spotfleet-fleetlaunchtemplatespecification-version
         */
        readonly version: string;
    }
}
/**
 * A CloudFormation `AWS::EC2::SpotFleet`.
 *
 * @external
 * @cloudformationResource AWS::EC2::SpotFleet
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-spotfleet.html
 */
export declare namespace CfnSpotFleet {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-groupidentifier.html
     */
    interface GroupIdentifierProperty {
        /**
         * `CfnSpotFleet.GroupIdentifierProperty.GroupId`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-groupidentifier.html#cfn-ec2-spotfleet-groupidentifier-groupid
         */
        readonly groupId: string;
    }
}
/**
 * A CloudFormation `AWS::EC2::SpotFleet`.
 *
 * @external
 * @cloudformationResource AWS::EC2::SpotFleet
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-spotfleet.html
 */
export declare namespace CfnSpotFleet {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-iaminstanceprofilespecification.html
     */
    interface IamInstanceProfileSpecificationProperty {
        /**
         * `CfnSpotFleet.IamInstanceProfileSpecificationProperty.Arn`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-iaminstanceprofilespecification.html#cfn-ec2-spotfleet-iaminstanceprofilespecification-arn
         */
        readonly arn?: string;
    }
}
/**
 * A CloudFormation `AWS::EC2::SpotFleet`.
 *
 * @external
 * @cloudformationResource AWS::EC2::SpotFleet
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-spotfleet.html
 */
export declare namespace CfnSpotFleet {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-instanceipv6address.html
     */
    interface InstanceIpv6AddressProperty {
        /**
         * `CfnSpotFleet.InstanceIpv6AddressProperty.Ipv6Address`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-instanceipv6address.html#cfn-ec2-spotfleet-instanceipv6address-ipv6address
         */
        readonly ipv6Address: string;
    }
}
/**
 * A CloudFormation `AWS::EC2::SpotFleet`.
 *
 * @external
 * @cloudformationResource AWS::EC2::SpotFleet
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-spotfleet.html
 */
export declare namespace CfnSpotFleet {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-instancenetworkinterfacespecification.html
     */
    interface InstanceNetworkInterfaceSpecificationProperty {
        /**
         * `CfnSpotFleet.InstanceNetworkInterfaceSpecificationProperty.AssociatePublicIpAddress`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-instancenetworkinterfacespecification.html#cfn-ec2-spotfleet-instancenetworkinterfacespecification-associatepublicipaddress
         */
        readonly associatePublicIpAddress?: boolean | cdk.IResolvable;
        /**
         * `CfnSpotFleet.InstanceNetworkInterfaceSpecificationProperty.DeleteOnTermination`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-instancenetworkinterfacespecification.html#cfn-ec2-spotfleet-instancenetworkinterfacespecification-deleteontermination
         */
        readonly deleteOnTermination?: boolean | cdk.IResolvable;
        /**
         * `CfnSpotFleet.InstanceNetworkInterfaceSpecificationProperty.Description`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-instancenetworkinterfacespecification.html#cfn-ec2-spotfleet-instancenetworkinterfacespecification-description
         */
        readonly description?: string;
        /**
         * `CfnSpotFleet.InstanceNetworkInterfaceSpecificationProperty.DeviceIndex`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-instancenetworkinterfacespecification.html#cfn-ec2-spotfleet-instancenetworkinterfacespecification-deviceindex
         */
        readonly deviceIndex?: number;
        /**
         * `CfnSpotFleet.InstanceNetworkInterfaceSpecificationProperty.Groups`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-instancenetworkinterfacespecification.html#cfn-ec2-spotfleet-instancenetworkinterfacespecification-groups
         */
        readonly groups?: string[];
        /**
         * `CfnSpotFleet.InstanceNetworkInterfaceSpecificationProperty.Ipv6AddressCount`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-instancenetworkinterfacespecification.html#cfn-ec2-spotfleet-instancenetworkinterfacespecification-ipv6addresscount
         */
        readonly ipv6AddressCount?: number;
        /**
         * `CfnSpotFleet.InstanceNetworkInterfaceSpecificationProperty.Ipv6Addresses`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-instancenetworkinterfacespecification.html#cfn-ec2-spotfleet-instancenetworkinterfacespecification-ipv6addresses
         */
        readonly ipv6Addresses?: Array<CfnSpotFleet.InstanceIpv6AddressProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnSpotFleet.InstanceNetworkInterfaceSpecificationProperty.NetworkInterfaceId`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-instancenetworkinterfacespecification.html#cfn-ec2-spotfleet-instancenetworkinterfacespecification-networkinterfaceid
         */
        readonly networkInterfaceId?: string;
        /**
         * `CfnSpotFleet.InstanceNetworkInterfaceSpecificationProperty.PrivateIpAddresses`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-instancenetworkinterfacespecification.html#cfn-ec2-spotfleet-instancenetworkinterfacespecification-privateipaddresses
         */
        readonly privateIpAddresses?: Array<CfnSpotFleet.PrivateIpAddressSpecificationProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnSpotFleet.InstanceNetworkInterfaceSpecificationProperty.SecondaryPrivateIpAddressCount`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-instancenetworkinterfacespecification.html#cfn-ec2-spotfleet-instancenetworkinterfacespecification-secondaryprivateipaddresscount
         */
        readonly secondaryPrivateIpAddressCount?: number;
        /**
         * `CfnSpotFleet.InstanceNetworkInterfaceSpecificationProperty.SubnetId`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-instancenetworkinterfacespecification.html#cfn-ec2-spotfleet-instancenetworkinterfacespecification-subnetid
         */
        readonly subnetId?: string;
    }
}
/**
 * A CloudFormation `AWS::EC2::SpotFleet`.
 *
 * @external
 * @cloudformationResource AWS::EC2::SpotFleet
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-spotfleet.html
 */
export declare namespace CfnSpotFleet {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-instancerequirementsrequest.html
     */
    interface InstanceRequirementsRequestProperty {
        /**
         * `CfnSpotFleet.InstanceRequirementsRequestProperty.AcceleratorCount`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-instancerequirementsrequest.html#cfn-ec2-spotfleet-instancerequirementsrequest-acceleratorcount
         */
        readonly acceleratorCount?: CfnSpotFleet.AcceleratorCountRequestProperty | cdk.IResolvable;
        /**
         * `CfnSpotFleet.InstanceRequirementsRequestProperty.AcceleratorManufacturers`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-instancerequirementsrequest.html#cfn-ec2-spotfleet-instancerequirementsrequest-acceleratormanufacturers
         */
        readonly acceleratorManufacturers?: string[];
        /**
         * `CfnSpotFleet.InstanceRequirementsRequestProperty.AcceleratorNames`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-instancerequirementsrequest.html#cfn-ec2-spotfleet-instancerequirementsrequest-acceleratornames
         */
        readonly acceleratorNames?: string[];
        /**
         * `CfnSpotFleet.InstanceRequirementsRequestProperty.AcceleratorTotalMemoryMiB`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-instancerequirementsrequest.html#cfn-ec2-spotfleet-instancerequirementsrequest-acceleratortotalmemorymib
         */
        readonly acceleratorTotalMemoryMiB?: CfnSpotFleet.AcceleratorTotalMemoryMiBRequestProperty | cdk.IResolvable;
        /**
         * `CfnSpotFleet.InstanceRequirementsRequestProperty.AcceleratorTypes`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-instancerequirementsrequest.html#cfn-ec2-spotfleet-instancerequirementsrequest-acceleratortypes
         */
        readonly acceleratorTypes?: string[];
        /**
         * `CfnSpotFleet.InstanceRequirementsRequestProperty.BareMetal`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-instancerequirementsrequest.html#cfn-ec2-spotfleet-instancerequirementsrequest-baremetal
         */
        readonly bareMetal?: string;
        /**
         * `CfnSpotFleet.InstanceRequirementsRequestProperty.BaselineEbsBandwidthMbps`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-instancerequirementsrequest.html#cfn-ec2-spotfleet-instancerequirementsrequest-baselineebsbandwidthmbps
         */
        readonly baselineEbsBandwidthMbps?: CfnSpotFleet.BaselineEbsBandwidthMbpsRequestProperty | cdk.IResolvable;
        /**
         * `CfnSpotFleet.InstanceRequirementsRequestProperty.BurstablePerformance`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-instancerequirementsrequest.html#cfn-ec2-spotfleet-instancerequirementsrequest-burstableperformance
         */
        readonly burstablePerformance?: string;
        /**
         * `CfnSpotFleet.InstanceRequirementsRequestProperty.CpuManufacturers`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-instancerequirementsrequest.html#cfn-ec2-spotfleet-instancerequirementsrequest-cpumanufacturers
         */
        readonly cpuManufacturers?: string[];
        /**
         * `CfnSpotFleet.InstanceRequirementsRequestProperty.ExcludedInstanceTypes`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-instancerequirementsrequest.html#cfn-ec2-spotfleet-instancerequirementsrequest-excludedinstancetypes
         */
        readonly excludedInstanceTypes?: string[];
        /**
         * `CfnSpotFleet.InstanceRequirementsRequestProperty.InstanceGenerations`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-instancerequirementsrequest.html#cfn-ec2-spotfleet-instancerequirementsrequest-instancegenerations
         */
        readonly instanceGenerations?: string[];
        /**
         * `CfnSpotFleet.InstanceRequirementsRequestProperty.LocalStorage`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-instancerequirementsrequest.html#cfn-ec2-spotfleet-instancerequirementsrequest-localstorage
         */
        readonly localStorage?: string;
        /**
         * `CfnSpotFleet.InstanceRequirementsRequestProperty.LocalStorageTypes`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-instancerequirementsrequest.html#cfn-ec2-spotfleet-instancerequirementsrequest-localstoragetypes
         */
        readonly localStorageTypes?: string[];
        /**
         * `CfnSpotFleet.InstanceRequirementsRequestProperty.MemoryGiBPerVCpu`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-instancerequirementsrequest.html#cfn-ec2-spotfleet-instancerequirementsrequest-memorygibpervcpu
         */
        readonly memoryGiBPerVCpu?: CfnSpotFleet.MemoryGiBPerVCpuRequestProperty | cdk.IResolvable;
        /**
         * `CfnSpotFleet.InstanceRequirementsRequestProperty.MemoryMiB`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-instancerequirementsrequest.html#cfn-ec2-spotfleet-instancerequirementsrequest-memorymib
         */
        readonly memoryMiB?: CfnSpotFleet.MemoryMiBRequestProperty | cdk.IResolvable;
        /**
         * `CfnSpotFleet.InstanceRequirementsRequestProperty.NetworkInterfaceCount`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-instancerequirementsrequest.html#cfn-ec2-spotfleet-instancerequirementsrequest-networkinterfacecount
         */
        readonly networkInterfaceCount?: CfnSpotFleet.NetworkInterfaceCountRequestProperty | cdk.IResolvable;
        /**
         * `CfnSpotFleet.InstanceRequirementsRequestProperty.OnDemandMaxPricePercentageOverLowestPrice`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-instancerequirementsrequest.html#cfn-ec2-spotfleet-instancerequirementsrequest-ondemandmaxpricepercentageoverlowestprice
         */
        readonly onDemandMaxPricePercentageOverLowestPrice?: number;
        /**
         * `CfnSpotFleet.InstanceRequirementsRequestProperty.RequireHibernateSupport`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-instancerequirementsrequest.html#cfn-ec2-spotfleet-instancerequirementsrequest-requirehibernatesupport
         */
        readonly requireHibernateSupport?: boolean | cdk.IResolvable;
        /**
         * `CfnSpotFleet.InstanceRequirementsRequestProperty.SpotMaxPricePercentageOverLowestPrice`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-instancerequirementsrequest.html#cfn-ec2-spotfleet-instancerequirementsrequest-spotmaxpricepercentageoverlowestprice
         */
        readonly spotMaxPricePercentageOverLowestPrice?: number;
        /**
         * `CfnSpotFleet.InstanceRequirementsRequestProperty.TotalLocalStorageGB`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-instancerequirementsrequest.html#cfn-ec2-spotfleet-instancerequirementsrequest-totallocalstoragegb
         */
        readonly totalLocalStorageGb?: CfnSpotFleet.TotalLocalStorageGBRequestProperty | cdk.IResolvable;
        /**
         * `CfnSpotFleet.InstanceRequirementsRequestProperty.VCpuCount`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-instancerequirementsrequest.html#cfn-ec2-spotfleet-instancerequirementsrequest-vcpucount
         */
        readonly vCpuCount?: CfnSpotFleet.VCpuCountRangeRequestProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::EC2::SpotFleet`.
 *
 * @external
 * @cloudformationResource AWS::EC2::SpotFleet
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-spotfleet.html
 */
export declare namespace CfnSpotFleet {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-launchtemplateconfig.html
     */
    interface LaunchTemplateConfigProperty {
        /**
         * `CfnSpotFleet.LaunchTemplateConfigProperty.LaunchTemplateSpecification`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-launchtemplateconfig.html#cfn-ec2-spotfleet-launchtemplateconfig-launchtemplatespecification
         */
        readonly launchTemplateSpecification?: CfnSpotFleet.FleetLaunchTemplateSpecificationProperty | cdk.IResolvable;
        /**
         * `CfnSpotFleet.LaunchTemplateConfigProperty.Overrides`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-launchtemplateconfig.html#cfn-ec2-spotfleet-launchtemplateconfig-overrides
         */
        readonly overrides?: Array<CfnSpotFleet.LaunchTemplateOverridesProperty | cdk.IResolvable> | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::EC2::SpotFleet`.
 *
 * @external
 * @cloudformationResource AWS::EC2::SpotFleet
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-spotfleet.html
 */
export declare namespace CfnSpotFleet {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-launchtemplateoverrides.html
     */
    interface LaunchTemplateOverridesProperty {
        /**
         * `CfnSpotFleet.LaunchTemplateOverridesProperty.AvailabilityZone`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-launchtemplateoverrides.html#cfn-ec2-spotfleet-launchtemplateoverrides-availabilityzone
         */
        readonly availabilityZone?: string;
        /**
         * `CfnSpotFleet.LaunchTemplateOverridesProperty.InstanceRequirements`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-launchtemplateoverrides.html#cfn-ec2-spotfleet-launchtemplateoverrides-instancerequirements
         */
        readonly instanceRequirements?: CfnSpotFleet.InstanceRequirementsRequestProperty | cdk.IResolvable;
        /**
         * `CfnSpotFleet.LaunchTemplateOverridesProperty.InstanceType`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-launchtemplateoverrides.html#cfn-ec2-spotfleet-launchtemplateoverrides-instancetype
         */
        readonly instanceType?: string;
        /**
         * `CfnSpotFleet.LaunchTemplateOverridesProperty.SpotPrice`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-launchtemplateoverrides.html#cfn-ec2-spotfleet-launchtemplateoverrides-spotprice
         */
        readonly spotPrice?: string;
        /**
         * `CfnSpotFleet.LaunchTemplateOverridesProperty.SubnetId`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-launchtemplateoverrides.html#cfn-ec2-spotfleet-launchtemplateoverrides-subnetid
         */
        readonly subnetId?: string;
        /**
         * `CfnSpotFleet.LaunchTemplateOverridesProperty.WeightedCapacity`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-launchtemplateoverrides.html#cfn-ec2-spotfleet-launchtemplateoverrides-weightedcapacity
         */
        readonly weightedCapacity?: number;
    }
}
/**
 * A CloudFormation `AWS::EC2::SpotFleet`.
 *
 * @external
 * @cloudformationResource AWS::EC2::SpotFleet
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-spotfleet.html
 */
export declare namespace CfnSpotFleet {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-loadbalancersconfig.html
     */
    interface LoadBalancersConfigProperty {
        /**
         * `CfnSpotFleet.LoadBalancersConfigProperty.ClassicLoadBalancersConfig`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-loadbalancersconfig.html#cfn-ec2-spotfleet-loadbalancersconfig-classicloadbalancersconfig
         */
        readonly classicLoadBalancersConfig?: CfnSpotFleet.ClassicLoadBalancersConfigProperty | cdk.IResolvable;
        /**
         * `CfnSpotFleet.LoadBalancersConfigProperty.TargetGroupsConfig`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-loadbalancersconfig.html#cfn-ec2-spotfleet-loadbalancersconfig-targetgroupsconfig
         */
        readonly targetGroupsConfig?: CfnSpotFleet.TargetGroupsConfigProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::EC2::SpotFleet`.
 *
 * @external
 * @cloudformationResource AWS::EC2::SpotFleet
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-spotfleet.html
 */
export declare namespace CfnSpotFleet {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-memorygibpervcpurequest.html
     */
    interface MemoryGiBPerVCpuRequestProperty {
        /**
         * `CfnSpotFleet.MemoryGiBPerVCpuRequestProperty.Max`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-memorygibpervcpurequest.html#cfn-ec2-spotfleet-memorygibpervcpurequest-max
         */
        readonly max?: number;
        /**
         * `CfnSpotFleet.MemoryGiBPerVCpuRequestProperty.Min`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-memorygibpervcpurequest.html#cfn-ec2-spotfleet-memorygibpervcpurequest-min
         */
        readonly min?: number;
    }
}
/**
 * A CloudFormation `AWS::EC2::SpotFleet`.
 *
 * @external
 * @cloudformationResource AWS::EC2::SpotFleet
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-spotfleet.html
 */
export declare namespace CfnSpotFleet {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-memorymibrequest.html
     */
    interface MemoryMiBRequestProperty {
        /**
         * `CfnSpotFleet.MemoryMiBRequestProperty.Max`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-memorymibrequest.html#cfn-ec2-spotfleet-memorymibrequest-max
         */
        readonly max?: number;
        /**
         * `CfnSpotFleet.MemoryMiBRequestProperty.Min`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-memorymibrequest.html#cfn-ec2-spotfleet-memorymibrequest-min
         */
        readonly min?: number;
    }
}
/**
 * A CloudFormation `AWS::EC2::SpotFleet`.
 *
 * @external
 * @cloudformationResource AWS::EC2::SpotFleet
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-spotfleet.html
 */
export declare namespace CfnSpotFleet {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-networkinterfacecountrequest.html
     */
    interface NetworkInterfaceCountRequestProperty {
        /**
         * `CfnSpotFleet.NetworkInterfaceCountRequestProperty.Max`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-networkinterfacecountrequest.html#cfn-ec2-spotfleet-networkinterfacecountrequest-max
         */
        readonly max?: number;
        /**
         * `CfnSpotFleet.NetworkInterfaceCountRequestProperty.Min`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-networkinterfacecountrequest.html#cfn-ec2-spotfleet-networkinterfacecountrequest-min
         */
        readonly min?: number;
    }
}
/**
 * A CloudFormation `AWS::EC2::SpotFleet`.
 *
 * @external
 * @cloudformationResource AWS::EC2::SpotFleet
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-spotfleet.html
 */
export declare namespace CfnSpotFleet {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-privateipaddressspecification.html
     */
    interface PrivateIpAddressSpecificationProperty {
        /**
         * `CfnSpotFleet.PrivateIpAddressSpecificationProperty.Primary`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-privateipaddressspecification.html#cfn-ec2-spotfleet-privateipaddressspecification-primary
         */
        readonly primary?: boolean | cdk.IResolvable;
        /**
         * `CfnSpotFleet.PrivateIpAddressSpecificationProperty.PrivateIpAddress`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-privateipaddressspecification.html#cfn-ec2-spotfleet-privateipaddressspecification-privateipaddress
         */
        readonly privateIpAddress: string;
    }
}
/**
 * A CloudFormation `AWS::EC2::SpotFleet`.
 *
 * @external
 * @cloudformationResource AWS::EC2::SpotFleet
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-spotfleet.html
 */
export declare namespace CfnSpotFleet {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotcapacityrebalance.html
     */
    interface SpotCapacityRebalanceProperty {
        /**
         * `CfnSpotFleet.SpotCapacityRebalanceProperty.ReplacementStrategy`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotcapacityrebalance.html#cfn-ec2-spotfleet-spotcapacityrebalance-replacementstrategy
         */
        readonly replacementStrategy?: string;
        /**
         * `CfnSpotFleet.SpotCapacityRebalanceProperty.TerminationDelay`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotcapacityrebalance.html#cfn-ec2-spotfleet-spotcapacityrebalance-terminationdelay
         */
        readonly terminationDelay?: number;
    }
}
/**
 * A CloudFormation `AWS::EC2::SpotFleet`.
 *
 * @external
 * @cloudformationResource AWS::EC2::SpotFleet
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-spotfleet.html
 */
export declare namespace CfnSpotFleet {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetlaunchspecification.html
     */
    interface SpotFleetLaunchSpecificationProperty {
        /**
         * `CfnSpotFleet.SpotFleetLaunchSpecificationProperty.BlockDeviceMappings`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetlaunchspecification.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-blockdevicemappings
         */
        readonly blockDeviceMappings?: Array<CfnSpotFleet.BlockDeviceMappingProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnSpotFleet.SpotFleetLaunchSpecificationProperty.EbsOptimized`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetlaunchspecification.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-ebsoptimized
         */
        readonly ebsOptimized?: boolean | cdk.IResolvable;
        /**
         * `CfnSpotFleet.SpotFleetLaunchSpecificationProperty.IamInstanceProfile`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetlaunchspecification.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-iaminstanceprofile
         */
        readonly iamInstanceProfile?: CfnSpotFleet.IamInstanceProfileSpecificationProperty | cdk.IResolvable;
        /**
         * `CfnSpotFleet.SpotFleetLaunchSpecificationProperty.ImageId`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetlaunchspecification.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-imageid
         */
        readonly imageId: string;
        /**
         * `CfnSpotFleet.SpotFleetLaunchSpecificationProperty.InstanceRequirements`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetlaunchspecification.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-instancerequirements
         */
        readonly instanceRequirements?: CfnSpotFleet.InstanceRequirementsRequestProperty | cdk.IResolvable;
        /**
         * `CfnSpotFleet.SpotFleetLaunchSpecificationProperty.InstanceType`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetlaunchspecification.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-instancetype
         */
        readonly instanceType?: string;
        /**
         * `CfnSpotFleet.SpotFleetLaunchSpecificationProperty.KernelId`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetlaunchspecification.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-kernelid
         */
        readonly kernelId?: string;
        /**
         * `CfnSpotFleet.SpotFleetLaunchSpecificationProperty.KeyName`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetlaunchspecification.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-keyname
         */
        readonly keyName?: string;
        /**
         * `CfnSpotFleet.SpotFleetLaunchSpecificationProperty.Monitoring`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetlaunchspecification.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-monitoring
         */
        readonly monitoring?: CfnSpotFleet.SpotFleetMonitoringProperty | cdk.IResolvable;
        /**
         * `CfnSpotFleet.SpotFleetLaunchSpecificationProperty.NetworkInterfaces`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetlaunchspecification.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-networkinterfaces
         */
        readonly networkInterfaces?: Array<CfnSpotFleet.InstanceNetworkInterfaceSpecificationProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnSpotFleet.SpotFleetLaunchSpecificationProperty.Placement`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetlaunchspecification.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-placement
         */
        readonly placement?: CfnSpotFleet.SpotPlacementProperty | cdk.IResolvable;
        /**
         * `CfnSpotFleet.SpotFleetLaunchSpecificationProperty.RamdiskId`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetlaunchspecification.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-ramdiskid
         */
        readonly ramdiskId?: string;
        /**
         * `CfnSpotFleet.SpotFleetLaunchSpecificationProperty.SecurityGroups`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetlaunchspecification.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-securitygroups
         */
        readonly securityGroups?: Array<CfnSpotFleet.GroupIdentifierProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnSpotFleet.SpotFleetLaunchSpecificationProperty.SpotPrice`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetlaunchspecification.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-spotprice
         */
        readonly spotPrice?: string;
        /**
         * `CfnSpotFleet.SpotFleetLaunchSpecificationProperty.SubnetId`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetlaunchspecification.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-subnetid
         */
        readonly subnetId?: string;
        /**
         * `CfnSpotFleet.SpotFleetLaunchSpecificationProperty.TagSpecifications`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetlaunchspecification.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-tagspecifications
         */
        readonly tagSpecifications?: Array<CfnSpotFleet.SpotFleetTagSpecificationProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnSpotFleet.SpotFleetLaunchSpecificationProperty.UserData`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetlaunchspecification.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-userdata
         */
        readonly userData?: string;
        /**
         * `CfnSpotFleet.SpotFleetLaunchSpecificationProperty.WeightedCapacity`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetlaunchspecification.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-weightedcapacity
         */
        readonly weightedCapacity?: number;
    }
}
/**
 * A CloudFormation `AWS::EC2::SpotFleet`.
 *
 * @external
 * @cloudformationResource AWS::EC2::SpotFleet
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-spotfleet.html
 */
export declare namespace CfnSpotFleet {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetmonitoring.html
     */
    interface SpotFleetMonitoringProperty {
        /**
         * `CfnSpotFleet.SpotFleetMonitoringProperty.Enabled`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetmonitoring.html#cfn-ec2-spotfleet-spotfleetmonitoring-enabled
         */
        readonly enabled?: boolean | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::EC2::SpotFleet`.
 *
 * @external
 * @cloudformationResource AWS::EC2::SpotFleet
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-spotfleet.html
 */
export declare namespace CfnSpotFleet {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata.html
     */
    interface SpotFleetRequestConfigDataProperty {
        /**
         * `CfnSpotFleet.SpotFleetRequestConfigDataProperty.AllocationStrategy`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata.html#cfn-ec2-spotfleet-spotfleetrequestconfigdata-allocationstrategy
         */
        readonly allocationStrategy?: string;
        /**
         * `CfnSpotFleet.SpotFleetRequestConfigDataProperty.Context`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata.html#cfn-ec2-spotfleet-spotfleetrequestconfigdata-context
         */
        readonly context?: string;
        /**
         * `CfnSpotFleet.SpotFleetRequestConfigDataProperty.ExcessCapacityTerminationPolicy`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata.html#cfn-ec2-spotfleet-spotfleetrequestconfigdata-excesscapacityterminationpolicy
         */
        readonly excessCapacityTerminationPolicy?: string;
        /**
         * `CfnSpotFleet.SpotFleetRequestConfigDataProperty.IamFleetRole`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata.html#cfn-ec2-spotfleet-spotfleetrequestconfigdata-iamfleetrole
         */
        readonly iamFleetRole: string;
        /**
         * `CfnSpotFleet.SpotFleetRequestConfigDataProperty.InstanceInterruptionBehavior`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata.html#cfn-ec2-spotfleet-spotfleetrequestconfigdata-instanceinterruptionbehavior
         */
        readonly instanceInterruptionBehavior?: string;
        /**
         * `CfnSpotFleet.SpotFleetRequestConfigDataProperty.InstancePoolsToUseCount`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata.html#cfn-ec2-spotfleet-spotfleetrequestconfigdata-instancepoolstousecount
         */
        readonly instancePoolsToUseCount?: number;
        /**
         * `CfnSpotFleet.SpotFleetRequestConfigDataProperty.LaunchSpecifications`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata.html#cfn-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications
         */
        readonly launchSpecifications?: Array<CfnSpotFleet.SpotFleetLaunchSpecificationProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnSpotFleet.SpotFleetRequestConfigDataProperty.LaunchTemplateConfigs`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata.html#cfn-ec2-spotfleet-spotfleetrequestconfigdata-launchtemplateconfigs
         */
        readonly launchTemplateConfigs?: Array<CfnSpotFleet.LaunchTemplateConfigProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnSpotFleet.SpotFleetRequestConfigDataProperty.LoadBalancersConfig`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata.html#cfn-ec2-spotfleet-spotfleetrequestconfigdata-loadbalancersconfig
         */
        readonly loadBalancersConfig?: CfnSpotFleet.LoadBalancersConfigProperty | cdk.IResolvable;
        /**
         * `CfnSpotFleet.SpotFleetRequestConfigDataProperty.OnDemandAllocationStrategy`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata.html#cfn-ec2-spotfleet-spotfleetrequestconfigdata-ondemandallocationstrategy
         */
        readonly onDemandAllocationStrategy?: string;
        /**
         * `CfnSpotFleet.SpotFleetRequestConfigDataProperty.OnDemandMaxTotalPrice`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata.html#cfn-ec2-spotfleet-spotfleetrequestconfigdata-ondemandmaxtotalprice
         */
        readonly onDemandMaxTotalPrice?: string;
        /**
         * `CfnSpotFleet.SpotFleetRequestConfigDataProperty.OnDemandTargetCapacity`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata.html#cfn-ec2-spotfleet-spotfleetrequestconfigdata-ondemandtargetcapacity
         */
        readonly onDemandTargetCapacity?: number;
        /**
         * `CfnSpotFleet.SpotFleetRequestConfigDataProperty.ReplaceUnhealthyInstances`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata.html#cfn-ec2-spotfleet-spotfleetrequestconfigdata-replaceunhealthyinstances
         */
        readonly replaceUnhealthyInstances?: boolean | cdk.IResolvable;
        /**
         * `CfnSpotFleet.SpotFleetRequestConfigDataProperty.SpotMaintenanceStrategies`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata.html#cfn-ec2-spotfleet-spotfleetrequestconfigdata-spotmaintenancestrategies
         */
        readonly spotMaintenanceStrategies?: CfnSpotFleet.SpotMaintenanceStrategiesProperty | cdk.IResolvable;
        /**
         * `CfnSpotFleet.SpotFleetRequestConfigDataProperty.SpotMaxTotalPrice`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata.html#cfn-ec2-spotfleet-spotfleetrequestconfigdata-spotmaxtotalprice
         */
        readonly spotMaxTotalPrice?: string;
        /**
         * `CfnSpotFleet.SpotFleetRequestConfigDataProperty.SpotPrice`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata.html#cfn-ec2-spotfleet-spotfleetrequestconfigdata-spotprice
         */
        readonly spotPrice?: string;
        /**
         * `CfnSpotFleet.SpotFleetRequestConfigDataProperty.TargetCapacity`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata.html#cfn-ec2-spotfleet-spotfleetrequestconfigdata-targetcapacity
         */
        readonly targetCapacity: number;
        /**
         * `CfnSpotFleet.SpotFleetRequestConfigDataProperty.TargetCapacityUnitType`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata.html#cfn-ec2-spotfleet-spotfleetrequestconfigdata-targetcapacityunittype
         */
        readonly targetCapacityUnitType?: string;
        /**
         * `CfnSpotFleet.SpotFleetRequestConfigDataProperty.TerminateInstancesWithExpiration`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata.html#cfn-ec2-spotfleet-spotfleetrequestconfigdata-terminateinstanceswithexpiration
         */
        readonly terminateInstancesWithExpiration?: boolean | cdk.IResolvable;
        /**
         * `CfnSpotFleet.SpotFleetRequestConfigDataProperty.Type`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata.html#cfn-ec2-spotfleet-spotfleetrequestconfigdata-type
         */
        readonly type?: string;
        /**
         * `CfnSpotFleet.SpotFleetRequestConfigDataProperty.ValidFrom`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata.html#cfn-ec2-spotfleet-spotfleetrequestconfigdata-validfrom
         */
        readonly validFrom?: string;
        /**
         * `CfnSpotFleet.SpotFleetRequestConfigDataProperty.ValidUntil`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata.html#cfn-ec2-spotfleet-spotfleetrequestconfigdata-validuntil
         */
        readonly validUntil?: string;
    }
}
/**
 * A CloudFormation `AWS::EC2::SpotFleet`.
 *
 * @external
 * @cloudformationResource AWS::EC2::SpotFleet
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-spotfleet.html
 */
export declare namespace CfnSpotFleet {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleettagspecification.html
     */
    interface SpotFleetTagSpecificationProperty {
        /**
         * `CfnSpotFleet.SpotFleetTagSpecificationProperty.ResourceType`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleettagspecification.html#cfn-ec2-spotfleet-spotfleettagspecification-resourcetype
         */
        readonly resourceType?: string;
        /**
         * `CfnSpotFleet.SpotFleetTagSpecificationProperty.Tags`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleettagspecification.html#cfn-ec2-spotfleet-spotfleettagspecification-tags
         */
        readonly tags?: cdk.CfnTag[];
    }
}
/**
 * A CloudFormation `AWS::EC2::SpotFleet`.
 *
 * @external
 * @cloudformationResource AWS::EC2::SpotFleet
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-spotfleet.html
 */
export declare namespace CfnSpotFleet {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotmaintenancestrategies.html
     */
    interface SpotMaintenanceStrategiesProperty {
        /**
         * `CfnSpotFleet.SpotMaintenanceStrategiesProperty.CapacityRebalance`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotmaintenancestrategies.html#cfn-ec2-spotfleet-spotmaintenancestrategies-capacityrebalance
         */
        readonly capacityRebalance?: CfnSpotFleet.SpotCapacityRebalanceProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::EC2::SpotFleet`.
 *
 * @external
 * @cloudformationResource AWS::EC2::SpotFleet
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-spotfleet.html
 */
export declare namespace CfnSpotFleet {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotplacement.html
     */
    interface SpotPlacementProperty {
        /**
         * `CfnSpotFleet.SpotPlacementProperty.AvailabilityZone`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotplacement.html#cfn-ec2-spotfleet-spotplacement-availabilityzone
         */
        readonly availabilityZone?: string;
        /**
         * `CfnSpotFleet.SpotPlacementProperty.GroupName`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotplacement.html#cfn-ec2-spotfleet-spotplacement-groupname
         */
        readonly groupName?: string;
        /**
         * `CfnSpotFleet.SpotPlacementProperty.Tenancy`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotplacement.html#cfn-ec2-spotfleet-spotplacement-tenancy
         */
        readonly tenancy?: string;
    }
}
/**
 * A CloudFormation `AWS::EC2::SpotFleet`.
 *
 * @external
 * @cloudformationResource AWS::EC2::SpotFleet
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-spotfleet.html
 */
export declare namespace CfnSpotFleet {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-targetgroup.html
     */
    interface TargetGroupProperty {
        /**
         * `CfnSpotFleet.TargetGroupProperty.Arn`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-targetgroup.html#cfn-ec2-spotfleet-targetgroup-arn
         */
        readonly arn: string;
    }
}
/**
 * A CloudFormation `AWS::EC2::SpotFleet`.
 *
 * @external
 * @cloudformationResource AWS::EC2::SpotFleet
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-spotfleet.html
 */
export declare namespace CfnSpotFleet {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-targetgroupsconfig.html
     */
    interface TargetGroupsConfigProperty {
        /**
         * `CfnSpotFleet.TargetGroupsConfigProperty.TargetGroups`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-targetgroupsconfig.html#cfn-ec2-spotfleet-targetgroupsconfig-targetgroups
         */
        readonly targetGroups: Array<CfnSpotFleet.TargetGroupProperty | cdk.IResolvable> | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::EC2::SpotFleet`.
 *
 * @external
 * @cloudformationResource AWS::EC2::SpotFleet
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-spotfleet.html
 */
export declare namespace CfnSpotFleet {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-totallocalstoragegbrequest.html
     */
    interface TotalLocalStorageGBRequestProperty {
        /**
         * `CfnSpotFleet.TotalLocalStorageGBRequestProperty.Max`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-totallocalstoragegbrequest.html#cfn-ec2-spotfleet-totallocalstoragegbrequest-max
         */
        readonly max?: number;
        /**
         * `CfnSpotFleet.TotalLocalStorageGBRequestProperty.Min`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-totallocalstoragegbrequest.html#cfn-ec2-spotfleet-totallocalstoragegbrequest-min
         */
        readonly min?: number;
    }
}
/**
 * A CloudFormation `AWS::EC2::SpotFleet`.
 *
 * @external
 * @cloudformationResource AWS::EC2::SpotFleet
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-spotfleet.html
 */
export declare namespace CfnSpotFleet {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-vcpucountrangerequest.html
     */
    interface VCpuCountRangeRequestProperty {
        /**
         * `CfnSpotFleet.VCpuCountRangeRequestProperty.Max`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-vcpucountrangerequest.html#cfn-ec2-spotfleet-vcpucountrangerequest-max
         */
        readonly max?: number;
        /**
         * `CfnSpotFleet.VCpuCountRangeRequestProperty.Min`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-vcpucountrangerequest.html#cfn-ec2-spotfleet-vcpucountrangerequest-min
         */
        readonly min?: number;
    }
}
/**
 * Properties for defining a `AWS::EC2::Subnet`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-subnet.html
 */
export interface CfnSubnetProps {
    /**
     * `AWS::EC2::Subnet.CidrBlock`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-subnet.html#cfn-ec2-subnet-cidrblock
     */
    readonly cidrBlock: string;
    /**
     * `AWS::EC2::Subnet.VpcId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-subnet.html#cfn-awsec2subnet-prop-vpcid
     */
    readonly vpcId: string;
    /**
     * `AWS::EC2::Subnet.AssignIpv6AddressOnCreation`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-subnet.html#cfn-ec2-subnet-assignipv6addressoncreation
     */
    readonly assignIpv6AddressOnCreation?: boolean | cdk.IResolvable;
    /**
     * `AWS::EC2::Subnet.AvailabilityZone`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-subnet.html#cfn-ec2-subnet-availabilityzone
     */
    readonly availabilityZone?: string;
    /**
     * `AWS::EC2::Subnet.Ipv6CidrBlock`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-subnet.html#cfn-ec2-subnet-ipv6cidrblock
     */
    readonly ipv6CidrBlock?: string;
    /**
     * `AWS::EC2::Subnet.MapPublicIpOnLaunch`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-subnet.html#cfn-ec2-subnet-mappubliciponlaunch
     */
    readonly mapPublicIpOnLaunch?: boolean | cdk.IResolvable;
    /**
     * `AWS::EC2::Subnet.OutpostArn`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-subnet.html#cfn-ec2-subnet-outpostarn
     */
    readonly outpostArn?: string;
    /**
     * `AWS::EC2::Subnet.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-subnet.html#cfn-ec2-subnet-tags
     */
    readonly tags?: cdk.CfnTag[];
}
/**
 * A CloudFormation `AWS::EC2::Subnet`.
 *
 * @external
 * @cloudformationResource AWS::EC2::Subnet
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-subnet.html
 */
export declare class CfnSubnet extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::EC2::Subnet";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnSubnet;
    /**
     * @external
     * @cloudformationAttribute AvailabilityZone
     */
    readonly attrAvailabilityZone: string;
    /**
     * @external
     * @cloudformationAttribute Ipv6CidrBlocks
     */
    readonly attrIpv6CidrBlocks: string[];
    /**
     * @external
     * @cloudformationAttribute NetworkAclAssociationId
     */
    readonly attrNetworkAclAssociationId: string;
    /**
     * @external
     * @cloudformationAttribute OutpostArn
     */
    readonly attrOutpostArn: string;
    /**
     * @external
     * @cloudformationAttribute VpcId
     */
    readonly attrVpcId: string;
    /**
     * `AWS::EC2::Subnet.CidrBlock`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-subnet.html#cfn-ec2-subnet-cidrblock
     */
    cidrBlock: string;
    /**
     * `AWS::EC2::Subnet.VpcId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-subnet.html#cfn-awsec2subnet-prop-vpcid
     */
    vpcId: string;
    /**
     * `AWS::EC2::Subnet.AssignIpv6AddressOnCreation`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-subnet.html#cfn-ec2-subnet-assignipv6addressoncreation
     */
    assignIpv6AddressOnCreation: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::EC2::Subnet.AvailabilityZone`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-subnet.html#cfn-ec2-subnet-availabilityzone
     */
    availabilityZone: string | undefined;
    /**
     * `AWS::EC2::Subnet.Ipv6CidrBlock`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-subnet.html#cfn-ec2-subnet-ipv6cidrblock
     */
    ipv6CidrBlock: string | undefined;
    /**
     * `AWS::EC2::Subnet.MapPublicIpOnLaunch`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-subnet.html#cfn-ec2-subnet-mappubliciponlaunch
     */
    mapPublicIpOnLaunch: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::EC2::Subnet.OutpostArn`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-subnet.html#cfn-ec2-subnet-outpostarn
     */
    outpostArn: string | undefined;
    /**
     * `AWS::EC2::Subnet.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-subnet.html#cfn-ec2-subnet-tags
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::EC2::Subnet`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnSubnetProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @external
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::EC2::SubnetCidrBlock`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-subnetcidrblock.html
 */
export interface CfnSubnetCidrBlockProps {
    /**
     * `AWS::EC2::SubnetCidrBlock.Ipv6CidrBlock`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-subnetcidrblock.html#cfn-ec2-subnetcidrblock-ipv6cidrblock
     */
    readonly ipv6CidrBlock: string;
    /**
     * `AWS::EC2::SubnetCidrBlock.SubnetId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-subnetcidrblock.html#cfn-ec2-subnetcidrblock-subnetid
     */
    readonly subnetId: string;
}
/**
 * A CloudFormation `AWS::EC2::SubnetCidrBlock`.
 *
 * @external
 * @cloudformationResource AWS::EC2::SubnetCidrBlock
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-subnetcidrblock.html
 */
export declare class CfnSubnetCidrBlock extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::EC2::SubnetCidrBlock";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnSubnetCidrBlock;
    /**
     * `AWS::EC2::SubnetCidrBlock.Ipv6CidrBlock`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-subnetcidrblock.html#cfn-ec2-subnetcidrblock-ipv6cidrblock
     */
    ipv6CidrBlock: string;
    /**
     * `AWS::EC2::SubnetCidrBlock.SubnetId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-subnetcidrblock.html#cfn-ec2-subnetcidrblock-subnetid
     */
    subnetId: string;
    /**
     * Create a new `AWS::EC2::SubnetCidrBlock`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnSubnetCidrBlockProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @external
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::EC2::SubnetNetworkAclAssociation`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-subnet-network-acl-assoc.html
 */
export interface CfnSubnetNetworkAclAssociationProps {
    /**
     * `AWS::EC2::SubnetNetworkAclAssociation.NetworkAclId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-subnet-network-acl-assoc.html#cfn-ec2-subnetnetworkaclassociation-networkaclid
     */
    readonly networkAclId: string;
    /**
     * `AWS::EC2::SubnetNetworkAclAssociation.SubnetId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-subnet-network-acl-assoc.html#cfn-ec2-subnetnetworkaclassociation-associationid
     */
    readonly subnetId: string;
}
/**
 * A CloudFormation `AWS::EC2::SubnetNetworkAclAssociation`.
 *
 * @external
 * @cloudformationResource AWS::EC2::SubnetNetworkAclAssociation
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-subnet-network-acl-assoc.html
 */
export declare class CfnSubnetNetworkAclAssociation extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::EC2::SubnetNetworkAclAssociation";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnSubnetNetworkAclAssociation;
    /**
     * @external
     * @cloudformationAttribute AssociationId
     */
    readonly attrAssociationId: string;
    /**
     * `AWS::EC2::SubnetNetworkAclAssociation.NetworkAclId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-subnet-network-acl-assoc.html#cfn-ec2-subnetnetworkaclassociation-networkaclid
     */
    networkAclId: string;
    /**
     * `AWS::EC2::SubnetNetworkAclAssociation.SubnetId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-subnet-network-acl-assoc.html#cfn-ec2-subnetnetworkaclassociation-associationid
     */
    subnetId: string;
    /**
     * Create a new `AWS::EC2::SubnetNetworkAclAssociation`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnSubnetNetworkAclAssociationProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @external
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::EC2::SubnetRouteTableAssociation`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-subnet-route-table-assoc.html
 */
export interface CfnSubnetRouteTableAssociationProps {
    /**
     * `AWS::EC2::SubnetRouteTableAssociation.RouteTableId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-subnet-route-table-assoc.html#cfn-ec2-subnetroutetableassociation-routetableid
     */
    readonly routeTableId: string;
    /**
     * `AWS::EC2::SubnetRouteTableAssociation.SubnetId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-subnet-route-table-assoc.html#cfn-ec2-subnetroutetableassociation-subnetid
     */
    readonly subnetId: string;
}
/**
 * A CloudFormation `AWS::EC2::SubnetRouteTableAssociation`.
 *
 * @external
 * @cloudformationResource AWS::EC2::SubnetRouteTableAssociation
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-subnet-route-table-assoc.html
 */
export declare class CfnSubnetRouteTableAssociation extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::EC2::SubnetRouteTableAssociation";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnSubnetRouteTableAssociation;
    /**
     * `AWS::EC2::SubnetRouteTableAssociation.RouteTableId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-subnet-route-table-assoc.html#cfn-ec2-subnetroutetableassociation-routetableid
     */
    routeTableId: string;
    /**
     * `AWS::EC2::SubnetRouteTableAssociation.SubnetId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-subnet-route-table-assoc.html#cfn-ec2-subnetroutetableassociation-subnetid
     */
    subnetId: string;
    /**
     * Create a new `AWS::EC2::SubnetRouteTableAssociation`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnSubnetRouteTableAssociationProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @external
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::EC2::TrafficMirrorFilter`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-trafficmirrorfilter.html
 */
export interface CfnTrafficMirrorFilterProps {
    /**
     * `AWS::EC2::TrafficMirrorFilter.Description`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-trafficmirrorfilter.html#cfn-ec2-trafficmirrorfilter-description
     */
    readonly description?: string;
    /**
     * `AWS::EC2::TrafficMirrorFilter.NetworkServices`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-trafficmirrorfilter.html#cfn-ec2-trafficmirrorfilter-networkservices
     */
    readonly networkServices?: string[];
    /**
     * `AWS::EC2::TrafficMirrorFilter.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-trafficmirrorfilter.html#cfn-ec2-trafficmirrorfilter-tags
     */
    readonly tags?: cdk.CfnTag[];
}
/**
 * A CloudFormation `AWS::EC2::TrafficMirrorFilter`.
 *
 * @external
 * @cloudformationResource AWS::EC2::TrafficMirrorFilter
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-trafficmirrorfilter.html
 */
export declare class CfnTrafficMirrorFilter extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::EC2::TrafficMirrorFilter";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnTrafficMirrorFilter;
    /**
     * `AWS::EC2::TrafficMirrorFilter.Description`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-trafficmirrorfilter.html#cfn-ec2-trafficmirrorfilter-description
     */
    description: string | undefined;
    /**
     * `AWS::EC2::TrafficMirrorFilter.NetworkServices`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-trafficmirrorfilter.html#cfn-ec2-trafficmirrorfilter-networkservices
     */
    networkServices: string[] | undefined;
    /**
     * `AWS::EC2::TrafficMirrorFilter.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-trafficmirrorfilter.html#cfn-ec2-trafficmirrorfilter-tags
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::EC2::TrafficMirrorFilter`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props?: CfnTrafficMirrorFilterProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @external
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::EC2::TrafficMirrorFilterRule`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-trafficmirrorfilterrule.html
 */
export interface CfnTrafficMirrorFilterRuleProps {
    /**
     * `AWS::EC2::TrafficMirrorFilterRule.DestinationCidrBlock`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-trafficmirrorfilterrule.html#cfn-ec2-trafficmirrorfilterrule-destinationcidrblock
     */
    readonly destinationCidrBlock: string;
    /**
     * `AWS::EC2::TrafficMirrorFilterRule.RuleAction`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-trafficmirrorfilterrule.html#cfn-ec2-trafficmirrorfilterrule-ruleaction
     */
    readonly ruleAction: string;
    /**
     * `AWS::EC2::TrafficMirrorFilterRule.RuleNumber`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-trafficmirrorfilterrule.html#cfn-ec2-trafficmirrorfilterrule-rulenumber
     */
    readonly ruleNumber: number;
    /**
     * `AWS::EC2::TrafficMirrorFilterRule.SourceCidrBlock`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-trafficmirrorfilterrule.html#cfn-ec2-trafficmirrorfilterrule-sourcecidrblock
     */
    readonly sourceCidrBlock: string;
    /**
     * `AWS::EC2::TrafficMirrorFilterRule.TrafficDirection`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-trafficmirrorfilterrule.html#cfn-ec2-trafficmirrorfilterrule-trafficdirection
     */
    readonly trafficDirection: string;
    /**
     * `AWS::EC2::TrafficMirrorFilterRule.TrafficMirrorFilterId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-trafficmirrorfilterrule.html#cfn-ec2-trafficmirrorfilterrule-trafficmirrorfilterid
     */
    readonly trafficMirrorFilterId: string;
    /**
     * `AWS::EC2::TrafficMirrorFilterRule.Description`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-trafficmirrorfilterrule.html#cfn-ec2-trafficmirrorfilterrule-description
     */
    readonly description?: string;
    /**
     * `AWS::EC2::TrafficMirrorFilterRule.DestinationPortRange`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-trafficmirrorfilterrule.html#cfn-ec2-trafficmirrorfilterrule-destinationportrange
     */
    readonly destinationPortRange?: CfnTrafficMirrorFilterRule.TrafficMirrorPortRangeProperty | cdk.IResolvable;
    /**
     * `AWS::EC2::TrafficMirrorFilterRule.Protocol`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-trafficmirrorfilterrule.html#cfn-ec2-trafficmirrorfilterrule-protocol
     */
    readonly protocol?: number;
    /**
     * `AWS::EC2::TrafficMirrorFilterRule.SourcePortRange`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-trafficmirrorfilterrule.html#cfn-ec2-trafficmirrorfilterrule-sourceportrange
     */
    readonly sourcePortRange?: CfnTrafficMirrorFilterRule.TrafficMirrorPortRangeProperty | cdk.IResolvable;
}
/**
 * A CloudFormation `AWS::EC2::TrafficMirrorFilterRule`.
 *
 * @external
 * @cloudformationResource AWS::EC2::TrafficMirrorFilterRule
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-trafficmirrorfilterrule.html
 */
export declare class CfnTrafficMirrorFilterRule extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::EC2::TrafficMirrorFilterRule";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnTrafficMirrorFilterRule;
    /**
     * `AWS::EC2::TrafficMirrorFilterRule.DestinationCidrBlock`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-trafficmirrorfilterrule.html#cfn-ec2-trafficmirrorfilterrule-destinationcidrblock
     */
    destinationCidrBlock: string;
    /**
     * `AWS::EC2::TrafficMirrorFilterRule.RuleAction`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-trafficmirrorfilterrule.html#cfn-ec2-trafficmirrorfilterrule-ruleaction
     */
    ruleAction: string;
    /**
     * `AWS::EC2::TrafficMirrorFilterRule.RuleNumber`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-trafficmirrorfilterrule.html#cfn-ec2-trafficmirrorfilterrule-rulenumber
     */
    ruleNumber: number;
    /**
     * `AWS::EC2::TrafficMirrorFilterRule.SourceCidrBlock`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-trafficmirrorfilterrule.html#cfn-ec2-trafficmirrorfilterrule-sourcecidrblock
     */
    sourceCidrBlock: string;
    /**
     * `AWS::EC2::TrafficMirrorFilterRule.TrafficDirection`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-trafficmirrorfilterrule.html#cfn-ec2-trafficmirrorfilterrule-trafficdirection
     */
    trafficDirection: string;
    /**
     * `AWS::EC2::TrafficMirrorFilterRule.TrafficMirrorFilterId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-trafficmirrorfilterrule.html#cfn-ec2-trafficmirrorfilterrule-trafficmirrorfilterid
     */
    trafficMirrorFilterId: string;
    /**
     * `AWS::EC2::TrafficMirrorFilterRule.Description`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-trafficmirrorfilterrule.html#cfn-ec2-trafficmirrorfilterrule-description
     */
    description: string | undefined;
    /**
     * `AWS::EC2::TrafficMirrorFilterRule.DestinationPortRange`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-trafficmirrorfilterrule.html#cfn-ec2-trafficmirrorfilterrule-destinationportrange
     */
    destinationPortRange: CfnTrafficMirrorFilterRule.TrafficMirrorPortRangeProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::EC2::TrafficMirrorFilterRule.Protocol`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-trafficmirrorfilterrule.html#cfn-ec2-trafficmirrorfilterrule-protocol
     */
    protocol: number | undefined;
    /**
     * `AWS::EC2::TrafficMirrorFilterRule.SourcePortRange`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-trafficmirrorfilterrule.html#cfn-ec2-trafficmirrorfilterrule-sourceportrange
     */
    sourcePortRange: CfnTrafficMirrorFilterRule.TrafficMirrorPortRangeProperty | cdk.IResolvable | undefined;
    /**
     * Create a new `AWS::EC2::TrafficMirrorFilterRule`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnTrafficMirrorFilterRuleProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @external
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::EC2::TrafficMirrorFilterRule`.
 *
 * @external
 * @cloudformationResource AWS::EC2::TrafficMirrorFilterRule
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-trafficmirrorfilterrule.html
 */
export declare namespace CfnTrafficMirrorFilterRule {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-trafficmirrorfilterrule-trafficmirrorportrange.html
     */
    interface TrafficMirrorPortRangeProperty {
        /**
         * `CfnTrafficMirrorFilterRule.TrafficMirrorPortRangeProperty.FromPort`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-trafficmirrorfilterrule-trafficmirrorportrange.html#cfn-ec2-trafficmirrorfilterrule-trafficmirrorportrange-fromport
         */
        readonly fromPort: number;
        /**
         * `CfnTrafficMirrorFilterRule.TrafficMirrorPortRangeProperty.ToPort`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-trafficmirrorfilterrule-trafficmirrorportrange.html#cfn-ec2-trafficmirrorfilterrule-trafficmirrorportrange-toport
         */
        readonly toPort: number;
    }
}
/**
 * Properties for defining a `AWS::EC2::TrafficMirrorSession`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-trafficmirrorsession.html
 */
export interface CfnTrafficMirrorSessionProps {
    /**
     * `AWS::EC2::TrafficMirrorSession.NetworkInterfaceId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-trafficmirrorsession.html#cfn-ec2-trafficmirrorsession-networkinterfaceid
     */
    readonly networkInterfaceId: string;
    /**
     * `AWS::EC2::TrafficMirrorSession.SessionNumber`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-trafficmirrorsession.html#cfn-ec2-trafficmirrorsession-sessionnumber
     */
    readonly sessionNumber: number;
    /**
     * `AWS::EC2::TrafficMirrorSession.TrafficMirrorFilterId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-trafficmirrorsession.html#cfn-ec2-trafficmirrorsession-trafficmirrorfilterid
     */
    readonly trafficMirrorFilterId: string;
    /**
     * `AWS::EC2::TrafficMirrorSession.TrafficMirrorTargetId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-trafficmirrorsession.html#cfn-ec2-trafficmirrorsession-trafficmirrortargetid
     */
    readonly trafficMirrorTargetId: string;
    /**
     * `AWS::EC2::TrafficMirrorSession.Description`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-trafficmirrorsession.html#cfn-ec2-trafficmirrorsession-description
     */
    readonly description?: string;
    /**
     * `AWS::EC2::TrafficMirrorSession.PacketLength`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-trafficmirrorsession.html#cfn-ec2-trafficmirrorsession-packetlength
     */
    readonly packetLength?: number;
    /**
     * `AWS::EC2::TrafficMirrorSession.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-trafficmirrorsession.html#cfn-ec2-trafficmirrorsession-tags
     */
    readonly tags?: cdk.CfnTag[];
    /**
     * `AWS::EC2::TrafficMirrorSession.VirtualNetworkId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-trafficmirrorsession.html#cfn-ec2-trafficmirrorsession-virtualnetworkid
     */
    readonly virtualNetworkId?: number;
}
/**
 * A CloudFormation `AWS::EC2::TrafficMirrorSession`.
 *
 * @external
 * @cloudformationResource AWS::EC2::TrafficMirrorSession
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-trafficmirrorsession.html
 */
export declare class CfnTrafficMirrorSession extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::EC2::TrafficMirrorSession";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnTrafficMirrorSession;
    /**
     * `AWS::EC2::TrafficMirrorSession.NetworkInterfaceId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-trafficmirrorsession.html#cfn-ec2-trafficmirrorsession-networkinterfaceid
     */
    networkInterfaceId: string;
    /**
     * `AWS::EC2::TrafficMirrorSession.SessionNumber`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-trafficmirrorsession.html#cfn-ec2-trafficmirrorsession-sessionnumber
     */
    sessionNumber: number;
    /**
     * `AWS::EC2::TrafficMirrorSession.TrafficMirrorFilterId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-trafficmirrorsession.html#cfn-ec2-trafficmirrorsession-trafficmirrorfilterid
     */
    trafficMirrorFilterId: string;
    /**
     * `AWS::EC2::TrafficMirrorSession.TrafficMirrorTargetId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-trafficmirrorsession.html#cfn-ec2-trafficmirrorsession-trafficmirrortargetid
     */
    trafficMirrorTargetId: string;
    /**
     * `AWS::EC2::TrafficMirrorSession.Description`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-trafficmirrorsession.html#cfn-ec2-trafficmirrorsession-description
     */
    description: string | undefined;
    /**
     * `AWS::EC2::TrafficMirrorSession.PacketLength`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-trafficmirrorsession.html#cfn-ec2-trafficmirrorsession-packetlength
     */
    packetLength: number | undefined;
    /**
     * `AWS::EC2::TrafficMirrorSession.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-trafficmirrorsession.html#cfn-ec2-trafficmirrorsession-tags
     */
    readonly tags: cdk.TagManager;
    /**
     * `AWS::EC2::TrafficMirrorSession.VirtualNetworkId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-trafficmirrorsession.html#cfn-ec2-trafficmirrorsession-virtualnetworkid
     */
    virtualNetworkId: number | undefined;
    /**
     * Create a new `AWS::EC2::TrafficMirrorSession`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnTrafficMirrorSessionProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @external
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::EC2::TrafficMirrorTarget`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-trafficmirrortarget.html
 */
export interface CfnTrafficMirrorTargetProps {
    /**
     * `AWS::EC2::TrafficMirrorTarget.Description`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-trafficmirrortarget.html#cfn-ec2-trafficmirrortarget-description
     */
    readonly description?: string;
    /**
     * `AWS::EC2::TrafficMirrorTarget.NetworkInterfaceId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-trafficmirrortarget.html#cfn-ec2-trafficmirrortarget-networkinterfaceid
     */
    readonly networkInterfaceId?: string;
    /**
     * `AWS::EC2::TrafficMirrorTarget.NetworkLoadBalancerArn`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-trafficmirrortarget.html#cfn-ec2-trafficmirrortarget-networkloadbalancerarn
     */
    readonly networkLoadBalancerArn?: string;
    /**
     * `AWS::EC2::TrafficMirrorTarget.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-trafficmirrortarget.html#cfn-ec2-trafficmirrortarget-tags
     */
    readonly tags?: cdk.CfnTag[];
}
/**
 * A CloudFormation `AWS::EC2::TrafficMirrorTarget`.
 *
 * @external
 * @cloudformationResource AWS::EC2::TrafficMirrorTarget
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-trafficmirrortarget.html
 */
export declare class CfnTrafficMirrorTarget extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::EC2::TrafficMirrorTarget";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnTrafficMirrorTarget;
    /**
     * `AWS::EC2::TrafficMirrorTarget.Description`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-trafficmirrortarget.html#cfn-ec2-trafficmirrortarget-description
     */
    description: string | undefined;
    /**
     * `AWS::EC2::TrafficMirrorTarget.NetworkInterfaceId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-trafficmirrortarget.html#cfn-ec2-trafficmirrortarget-networkinterfaceid
     */
    networkInterfaceId: string | undefined;
    /**
     * `AWS::EC2::TrafficMirrorTarget.NetworkLoadBalancerArn`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-trafficmirrortarget.html#cfn-ec2-trafficmirrortarget-networkloadbalancerarn
     */
    networkLoadBalancerArn: string | undefined;
    /**
     * `AWS::EC2::TrafficMirrorTarget.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-trafficmirrortarget.html#cfn-ec2-trafficmirrortarget-tags
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::EC2::TrafficMirrorTarget`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props?: CfnTrafficMirrorTargetProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @external
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::EC2::TransitGateway`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgateway.html
 */
export interface CfnTransitGatewayProps {
    /**
     * `AWS::EC2::TransitGateway.AmazonSideAsn`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgateway.html#cfn-ec2-transitgateway-amazonsideasn
     */
    readonly amazonSideAsn?: number;
    /**
     * `AWS::EC2::TransitGateway.AssociationDefaultRouteTableId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgateway.html#cfn-ec2-transitgateway-associationdefaultroutetableid
     */
    readonly associationDefaultRouteTableId?: string;
    /**
     * `AWS::EC2::TransitGateway.AutoAcceptSharedAttachments`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgateway.html#cfn-ec2-transitgateway-autoacceptsharedattachments
     */
    readonly autoAcceptSharedAttachments?: string;
    /**
     * `AWS::EC2::TransitGateway.DefaultRouteTableAssociation`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgateway.html#cfn-ec2-transitgateway-defaultroutetableassociation
     */
    readonly defaultRouteTableAssociation?: string;
    /**
     * `AWS::EC2::TransitGateway.DefaultRouteTablePropagation`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgateway.html#cfn-ec2-transitgateway-defaultroutetablepropagation
     */
    readonly defaultRouteTablePropagation?: string;
    /**
     * `AWS::EC2::TransitGateway.Description`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgateway.html#cfn-ec2-transitgateway-description
     */
    readonly description?: string;
    /**
     * `AWS::EC2::TransitGateway.DnsSupport`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgateway.html#cfn-ec2-transitgateway-dnssupport
     */
    readonly dnsSupport?: string;
    /**
     * `AWS::EC2::TransitGateway.MulticastSupport`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgateway.html#cfn-ec2-transitgateway-multicastsupport
     */
    readonly multicastSupport?: string;
    /**
     * `AWS::EC2::TransitGateway.PropagationDefaultRouteTableId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgateway.html#cfn-ec2-transitgateway-propagationdefaultroutetableid
     */
    readonly propagationDefaultRouteTableId?: string;
    /**
     * `AWS::EC2::TransitGateway.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgateway.html#cfn-ec2-transitgateway-tags
     */
    readonly tags?: cdk.CfnTag[];
    /**
     * `AWS::EC2::TransitGateway.TransitGatewayCidrBlocks`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgateway.html#cfn-ec2-transitgateway-transitgatewaycidrblocks
     */
    readonly transitGatewayCidrBlocks?: string[];
    /**
     * `AWS::EC2::TransitGateway.VpnEcmpSupport`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgateway.html#cfn-ec2-transitgateway-vpnecmpsupport
     */
    readonly vpnEcmpSupport?: string;
}
/**
 * A CloudFormation `AWS::EC2::TransitGateway`.
 *
 * @external
 * @cloudformationResource AWS::EC2::TransitGateway
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgateway.html
 */
export declare class CfnTransitGateway extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::EC2::TransitGateway";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnTransitGateway;
    /**
     * @external
     * @cloudformationAttribute Id
     */
    readonly attrId: string;
    /**
     * `AWS::EC2::TransitGateway.AmazonSideAsn`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgateway.html#cfn-ec2-transitgateway-amazonsideasn
     */
    amazonSideAsn: number | undefined;
    /**
     * `AWS::EC2::TransitGateway.AssociationDefaultRouteTableId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgateway.html#cfn-ec2-transitgateway-associationdefaultroutetableid
     */
    associationDefaultRouteTableId: string | undefined;
    /**
     * `AWS::EC2::TransitGateway.AutoAcceptSharedAttachments`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgateway.html#cfn-ec2-transitgateway-autoacceptsharedattachments
     */
    autoAcceptSharedAttachments: string | undefined;
    /**
     * `AWS::EC2::TransitGateway.DefaultRouteTableAssociation`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgateway.html#cfn-ec2-transitgateway-defaultroutetableassociation
     */
    defaultRouteTableAssociation: string | undefined;
    /**
     * `AWS::EC2::TransitGateway.DefaultRouteTablePropagation`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgateway.html#cfn-ec2-transitgateway-defaultroutetablepropagation
     */
    defaultRouteTablePropagation: string | undefined;
    /**
     * `AWS::EC2::TransitGateway.Description`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgateway.html#cfn-ec2-transitgateway-description
     */
    description: string | undefined;
    /**
     * `AWS::EC2::TransitGateway.DnsSupport`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgateway.html#cfn-ec2-transitgateway-dnssupport
     */
    dnsSupport: string | undefined;
    /**
     * `AWS::EC2::TransitGateway.MulticastSupport`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgateway.html#cfn-ec2-transitgateway-multicastsupport
     */
    multicastSupport: string | undefined;
    /**
     * `AWS::EC2::TransitGateway.PropagationDefaultRouteTableId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgateway.html#cfn-ec2-transitgateway-propagationdefaultroutetableid
     */
    propagationDefaultRouteTableId: string | undefined;
    /**
     * `AWS::EC2::TransitGateway.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgateway.html#cfn-ec2-transitgateway-tags
     */
    readonly tags: cdk.TagManager;
    /**
     * `AWS::EC2::TransitGateway.TransitGatewayCidrBlocks`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgateway.html#cfn-ec2-transitgateway-transitgatewaycidrblocks
     */
    transitGatewayCidrBlocks: string[] | undefined;
    /**
     * `AWS::EC2::TransitGateway.VpnEcmpSupport`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgateway.html#cfn-ec2-transitgateway-vpnecmpsupport
     */
    vpnEcmpSupport: string | undefined;
    /**
     * Create a new `AWS::EC2::TransitGateway`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props?: CfnTransitGatewayProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @external
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::EC2::TransitGatewayAttachment`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgatewayattachment.html
 */
export interface CfnTransitGatewayAttachmentProps {
    /**
     * `AWS::EC2::TransitGatewayAttachment.SubnetIds`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgatewayattachment.html#cfn-ec2-transitgatewayattachment-subnetids
     */
    readonly subnetIds: string[];
    /**
     * `AWS::EC2::TransitGatewayAttachment.TransitGatewayId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgatewayattachment.html#cfn-ec2-transitgatewayattachment-transitgatewayid
     */
    readonly transitGatewayId: string;
    /**
     * `AWS::EC2::TransitGatewayAttachment.VpcId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgatewayattachment.html#cfn-ec2-transitgatewayattachment-vpcid
     */
    readonly vpcId: string;
    /**
     * `AWS::EC2::TransitGatewayAttachment.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgatewayattachment.html#cfn-ec2-transitgatewayattachment-tags
     */
    readonly tags?: cdk.CfnTag[];
}
/**
 * A CloudFormation `AWS::EC2::TransitGatewayAttachment`.
 *
 * @external
 * @cloudformationResource AWS::EC2::TransitGatewayAttachment
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgatewayattachment.html
 */
export declare class CfnTransitGatewayAttachment extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::EC2::TransitGatewayAttachment";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnTransitGatewayAttachment;
    /**
     * `AWS::EC2::TransitGatewayAttachment.SubnetIds`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgatewayattachment.html#cfn-ec2-transitgatewayattachment-subnetids
     */
    subnetIds: string[];
    /**
     * `AWS::EC2::TransitGatewayAttachment.TransitGatewayId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgatewayattachment.html#cfn-ec2-transitgatewayattachment-transitgatewayid
     */
    transitGatewayId: string;
    /**
     * `AWS::EC2::TransitGatewayAttachment.VpcId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgatewayattachment.html#cfn-ec2-transitgatewayattachment-vpcid
     */
    vpcId: string;
    /**
     * `AWS::EC2::TransitGatewayAttachment.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgatewayattachment.html#cfn-ec2-transitgatewayattachment-tags
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::EC2::TransitGatewayAttachment`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnTransitGatewayAttachmentProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @external
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::EC2::TransitGatewayConnect`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgatewayconnect.html
 */
export interface CfnTransitGatewayConnectProps {
    /**
     * `AWS::EC2::TransitGatewayConnect.Options`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgatewayconnect.html#cfn-ec2-transitgatewayconnect-options
     */
    readonly options: CfnTransitGatewayConnect.TransitGatewayConnectOptionsProperty | cdk.IResolvable;
    /**
     * `AWS::EC2::TransitGatewayConnect.TransportTransitGatewayAttachmentId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgatewayconnect.html#cfn-ec2-transitgatewayconnect-transporttransitgatewayattachmentid
     */
    readonly transportTransitGatewayAttachmentId: string;
    /**
     * `AWS::EC2::TransitGatewayConnect.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgatewayconnect.html#cfn-ec2-transitgatewayconnect-tags
     */
    readonly tags?: cdk.CfnTag[];
}
/**
 * A CloudFormation `AWS::EC2::TransitGatewayConnect`.
 *
 * @external
 * @cloudformationResource AWS::EC2::TransitGatewayConnect
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgatewayconnect.html
 */
export declare class CfnTransitGatewayConnect extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::EC2::TransitGatewayConnect";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnTransitGatewayConnect;
    /**
     * @external
     * @cloudformationAttribute CreationTime
     */
    readonly attrCreationTime: string;
    /**
     * @external
     * @cloudformationAttribute State
     */
    readonly attrState: string;
    /**
     * @external
     * @cloudformationAttribute TransitGatewayAttachmentId
     */
    readonly attrTransitGatewayAttachmentId: string;
    /**
     * @external
     * @cloudformationAttribute TransitGatewayId
     */
    readonly attrTransitGatewayId: string;
    /**
     * `AWS::EC2::TransitGatewayConnect.Options`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgatewayconnect.html#cfn-ec2-transitgatewayconnect-options
     */
    options: CfnTransitGatewayConnect.TransitGatewayConnectOptionsProperty | cdk.IResolvable;
    /**
     * `AWS::EC2::TransitGatewayConnect.TransportTransitGatewayAttachmentId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgatewayconnect.html#cfn-ec2-transitgatewayconnect-transporttransitgatewayattachmentid
     */
    transportTransitGatewayAttachmentId: string;
    /**
     * `AWS::EC2::TransitGatewayConnect.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgatewayconnect.html#cfn-ec2-transitgatewayconnect-tags
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::EC2::TransitGatewayConnect`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnTransitGatewayConnectProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @external
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::EC2::TransitGatewayConnect`.
 *
 * @external
 * @cloudformationResource AWS::EC2::TransitGatewayConnect
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgatewayconnect.html
 */
export declare namespace CfnTransitGatewayConnect {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-transitgatewayconnect-transitgatewayconnectoptions.html
     */
    interface TransitGatewayConnectOptionsProperty {
        /**
         * `CfnTransitGatewayConnect.TransitGatewayConnectOptionsProperty.Protocol`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-transitgatewayconnect-transitgatewayconnectoptions.html#cfn-ec2-transitgatewayconnect-transitgatewayconnectoptions-protocol
         */
        readonly protocol?: string;
    }
}
/**
 * Properties for defining a `AWS::EC2::TransitGatewayMulticastDomain`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgatewaymulticastdomain.html
 */
export interface CfnTransitGatewayMulticastDomainProps {
    /**
     * `AWS::EC2::TransitGatewayMulticastDomain.TransitGatewayId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgatewaymulticastdomain.html#cfn-ec2-transitgatewaymulticastdomain-transitgatewayid
     */
    readonly transitGatewayId: string;
    /**
     * `AWS::EC2::TransitGatewayMulticastDomain.Options`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgatewaymulticastdomain.html#cfn-ec2-transitgatewaymulticastdomain-options
     */
    readonly options?: any | cdk.IResolvable;
    /**
     * `AWS::EC2::TransitGatewayMulticastDomain.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgatewaymulticastdomain.html#cfn-ec2-transitgatewaymulticastdomain-tags
     */
    readonly tags?: cdk.CfnTag[];
}
/**
 * A CloudFormation `AWS::EC2::TransitGatewayMulticastDomain`.
 *
 * @external
 * @cloudformationResource AWS::EC2::TransitGatewayMulticastDomain
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgatewaymulticastdomain.html
 */
export declare class CfnTransitGatewayMulticastDomain extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::EC2::TransitGatewayMulticastDomain";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnTransitGatewayMulticastDomain;
    /**
     * @external
     * @cloudformationAttribute CreationTime
     */
    readonly attrCreationTime: string;
    /**
     * @external
     * @cloudformationAttribute State
     */
    readonly attrState: string;
    /**
     * @external
     * @cloudformationAttribute TransitGatewayMulticastDomainArn
     */
    readonly attrTransitGatewayMulticastDomainArn: string;
    /**
     * @external
     * @cloudformationAttribute TransitGatewayMulticastDomainId
     */
    readonly attrTransitGatewayMulticastDomainId: string;
    /**
     * `AWS::EC2::TransitGatewayMulticastDomain.TransitGatewayId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgatewaymulticastdomain.html#cfn-ec2-transitgatewaymulticastdomain-transitgatewayid
     */
    transitGatewayId: string;
    /**
     * `AWS::EC2::TransitGatewayMulticastDomain.Options`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgatewaymulticastdomain.html#cfn-ec2-transitgatewaymulticastdomain-options
     */
    options: any | cdk.IResolvable | undefined;
    /**
     * `AWS::EC2::TransitGatewayMulticastDomain.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgatewaymulticastdomain.html#cfn-ec2-transitgatewaymulticastdomain-tags
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::EC2::TransitGatewayMulticastDomain`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnTransitGatewayMulticastDomainProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @external
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::EC2::TransitGatewayMulticastDomainAssociation`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgatewaymulticastdomainassociation.html
 */
export interface CfnTransitGatewayMulticastDomainAssociationProps {
    /**
     * `AWS::EC2::TransitGatewayMulticastDomainAssociation.SubnetId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgatewaymulticastdomainassociation.html#cfn-ec2-transitgatewaymulticastdomainassociation-subnetid
     */
    readonly subnetId: string;
    /**
     * `AWS::EC2::TransitGatewayMulticastDomainAssociation.TransitGatewayAttachmentId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgatewaymulticastdomainassociation.html#cfn-ec2-transitgatewaymulticastdomainassociation-transitgatewayattachmentid
     */
    readonly transitGatewayAttachmentId: string;
    /**
     * `AWS::EC2::TransitGatewayMulticastDomainAssociation.TransitGatewayMulticastDomainId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgatewaymulticastdomainassociation.html#cfn-ec2-transitgatewaymulticastdomainassociation-transitgatewaymulticastdomainid
     */
    readonly transitGatewayMulticastDomainId: string;
}
/**
 * A CloudFormation `AWS::EC2::TransitGatewayMulticastDomainAssociation`.
 *
 * @external
 * @cloudformationResource AWS::EC2::TransitGatewayMulticastDomainAssociation
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgatewaymulticastdomainassociation.html
 */
export declare class CfnTransitGatewayMulticastDomainAssociation extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::EC2::TransitGatewayMulticastDomainAssociation";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnTransitGatewayMulticastDomainAssociation;
    /**
     * @external
     * @cloudformationAttribute ResourceId
     */
    readonly attrResourceId: string;
    /**
     * @external
     * @cloudformationAttribute ResourceType
     */
    readonly attrResourceType: string;
    /**
     * @external
     * @cloudformationAttribute State
     */
    readonly attrState: string;
    /**
     * `AWS::EC2::TransitGatewayMulticastDomainAssociation.SubnetId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgatewaymulticastdomainassociation.html#cfn-ec2-transitgatewaymulticastdomainassociation-subnetid
     */
    subnetId: string;
    /**
     * `AWS::EC2::TransitGatewayMulticastDomainAssociation.TransitGatewayAttachmentId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgatewaymulticastdomainassociation.html#cfn-ec2-transitgatewaymulticastdomainassociation-transitgatewayattachmentid
     */
    transitGatewayAttachmentId: string;
    /**
     * `AWS::EC2::TransitGatewayMulticastDomainAssociation.TransitGatewayMulticastDomainId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgatewaymulticastdomainassociation.html#cfn-ec2-transitgatewaymulticastdomainassociation-transitgatewaymulticastdomainid
     */
    transitGatewayMulticastDomainId: string;
    /**
     * Create a new `AWS::EC2::TransitGatewayMulticastDomainAssociation`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnTransitGatewayMulticastDomainAssociationProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @external
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::EC2::TransitGatewayMulticastGroupMember`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgatewaymulticastgroupmember.html
 */
export interface CfnTransitGatewayMulticastGroupMemberProps {
    /**
     * `AWS::EC2::TransitGatewayMulticastGroupMember.GroupIpAddress`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgatewaymulticastgroupmember.html#cfn-ec2-transitgatewaymulticastgroupmember-groupipaddress
     */
    readonly groupIpAddress: string;
    /**
     * `AWS::EC2::TransitGatewayMulticastGroupMember.NetworkInterfaceId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgatewaymulticastgroupmember.html#cfn-ec2-transitgatewaymulticastgroupmember-networkinterfaceid
     */
    readonly networkInterfaceId: string;
    /**
     * `AWS::EC2::TransitGatewayMulticastGroupMember.TransitGatewayMulticastDomainId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgatewaymulticastgroupmember.html#cfn-ec2-transitgatewaymulticastgroupmember-transitgatewaymulticastdomainid
     */
    readonly transitGatewayMulticastDomainId: string;
}
/**
 * A CloudFormation `AWS::EC2::TransitGatewayMulticastGroupMember`.
 *
 * @external
 * @cloudformationResource AWS::EC2::TransitGatewayMulticastGroupMember
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgatewaymulticastgroupmember.html
 */
export declare class CfnTransitGatewayMulticastGroupMember extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::EC2::TransitGatewayMulticastGroupMember";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnTransitGatewayMulticastGroupMember;
    /**
     * @external
     * @cloudformationAttribute GroupMember
     */
    readonly attrGroupMember: cdk.IResolvable;
    /**
     * @external
     * @cloudformationAttribute GroupSource
     */
    readonly attrGroupSource: cdk.IResolvable;
    /**
     * @external
     * @cloudformationAttribute MemberType
     */
    readonly attrMemberType: string;
    /**
     * @external
     * @cloudformationAttribute ResourceId
     */
    readonly attrResourceId: string;
    /**
     * @external
     * @cloudformationAttribute ResourceType
     */
    readonly attrResourceType: string;
    /**
     * @external
     * @cloudformationAttribute SourceType
     */
    readonly attrSourceType: string;
    /**
     * @external
     * @cloudformationAttribute SubnetId
     */
    readonly attrSubnetId: string;
    /**
     * @external
     * @cloudformationAttribute TransitGatewayAttachmentId
     */
    readonly attrTransitGatewayAttachmentId: string;
    /**
     * `AWS::EC2::TransitGatewayMulticastGroupMember.GroupIpAddress`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgatewaymulticastgroupmember.html#cfn-ec2-transitgatewaymulticastgroupmember-groupipaddress
     */
    groupIpAddress: string;
    /**
     * `AWS::EC2::TransitGatewayMulticastGroupMember.NetworkInterfaceId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgatewaymulticastgroupmember.html#cfn-ec2-transitgatewaymulticastgroupmember-networkinterfaceid
     */
    networkInterfaceId: string;
    /**
     * `AWS::EC2::TransitGatewayMulticastGroupMember.TransitGatewayMulticastDomainId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgatewaymulticastgroupmember.html#cfn-ec2-transitgatewaymulticastgroupmember-transitgatewaymulticastdomainid
     */
    transitGatewayMulticastDomainId: string;
    /**
     * Create a new `AWS::EC2::TransitGatewayMulticastGroupMember`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnTransitGatewayMulticastGroupMemberProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @external
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::EC2::TransitGatewayMulticastGroupSource`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgatewaymulticastgroupsource.html
 */
export interface CfnTransitGatewayMulticastGroupSourceProps {
    /**
     * `AWS::EC2::TransitGatewayMulticastGroupSource.GroupIpAddress`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgatewaymulticastgroupsource.html#cfn-ec2-transitgatewaymulticastgroupsource-groupipaddress
     */
    readonly groupIpAddress: string;
    /**
     * `AWS::EC2::TransitGatewayMulticastGroupSource.NetworkInterfaceId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgatewaymulticastgroupsource.html#cfn-ec2-transitgatewaymulticastgroupsource-networkinterfaceid
     */
    readonly networkInterfaceId: string;
    /**
     * `AWS::EC2::TransitGatewayMulticastGroupSource.TransitGatewayMulticastDomainId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgatewaymulticastgroupsource.html#cfn-ec2-transitgatewaymulticastgroupsource-transitgatewaymulticastdomainid
     */
    readonly transitGatewayMulticastDomainId: string;
}
/**
 * A CloudFormation `AWS::EC2::TransitGatewayMulticastGroupSource`.
 *
 * @external
 * @cloudformationResource AWS::EC2::TransitGatewayMulticastGroupSource
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgatewaymulticastgroupsource.html
 */
export declare class CfnTransitGatewayMulticastGroupSource extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::EC2::TransitGatewayMulticastGroupSource";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnTransitGatewayMulticastGroupSource;
    /**
     * @external
     * @cloudformationAttribute GroupMember
     */
    readonly attrGroupMember: cdk.IResolvable;
    /**
     * @external
     * @cloudformationAttribute GroupSource
     */
    readonly attrGroupSource: cdk.IResolvable;
    /**
     * @external
     * @cloudformationAttribute MemberType
     */
    readonly attrMemberType: string;
    /**
     * @external
     * @cloudformationAttribute ResourceId
     */
    readonly attrResourceId: string;
    /**
     * @external
     * @cloudformationAttribute ResourceType
     */
    readonly attrResourceType: string;
    /**
     * @external
     * @cloudformationAttribute SourceType
     */
    readonly attrSourceType: string;
    /**
     * @external
     * @cloudformationAttribute SubnetId
     */
    readonly attrSubnetId: string;
    /**
     * @external
     * @cloudformationAttribute TransitGatewayAttachmentId
     */
    readonly attrTransitGatewayAttachmentId: string;
    /**
     * `AWS::EC2::TransitGatewayMulticastGroupSource.GroupIpAddress`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgatewaymulticastgroupsource.html#cfn-ec2-transitgatewaymulticastgroupsource-groupipaddress
     */
    groupIpAddress: string;
    /**
     * `AWS::EC2::TransitGatewayMulticastGroupSource.NetworkInterfaceId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgatewaymulticastgroupsource.html#cfn-ec2-transitgatewaymulticastgroupsource-networkinterfaceid
     */
    networkInterfaceId: string;
    /**
     * `AWS::EC2::TransitGatewayMulticastGroupSource.TransitGatewayMulticastDomainId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgatewaymulticastgroupsource.html#cfn-ec2-transitgatewaymulticastgroupsource-transitgatewaymulticastdomainid
     */
    transitGatewayMulticastDomainId: string;
    /**
     * Create a new `AWS::EC2::TransitGatewayMulticastGroupSource`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnTransitGatewayMulticastGroupSourceProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @external
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::EC2::TransitGatewayPeeringAttachment`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgatewaypeeringattachment.html
 */
export interface CfnTransitGatewayPeeringAttachmentProps {
    /**
     * `AWS::EC2::TransitGatewayPeeringAttachment.PeerAccountId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgatewaypeeringattachment.html#cfn-ec2-transitgatewaypeeringattachment-peeraccountid
     */
    readonly peerAccountId: string;
    /**
     * `AWS::EC2::TransitGatewayPeeringAttachment.PeerRegion`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgatewaypeeringattachment.html#cfn-ec2-transitgatewaypeeringattachment-peerregion
     */
    readonly peerRegion: string;
    /**
     * `AWS::EC2::TransitGatewayPeeringAttachment.PeerTransitGatewayId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgatewaypeeringattachment.html#cfn-ec2-transitgatewaypeeringattachment-peertransitgatewayid
     */
    readonly peerTransitGatewayId: string;
    /**
     * `AWS::EC2::TransitGatewayPeeringAttachment.TransitGatewayId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgatewaypeeringattachment.html#cfn-ec2-transitgatewaypeeringattachment-transitgatewayid
     */
    readonly transitGatewayId: string;
    /**
     * `AWS::EC2::TransitGatewayPeeringAttachment.Options`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgatewaypeeringattachment.html#cfn-ec2-transitgatewaypeeringattachment-options
     */
    readonly options?: CfnTransitGatewayPeeringAttachment.TransitGatewayPeeringAttachmentOptionsProperty | cdk.IResolvable;
    /**
     * `AWS::EC2::TransitGatewayPeeringAttachment.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgatewaypeeringattachment.html#cfn-ec2-transitgatewaypeeringattachment-tags
     */
    readonly tags?: cdk.CfnTag[];
}
/**
 * A CloudFormation `AWS::EC2::TransitGatewayPeeringAttachment`.
 *
 * @external
 * @cloudformationResource AWS::EC2::TransitGatewayPeeringAttachment
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgatewaypeeringattachment.html
 */
export declare class CfnTransitGatewayPeeringAttachment extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::EC2::TransitGatewayPeeringAttachment";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnTransitGatewayPeeringAttachment;
    /**
     * @external
     * @cloudformationAttribute CreationTime
     */
    readonly attrCreationTime: string;
    /**
     * @external
     * @cloudformationAttribute State
     */
    readonly attrState: string;
    /**
     * @external
     * @cloudformationAttribute TransitGatewayAttachmentId
     */
    readonly attrTransitGatewayAttachmentId: string;
    /**
     * `AWS::EC2::TransitGatewayPeeringAttachment.PeerAccountId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgatewaypeeringattachment.html#cfn-ec2-transitgatewaypeeringattachment-peeraccountid
     */
    peerAccountId: string;
    /**
     * `AWS::EC2::TransitGatewayPeeringAttachment.PeerRegion`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgatewaypeeringattachment.html#cfn-ec2-transitgatewaypeeringattachment-peerregion
     */
    peerRegion: string;
    /**
     * `AWS::EC2::TransitGatewayPeeringAttachment.PeerTransitGatewayId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgatewaypeeringattachment.html#cfn-ec2-transitgatewaypeeringattachment-peertransitgatewayid
     */
    peerTransitGatewayId: string;
    /**
     * `AWS::EC2::TransitGatewayPeeringAttachment.TransitGatewayId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgatewaypeeringattachment.html#cfn-ec2-transitgatewaypeeringattachment-transitgatewayid
     */
    transitGatewayId: string;
    /**
     * `AWS::EC2::TransitGatewayPeeringAttachment.Options`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgatewaypeeringattachment.html#cfn-ec2-transitgatewaypeeringattachment-options
     */
    options: CfnTransitGatewayPeeringAttachment.TransitGatewayPeeringAttachmentOptionsProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::EC2::TransitGatewayPeeringAttachment.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgatewaypeeringattachment.html#cfn-ec2-transitgatewaypeeringattachment-tags
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::EC2::TransitGatewayPeeringAttachment`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnTransitGatewayPeeringAttachmentProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @external
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::EC2::TransitGatewayPeeringAttachment`.
 *
 * @external
 * @cloudformationResource AWS::EC2::TransitGatewayPeeringAttachment
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgatewaypeeringattachment.html
 */
export declare namespace CfnTransitGatewayPeeringAttachment {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-transitgatewaypeeringattachment-transitgatewaypeeringattachmentoptions.html
     */
    interface TransitGatewayPeeringAttachmentOptionsProperty {
        /**
         * `CfnTransitGatewayPeeringAttachment.TransitGatewayPeeringAttachmentOptionsProperty.DynamicRouting`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-transitgatewaypeeringattachment-transitgatewaypeeringattachmentoptions.html#cfn-ec2-transitgatewaypeeringattachment-transitgatewaypeeringattachmentoptions-dynamicrouting
         */
        readonly dynamicRouting?: string;
    }
}
/**
 * Properties for defining a `AWS::EC2::TransitGatewayRoute`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgatewayroute.html
 */
export interface CfnTransitGatewayRouteProps {
    /**
     * `AWS::EC2::TransitGatewayRoute.TransitGatewayRouteTableId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgatewayroute.html#cfn-ec2-transitgatewayroute-transitgatewayroutetableid
     */
    readonly transitGatewayRouteTableId: string;
    /**
     * `AWS::EC2::TransitGatewayRoute.Blackhole`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgatewayroute.html#cfn-ec2-transitgatewayroute-blackhole
     */
    readonly blackhole?: boolean | cdk.IResolvable;
    /**
     * `AWS::EC2::TransitGatewayRoute.DestinationCidrBlock`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgatewayroute.html#cfn-ec2-transitgatewayroute-destinationcidrblock
     */
    readonly destinationCidrBlock?: string;
    /**
     * `AWS::EC2::TransitGatewayRoute.TransitGatewayAttachmentId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgatewayroute.html#cfn-ec2-transitgatewayroute-transitgatewayattachmentid
     */
    readonly transitGatewayAttachmentId?: string;
}
/**
 * A CloudFormation `AWS::EC2::TransitGatewayRoute`.
 *
 * @external
 * @cloudformationResource AWS::EC2::TransitGatewayRoute
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgatewayroute.html
 */
export declare class CfnTransitGatewayRoute extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::EC2::TransitGatewayRoute";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnTransitGatewayRoute;
    /**
     * `AWS::EC2::TransitGatewayRoute.TransitGatewayRouteTableId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgatewayroute.html#cfn-ec2-transitgatewayroute-transitgatewayroutetableid
     */
    transitGatewayRouteTableId: string;
    /**
     * `AWS::EC2::TransitGatewayRoute.Blackhole`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgatewayroute.html#cfn-ec2-transitgatewayroute-blackhole
     */
    blackhole: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::EC2::TransitGatewayRoute.DestinationCidrBlock`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgatewayroute.html#cfn-ec2-transitgatewayroute-destinationcidrblock
     */
    destinationCidrBlock: string | undefined;
    /**
     * `AWS::EC2::TransitGatewayRoute.TransitGatewayAttachmentId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgatewayroute.html#cfn-ec2-transitgatewayroute-transitgatewayattachmentid
     */
    transitGatewayAttachmentId: string | undefined;
    /**
     * Create a new `AWS::EC2::TransitGatewayRoute`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnTransitGatewayRouteProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @external
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::EC2::TransitGatewayRouteTable`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgatewayroutetable.html
 */
export interface CfnTransitGatewayRouteTableProps {
    /**
     * `AWS::EC2::TransitGatewayRouteTable.TransitGatewayId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgatewayroutetable.html#cfn-ec2-transitgatewayroutetable-transitgatewayid
     */
    readonly transitGatewayId: string;
    /**
     * `AWS::EC2::TransitGatewayRouteTable.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgatewayroutetable.html#cfn-ec2-transitgatewayroutetable-tags
     */
    readonly tags?: cdk.CfnTag[];
}
/**
 * A CloudFormation `AWS::EC2::TransitGatewayRouteTable`.
 *
 * @external
 * @cloudformationResource AWS::EC2::TransitGatewayRouteTable
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgatewayroutetable.html
 */
export declare class CfnTransitGatewayRouteTable extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::EC2::TransitGatewayRouteTable";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnTransitGatewayRouteTable;
    /**
     * `AWS::EC2::TransitGatewayRouteTable.TransitGatewayId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgatewayroutetable.html#cfn-ec2-transitgatewayroutetable-transitgatewayid
     */
    transitGatewayId: string;
    /**
     * `AWS::EC2::TransitGatewayRouteTable.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgatewayroutetable.html#cfn-ec2-transitgatewayroutetable-tags
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::EC2::TransitGatewayRouteTable`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnTransitGatewayRouteTableProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @external
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::EC2::TransitGatewayRouteTableAssociation`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgatewayroutetableassociation.html
 */
export interface CfnTransitGatewayRouteTableAssociationProps {
    /**
     * `AWS::EC2::TransitGatewayRouteTableAssociation.TransitGatewayAttachmentId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgatewayroutetableassociation.html#cfn-ec2-transitgatewayroutetableassociation-transitgatewayattachmentid
     */
    readonly transitGatewayAttachmentId: string;
    /**
     * `AWS::EC2::TransitGatewayRouteTableAssociation.TransitGatewayRouteTableId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgatewayroutetableassociation.html#cfn-ec2-transitgatewayroutetableassociation-transitgatewayroutetableid
     */
    readonly transitGatewayRouteTableId: string;
}
/**
 * A CloudFormation `AWS::EC2::TransitGatewayRouteTableAssociation`.
 *
 * @external
 * @cloudformationResource AWS::EC2::TransitGatewayRouteTableAssociation
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgatewayroutetableassociation.html
 */
export declare class CfnTransitGatewayRouteTableAssociation extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::EC2::TransitGatewayRouteTableAssociation";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnTransitGatewayRouteTableAssociation;
    /**
     * `AWS::EC2::TransitGatewayRouteTableAssociation.TransitGatewayAttachmentId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgatewayroutetableassociation.html#cfn-ec2-transitgatewayroutetableassociation-transitgatewayattachmentid
     */
    transitGatewayAttachmentId: string;
    /**
     * `AWS::EC2::TransitGatewayRouteTableAssociation.TransitGatewayRouteTableId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgatewayroutetableassociation.html#cfn-ec2-transitgatewayroutetableassociation-transitgatewayroutetableid
     */
    transitGatewayRouteTableId: string;
    /**
     * Create a new `AWS::EC2::TransitGatewayRouteTableAssociation`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnTransitGatewayRouteTableAssociationProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @external
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::EC2::TransitGatewayRouteTablePropagation`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgatewayroutetablepropagation.html
 */
export interface CfnTransitGatewayRouteTablePropagationProps {
    /**
     * `AWS::EC2::TransitGatewayRouteTablePropagation.TransitGatewayAttachmentId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgatewayroutetablepropagation.html#cfn-ec2-transitgatewayroutetablepropagation-transitgatewayattachmentid
     */
    readonly transitGatewayAttachmentId: string;
    /**
     * `AWS::EC2::TransitGatewayRouteTablePropagation.TransitGatewayRouteTableId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgatewayroutetablepropagation.html#cfn-ec2-transitgatewayroutetablepropagation-transitgatewayroutetableid
     */
    readonly transitGatewayRouteTableId: string;
}
/**
 * A CloudFormation `AWS::EC2::TransitGatewayRouteTablePropagation`.
 *
 * @external
 * @cloudformationResource AWS::EC2::TransitGatewayRouteTablePropagation
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgatewayroutetablepropagation.html
 */
export declare class CfnTransitGatewayRouteTablePropagation extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::EC2::TransitGatewayRouteTablePropagation";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnTransitGatewayRouteTablePropagation;
    /**
     * `AWS::EC2::TransitGatewayRouteTablePropagation.TransitGatewayAttachmentId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgatewayroutetablepropagation.html#cfn-ec2-transitgatewayroutetablepropagation-transitgatewayattachmentid
     */
    transitGatewayAttachmentId: string;
    /**
     * `AWS::EC2::TransitGatewayRouteTablePropagation.TransitGatewayRouteTableId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgatewayroutetablepropagation.html#cfn-ec2-transitgatewayroutetablepropagation-transitgatewayroutetableid
     */
    transitGatewayRouteTableId: string;
    /**
     * Create a new `AWS::EC2::TransitGatewayRouteTablePropagation`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnTransitGatewayRouteTablePropagationProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @external
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::EC2::TransitGatewayVpcAttachment`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgatewayvpcattachment.html
 */
export interface CfnTransitGatewayVpcAttachmentProps {
    /**
     * `AWS::EC2::TransitGatewayVpcAttachment.AddSubnetIds`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgatewayvpcattachment.html#cfn-ec2-transitgatewayvpcattachment-addsubnetids
     */
    readonly addSubnetIds?: string[];
    /**
     * `AWS::EC2::TransitGatewayVpcAttachment.Options`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgatewayvpcattachment.html#cfn-ec2-transitgatewayvpcattachment-options
     */
    readonly options?: any | cdk.IResolvable;
    /**
     * `AWS::EC2::TransitGatewayVpcAttachment.RemoveSubnetIds`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgatewayvpcattachment.html#cfn-ec2-transitgatewayvpcattachment-removesubnetids
     */
    readonly removeSubnetIds?: string[];
    /**
     * `AWS::EC2::TransitGatewayVpcAttachment.SubnetIds`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgatewayvpcattachment.html#cfn-ec2-transitgatewayvpcattachment-subnetids
     */
    readonly subnetIds?: string[];
    /**
     * `AWS::EC2::TransitGatewayVpcAttachment.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgatewayvpcattachment.html#cfn-ec2-transitgatewayvpcattachment-tags
     */
    readonly tags?: cdk.CfnTag[];
    /**
     * `AWS::EC2::TransitGatewayVpcAttachment.TransitGatewayId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgatewayvpcattachment.html#cfn-ec2-transitgatewayvpcattachment-transitgatewayid
     */
    readonly transitGatewayId?: string;
    /**
     * `AWS::EC2::TransitGatewayVpcAttachment.VpcId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgatewayvpcattachment.html#cfn-ec2-transitgatewayvpcattachment-vpcid
     */
    readonly vpcId?: string;
}
/**
 * A CloudFormation `AWS::EC2::TransitGatewayVpcAttachment`.
 *
 * @external
 * @cloudformationResource AWS::EC2::TransitGatewayVpcAttachment
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgatewayvpcattachment.html
 */
export declare class CfnTransitGatewayVpcAttachment extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::EC2::TransitGatewayVpcAttachment";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnTransitGatewayVpcAttachment;
    /**
     * @external
     * @cloudformationAttribute Id
     */
    readonly attrId: string;
    /**
     * `AWS::EC2::TransitGatewayVpcAttachment.AddSubnetIds`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgatewayvpcattachment.html#cfn-ec2-transitgatewayvpcattachment-addsubnetids
     */
    addSubnetIds: string[] | undefined;
    /**
     * `AWS::EC2::TransitGatewayVpcAttachment.Options`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgatewayvpcattachment.html#cfn-ec2-transitgatewayvpcattachment-options
     */
    options: any | cdk.IResolvable | undefined;
    /**
     * `AWS::EC2::TransitGatewayVpcAttachment.RemoveSubnetIds`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgatewayvpcattachment.html#cfn-ec2-transitgatewayvpcattachment-removesubnetids
     */
    removeSubnetIds: string[] | undefined;
    /**
     * `AWS::EC2::TransitGatewayVpcAttachment.SubnetIds`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgatewayvpcattachment.html#cfn-ec2-transitgatewayvpcattachment-subnetids
     */
    subnetIds: string[] | undefined;
    /**
     * `AWS::EC2::TransitGatewayVpcAttachment.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgatewayvpcattachment.html#cfn-ec2-transitgatewayvpcattachment-tags
     */
    readonly tags: cdk.TagManager;
    /**
     * `AWS::EC2::TransitGatewayVpcAttachment.TransitGatewayId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgatewayvpcattachment.html#cfn-ec2-transitgatewayvpcattachment-transitgatewayid
     */
    transitGatewayId: string | undefined;
    /**
     * `AWS::EC2::TransitGatewayVpcAttachment.VpcId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgatewayvpcattachment.html#cfn-ec2-transitgatewayvpcattachment-vpcid
     */
    vpcId: string | undefined;
    /**
     * Create a new `AWS::EC2::TransitGatewayVpcAttachment`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props?: CfnTransitGatewayVpcAttachmentProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @external
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::EC2::VPC`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpc.html
 */
export interface CfnVPCProps {
    /**
     * `AWS::EC2::VPC.CidrBlock`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpc.html#cfn-aws-ec2-vpc-cidrblock
     */
    readonly cidrBlock: string;
    /**
     * `AWS::EC2::VPC.EnableDnsHostnames`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpc.html#cfn-aws-ec2-vpc-EnableDnsHostnames
     */
    readonly enableDnsHostnames?: boolean | cdk.IResolvable;
    /**
     * `AWS::EC2::VPC.EnableDnsSupport`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpc.html#cfn-aws-ec2-vpc-EnableDnsSupport
     */
    readonly enableDnsSupport?: boolean | cdk.IResolvable;
    /**
     * `AWS::EC2::VPC.InstanceTenancy`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpc.html#cfn-aws-ec2-vpc-instancetenancy
     */
    readonly instanceTenancy?: string;
    /**
     * `AWS::EC2::VPC.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpc.html#cfn-aws-ec2-vpc-tags
     */
    readonly tags?: cdk.CfnTag[];
}
/**
 * A CloudFormation `AWS::EC2::VPC`.
 *
 * @external
 * @cloudformationResource AWS::EC2::VPC
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpc.html
 */
export declare class CfnVPC extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::EC2::VPC";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnVPC;
    /**
     * @external
     * @cloudformationAttribute CidrBlock
     */
    readonly attrCidrBlock: string;
    /**
     * @external
     * @cloudformationAttribute CidrBlockAssociations
     */
    readonly attrCidrBlockAssociations: string[];
    /**
     * @external
     * @cloudformationAttribute DefaultNetworkAcl
     */
    readonly attrDefaultNetworkAcl: string;
    /**
     * @external
     * @cloudformationAttribute DefaultSecurityGroup
     */
    readonly attrDefaultSecurityGroup: string;
    /**
     * @external
     * @cloudformationAttribute Ipv6CidrBlocks
     */
    readonly attrIpv6CidrBlocks: string[];
    /**
     * `AWS::EC2::VPC.CidrBlock`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpc.html#cfn-aws-ec2-vpc-cidrblock
     */
    cidrBlock: string;
    /**
     * `AWS::EC2::VPC.EnableDnsHostnames`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpc.html#cfn-aws-ec2-vpc-EnableDnsHostnames
     */
    enableDnsHostnames: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::EC2::VPC.EnableDnsSupport`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpc.html#cfn-aws-ec2-vpc-EnableDnsSupport
     */
    enableDnsSupport: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::EC2::VPC.InstanceTenancy`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpc.html#cfn-aws-ec2-vpc-instancetenancy
     */
    instanceTenancy: string | undefined;
    /**
     * `AWS::EC2::VPC.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpc.html#cfn-aws-ec2-vpc-tags
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::EC2::VPC`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnVPCProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @external
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::EC2::VPCCidrBlock`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpccidrblock.html
 */
export interface CfnVPCCidrBlockProps {
    /**
     * `AWS::EC2::VPCCidrBlock.VpcId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpccidrblock.html#cfn-ec2-vpccidrblock-vpcid
     */
    readonly vpcId: string;
    /**
     * `AWS::EC2::VPCCidrBlock.AmazonProvidedIpv6CidrBlock`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpccidrblock.html#cfn-ec2-vpccidrblock-amazonprovidedipv6cidrblock
     */
    readonly amazonProvidedIpv6CidrBlock?: boolean | cdk.IResolvable;
    /**
     * `AWS::EC2::VPCCidrBlock.CidrBlock`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpccidrblock.html#cfn-ec2-vpccidrblock-cidrblock
     */
    readonly cidrBlock?: string;
    /**
     * `AWS::EC2::VPCCidrBlock.Ipv6CidrBlock`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpccidrblock.html#cfn-ec2-vpccidrblock-ipv6cidrblock
     */
    readonly ipv6CidrBlock?: string;
    /**
     * `AWS::EC2::VPCCidrBlock.Ipv6Pool`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpccidrblock.html#cfn-ec2-vpccidrblock-ipv6pool
     */
    readonly ipv6Pool?: string;
}
/**
 * A CloudFormation `AWS::EC2::VPCCidrBlock`.
 *
 * @external
 * @cloudformationResource AWS::EC2::VPCCidrBlock
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpccidrblock.html
 */
export declare class CfnVPCCidrBlock extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::EC2::VPCCidrBlock";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnVPCCidrBlock;
    /**
     * `AWS::EC2::VPCCidrBlock.VpcId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpccidrblock.html#cfn-ec2-vpccidrblock-vpcid
     */
    vpcId: string;
    /**
     * `AWS::EC2::VPCCidrBlock.AmazonProvidedIpv6CidrBlock`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpccidrblock.html#cfn-ec2-vpccidrblock-amazonprovidedipv6cidrblock
     */
    amazonProvidedIpv6CidrBlock: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::EC2::VPCCidrBlock.CidrBlock`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpccidrblock.html#cfn-ec2-vpccidrblock-cidrblock
     */
    cidrBlock: string | undefined;
    /**
     * `AWS::EC2::VPCCidrBlock.Ipv6CidrBlock`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpccidrblock.html#cfn-ec2-vpccidrblock-ipv6cidrblock
     */
    ipv6CidrBlock: string | undefined;
    /**
     * `AWS::EC2::VPCCidrBlock.Ipv6Pool`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpccidrblock.html#cfn-ec2-vpccidrblock-ipv6pool
     */
    ipv6Pool: string | undefined;
    /**
     * Create a new `AWS::EC2::VPCCidrBlock`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnVPCCidrBlockProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @external
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::EC2::VPCDHCPOptionsAssociation`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcdhcpoptionsassociation.html
 */
export interface CfnVPCDHCPOptionsAssociationProps {
    /**
     * `AWS::EC2::VPCDHCPOptionsAssociation.DhcpOptionsId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcdhcpoptionsassociation.html#cfn-ec2-vpcdhcpoptionsassociation-dhcpoptionsid
     */
    readonly dhcpOptionsId: string;
    /**
     * `AWS::EC2::VPCDHCPOptionsAssociation.VpcId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcdhcpoptionsassociation.html#cfn-ec2-vpcdhcpoptionsassociation-vpcid
     */
    readonly vpcId: string;
}
/**
 * A CloudFormation `AWS::EC2::VPCDHCPOptionsAssociation`.
 *
 * @external
 * @cloudformationResource AWS::EC2::VPCDHCPOptionsAssociation
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcdhcpoptionsassociation.html
 */
export declare class CfnVPCDHCPOptionsAssociation extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::EC2::VPCDHCPOptionsAssociation";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnVPCDHCPOptionsAssociation;
    /**
     * @external
     * @cloudformationAttribute Id
     */
    readonly attrId: string;
    /**
     * `AWS::EC2::VPCDHCPOptionsAssociation.DhcpOptionsId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcdhcpoptionsassociation.html#cfn-ec2-vpcdhcpoptionsassociation-dhcpoptionsid
     */
    dhcpOptionsId: string;
    /**
     * `AWS::EC2::VPCDHCPOptionsAssociation.VpcId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcdhcpoptionsassociation.html#cfn-ec2-vpcdhcpoptionsassociation-vpcid
     */
    vpcId: string;
    /**
     * Create a new `AWS::EC2::VPCDHCPOptionsAssociation`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnVPCDHCPOptionsAssociationProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @external
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::EC2::VPCEndpoint`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcendpoint.html
 */
export interface CfnVPCEndpointProps {
    /**
     * `AWS::EC2::VPCEndpoint.ServiceName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcendpoint.html#cfn-ec2-vpcendpoint-servicename
     */
    readonly serviceName: string;
    /**
     * `AWS::EC2::VPCEndpoint.VpcId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcendpoint.html#cfn-ec2-vpcendpoint-vpcid
     */
    readonly vpcId: string;
    /**
     * `AWS::EC2::VPCEndpoint.PolicyDocument`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcendpoint.html#cfn-ec2-vpcendpoint-policydocument
     */
    readonly policyDocument?: any | cdk.IResolvable;
    /**
     * `AWS::EC2::VPCEndpoint.PrivateDnsEnabled`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcendpoint.html#cfn-ec2-vpcendpoint-privatednsenabled
     */
    readonly privateDnsEnabled?: boolean | cdk.IResolvable;
    /**
     * `AWS::EC2::VPCEndpoint.RouteTableIds`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcendpoint.html#cfn-ec2-vpcendpoint-routetableids
     */
    readonly routeTableIds?: string[];
    /**
     * `AWS::EC2::VPCEndpoint.SecurityGroupIds`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcendpoint.html#cfn-ec2-vpcendpoint-securitygroupids
     */
    readonly securityGroupIds?: string[];
    /**
     * `AWS::EC2::VPCEndpoint.SubnetIds`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcendpoint.html#cfn-ec2-vpcendpoint-subnetids
     */
    readonly subnetIds?: string[];
    /**
     * `AWS::EC2::VPCEndpoint.VpcEndpointType`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcendpoint.html#cfn-ec2-vpcendpoint-vpcendpointtype
     */
    readonly vpcEndpointType?: string;
}
/**
 * A CloudFormation `AWS::EC2::VPCEndpoint`.
 *
 * @external
 * @cloudformationResource AWS::EC2::VPCEndpoint
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcendpoint.html
 */
export declare class CfnVPCEndpoint extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::EC2::VPCEndpoint";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnVPCEndpoint;
    /**
     * @external
     * @cloudformationAttribute CreationTimestamp
     */
    readonly attrCreationTimestamp: string;
    /**
     * @external
     * @cloudformationAttribute DnsEntries
     */
    readonly attrDnsEntries: string[];
    /**
     * @external
     * @cloudformationAttribute NetworkInterfaceIds
     */
    readonly attrNetworkInterfaceIds: string[];
    /**
     * `AWS::EC2::VPCEndpoint.ServiceName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcendpoint.html#cfn-ec2-vpcendpoint-servicename
     */
    serviceName: string;
    /**
     * `AWS::EC2::VPCEndpoint.VpcId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcendpoint.html#cfn-ec2-vpcendpoint-vpcid
     */
    vpcId: string;
    /**
     * `AWS::EC2::VPCEndpoint.PolicyDocument`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcendpoint.html#cfn-ec2-vpcendpoint-policydocument
     */
    policyDocument: any | cdk.IResolvable | undefined;
    /**
     * `AWS::EC2::VPCEndpoint.PrivateDnsEnabled`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcendpoint.html#cfn-ec2-vpcendpoint-privatednsenabled
     */
    privateDnsEnabled: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::EC2::VPCEndpoint.RouteTableIds`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcendpoint.html#cfn-ec2-vpcendpoint-routetableids
     */
    routeTableIds: string[] | undefined;
    /**
     * `AWS::EC2::VPCEndpoint.SecurityGroupIds`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcendpoint.html#cfn-ec2-vpcendpoint-securitygroupids
     */
    securityGroupIds: string[] | undefined;
    /**
     * `AWS::EC2::VPCEndpoint.SubnetIds`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcendpoint.html#cfn-ec2-vpcendpoint-subnetids
     */
    subnetIds: string[] | undefined;
    /**
     * `AWS::EC2::VPCEndpoint.VpcEndpointType`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcendpoint.html#cfn-ec2-vpcendpoint-vpcendpointtype
     */
    vpcEndpointType: string | undefined;
    /**
     * Create a new `AWS::EC2::VPCEndpoint`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnVPCEndpointProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @external
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::EC2::VPCEndpointConnectionNotification`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcendpointconnectionnotification.html
 */
export interface CfnVPCEndpointConnectionNotificationProps {
    /**
     * `AWS::EC2::VPCEndpointConnectionNotification.ConnectionEvents`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcendpointconnectionnotification.html#cfn-ec2-vpcendpointconnectionnotification-connectionevents
     */
    readonly connectionEvents: string[];
    /**
     * `AWS::EC2::VPCEndpointConnectionNotification.ConnectionNotificationArn`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcendpointconnectionnotification.html#cfn-ec2-vpcendpointconnectionnotification-connectionnotificationarn
     */
    readonly connectionNotificationArn: string;
    /**
     * `AWS::EC2::VPCEndpointConnectionNotification.ServiceId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcendpointconnectionnotification.html#cfn-ec2-vpcendpointconnectionnotification-serviceid
     */
    readonly serviceId?: string;
    /**
     * `AWS::EC2::VPCEndpointConnectionNotification.VPCEndpointId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcendpointconnectionnotification.html#cfn-ec2-vpcendpointconnectionnotification-vpcendpointid
     */
    readonly vpcEndpointId?: string;
}
/**
 * A CloudFormation `AWS::EC2::VPCEndpointConnectionNotification`.
 *
 * @external
 * @cloudformationResource AWS::EC2::VPCEndpointConnectionNotification
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcendpointconnectionnotification.html
 */
export declare class CfnVPCEndpointConnectionNotification extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::EC2::VPCEndpointConnectionNotification";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnVPCEndpointConnectionNotification;
    /**
     * `AWS::EC2::VPCEndpointConnectionNotification.ConnectionEvents`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcendpointconnectionnotification.html#cfn-ec2-vpcendpointconnectionnotification-connectionevents
     */
    connectionEvents: string[];
    /**
     * `AWS::EC2::VPCEndpointConnectionNotification.ConnectionNotificationArn`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcendpointconnectionnotification.html#cfn-ec2-vpcendpointconnectionnotification-connectionnotificationarn
     */
    connectionNotificationArn: string;
    /**
     * `AWS::EC2::VPCEndpointConnectionNotification.ServiceId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcendpointconnectionnotification.html#cfn-ec2-vpcendpointconnectionnotification-serviceid
     */
    serviceId: string | undefined;
    /**
     * `AWS::EC2::VPCEndpointConnectionNotification.VPCEndpointId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcendpointconnectionnotification.html#cfn-ec2-vpcendpointconnectionnotification-vpcendpointid
     */
    vpcEndpointId: string | undefined;
    /**
     * Create a new `AWS::EC2::VPCEndpointConnectionNotification`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnVPCEndpointConnectionNotificationProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @external
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::EC2::VPCEndpointService`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcendpointservice.html
 */
export interface CfnVPCEndpointServiceProps {
    /**
     * `AWS::EC2::VPCEndpointService.AcceptanceRequired`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcendpointservice.html#cfn-ec2-vpcendpointservice-acceptancerequired
     */
    readonly acceptanceRequired?: boolean | cdk.IResolvable;
    /**
     * `AWS::EC2::VPCEndpointService.GatewayLoadBalancerArns`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcendpointservice.html#cfn-ec2-vpcendpointservice-gatewayloadbalancerarns
     */
    readonly gatewayLoadBalancerArns?: string[];
    /**
     * `AWS::EC2::VPCEndpointService.NetworkLoadBalancerArns`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcendpointservice.html#cfn-ec2-vpcendpointservice-networkloadbalancerarns
     */
    readonly networkLoadBalancerArns?: string[];
}
/**
 * A CloudFormation `AWS::EC2::VPCEndpointService`.
 *
 * @external
 * @cloudformationResource AWS::EC2::VPCEndpointService
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcendpointservice.html
 */
export declare class CfnVPCEndpointService extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::EC2::VPCEndpointService";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnVPCEndpointService;
    /**
     * `AWS::EC2::VPCEndpointService.AcceptanceRequired`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcendpointservice.html#cfn-ec2-vpcendpointservice-acceptancerequired
     */
    acceptanceRequired: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::EC2::VPCEndpointService.GatewayLoadBalancerArns`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcendpointservice.html#cfn-ec2-vpcendpointservice-gatewayloadbalancerarns
     */
    gatewayLoadBalancerArns: string[] | undefined;
    /**
     * `AWS::EC2::VPCEndpointService.NetworkLoadBalancerArns`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcendpointservice.html#cfn-ec2-vpcendpointservice-networkloadbalancerarns
     */
    networkLoadBalancerArns: string[] | undefined;
    /**
     * Create a new `AWS::EC2::VPCEndpointService`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props?: CfnVPCEndpointServiceProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @external
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::EC2::VPCEndpointServicePermissions`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcendpointservicepermissions.html
 */
export interface CfnVPCEndpointServicePermissionsProps {
    /**
     * `AWS::EC2::VPCEndpointServicePermissions.ServiceId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcendpointservicepermissions.html#cfn-ec2-vpcendpointservicepermissions-serviceid
     */
    readonly serviceId: string;
    /**
     * `AWS::EC2::VPCEndpointServicePermissions.AllowedPrincipals`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcendpointservicepermissions.html#cfn-ec2-vpcendpointservicepermissions-allowedprincipals
     */
    readonly allowedPrincipals?: string[];
}
/**
 * A CloudFormation `AWS::EC2::VPCEndpointServicePermissions`.
 *
 * @external
 * @cloudformationResource AWS::EC2::VPCEndpointServicePermissions
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcendpointservicepermissions.html
 */
export declare class CfnVPCEndpointServicePermissions extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::EC2::VPCEndpointServicePermissions";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnVPCEndpointServicePermissions;
    /**
     * `AWS::EC2::VPCEndpointServicePermissions.ServiceId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcendpointservicepermissions.html#cfn-ec2-vpcendpointservicepermissions-serviceid
     */
    serviceId: string;
    /**
     * `AWS::EC2::VPCEndpointServicePermissions.AllowedPrincipals`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcendpointservicepermissions.html#cfn-ec2-vpcendpointservicepermissions-allowedprincipals
     */
    allowedPrincipals: string[] | undefined;
    /**
     * Create a new `AWS::EC2::VPCEndpointServicePermissions`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnVPCEndpointServicePermissionsProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @external
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::EC2::VPCGatewayAttachment`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpc-gateway-attachment.html
 */
export interface CfnVPCGatewayAttachmentProps {
    /**
     * `AWS::EC2::VPCGatewayAttachment.VpcId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpc-gateway-attachment.html#cfn-ec2-vpcgatewayattachment-vpcid
     */
    readonly vpcId: string;
    /**
     * `AWS::EC2::VPCGatewayAttachment.InternetGatewayId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpc-gateway-attachment.html#cfn-ec2-vpcgatewayattachment-internetgatewayid
     */
    readonly internetGatewayId?: string;
    /**
     * `AWS::EC2::VPCGatewayAttachment.VpnGatewayId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpc-gateway-attachment.html#cfn-ec2-vpcgatewayattachment-vpngatewayid
     */
    readonly vpnGatewayId?: string;
}
/**
 * A CloudFormation `AWS::EC2::VPCGatewayAttachment`.
 *
 * @external
 * @cloudformationResource AWS::EC2::VPCGatewayAttachment
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpc-gateway-attachment.html
 */
export declare class CfnVPCGatewayAttachment extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::EC2::VPCGatewayAttachment";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnVPCGatewayAttachment;
    /**
     * `AWS::EC2::VPCGatewayAttachment.VpcId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpc-gateway-attachment.html#cfn-ec2-vpcgatewayattachment-vpcid
     */
    vpcId: string;
    /**
     * `AWS::EC2::VPCGatewayAttachment.InternetGatewayId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpc-gateway-attachment.html#cfn-ec2-vpcgatewayattachment-internetgatewayid
     */
    internetGatewayId: string | undefined;
    /**
     * `AWS::EC2::VPCGatewayAttachment.VpnGatewayId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpc-gateway-attachment.html#cfn-ec2-vpcgatewayattachment-vpngatewayid
     */
    vpnGatewayId: string | undefined;
    /**
     * Create a new `AWS::EC2::VPCGatewayAttachment`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnVPCGatewayAttachmentProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @external
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::EC2::VPCPeeringConnection`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcpeeringconnection.html
 */
export interface CfnVPCPeeringConnectionProps {
    /**
     * `AWS::EC2::VPCPeeringConnection.PeerVpcId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcpeeringconnection.html#cfn-ec2-vpcpeeringconnection-peervpcid
     */
    readonly peerVpcId: string;
    /**
     * `AWS::EC2::VPCPeeringConnection.VpcId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcpeeringconnection.html#cfn-ec2-vpcpeeringconnection-vpcid
     */
    readonly vpcId: string;
    /**
     * `AWS::EC2::VPCPeeringConnection.PeerOwnerId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcpeeringconnection.html#cfn-ec2-vpcpeeringconnection-peerownerid
     */
    readonly peerOwnerId?: string;
    /**
     * `AWS::EC2::VPCPeeringConnection.PeerRegion`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcpeeringconnection.html#cfn-ec2-vpcpeeringconnection-peerregion
     */
    readonly peerRegion?: string;
    /**
     * `AWS::EC2::VPCPeeringConnection.PeerRoleArn`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcpeeringconnection.html#cfn-ec2-vpcpeeringconnection-peerrolearn
     */
    readonly peerRoleArn?: string;
    /**
     * `AWS::EC2::VPCPeeringConnection.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcpeeringconnection.html#cfn-ec2-vpcpeeringconnection-tags
     */
    readonly tags?: cdk.CfnTag[];
}
/**
 * A CloudFormation `AWS::EC2::VPCPeeringConnection`.
 *
 * @external
 * @cloudformationResource AWS::EC2::VPCPeeringConnection
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcpeeringconnection.html
 */
export declare class CfnVPCPeeringConnection extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::EC2::VPCPeeringConnection";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnVPCPeeringConnection;
    /**
     * `AWS::EC2::VPCPeeringConnection.PeerVpcId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcpeeringconnection.html#cfn-ec2-vpcpeeringconnection-peervpcid
     */
    peerVpcId: string;
    /**
     * `AWS::EC2::VPCPeeringConnection.VpcId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcpeeringconnection.html#cfn-ec2-vpcpeeringconnection-vpcid
     */
    vpcId: string;
    /**
     * `AWS::EC2::VPCPeeringConnection.PeerOwnerId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcpeeringconnection.html#cfn-ec2-vpcpeeringconnection-peerownerid
     */
    peerOwnerId: string | undefined;
    /**
     * `AWS::EC2::VPCPeeringConnection.PeerRegion`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcpeeringconnection.html#cfn-ec2-vpcpeeringconnection-peerregion
     */
    peerRegion: string | undefined;
    /**
     * `AWS::EC2::VPCPeeringConnection.PeerRoleArn`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcpeeringconnection.html#cfn-ec2-vpcpeeringconnection-peerrolearn
     */
    peerRoleArn: string | undefined;
    /**
     * `AWS::EC2::VPCPeeringConnection.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcpeeringconnection.html#cfn-ec2-vpcpeeringconnection-tags
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::EC2::VPCPeeringConnection`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnVPCPeeringConnectionProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @external
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::EC2::VPNConnection`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpn-connection.html
 */
export interface CfnVPNConnectionProps {
    /**
     * `AWS::EC2::VPNConnection.CustomerGatewayId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpn-connection.html#cfn-ec2-vpnconnection-customergatewayid
     */
    readonly customerGatewayId: string;
    /**
     * `AWS::EC2::VPNConnection.Type`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpn-connection.html#cfn-ec2-vpnconnection-type
     */
    readonly type: string;
    /**
     * `AWS::EC2::VPNConnection.StaticRoutesOnly`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpn-connection.html#cfn-ec2-vpnconnection-StaticRoutesOnly
     */
    readonly staticRoutesOnly?: boolean | cdk.IResolvable;
    /**
     * `AWS::EC2::VPNConnection.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpn-connection.html#cfn-ec2-vpnconnection-tags
     */
    readonly tags?: cdk.CfnTag[];
    /**
     * `AWS::EC2::VPNConnection.TransitGatewayId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpn-connection.html#cfn-ec2-vpnconnection-transitgatewayid
     */
    readonly transitGatewayId?: string;
    /**
     * `AWS::EC2::VPNConnection.VpnGatewayId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpn-connection.html#cfn-ec2-vpnconnection-vpngatewayid
     */
    readonly vpnGatewayId?: string;
    /**
     * `AWS::EC2::VPNConnection.VpnTunnelOptionsSpecifications`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpn-connection.html#cfn-ec2-vpnconnection-vpntunneloptionsspecifications
     */
    readonly vpnTunnelOptionsSpecifications?: Array<CfnVPNConnection.VpnTunnelOptionsSpecificationProperty | cdk.IResolvable> | cdk.IResolvable;
}
/**
 * A CloudFormation `AWS::EC2::VPNConnection`.
 *
 * @external
 * @cloudformationResource AWS::EC2::VPNConnection
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpn-connection.html
 */
export declare class CfnVPNConnection extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::EC2::VPNConnection";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnVPNConnection;
    /**
     * `AWS::EC2::VPNConnection.CustomerGatewayId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpn-connection.html#cfn-ec2-vpnconnection-customergatewayid
     */
    customerGatewayId: string;
    /**
     * `AWS::EC2::VPNConnection.Type`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpn-connection.html#cfn-ec2-vpnconnection-type
     */
    type: string;
    /**
     * `AWS::EC2::VPNConnection.StaticRoutesOnly`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpn-connection.html#cfn-ec2-vpnconnection-StaticRoutesOnly
     */
    staticRoutesOnly: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::EC2::VPNConnection.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpn-connection.html#cfn-ec2-vpnconnection-tags
     */
    readonly tags: cdk.TagManager;
    /**
     * `AWS::EC2::VPNConnection.TransitGatewayId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpn-connection.html#cfn-ec2-vpnconnection-transitgatewayid
     */
    transitGatewayId: string | undefined;
    /**
     * `AWS::EC2::VPNConnection.VpnGatewayId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpn-connection.html#cfn-ec2-vpnconnection-vpngatewayid
     */
    vpnGatewayId: string | undefined;
    /**
     * `AWS::EC2::VPNConnection.VpnTunnelOptionsSpecifications`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpn-connection.html#cfn-ec2-vpnconnection-vpntunneloptionsspecifications
     */
    vpnTunnelOptionsSpecifications: Array<CfnVPNConnection.VpnTunnelOptionsSpecificationProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * Create a new `AWS::EC2::VPNConnection`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnVPNConnectionProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @external
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::EC2::VPNConnection`.
 *
 * @external
 * @cloudformationResource AWS::EC2::VPNConnection
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpn-connection.html
 */
export declare namespace CfnVPNConnection {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-vpnconnection-vpntunneloptionsspecification.html
     */
    interface VpnTunnelOptionsSpecificationProperty {
        /**
         * `CfnVPNConnection.VpnTunnelOptionsSpecificationProperty.PreSharedKey`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-vpnconnection-vpntunneloptionsspecification.html#cfn-ec2-vpnconnection-vpntunneloptionsspecification-presharedkey
         */
        readonly preSharedKey?: string;
        /**
         * `CfnVPNConnection.VpnTunnelOptionsSpecificationProperty.TunnelInsideCidr`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-vpnconnection-vpntunneloptionsspecification.html#cfn-ec2-vpnconnection-vpntunneloptionsspecification-tunnelinsidecidr
         */
        readonly tunnelInsideCidr?: string;
    }
}
/**
 * Properties for defining a `AWS::EC2::VPNConnectionRoute`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpn-connection-route.html
 */
export interface CfnVPNConnectionRouteProps {
    /**
     * `AWS::EC2::VPNConnectionRoute.DestinationCidrBlock`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpn-connection-route.html#cfn-ec2-vpnconnectionroute-cidrblock
     */
    readonly destinationCidrBlock: string;
    /**
     * `AWS::EC2::VPNConnectionRoute.VpnConnectionId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpn-connection-route.html#cfn-ec2-vpnconnectionroute-connectionid
     */
    readonly vpnConnectionId: string;
}
/**
 * A CloudFormation `AWS::EC2::VPNConnectionRoute`.
 *
 * @external
 * @cloudformationResource AWS::EC2::VPNConnectionRoute
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpn-connection-route.html
 */
export declare class CfnVPNConnectionRoute extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::EC2::VPNConnectionRoute";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnVPNConnectionRoute;
    /**
     * `AWS::EC2::VPNConnectionRoute.DestinationCidrBlock`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpn-connection-route.html#cfn-ec2-vpnconnectionroute-cidrblock
     */
    destinationCidrBlock: string;
    /**
     * `AWS::EC2::VPNConnectionRoute.VpnConnectionId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpn-connection-route.html#cfn-ec2-vpnconnectionroute-connectionid
     */
    vpnConnectionId: string;
    /**
     * Create a new `AWS::EC2::VPNConnectionRoute`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnVPNConnectionRouteProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @external
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::EC2::VPNGateway`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpn-gateway.html
 */
export interface CfnVPNGatewayProps {
    /**
     * `AWS::EC2::VPNGateway.Type`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpn-gateway.html#cfn-ec2-vpngateway-type
     */
    readonly type: string;
    /**
     * `AWS::EC2::VPNGateway.AmazonSideAsn`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpn-gateway.html#cfn-ec2-vpngateway-amazonsideasn
     */
    readonly amazonSideAsn?: number;
    /**
     * `AWS::EC2::VPNGateway.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpn-gateway.html#cfn-ec2-vpngateway-tags
     */
    readonly tags?: cdk.CfnTag[];
}
/**
 * A CloudFormation `AWS::EC2::VPNGateway`.
 *
 * @external
 * @cloudformationResource AWS::EC2::VPNGateway
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpn-gateway.html
 */
export declare class CfnVPNGateway extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::EC2::VPNGateway";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnVPNGateway;
    /**
     * `AWS::EC2::VPNGateway.Type`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpn-gateway.html#cfn-ec2-vpngateway-type
     */
    type: string;
    /**
     * `AWS::EC2::VPNGateway.AmazonSideAsn`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpn-gateway.html#cfn-ec2-vpngateway-amazonsideasn
     */
    amazonSideAsn: number | undefined;
    /**
     * `AWS::EC2::VPNGateway.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpn-gateway.html#cfn-ec2-vpngateway-tags
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::EC2::VPNGateway`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnVPNGatewayProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @external
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::EC2::VPNGatewayRoutePropagation`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpn-gatewayrouteprop.html
 */
export interface CfnVPNGatewayRoutePropagationProps {
    /**
     * `AWS::EC2::VPNGatewayRoutePropagation.RouteTableIds`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpn-gatewayrouteprop.html#cfn-ec2-vpngatewayrouteprop-routetableids
     */
    readonly routeTableIds: string[];
    /**
     * `AWS::EC2::VPNGatewayRoutePropagation.VpnGatewayId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpn-gatewayrouteprop.html#cfn-ec2-vpngatewayrouteprop-vpngatewayid
     */
    readonly vpnGatewayId: string;
}
/**
 * A CloudFormation `AWS::EC2::VPNGatewayRoutePropagation`.
 *
 * @external
 * @cloudformationResource AWS::EC2::VPNGatewayRoutePropagation
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpn-gatewayrouteprop.html
 */
export declare class CfnVPNGatewayRoutePropagation extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::EC2::VPNGatewayRoutePropagation";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnVPNGatewayRoutePropagation;
    /**
     * `AWS::EC2::VPNGatewayRoutePropagation.RouteTableIds`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpn-gatewayrouteprop.html#cfn-ec2-vpngatewayrouteprop-routetableids
     */
    routeTableIds: string[];
    /**
     * `AWS::EC2::VPNGatewayRoutePropagation.VpnGatewayId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpn-gatewayrouteprop.html#cfn-ec2-vpngatewayrouteprop-vpngatewayid
     */
    vpnGatewayId: string;
    /**
     * Create a new `AWS::EC2::VPNGatewayRoutePropagation`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnVPNGatewayRoutePropagationProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @external
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::EC2::Volume`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ebs-volume.html
 */
export interface CfnVolumeProps {
    /**
     * `AWS::EC2::Volume.AvailabilityZone`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ebs-volume.html#cfn-ec2-ebs-volume-availabilityzone
     */
    readonly availabilityZone: string;
    /**
     * `AWS::EC2::Volume.AutoEnableIO`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ebs-volume.html#cfn-ec2-ebs-volume-autoenableio
     */
    readonly autoEnableIo?: boolean | cdk.IResolvable;
    /**
     * `AWS::EC2::Volume.Encrypted`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ebs-volume.html#cfn-ec2-ebs-volume-encrypted
     */
    readonly encrypted?: boolean | cdk.IResolvable;
    /**
     * `AWS::EC2::Volume.Iops`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ebs-volume.html#cfn-ec2-ebs-volume-iops
     */
    readonly iops?: number;
    /**
     * `AWS::EC2::Volume.KmsKeyId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ebs-volume.html#cfn-ec2-ebs-volume-kmskeyid
     */
    readonly kmsKeyId?: string;
    /**
     * `AWS::EC2::Volume.MultiAttachEnabled`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ebs-volume.html#cfn-ec2-ebs-volume-multiattachenabled
     */
    readonly multiAttachEnabled?: boolean | cdk.IResolvable;
    /**
     * `AWS::EC2::Volume.OutpostArn`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ebs-volume.html#cfn-ec2-ebs-volume-outpostarn
     */
    readonly outpostArn?: string;
    /**
     * `AWS::EC2::Volume.Size`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ebs-volume.html#cfn-ec2-ebs-volume-size
     */
    readonly size?: number;
    /**
     * `AWS::EC2::Volume.SnapshotId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ebs-volume.html#cfn-ec2-ebs-volume-snapshotid
     */
    readonly snapshotId?: string;
    /**
     * `AWS::EC2::Volume.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ebs-volume.html#cfn-ec2-ebs-volume-tags
     */
    readonly tags?: cdk.CfnTag[];
    /**
     * `AWS::EC2::Volume.Throughput`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ebs-volume.html#cfn-ec2-ebs-volume-throughput
     */
    readonly throughput?: number;
    /**
     * `AWS::EC2::Volume.VolumeType`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ebs-volume.html#cfn-ec2-ebs-volume-volumetype
     */
    readonly volumeType?: string;
}
/**
 * A CloudFormation `AWS::EC2::Volume`.
 *
 * @external
 * @cloudformationResource AWS::EC2::Volume
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ebs-volume.html
 */
export declare class CfnVolume extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::EC2::Volume";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnVolume;
    /**
     * `AWS::EC2::Volume.AvailabilityZone`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ebs-volume.html#cfn-ec2-ebs-volume-availabilityzone
     */
    availabilityZone: string;
    /**
     * `AWS::EC2::Volume.AutoEnableIO`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ebs-volume.html#cfn-ec2-ebs-volume-autoenableio
     */
    autoEnableIo: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::EC2::Volume.Encrypted`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ebs-volume.html#cfn-ec2-ebs-volume-encrypted
     */
    encrypted: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::EC2::Volume.Iops`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ebs-volume.html#cfn-ec2-ebs-volume-iops
     */
    iops: number | undefined;
    /**
     * `AWS::EC2::Volume.KmsKeyId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ebs-volume.html#cfn-ec2-ebs-volume-kmskeyid
     */
    kmsKeyId: string | undefined;
    /**
     * `AWS::EC2::Volume.MultiAttachEnabled`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ebs-volume.html#cfn-ec2-ebs-volume-multiattachenabled
     */
    multiAttachEnabled: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::EC2::Volume.OutpostArn`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ebs-volume.html#cfn-ec2-ebs-volume-outpostarn
     */
    outpostArn: string | undefined;
    /**
     * `AWS::EC2::Volume.Size`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ebs-volume.html#cfn-ec2-ebs-volume-size
     */
    size: number | undefined;
    /**
     * `AWS::EC2::Volume.SnapshotId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ebs-volume.html#cfn-ec2-ebs-volume-snapshotid
     */
    snapshotId: string | undefined;
    /**
     * `AWS::EC2::Volume.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ebs-volume.html#cfn-ec2-ebs-volume-tags
     */
    readonly tags: cdk.TagManager;
    /**
     * `AWS::EC2::Volume.Throughput`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ebs-volume.html#cfn-ec2-ebs-volume-throughput
     */
    throughput: number | undefined;
    /**
     * `AWS::EC2::Volume.VolumeType`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ebs-volume.html#cfn-ec2-ebs-volume-volumetype
     */
    volumeType: string | undefined;
    /**
     * Create a new `AWS::EC2::Volume`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnVolumeProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @external
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::EC2::VolumeAttachment`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ebs-volumeattachment.html
 */
export interface CfnVolumeAttachmentProps {
    /**
     * `AWS::EC2::VolumeAttachment.Device`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ebs-volumeattachment.html#cfn-ec2-ebs-volumeattachment-device
     */
    readonly device: string;
    /**
     * `AWS::EC2::VolumeAttachment.InstanceId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ebs-volumeattachment.html#cfn-ec2-ebs-volumeattachment-instanceid
     */
    readonly instanceId: string;
    /**
     * `AWS::EC2::VolumeAttachment.VolumeId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ebs-volumeattachment.html#cfn-ec2-ebs-volumeattachment-volumeid
     */
    readonly volumeId: string;
}
/**
 * A CloudFormation `AWS::EC2::VolumeAttachment`.
 *
 * @external
 * @cloudformationResource AWS::EC2::VolumeAttachment
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ebs-volumeattachment.html
 */
export declare class CfnVolumeAttachment extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::EC2::VolumeAttachment";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnVolumeAttachment;
    /**
     * `AWS::EC2::VolumeAttachment.Device`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ebs-volumeattachment.html#cfn-ec2-ebs-volumeattachment-device
     */
    device: string;
    /**
     * `AWS::EC2::VolumeAttachment.InstanceId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ebs-volumeattachment.html#cfn-ec2-ebs-volumeattachment-instanceid
     */
    instanceId: string;
    /**
     * `AWS::EC2::VolumeAttachment.VolumeId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ebs-volumeattachment.html#cfn-ec2-ebs-volumeattachment-volumeid
     */
    volumeId: string;
    /**
     * Create a new `AWS::EC2::VolumeAttachment`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnVolumeAttachmentProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @external
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
