import { Resource } from '@aws-cdk/core';
import { Construct } from 'constructs';
import { IClientVpnEndpoint } from './client-vpn-endpoint-types';
import { ISubnet } from './vpc';
/**
 * Options for a ClientVpnRoute.
 *
 * @stability stable
 */
export interface ClientVpnRouteOptions {
    /**
     * The IPv4 address range, in CIDR notation, of the route destination.
     *
     * For example:
     *    - To add a route for Internet access, enter 0.0.0.0/0
     *    - To add a route for a peered VPC, enter the peered VPC's IPv4 CIDR range
     *    - To add a route for an on-premises network, enter the AWS Site-to-Site VPN
     *      connection's IPv4 CIDR range
     *    - To add a route for the local network, enter the client CIDR range
     *
     * @stability stable
     */
    readonly cidr: string;
    /**
     * A brief description of the authorization rule.
     *
     * @default - no description
     * @stability stable
     */
    readonly description?: string;
    /**
     * The target for the route.
     *
     * @stability stable
     */
    readonly target: ClientVpnRouteTarget;
}
/**
 * Target for a client VPN route.
 *
 * @stability stable
 */
export declare abstract class ClientVpnRouteTarget {
    /**
     * Subnet.
     *
     * The specified subnet must be an existing target network of the client VPN
     * endpoint.
     *
     * @stability stable
     */
    static subnet(subnet: ISubnet): ClientVpnRouteTarget;
    /**
     * Local network.
     *
     * @stability stable
     */
    static local(): ClientVpnRouteTarget;
    /**
     * The subnet ID.
     *
     * @stability stable
     */
    abstract readonly subnetId: string;
}
/**
 * Properties for a ClientVpnRoute.
 *
 * @stability stable
 */
export interface ClientVpnRouteProps extends ClientVpnRouteOptions {
    /**
     * The client VPN endpoint to which to add the route.
     *
     * @default clientVpnEndpoint is required
     * @stability stable
     */
    readonly clientVpnEndpoint?: IClientVpnEndpoint;
    /**
     * (deprecated) The client VPN endpoint to which to add the route.
     *
     * @default clientVpnEndpoint is required
     * @deprecated Use `clientVpnEndpoint` instead
     */
    readonly clientVpnEndoint?: IClientVpnEndpoint;
}
/**
 * A client VPN route.
 *
 * @stability stable
 */
export declare class ClientVpnRoute extends Resource {
    /**
     * @stability stable
     */
    constructor(scope: Construct, id: string, props: ClientVpnRouteProps);
}
