"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ClientVpnAuthorizationRule = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const core_1 = require("@aws-cdk/core");
const ec2_generated_1 = require("./ec2.generated");
/**
 * A client VPN authorization rule.
 *
 * @stability stable
 */
class ClientVpnAuthorizationRule extends core_1.Resource {
    /**
     * @stability stable
     */
    constructor(scope, id, props) {
        jsiiDeprecationWarnings._aws_cdk_aws_ec2_ClientVpnAuthorizationRuleProps(props);
        if (!props.clientVpnEndoint && !props.clientVpnEndpoint) {
            throw new Error('ClientVpnAuthorizationRule: either clientVpnEndpoint or clientVpnEndoint (deprecated) must be specified');
        }
        if (props.clientVpnEndoint && props.clientVpnEndpoint) {
            throw new Error('ClientVpnAuthorizationRule: either clientVpnEndpoint or clientVpnEndoint (deprecated) must be specified' +
                ', but not both');
        }
        const clientVpnEndpoint = props.clientVpnEndoint || props.clientVpnEndpoint;
        super(scope, id);
        new ec2_generated_1.CfnClientVpnAuthorizationRule(this, 'Resource', {
            clientVpnEndpointId: clientVpnEndpoint.endpointId,
            targetNetworkCidr: props.cidr,
            accessGroupId: props.groupId,
            authorizeAllGroups: !props.groupId,
            description: props.description,
        });
    }
}
exports.ClientVpnAuthorizationRule = ClientVpnAuthorizationRule;
_a = JSII_RTTI_SYMBOL_1;
ClientVpnAuthorizationRule[_a] = { fqn: "@aws-cdk/aws-ec2.ClientVpnAuthorizationRule", version: "1.134.0" };
//# sourceMappingURL=data:application/json;base64,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