"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Cli = void 0;
const path_1 = require("path");
class Cli {
    constructor(command = 'dependency-check.sh') {
        this.command = command;
    }
    scan(props) {
        const args = [this.command];
        const { projectName, basedir = '.', paths, excludes = [], suppressions = [], failOnCVSS = 0, enableExperimental = false, noUpdate = false, } = props;
        if (projectName) {
            args.push(`--project "${projectName}"`);
        }
        paths.forEach((path) => {
            args.push(`--scan "${path_1.join(basedir, path)}"`);
        });
        excludes.forEach((exclude) => {
            args.push(`--exclude "${path_1.join(basedir, exclude)}"`);
        });
        suppressions.forEach((suppression) => {
            args.push(`--suppression "${path_1.join(basedir, suppression)}}"`);
        });
        args.push(`--failOnCVSS ${failOnCVSS}`);
        args.push(`--junitFailOnCVSS ${failOnCVSS}`);
        if (enableExperimental) {
            args.push('--enableExperimental');
        }
        if (noUpdate) {
            args.push('--noupdate');
        }
        args.push('--prettyPrint --format HTML --format JUNIT');
        args.push('--out reports');
        return args.join(' ');
    }
    update() {
        const args = [this.command];
        args.push('--updateonly');
        return args.join(' ');
    }
    version() {
        const args = [this.command];
        args.push('--version');
        return args.join(' ');
    }
}
exports.Cli = Cli;
//# sourceMappingURL=data:application/json;base64,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