"""
MIT license
Copyright (C) 2022 Zhi Liu<zliucd66@gmail.com>

zeekparser.py
This file is part of TLSfeatmark, a testing package for TLS analytics. See LICENSE for more information.
"""

import os
from pathlib import Path

def parse_zeek_output():
    """
    Parse feature file generated by Zeek, output number of TLS streams and certs,
    Args:

    Returns:
        tls_num, cert_num
    """

    tls_num = 0
    cert_num = 0

    try:
        f = open("ssl.log")
        lines = f.readlines()

        for line in lines:
            if line[0] == "#":
                pass
            else:
                tls_num += 1

                elements = line.split("\t")
                certs = elements[15]
                if certs == "(empty)":
                    cert_num += 0
                else:
                    certs_list = certs.split(",")
                    cert_num += len(certs_list)
    except:
        pass

    return tls_num, cert_num

def run_zeek_command(pcap_path):
    """
    Run zeek command to parse pcap file
    Args:
        pcap_path: pcap file path

    Returns:
        status code of executed command
    """

    p = Path(pcap_path)

    cmd_str = "zeek -Cr %s" %pcap_path
    ret = os.system(cmd_str)

    if ret == 0:
        # print("[INFO]%s processed by Zeek success" % p.name)
        pass
    else:
        print("[Error]%s processed by Zeek error" % p.name)

    return ret


def parse_pcap_zeek(pcap_path):
    """
    Wrapper to parse pcap using Zeek
    Args:
        pcap_path: pcap file path

    Returns:
        tls_num, cert_num
    """

    run_zeek_command(pcap_path)
    tls_num, cert_num = parse_zeek_output()

    os.system("rm *.log")

    return tls_num, cert_num