"""
MIT license
Copyright (C) 2022 Zhi Liu<zliucd66@gmail.com>

joyparser.py
This file is part of TLSfeatmark, a testing package for TLS analytics. See LICENSE for more information.
"""

import json
import os
from pathlib import Path
from tempfile import NamedTemporaryFile


def parse_joy_output(feat_path):
    """
    Parse feature file generated by Joy, output number of TLS streams and certs,
    Args:
        feat_path:

    Returns:
        tls_num, cert_num
    """

    f = open(feat_path)
    lines = f.readlines()

    tls_num = 0
    cert_num = 0

    lines = lines[1:]
    for line in lines:
        j = json.loads(line)
        if "tls" in j:
            s = j["tls"]

            tls_num += 1
            if "s_cert" in s:
                cert_num += len(s["s_cert"])

    return tls_num, cert_num

def run_joy_command(pcap_path):
    """
    Run joy command to parse pcap file
    Args:
        pcap_path: pcap file path

    Returns:
        output file name
    """

    p = Path(pcap_path)
    f = NamedTemporaryFile("w+t", delete=False)

    cmd_str = "joy tls=1 dist=1 ssh=1 tls=1 bidir=1 fpx=1 %s | gunzip > %s" % (pcap_path, f.name)
    ret = os.system(cmd_str)

    if ret == 0:
        # print("[INFO]%s processed by Joy success" % p.name)
        pass
    else:
        print("[ERROR]%s processed by Joy error" % p.name)

    return f.name

def parse_pcap_joy(pcap_path):
    """
    Wrapper to parse pcap using Joy
    Args:
        pcap_path: pcap file path

    Returns:
        tls_num, cert_num
    """

    output = run_joy_command(pcap_path)
    tls_num, cert_num = parse_joy_output(output)

    return tls_num, cert_num