#!/usr/bin/env python
from setuptools import setup, find_packages, Distribution
import codecs
import os.path

# Make sure versiontag exists before going any further
Distribution().fetch_build_eggs('versiontag>=1.2.0')

from versiontag import get_version, cache_git_tag  # NOQA


packages = find_packages('src')

install_requires = [
    'django>=2.2',
    'django-oscar>=3.0',
    'instrumented-soap>=1.1.0',
]

extras_require = {
    'circuitbreaker': [
        'pybreaker>=0.6.0',
    ],
    'development': [
        'coverage>=4.4.2',
        'flake8>=3.2.1',
        'freezegun>=0.3.8',
        'lxml>=3.7.2',
        'psycopg2cffi>=2.7.7',
        'sorl-thumbnail>=11.04',
        'sphinx-rtd-theme>=0.4.3',
        'sphinx>=1.5.2',
        'tox>=2.6.0',
        'unittest-xml-reporting>=3.0.4',
        'versiontag>=1.2.0',
    ],
}


def fpath(name):
    return os.path.join(os.path.dirname(__file__), name)


def read(fname):
    return codecs.open(fpath(fname), encoding='utf-8').read()


cache_git_tag()

setup(
    name='django-oscar-cch',
    description="Integration between django-oscar and the CCH Sales Tax Office SOAP API.",
    version=get_version(pypi=True),
    long_description=open('README.rst').read(),
    classifiers=[
        'Development Status :: 5 - Production/Stable',
        'Environment :: Web Environment',
        'Framework :: Django',
        'Intended Audience :: Developers',
        'License :: OSI Approved :: ISC License (ISCL)',
        'Operating System :: Unix',
        'Programming Language :: Python',
        'Programming Language :: Python :: 3',
    ],
    author='Craig Weber',
    author_email='crgwbr@gmail.com',
    url='https://gitlab.com/thelabnyc/django-oscar/django-oscar-cch',
    license='ISC',
    package_dir={'': 'src'},
    packages=packages,
    install_requires=install_requires,
    extras_require=extras_require,
)
