"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CfnResource = exports.toJson_CfnResourceProps = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
// Generated by cdk-import
const cdk = require("aws-cdk-lib");
/**
 * Converts an object of type 'CfnResourceProps' to JSON representation.
 */
/* eslint-disable max-len, quote-props */
function toJson_CfnResourceProps(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'ClusterName': obj.clusterName,
        'Namespace': obj.namespace,
        'Manifest': obj.manifest,
        'Url': obj.url,
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
exports.toJson_CfnResourceProps = toJson_CfnResourceProps;
/* eslint-enable max-len, quote-props */
/**
 * A CloudFormation `AWSQS::Kubernetes::Resource`
 *
 * @cloudformationResource AWSQS::Kubernetes::Resource
 * @stability external
 * @link https://github.com/aws-quickstart/quickstart-amazon-eks.git
 */
class CfnResource extends cdk.CfnResource {
    /**
     * Create a new `AWSQS::Kubernetes::Resource`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnResource.CFN_RESOURCE_TYPE_NAME, properties: toJson_CfnResourceProps(props) });
        this.props = props;
        this.attrName = cdk.Token.asString(this.getAtt('Name'));
        this.attrResourceVersion = cdk.Token.asString(this.getAtt('ResourceVersion'));
        this.attrSelfLink = cdk.Token.asString(this.getAtt('SelfLink'));
        this.attrUid = cdk.Token.asString(this.getAtt('Uid'));
        this.attrCfnId = cdk.Token.asString(this.getAtt('CfnId'));
    }
}
exports.CfnResource = CfnResource;
_a = JSII_RTTI_SYMBOL_1;
CfnResource[_a] = { fqn: "@cdk-cloudformation/awsqs-kubernetes-resource.CfnResource", version: "1.15.0-alpha.5" };
/**
* The CloudFormation resource type name for this resource class.
*/
CfnResource.CFN_RESOURCE_TYPE_NAME = "AWSQS::Kubernetes::Resource";
//# sourceMappingURL=data:application/json;base64,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