import * as cdk from 'aws-cdk-lib';
import * as constructs from 'constructs';
/**
 * Applys a YAML manifest to the specified Kubernetes cluster
 *
 * @schema CfnResourceProps
 */
export interface CfnResourceProps {
    /**
     * Name of the EKS cluster
     *
     * @schema CfnResourceProps#ClusterName
     */
    readonly clusterName: string;
    /**
     * Kubernetes namespace
     *
     * @schema CfnResourceProps#Namespace
     */
    readonly namespace?: string;
    /**
     * Text representation of the kubernetes yaml manifests to apply to the cluster.
     *
     * @schema CfnResourceProps#Manifest
     */
    readonly manifest?: string;
    /**
     * Url to the kubernetes yaml manifests to apply to the cluster. Urls starting with s3:// will be fetched using an authenticated S3 read.
     *
     * @schema CfnResourceProps#Url
     */
    readonly url?: string;
}
/**
 * Converts an object of type 'CfnResourceProps' to JSON representation.
 */
export declare function toJson_CfnResourceProps(obj: CfnResourceProps | undefined): Record<string, any> | undefined;
/**
 * A CloudFormation `AWSQS::Kubernetes::Resource`
 *
 * @cloudformationResource AWSQS::Kubernetes::Resource
 * @stability external
 * @link https://github.com/aws-quickstart/quickstart-amazon-eks.git
 */
export declare class CfnResource extends cdk.CfnResource {
    /**
    * The CloudFormation resource type name for this resource class.
    */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWSQS::Kubernetes::Resource";
    /**
     * Resource props.
     */
    readonly props: CfnResourceProps;
    /**
     * Attribute `AWSQS::Kubernetes::Resource.Name`
     * @link https://github.com/aws-quickstart/quickstart-amazon-eks.git
     */
    readonly attrName: string;
    /**
     * Attribute `AWSQS::Kubernetes::Resource.ResourceVersion`
     * @link https://github.com/aws-quickstart/quickstart-amazon-eks.git
     */
    readonly attrResourceVersion: string;
    /**
     * Attribute `AWSQS::Kubernetes::Resource.SelfLink`
     * @link https://github.com/aws-quickstart/quickstart-amazon-eks.git
     */
    readonly attrSelfLink: string;
    /**
     * Attribute `AWSQS::Kubernetes::Resource.Uid`
     * @link https://github.com/aws-quickstart/quickstart-amazon-eks.git
     */
    readonly attrUid: string;
    /**
     * Attribute `AWSQS::Kubernetes::Resource.CfnId`
     * @link https://github.com/aws-quickstart/quickstart-amazon-eks.git
     */
    readonly attrCfnId: string;
    /**
     * Create a new `AWSQS::Kubernetes::Resource`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: constructs.Construct, id: string, props: CfnResourceProps);
}
