# mypy-boto3-batch

[![PyPI - mypy-boto3-batch](https://img.shields.io/pypi/v/mypy-boto3-batch.svg?color=blue)](https://pypi.org/project/mypy-boto3-batch)
[![PyPI - Python Version](https://img.shields.io/pypi/pyversions/mypy-boto3-batch.svg?color=blue)](https://pypi.org/project/mypy-boto3-batch)
[![Docs](https://img.shields.io/readthedocs/mypy-boto3-builder.svg?color=blue)](https://mypy-boto3-builder.readthedocs.io/)

![boto3.typed](https://github.com/vemel/mypy_boto3_builder/raw/master/logo.png)

Type annotations for
[boto3.Batch 1.17.36](https://boto3.amazonaws.com/v1/documentation/api/1.17.36/reference/services/batch.html#Batch) service
compatible with
[VSCode](https://code.visualstudio.com/),
[PyCharm](https://www.jetbrains.com/pycharm/),
[Emacs](https://www.gnu.org/software/emacs/),
[Sublime Text](https://www.sublimetext.com/),
[mypy](https://github.com/python/mypy),
[pyright](https://github.com/microsoft/pyright)
and other tools.

Generated by [mypy-boto3-buider 4.4.0](https://github.com/vemel/mypy_boto3_builder).

More information can be found on [boto3-stubs](https://pypi.org/project/boto3-stubs/) page.

See how it helps to find and fix potential bugs:

![boto3-stubs demo](https://github.com/vemel/mypy_boto3_builder/raw/master/demo.gif)

- [mypy-boto3-batch](#mypy-boto3-batch)
  - [How to install](#how-to-install)
  - [Usage](#usage)
    - [VSCode](#vscode)
    - [PyCharm](#pycharm)
    - [Other IDEs](#other-ides)
    - [mypy](#mypy)
    - [pyright](#pyright)
  - [Explicit type annotations](#explicit-type-annotations)
    - [Client annotations](#client-annotations)
    - [Paginators annotations](#paginators-annotations)
    - [Waiters annotations](#waiters-annotations)
    - [Service Resource annotations](#service-resource-annotations)
    - [Other resources annotations](#other-resources-annotations)
    - [Collections annotations](#collections-annotations)
    - [Typed dictionations](#typed-dictionations)

## How to install

Install `boto3-stubs` for `Batch` service.

```bash
python -m pip install boto3-stubs[batch]
```

## Usage

### VSCode

- Install [Python extension](https://marketplace.visualstudio.com/items?itemName=ms-python.python)
- Install [Pylance extension](https://marketplace.visualstudio.com/items?itemName=ms-python.vscode-pylance)
- Set `Pylance` as your Python Language Server
- Install `boto-stubs[batch]` in your environment: `python -m pip install 'boto3-stubs[batch]'`

Both type checking and auto-complete should work for `Batch` service.
No explicit type annotations required, write your `boto3` code as usual.

### PyCharm

- Install `boto-stubs[batch]` in your environment: `python -m pip install 'boto3-stubs[batch]'`

Both type checking and auto-complete should work for `Batch` service.
No explicit type annotations required, write your `boto3` code as usual.
Auto-complete can be slow on big projects or if you have a lot of installed `boto3-stubs` submodules.

### Other IDEs

Not tested, but as long as your IDE support `mypy` or `pyright`, everything should work.

### mypy

- Install `mypy`: `python -m pip install mypy`
- Install `boto-stubs[batch]` in your environment: `python -m pip install 'boto3-stubs[batch]'`
- Run `mypy` as usual

Type checking should work for `Batch` service.
No explicit type annotations required, write your `boto3` code as usual.

### pyright

- Install `pyright`: `yarn global add pyright`
- Install `boto-stubs[batch]` in your environment: `python -m pip install 'boto3-stubs[batch]'`
- Optionally, you can install `boto3-stubs` to `typings` folder.

Type checking should work for `Batch` service.
No explicit type annotations required, write your `boto3` code as usual.

## Explicit type annotations

### Client annotations

`BatchClient` provides annotations for `boto3.client("batch")`.

```python
import boto3

from mypy_boto3_batch import BatchClient

client: BatchClient = boto3.client("batch")

# now client usage is checked by mypy and IDE should provide code auto-complete

# works for session as well
session = boto3.session.Session(region="us-west-1")
session_client: BatchClient = session.client("batch")
```

### Paginators annotations

`mypy_boto3_batch.paginator` module contains type annotations for all paginators.

```python
from mypy_boto3_batch import BatchClient
from mypy_boto3_batch.paginator import (
    DescribeComputeEnvironmentsPaginator,
    DescribeJobDefinitionsPaginator,
    DescribeJobQueuesPaginator,
    ListJobsPaginator,
)

client: BatchClient = boto3.client("batch")

# Explicit type annotations are optional here
# Type should be correctly discovered by mypy and IDEs
# VSCode requires explicit type annotations
describe_compute_environments_paginator: DescribeComputeEnvironmentsPaginator = client.get_paginator("describe_compute_environments")
describe_job_definitions_paginator: DescribeJobDefinitionsPaginator = client.get_paginator("describe_job_definitions")
describe_job_queues_paginator: DescribeJobQueuesPaginator = client.get_paginator("describe_job_queues")
list_jobs_paginator: ListJobsPaginator = client.get_paginator("list_jobs")
```







### Typed dictionations

`mypy_boto3_batch.type_defs` module contains structures and shapes assembled
to typed dictionaries for additional type checking.

```python
from mypy_boto3_batch.type_defs import (
    ArrayPropertiesDetailTypeDef,
    ArrayPropertiesSummaryTypeDef,
    AttemptContainerDetailTypeDef,
    AttemptDetailTypeDef,
    ComputeEnvironmentDetailTypeDef,
    ComputeEnvironmentOrderTypeDef,
    ComputeResourceTypeDef,
    ContainerDetailTypeDef,
    ContainerOverridesTypeDef,
    ContainerPropertiesTypeDef,
    ContainerSummaryTypeDef,
    DeviceTypeDef,
    Ec2ConfigurationTypeDef,
    EvaluateOnExitTypeDef,
    FargatePlatformConfigurationTypeDef,
    HostTypeDef,
    JobDefinitionTypeDef,
    JobDependencyTypeDef,
    JobDetailTypeDef,
    JobQueueDetailTypeDef,
    JobSummaryTypeDef,
    JobTimeoutTypeDef,
    KeyValuePairTypeDef,
    LaunchTemplateSpecificationTypeDef,
    LinuxParametersTypeDef,
    LogConfigurationTypeDef,
    MountPointTypeDef,
    NetworkConfigurationTypeDef,
    NetworkInterfaceTypeDef,
    NodeDetailsTypeDef,
    NodePropertiesSummaryTypeDef,
    NodePropertiesTypeDef,
    NodePropertyOverrideTypeDef,
    NodeRangePropertyTypeDef,
    ResourceRequirementTypeDef,
    RetryStrategyTypeDef,
    SecretTypeDef,
    TmpfsTypeDef,
    UlimitTypeDef,
    VolumeTypeDef,
    ArrayPropertiesTypeDef,
    ComputeResourceUpdateTypeDef,
    CreateComputeEnvironmentResponseTypeDef,
    CreateJobQueueResponseTypeDef,
    DescribeComputeEnvironmentsResponseTypeDef,
    DescribeJobDefinitionsResponseTypeDef,
    DescribeJobQueuesResponseTypeDef,
    DescribeJobsResponseTypeDef,
    ListJobsResponseTypeDef,
    ListTagsForResourceResponseTypeDef,
    NodeOverridesTypeDef,
    PaginatorConfigTypeDef,
    RegisterJobDefinitionResponseTypeDef,
    SubmitJobResponseTypeDef,
    UpdateComputeEnvironmentResponseTypeDef,
    UpdateJobQueueResponseTypeDef,
)

def get_structure() -> ArrayPropertiesDetailTypeDef:
    return {
      ...
    }
```
