from pathlib import Path

import pytest
from pyscaffold import cli
from pyscaffold.file_system import chdir

from pyscaffoldext.markdown.extension import Markdown

from .helpers import run_common_tasks

EXT_FLAG = Markdown().flag

# If you need to check logs with caplog, have a look on
# pyscaffoldext-custom-extension's tests/conftest.py file and the
# `isolated_logger` fixture.


def test_add_custom_extension(tmpfolder):
    args = ["--no-config", EXT_FLAG, "my_project", "-p", "my_package"]
    # --no-config: avoid extra config from dev's machine interference
    cli.main(args)

    assert Path("my_project/src/my_package/__init__.py").exists()
    assert Path("my_project/README.md").exists()
    assert not Path("my_project/README.rst").exists()


def test_add_custom_extension_and_pretend(tmpfolder):
    args = ["--no-config", "--pretend", EXT_FLAG, "my_project", "-p", "my_package"]
    # --no-config: avoid extra config from dev's machine interference
    cli.main(args)

    assert not Path("my_project/README.md").exists()
    assert not Path("my_project").exists()


@pytest.mark.slow
@pytest.mark.system
def test_generated_extension(tmpfolder):
    args = ["--no-config", "--venv", "--pre-commit", EXT_FLAG, "my_project"]
    # --no-config: avoid extra config from dev's machine interference
    # --venv: generate a venv so we can install the resulting project
    # --pre-commit: ensure generated files respect repository conventions
    cli.main(args)

    with chdir("my_project"):
        # Testing a project generated by the custom extension
        run_common_tasks()
