from ast import Call
import math
from matplotlib import pyplot
from typing import Callable, Dict, List, Union

class Булева_формула: # Булева формула, операндами которой являются нечёткие высказывания
    def __init__(self, Истинность = None):
        self.__Истинность = Истинность
    
    def Вычислить_истинность(self):
        return None
    
    @property
    def Истинность(self) -> Union[float,None]: #-Свойство: Измненение значения истинности высказывания
        #if self.__Истинность is None:  # Если значение истинности для данного элемента ещё не рассчитано
           # Результат = self.Вычислить_истинность() # Рассчитываем значение истинности
            #self.__Истинность = Результат # Запоминаем чтобы избежать перерасчётов в дальнейшем
        return self.__Истинность # Возвращаем в качестве значения свойства
    
    @Истинность.setter
    def Истинность(self,Значение):
        if(Значение is None or (Значение <= 1 and Значение >= 0)):
            self.__Истинность = Значение
        else:
           raise ValueError("значение должно быть в диопазоне [0;1]")
    
    
    def __and__(self,other): # Конъюнкиця (&)
        return Булева_формула(self[1]*other[1] if self.Истинность is not None and other.Истинность is not None else None)
        
    def __or__(self,other): # Дизъюнкция (|)
        return Булева_формула(self[1]*other[0] + other[1] if self.Истинность is not None and other.Истинность is not None else None)
        
    def __invert__(self): # Отрицание (~)
        return Булева_формула(1 - self[1] if self.Истинность is not None else None)
    
    def __rshift__(self, other): # Импликация (>>)
       return ~self | other    # [ other[0]*self[1], self[0]*other[0] + other[1] ] 
    
    def __getitem__(self,item): # Индексатор
        return self.Истинность if item == 1 else 1 - self.Истинность
    
    def __str__(self):
        return str(self.Истинность)
    
class Нечёткая_переменная: # Кортеж вида (Имя,A), где 
    def __init__(self, Имя:str, A: Dict[float,float] = None):
        self.Имя = Имя  # Имя переменной,  
        self.A = A if A is not None else {}      # A - нечёткое множество на универсуме X (все пары вида (x,u(x)))
    
    def __getitem__(self,item) -> Union[float, str]: # Индексатор
        return self.A[item] if item in self.A else "None"
    
    def __str__(self):
        return "{Имя} = {Функция}".format(Имя = self.Имя, Функция = self.A)

class Лингвистическая_переменная: # Кортеж вида (бета,T,X,G,M), где 
    def __init__(self, Имя:str, Значение:float = None, 
                 #X:List[int] = None, 
                 T:List[Нечёткая_переменная] = None 
                 #G = None, 
                 #M = None
                 ):
        self.Имя = Имя    # бета - имя переменной
        self.Значение = Значение  # Значение - точное скалярное значение лингвистической переменной (например для роста может быть от 150 до 200)
        #self.X = X if X is not None else []          # X - область определения терм-множества(универсум нечётких переменных), 
        self.T = T if T is not None else []          # T - множество её значений(терм-множество состоящее из нечётких переменных) 
        #self.G = G          # G - синтаксическая процедура, позволяющая генерировать новые термы(значения)
        #self.M = M          # M - семантическая процедура, ставящая в соответствие каждому терму, полученному с помощью G нечёткое множество
    
    def __str__(self):
        #Строка = self.Имя + ": " +  str(self.Значение) + "\n\t" + "\n\t".join([НПеременная.Имя + ": \t" +  str(НПеременная[self.Значение]) for НПеременная in self.T])
        return """
{Имя}: {Значение}
{Нечёткие_переменные}""".format(
Имя = self.Имя, 
Значение = self.Значение, 
Нечёткие_переменные = "\n".join(["{Принадлежность}: \t{НП}".format(
                                НП = str(нп), 
                                Принадлежность = "\t" +  str(нп[self.Значение])) for нп in self.T]))
                                
class Нечёткое_высказывание(Булева_формула): #<лингвистическая_переменная> IS <нечёткая_переменная(терм) данной лингвистической переменной> 
    def __init__(self, Лингвистическая_переменная:Лингвистическая_переменная, Терм:Нечёткая_переменная):
        self.Лингвистическая_переменная = Лингвистическая_переменная # Лингвистическая переменная 
        self.Терм = Терм # Терм лингвистической переменной
        super().__init__()
     
    def Вычислить_истинность(self)-> Union[float, None]:
        return self.Терм.A[self.Лингвистическая_переменная.Значение] if self.Лингвистическая_переменная.Значение is not None else None
    
    @property
    def Неопределённость(self)-> Union[float,None]: #-Свойство-геттер: Неопределённость - S(x) = -x0*log2(x0) -x1*log2(x1)
            return { 
                self[0] is None : None,
                self[0] not in [0,1] : -self[0]*math.log(self[0],2) - self[1]*math.log(self[1],2),
                self[0] in [0,1] : 0 #Учитывая невозможность вычисления логарифма от нуля рассматриваются дополнительно два предельных случая x0=0 и x1=0
                }[True]
    
    def __str__(self):
        return "{Лингвистическая_переменная} {Терм} = {Истинность}".format(
            Лингвистическая_переменная = self.Лингвистическая_переменная.Имя, Терм = self.Терм.Имя, Истинность = self.Истинность)

class КНФ(Булева_формула):
    def __init__(self,Список_высказываний:List[Нечёткое_высказывание],F:Dict[Нечёткое_высказывание,float]):
        self.Список_высказываний = Список_высказываний  #список высказываний, которые содержит кнф
        self.F = F  # F - список весовых коэффициентов высказываний, входящих в кнф
        super().__init__()
    
    def Вычислить_истинность(self) -> Union[float, None]:
        Агр = None
        for i in self.Список_высказываний:
            if Агр is None:
                Агр = Булева_формула(i.Истинность)
            else:
                Агр = Агр & i
        return Агр.Истинность
    
    def __str__(self):
        return " v ".join(["(" + str(Высказывание) + ")" for Высказывание in self.Список_высказываний]) + " = " + str(self.Истинность)
    
class Правило:
    def __init__(self,Aнтецедент:КНФ,Консеквент:КНФ,Z:float = 1): # Задание правила вида A -> B = Z
        self.Антецедент = Aнтецедент # A - антецедент правила (вида кнф)
        self.Консеквент = Консеквент # B - консеквент правила(вида кнф)
        self.Z = Z # Z - степень нечёткости правила (вещественное число в интервале [0,1])
        self.Не_использовано = True # Все правила при выводе учитываются только один раз
        
    def __str__(self):
        return "{Антецедент} -> {Консеквент} = {Нечёткость}".format(
            Антецедент = f"[{self.Антецедент}]", Консеквент = f"[{self.Консеквент}]", Нечёткость = self.Z)
    
class Модель:
    #------------ Правила вывода ------------
        
    @staticmethod
    def Правило_вывода_modus_ponens(Правило:Правило):
        if(Правило.Антецедент[1] is not None and Правило.Антецедент[1] >= (1-Правило.Z) and Правило.Антецедент[1] != 0):
            return 1 - (1 - Правило.Z)/Правило.Антецедент[1]
        else:
           raise Exception("вывод невозможен")
    
    
    @staticmethod
    def Правило_вывода_отсутствует(Правило:Правило):
        return None
    
    #------------ Распределения истинности ------------
    
    @staticmethod
    def Распределение_истинности_стандарт(Правило:Правило) -> Dict[Нечёткое_высказывание,float]:
       return dict((Fi[0],Fi[1]*Правило.Консеквент.Истинность if Правило.Консеквент.Истинность is not None else Fi[1]) for Fi in Правило.Консеквент.F.items())
      
    @staticmethod
    def Распределение_истинности_задача_о_студентах(Правило:Правило) -> Dict[Нечёткое_высказывание,float]:
       return dict((Fi[0],Fi[1]*Правило.Антецедент[1] * Правило.Z) for Fi in Правило.Консеквент.F.items())
    
    
    #------------ Композиции ------------
    
    @staticmethod
    def Композиция_дизъюнкции_матричная(x:float,ux:float):
        return (Булева_формула(x) | Булева_формула(ux)).Истинность if x is not None else ux
    
    @staticmethod
    def Композиция_конъюнкции_матричная(x:float,ux:float):
        return (Булева_формула(x) & Булева_формула(ux)).Истинность if x is not None else ux
    
    @staticmethod
    def Композиция_конъюнкции_нематричная(x:float,ux:float):
        return min(x,ux)
    
    @staticmethod
    def Композиция_Ларсена(x:float,ux:float):
        return x*ux
    
    #------------ Дополнения ------------
    
    @staticmethod
    def Дополнение_стандарт(Высказывание:Нечёткое_высказывание, Новая_истинность:float):
        Высказывание.Истинность = Новая_истинность
    
    @staticmethod
    def Дополнение_Цукамото(Высказывание:Нечёткое_высказывание, Новая_истинность:float): # Сохранить пару вида ci,wj где ci - истинность высказывания wj - предполагаемое значение его лингвистической переменной 
        if hasattr(Высказывание.a,"CW"):
            Высказывание.Лингвистическая_переменная.CW.append(next((x,Новая_истинность) for x in Высказывание.Терм.A.keys() if Высказывание.Терм.A[x] == Новая_истинность))
        else:
            Высказывание.Лингвистическая_переменная.CW = dict(next((x,Новая_истинность) for x in Высказывание.Терм.A.keys() if Высказывание.Терм.A[x] == Новая_истинность))
    
    #------------ Методы дефаззификации ------------
    
    @staticmethod
    def Аккумуляция_дизъюнкция_матричная(UX:List[float]):
        Sn = Булева_формула(0)
        for u in UX:
            Sn = Sn | Булева_формула(u)
        return Sn.Истинность

    @staticmethod
    def Аккумуляция_дизъюнкция_нематричная(UX:List[float]) -> float:
        return max(UX)
    
    #------------ Методы дефаззификации ------------
    @staticmethod
    def Дефаззификация_Метод_центра_тяжести(Лингвистическая_переменная:Лингвистическая_переменная) -> float:
        Функция = list(Лингвистическая_переменная.Аккумулированная_функция.items())
        нижняя_сумма = верхняя_сумма = 0
        ux1 = Функция[0]
        for ux2 in Функция:
            if ux2 != ux1:
                a = (ux2[1]-ux1[1])/(ux2[0]-ux1[0])
                b=ux1[1]-a*ux1[0]
                нижняя_сумма += (ux2[0]**2 - ux1[0]**2)*a/2 + (ux2[0] - ux1[0])*b
                верхняя_сумма += (ux2[0]**3-ux1[0]**3)*a/3 + (ux2[0]**2 - ux1[0]**2)*b/2
            ux1 = ux2
        
        return верхняя_сумма/нижняя_сумма if нижняя_сумма > 0 else 0
    
    @staticmethod
    def Дефаззификация_Метод_центра_тяжести_точечный(Лингвистическая_переменная:Лингвистическая_переменная):
        return sum([x*ux for (x,ux) in Лингвистическая_переменная.Аккумулированная_функция.items()]) / sum(Лингвистическая_переменная.Аккумулированная_функция.values())
    
    @staticmethod
    def Дефаззификация_Метод_центра_площади(Лингвистическая_переменная):
        суммарная_площадь = sum(Лингвистическая_переменная.Аккумулированная_функция.values()) 
        текущая_площадь = 0
        центр = 0
        for (x,ux) in Лингвистическая_переменная.Аккумулированная_функция.items():
            if текущая_площадь <= (суммарная_площадь - ux)/2:
                текущая_площадь += ux
                центр = x
                
        return центр
    
    @staticmethod
    def Дефаззификация_Метод_центра_тяжести_модифицированный(Лингвистическая_переменная:Лингвистическая_переменная):
        return sum([x*ux for (x,ux) in Лингвистическая_переменная.CW])/sum(Лингвистическая_переменная.CW.values())
    
    #-------------------- Стандартные алгоритмы ------------------------------
    @staticmethod
    def Модели(name:str):
        return {
            "Задача_об_оценивании_студентов":Модель(Композиция= Модель.Композиция_конъюнкции_матричная,Правило_вывода=Модель.Правило_вывода_отсутствует,Правило_распределения_истинности=Модель.Распределение_истинности_задача_о_студентах),
            "Мамдани_матричный" :Модель(),
            "Мамдани_нематричный": Модель(Композиция= Модель.Композиция_конъюнкции_нематричная,Правило_аккумуляции=Модель.Аккумуляция_дизъюнкция_нематричная,Метод_дефаззификации=Модель.Дефаззификация_Метод_центра_тяжести_точечный),
            "Цукамото":Модель(Композиция=Модель.Композиция_конъюнкции_нематричная,Дополнение= Модель.Дополнение_Цукамото, Правило_аккумуляции = lambda  ux: None,Метод_дефаззификации = Модель.Дефаззификация_Метод_центра_тяжести_модифицированный),
            "Ларсена":Модель(Композиция= Модель.Композиция_Ларсена, Правило_аккумуляции = Модель.Аккумуляция_дизъюнкция_нематричная, Метод_дефаззификации= Модель.Дефаззификация_Метод_центра_тяжести_точечный)
        }[name]
    
    
    def __init__(self,
                 Правило_вывода: Callable[[Нечёткая_переменная,float], float] = Правило_вывода_modus_ponens,
                 Правило_распределения_истинности: Callable[[Правило], Dict[Нечёткое_высказывание,float]] = Распределение_истинности_стандарт,
                 Композиция: Callable[[float,float],Union[float,None]] = Композиция_дизъюнкции_матричная,
                 Дополнение: Callable[[Нечёткое_высказывание,float],None] = Дополнение_стандарт,
                 Правило_аккумуляции: Callable[[List[float]],Union[float,None]] = Аккумуляция_дизъюнкция_матричная,
                 Метод_дефаззификации: Callable[[Лингвистическая_переменная],float] = Дефаззификация_Метод_центра_тяжести):
        
        self.Правило_вывода = Правило_вывода
        self.Правило_распределения_истинности = Правило_распределения_истинности 
        self.Композиция = Композиция
        self.Дополнение = Дополнение
        
        self.Правило_аккумуляции = Правило_аккумуляции
        self.Метод_дефаззификации = Метод_дефаззификации
        
class Нечёткий_вывод:
    def __init__(self):
            self.Лингвистические_переменные = []
            self.Нечёткие_переменные = []
            self.Высказывания = []
            self.Список_кнф = {}
            self.Правила = []

    def Вывод(self, Модель = Модель(),Чтение_файлов = True):
        def Формирование_базы_правил():
            def Считать_таблицу(Функция, Имя_файла):
                try:
                 with open(Имя_файла, encoding = 'utf-8', mode = 'r') as Файл:
                    Шапка = Файл.readline().rstrip("\n")
                    Запись = Файл.readline().rstrip("\n")
                    while Запись:
                        try:
                            Функция(Запись.split("\t"))
                        except Exception as e:
                            print("Запись {Зп} была пропущена ввиду некорректности: {Ошибка}".format( 
                                                                                                 Ошибка = e, 
                                                                                                 Зп = dict(zip(Шапка.split("\t"),Запись.split("\t")))))
                        finally:
                            Запись = Файл.readline().rstrip("\n")
                except Exception as e:
                    print(f"Файл не найден: {Имя_файла}")
                
            def Строка_к_вещественному(Строка):
                try:
                    return float(Строка.replace(",","."))
                except:
                    return None 
        
            def Считать_лингвистическую_переменную(Запись):
                self.Лингвистические_переменные.append(
                    Лингвистическая_переменная(Запись[0],Строка_к_вещественному(Запись[1])))    

            def Считать_нечёткую_переменную(Запись):
                НП = Нечёткая_переменная(Запись[0])
                self.Нечёткие_переменные.append(НП)
                self.Лингвистические_переменные[int(Запись[1])].T.append(НП)
        
            def Считать_функцию_принадлежности(Запись):
                self.Нечёткие_переменные[int(Запись[0])].A[Строка_к_вещественному(Запись[1])] = Строка_к_вещественному(Запись[2])
                
            def Считать_высказывание(Запись):
                self.Высказывания.append(Нечёткое_высказывание(self.Лингвистические_переменные[int(Запись[0])],self.Нечёткие_переменные[int(Запись[1])]))
        
            def Считать_кнф(Запись):
                try:
                    self.Список_кнф[int(Запись[1])].Список_высказываний.append(self.Высказывания[int(Запись[0])])
                    self.Список_кнф[int(Запись[1])].F[self.Высказывания[int(Запись[0])]] =float(Запись[2])
                except:
                    self.Список_кнф[int(Запись[1])] = КНФ([self.Высказывания[int(Запись[0])]],{self.Высказывания[int(Запись[0])]:float(Запись[2])})
        
            def Считать_правила(Запись): 
                self.Правила.append(
                    Правило(self.Список_кнф[int(Запись[0])],self.Список_кнф[int(Запись[1])],Строка_к_вещественному(Запись[2])))
    
            for Этап in [
                (Считать_лингвистическую_переменную ,  "Лингвистические_переменные.txt"),
                (Считать_нечёткую_переменную ,  "Нечёткие_переменные.txt"),
                (Считать_функцию_принадлежности ,  "Функции_принадлежности.txt"),
        
                (Считать_высказывание ,  "Высказывания.txt"),
                (Считать_кнф ,  "КНФ.txt"),
                (Считать_правила ,   "Правила.txt")
            ]:
                Считать_таблицу(Этап[0],Этап[1])
        
        def Фаззификация(): # Нахождение значений функции принадлежности задействованых в правилах термов на основе исходных данных
            for Правило in self.Правила:
                    for Высказывание in Правило.Антецедент.Список_высказываний:
                        Высказывание.Истинность = Высказывание.Вычислить_истинность()#Высказывание.Истинность
                    
        def Агрегирование_подусловий(): # Определение истинности условий каждого из правил
            for Правило in self.Правила:
                if Правило.Не_использовано:
                    
                    Истинность = Правило.Антецедент.Вычислить_истинность()
                    Правило.Антецедент.Истинность = Истинность

                    Правило.Не_использовано = Истинность is None or (Истинность <= 1 and Истинность >= 0) 
                    
                    Правило.Активность = (Истинность is not None and Истинность > 0) or (Модель.Правило_вывода!=Модель.Правило_вывода_modus_ponens) 
                
        def Активизация_подзаключений( # Определение истинности заключений, подзаключений, а также новых термов подзаключений
            Правило_вывода, 
            Правило_деления_истинности, # Способ деления вычисленной по правилу истинности между членами кнф 
            Композиция,  # Способ композиции новой функции для термов, истинность которых изменилась 
            Дополнение # Дополнительные действия если требуются
            ):
            for Правило in self.Правила:
                if Правило.Активность and Правило.Не_использовано:
                    #if Правило.Консеквент.Истинность is None: - стоит ли вычислять заново истинность заключения если она уже известна из предыдущих расчётов?
                    try:
                        Правило.Консеквент.Истинность = Правило_вывода(Правило) # Находим истинность заключения        
                        
                        Новая_истинность = Правило_деления_истинности(Правило)  # Нахождение истинности и новой функции принадлежности для термов подзаключений
                        for Высказывание in Правило.Консеквент.Список_высказываний: # Нераспределённую истинность делим поровну между всеми членами кнф 
                            Высказывание.Терм.A = dict((x,Композиция(ux,Новая_истинность[Высказывание])) for (x,ux) in Высказывание.Терм.A.items())
                            if Высказывание.Лингвистическая_переменная.Значение is not None:
                                Дополнение(Высказывание,Высказывание.Терм.A[Высказывание.Лингвистическая_переменная.Значение])
                    except Exception as e:
                        print(e)
                    finally:
                        Правило.Не_использовано = False
                                    
        def Аккумуляция_заключений(Правило_аккумуляции): # Объединение всех термов каждой лингвистической переменной в аккумулированную функцию
            for ЛП in self.Лингвистические_переменные:
                if ЛП.Значение is None:
                    ЛП.Аккумулированная_функция = dict((x,Правило_аккумуляции([u.A[x] for u in ЛП.T])) for x in ЛП.T[0].A.keys())
        
        def Дефаззификация_выходных_переменных(Метод):
            for ЛП in self.Лингвистические_переменные:
                if ЛП.Значение is None:
                    ЛП.Дефаззифицированное_значение = Метод(ЛП)

        if Чтение_файлов:
            Формирование_базы_правил()
       
        while True:
            Использованность_правил = [not x.Не_использовано for x in self.Правила]
            
            Фаззификация()
            Агрегирование_подусловий()
            Активизация_подзаключений(Модель.Правило_вывода,Модель.Правило_распределения_истинности,Модель.Композиция,Модель.Дополнение)
            Аккумуляция_заключений(Модель.Правило_аккумуляции)
            Дефаззификация_выходных_переменных(Модель.Метод_дефаззификации)
            
            if all([not x.Не_использовано for x in self.Правила]) or all([a==p for a,p in zip(Использованность_правил,[not x.Не_использовано for x in self.Правила])]):
               break
        
        for ЛП in self.Лингвистические_переменные:
            try:
                if hasattr(ЛП,"Аккумулированная_функция"): 
                    print(ЛП.Дефаззифицированное_значение)
            except:
                print("Ошибка")  
   
    def __str__(self):
        return """
---Лингвистические перменные---
{Лингвистические_переменные}
---Правила---
{Правила}
    """.format(
        Нечёткие_переменные = "\n".join([str(Переменная) for Переменная in self.Нечёткие_переменные]), 
        Лингвистические_переменные = "\n".join([str(Переменная) for Переменная in self.Лингвистические_переменные]),
        Правила = "\n".join([str(Правило) for Правило in self.Правила])) 