# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['glint_mask_generator']

package_data = \
{'': ['*']}

install_requires = \
['Pillow>=9.3.0,<9.4.0',
 'fire>=0.4.0,<0.5.0',
 'loguru>=0.6.0,<0.7.0',
 'numpy>=1.23.5,<1.24.0',
 'pyqt6>=6.4.0,<7.0.0',
 'scipy>=1.9.3,<1.10.0',
 'tqdm>=4.64.1,<4.65.0']

entry_points = \
{'console_scripts': ['glint-mask = glint_mask_generator.cli:main']}

setup_kwargs = {
    'name': 'glint-mask-tools',
    'version': '3.0.2',
    'description': 'Create masks for specular reflection in UAV and aerial imagery',
    'long_description': '# Glint Mask Tools\n\n![Python application](https://github.com/HakaiInstitute/glint-mask-tools/workflows/Main/badge.svg?branch=master)\n\n## Description\n\nGlintMaskGenerator generates image masks for regions in RGB and multispectral image files that have high levels of specular reflection.\n\nThese masks can be used in 3rd party structure-from-motion programs to replace these high glint regions with more useful data from adjacent, overlapping imagery.\n\n## Installation\n\n1. Go to the [releases page](https://github.com/HakaiInstitute/glint-mask-tools/releases)\n2. Download the latest release file for your operating system.\n3. Extract the compressed binary files from the gzipped archive.\n4. This archive contains a file named GlintMaskGenerator-v*.\\*.\\*.exe that provides a GUI interface to the glint mask generation program.\n5. You can copy these files to any location that is convenient for you.\n\n### PyPi package\n\nThere also a python package version of the code available for Python 3.8 and 3.9.\n\n1. `pip install glint-mask-tools` to install the tools.\n2. Then, `import glint_mask_generator` in your Python script.\n3. Installing with pip also installs the CLI tool, detailed below.\n\n## Usage\n\n### GUI\n\nIn Windows, launch the GUI by double clicking the executable file. In Linux, you\'ll have to launch the GUI from the\nterminal, e.g. `./GlintMaskGenerator`.\n\nFor now, generating masks by passing directory paths containing images is the supported workflow. Be sure to change the\nimage type option when processing imagery for cameras other than RGB cameras (e.g. Micasense RedEdge or DJI P4MS cameras). You will be notified of any\nprocessing errors via a pop-up dialog.\n\n### CLI\n\nFor information about the parameters expected by the CLI, run `glint-mask --help` in a bash terminal or command\nline interface. All the functionality of the CLI is documented there.\n\n#### Examples\n\n```bash\nglint-mask-v*.*.* --help\n\n# NAME\n#     glint-mask-v*.*.*\n# \n# SYNOPSIS\n#     glint-mask-v*.*.* - COMMAND | VALUE\n# \n# COMMANDS\n#     COMMAND is one of the following:\n# \n#      cir_threshold\n#        Generate masks for glint regions in 4 Band CIR imagery using Tom Bell\'s binning algorithm.\n# \n#      micasense_threshold\n#        Generate masks for glint regions in multispectral imagery from the Micasense camera using Tom Bell\'s algorithm on the blue image band.\n# \n#      p4ms_threshold\n#        Generate masks for glint regions in multispectral imagery from the DJI camera using Tom Bell\'s algorithm on the Blue image band.\n# \n#      process\n# \n#      rgb_threshold\n#        Generate masks for glint regions in RGB imagery using Tom Bell\'s binning algorithm.\n# \n# VALUES\n#     VALUE is one of the following:\n# \n#      max_workers\n#        The maximum number of threads to use for processing.\n```\n\n```bash\n# Get addition parameters for one of the cameras/methods available\nglint-mask-v*.*.* rgb_threshold --help\n\n# NAME\n#     glint-mask-v*.*.* rgb_threshold - Generate masks for glint regions in RGB imagery using Tom Bell\'s binning algorithm.\n# \n# SYNOPSIS\n#     glint-mask-v*.*.* rgb_threshold IMG_DIR OUT_DIR <flags>\n# \n# DESCRIPTION\n#     Generate masks for glint regions in RGB imagery using Tom Bell\'s binning algorithm.\n# \n# POSITIONAL ARGUMENTS\n#     IMG_DIR\n#         The path to a named input image or directory containing images. If img_dir is a directory, all tif, jpg, jpeg, and png images in that directory will be # processed.\n#     OUT_DIR\n#         The path to send your out image including the file name and type. e.g. "/path/to/mask.png". out_dir must be a directory if img_dir is specified as a # # # directory.\n# \n# FLAGS\n#     --thresholds=THRESHOLDS\n#         The pixel band thresholds indicating glint. Domain for values is (0.0, 1.0). Default is [1, 1, 0.875].\n#     --pixel_buffer=PIXEL_BUFFER\n#         The pixel distance to buffer out the mask. Defaults to 0 (off).\n# \n# NOTES\n#     You can also use flags syntax for POSITIONAL ARGUMENTS\n```\n\n```bash\n# Process rgb imagery directory with default parameters\nglint-mask-v*.*.* rgb_threshold /path/to/dir/with/images/ /path/to/out_masks/dir/\n\n# Process PhaseONE camera imagery with image bands split over multiple files\nglint-mask-v*.*.* aco_threshold /path/to/dir/with/images/ /path/to/out_masks/dir/\n\n# Process DJI P4MS imagery\nglint-mask-v*.*.* p4ms_threshold /path/to/dir/with/images/ /path/to/out_masks/dir/\n\n# Process Micasense RedEdge imagery \nglint-mask-v*.*.* micasense_threshold /path/to/dir/with/images/ /path/to/out_masks/dir/\n```\n\n### Python package\nInstalling the PyPi package allows integrating the mask generation workflow into existing python scripts with ease.\n\n```python\nfrom glint_mask_generator import MicasenseRedEdgeThresholdMasker\n\n# Also available: P4MSThresholdMasker, RGBIntensityRatioMasker, RGBThresholdMasker\n\nmasker = MicasenseRedEdgeThresholdMasker(img_dir="path/to/micasense/images/", mask_dir="path/to/output/dir/",\n                                         thresholds=(0.875, 1, 1, 1, 1), pixel_buffer=5)\nmasker.process(max_workers=5, callback=print, err_callback=print)\n```\n\n## Notes\n\n### Directory of images processing\n\n- All files with "jpg", "jpeg", "tif", "tiff" and "png" extensions will be processed. This can be extended as needed.\n  File extension matching is case-insensitive.\n- Output mask files with be in the specified directory, and have the same name as the input file with "_mask" appended\n  to the end of the file name stem. The file type will match the input type.\n\n### Multi-band image processing\n- For imagery types where each band is spread over multiple files, a mask will be generated for all the sibling band images.\n    - For example, if a mask is generated using a threshold on the blue band image, identical masks are saved for sibling red, green, blue, nir, and red_edge bands as well.\n    - If thresholds are passed for multiple bands, these mask outputs combined with a union operator before being saved for all the sibling bands associated with that capture event.\n\n## Bugs and Feature Requests\n\nThis software is under active development. Bugs and feature requests can be filed using issues page located [here](https://github.com/HakaiInstitute/glint-mask-tools/issues).\n\n## Citation\n\nResearch using these tools or code should cite the following resources\n\n```bibtext\n@article{Cavanaugh2021,\n\ttitle        = {An Automated Method for Mapping Giant Kelp Canopy Dynamics from UAV},\n\tauthor       = {Cavanaugh, K.C. and Cavanaugh, K.C. and Bell, T.W. and Hockridge, E.G.},\n\tyear         = 2021,\n\tjournal      = {Front. Environ. Sci.},\n\tvolume       = {8:587354},\n\tdoi          = {10.3389/fenvs.2020.587354}\n}\n@misc{Denouden2021,\n\ttitle        = {GlintMaskGenerator},\n\tauthor       = {Denouden, T. and Timmer, B. and Reshitnyk, L.},\n\tyear         = 2021,\n\tjournal      = {GitHub repository},\n\tpublisher    = {GitHub},\n\tdoi          = {10.21966/3cpa-2e10},\n\thowpublished = {\\url{https://github.com/HakaiInstitute/GlintMaskGenerator}},\n\tcommit       = {8cb19e55f128da86bf0dbd312bc360ac89fe71c3}\n}\n```\n\n## Development\n\nSee [DEVELOPMENT.md](DEVELOPMENT.md) for development and software maintenance instructions.\n\n## License\nGlintMaskGenerator is released under a MIT license, as found in the [LICENSE](LICENSE) file.\n',
    'author': 'Taylor Denouden',
    'author_email': 'taylor.denouden@hakai.org',
    'maintainer': 'None',
    'maintainer_email': 'None',
    'url': 'https://github.com/HakaiInstitute/GlintMaskGenerator',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.8.1,<3.11',
}


setup(**setup_kwargs)
