# Malware Bazaar Client

This is `bwbzcl`, a Python-based client for the [bazaar.abuse.ch] API.

## Installation

```
pip install mwbzcl
```

## Example Usage

After aliasing the script `client.py` to `mwbzcl` and setting the environment variable `MALWARE_BAZAAR_API_KEY` to 
the value from your [bazaar.abuse.ch] profile, a typical session may look like the following:

```Batch
$ mwbzcl --json signature AgentTesla | jq -r "select(.tags[] | contains ("""exe""")) | .sha256"
1f71b476b9450a59fc8b76f1c3e0ddb8eab1dcd34a0cb451b1d1d2f1aa882ab2
a349d5cf195bf2126c239760539077607db536a57529957577b93ef58a44daf6
24c871a763e208ba82f7ce7df48fea42c962214954181dc72f17c9112cc74c5e
8d4cb50c1044910b9464e20dc05f2e61643cce2898348a0ede91330736a831df
5eb9b4d6d7e12e2b605adb64d332ec0ef196520106ee561a99b528c7f82f49ef
d69aa1932b2e702e5065ee19da9fc9cf2b05e7dbaa617141b14eaa501a14955e

$ mwbzcl download 1f71b476b9450a59fc8b76f1c3e0ddb8eab1dcd34a0cb451b1d1d2f1aa882ab2
[INFO] Downloaded 1 file(s), 0 skipped.
```

## Development

```bash
pip install -r requirements.txt
```


[bazaar.abuse.ch]: https://bazaar.abuse.ch/
