"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.HostCatalogPlugin = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdktf = require("cdktf");
/**
* Represents a {@link https://www.terraform.io/docs/providers/boundary/r/host_catalog_plugin boundary_host_catalog_plugin}
*/
class HostCatalogPlugin extends cdktf.TerraformResource {
    // ===========
    // INITIALIZER
    // ===========
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/boundary/r/host_catalog_plugin boundary_host_catalog_plugin} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options HostCatalogPluginConfig
    */
    constructor(scope, id, config) {
        super(scope, id, {
            terraformResourceType: 'boundary_host_catalog_plugin',
            terraformGeneratorMetadata: {
                providerName: 'boundary',
                providerVersion: '1.1.0',
                providerVersionConstraint: '~> 1.0'
            },
            provider: config.provider,
            dependsOn: config.dependsOn,
            count: config.count,
            lifecycle: config.lifecycle,
            provisioners: config.provisioners,
            connection: config.connection,
            forEach: config.forEach
        });
        this._attributesJson = config.attributesJson;
        this._description = config.description;
        this._internalForceUpdate = config.internalForceUpdate;
        this._internalHmacUsedForSecretsConfigHmac = config.internalHmacUsedForSecretsConfigHmac;
        this._internalSecretsConfigHmac = config.internalSecretsConfigHmac;
        this._name = config.name;
        this._pluginId = config.pluginId;
        this._pluginName = config.pluginName;
        this._scopeId = config.scopeId;
        this._secretsHmac = config.secretsHmac;
        this._secretsJson = config.secretsJson;
    }
    get attributesJson() {
        return this.getStringAttribute('attributes_json');
    }
    set attributesJson(value) {
        this._attributesJson = value;
    }
    resetAttributesJson() {
        this._attributesJson = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get attributesJsonInput() {
        return this._attributesJson;
    }
    get description() {
        return this.getStringAttribute('description');
    }
    set description(value) {
        this._description = value;
    }
    resetDescription() {
        this._description = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get descriptionInput() {
        return this._description;
    }
    // id - computed: true, optional: false, required: false
    get id() {
        return this.getStringAttribute('id');
    }
    get internalForceUpdate() {
        return this.getStringAttribute('internal_force_update');
    }
    set internalForceUpdate(value) {
        this._internalForceUpdate = value;
    }
    resetInternalForceUpdate() {
        this._internalForceUpdate = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get internalForceUpdateInput() {
        return this._internalForceUpdate;
    }
    get internalHmacUsedForSecretsConfigHmac() {
        return this.getStringAttribute('internal_hmac_used_for_secrets_config_hmac');
    }
    set internalHmacUsedForSecretsConfigHmac(value) {
        this._internalHmacUsedForSecretsConfigHmac = value;
    }
    resetInternalHmacUsedForSecretsConfigHmac() {
        this._internalHmacUsedForSecretsConfigHmac = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get internalHmacUsedForSecretsConfigHmacInput() {
        return this._internalHmacUsedForSecretsConfigHmac;
    }
    get internalSecretsConfigHmac() {
        return this.getStringAttribute('internal_secrets_config_hmac');
    }
    set internalSecretsConfigHmac(value) {
        this._internalSecretsConfigHmac = value;
    }
    resetInternalSecretsConfigHmac() {
        this._internalSecretsConfigHmac = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get internalSecretsConfigHmacInput() {
        return this._internalSecretsConfigHmac;
    }
    get name() {
        return this.getStringAttribute('name');
    }
    set name(value) {
        this._name = value;
    }
    resetName() {
        this._name = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get nameInput() {
        return this._name;
    }
    get pluginId() {
        return this.getStringAttribute('plugin_id');
    }
    set pluginId(value) {
        this._pluginId = value;
    }
    resetPluginId() {
        this._pluginId = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get pluginIdInput() {
        return this._pluginId;
    }
    get pluginName() {
        return this.getStringAttribute('plugin_name');
    }
    set pluginName(value) {
        this._pluginName = value;
    }
    resetPluginName() {
        this._pluginName = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get pluginNameInput() {
        return this._pluginName;
    }
    get scopeId() {
        return this.getStringAttribute('scope_id');
    }
    set scopeId(value) {
        this._scopeId = value;
    }
    // Temporarily expose input value. Use with caution.
    get scopeIdInput() {
        return this._scopeId;
    }
    get secretsHmac() {
        return this.getStringAttribute('secrets_hmac');
    }
    set secretsHmac(value) {
        this._secretsHmac = value;
    }
    resetSecretsHmac() {
        this._secretsHmac = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get secretsHmacInput() {
        return this._secretsHmac;
    }
    get secretsJson() {
        return this.getStringAttribute('secrets_json');
    }
    set secretsJson(value) {
        this._secretsJson = value;
    }
    resetSecretsJson() {
        this._secretsJson = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get secretsJsonInput() {
        return this._secretsJson;
    }
    // =========
    // SYNTHESIS
    // =========
    synthesizeAttributes() {
        return {
            attributes_json: cdktf.stringToTerraform(this._attributesJson),
            description: cdktf.stringToTerraform(this._description),
            internal_force_update: cdktf.stringToTerraform(this._internalForceUpdate),
            internal_hmac_used_for_secrets_config_hmac: cdktf.stringToTerraform(this._internalHmacUsedForSecretsConfigHmac),
            internal_secrets_config_hmac: cdktf.stringToTerraform(this._internalSecretsConfigHmac),
            name: cdktf.stringToTerraform(this._name),
            plugin_id: cdktf.stringToTerraform(this._pluginId),
            plugin_name: cdktf.stringToTerraform(this._pluginName),
            scope_id: cdktf.stringToTerraform(this._scopeId),
            secrets_hmac: cdktf.stringToTerraform(this._secretsHmac),
            secrets_json: cdktf.stringToTerraform(this._secretsJson),
        };
    }
}
exports.HostCatalogPlugin = HostCatalogPlugin;
_a = JSII_RTTI_SYMBOL_1;
HostCatalogPlugin[_a] = { fqn: "@cdktf/provider-boundary.hostCatalogPlugin.HostCatalogPlugin", version: "1.0.0" };
// =================
// STATIC PROPERTIES
// =================
HostCatalogPlugin.tfResourceType = "boundary_host_catalog_plugin";
//# sourceMappingURL=data:application/json;base64,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