import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface CredentialUsernamePasswordConfig extends cdktf.TerraformMetaArguments {
    /**
    * The credential store in which to save this username/password credential.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/boundary/r/credential_username_password#credential_store_id CredentialUsernamePassword#credential_store_id}
    */
    readonly credentialStoreId: string;
    /**
    * The description of this username/password credential.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/boundary/r/credential_username_password#description CredentialUsernamePassword#description}
    */
    readonly description?: string;
    /**
    * The name of this username/password credential. Defaults to the resource name.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/boundary/r/credential_username_password#name CredentialUsernamePassword#name}
    */
    readonly name?: string;
    /**
    * The password of this username/password credential.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/boundary/r/credential_username_password#password CredentialUsernamePassword#password}
    */
    readonly password: string;
    /**
    * The username of this username/password credential.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/boundary/r/credential_username_password#username CredentialUsernamePassword#username}
    */
    readonly username: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/boundary/r/credential_username_password boundary_credential_username_password}
*/
export declare class CredentialUsernamePassword extends cdktf.TerraformResource {
    static readonly tfResourceType = "boundary_credential_username_password";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/boundary/r/credential_username_password boundary_credential_username_password} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options CredentialUsernamePasswordConfig
    */
    constructor(scope: Construct, id: string, config: CredentialUsernamePasswordConfig);
    private _credentialStoreId?;
    get credentialStoreId(): string;
    set credentialStoreId(value: string);
    get credentialStoreIdInput(): string | undefined;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    get id(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _password?;
    get password(): string;
    set password(value: string);
    get passwordInput(): string | undefined;
    get passwordHmac(): string;
    private _username?;
    get username(): string;
    set username(value: string);
    get usernameInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
