# Generated by Django 3.1.13 on 2021-10-21 12:24

from PIL import Image
from django.db import migrations
from django.conf import settings


def forwards_func(apps, schema_editor):
    if not settings.IGNORE_MIGRATION:
        DemodData = apps.get_model("base", "DemodData")
        demoddata = DemodData.objects.all()
        for datum in demoddata:
            try:
                if datum.payload_demod:
                    with datum.payload_demod.storage.open(datum.payload_demod.name,
                                                         mode='rb') as data_file:
                        img = Image.open(data_file)
                        img.verify()
                else:
                    with datum.demodulated_data.storage.open(datum.demodulated_data.name,
                                                            mode='rb') as data_file:
                        img = Image.open(data_file)
                        img.verify()
                datum.is_image = True
                datum.save()
            except:
                pass

def reverse_func(apps, schema_editor):
    DemodData = apps.get_model("base", "DemodData")
    DemodData.objects.all().update(is_image=False)

class Migration(migrations.Migration):

    dependencies = [
        ('base', '0092_add_is_image_field_for_demoddata_model'),
    ]

    operations = [
        migrations.RunPython(forwards_func, reverse_func),
    ]
