"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from .basesdk import BaseSDK
from datetime import datetime
from gr4vy import errors, models, utils
from gr4vy._hooks import HookContext
from gr4vy.types import OptionalNullable, UNSET
from gr4vy.utils import get_security_from_env
from jsonpath import JSONPath
from typing import Any, Dict, List, Mapping, Optional, Union


class ReportExecutionsSDK(BaseSDK):
    def list(
        self,
        *,
        cursor: OptionalNullable[str] = UNSET,
        limit: Optional[int] = 20,
        report_name: OptionalNullable[str] = UNSET,
        created_at_lte: OptionalNullable[datetime] = UNSET,
        created_at_gte: OptionalNullable[datetime] = UNSET,
        status: OptionalNullable[List[models.ReportExecutionStatus]] = UNSET,
        creator_id: OptionalNullable[List[str]] = UNSET,
        merchant_account_id: Optional[str] = None,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> Optional[models.ListAllReportExecutionsResponse]:
        r"""List executed reports

        List all executed reports that have been generated.

        :param cursor: A pointer to the page of results to return.
        :param limit: The maximum number of items that are at returned.
        :param report_name: Filters the reports by searching their name for (partial) matches.
        :param created_at_lte: Filters the results to only reports created before this ISO date-time string. The time zone must be included. Ensure that the date-time string is URL encoded, e.g. `2022-01-01T12:00:00+08:00` must be encoded as `2022-01-01T12%3A00%3A00%2B08%3A00`.
        :param created_at_gte: Filters the results to only reports created after this ISO date-time string. The time zone must be included. Ensure that the date-time string is URL encoded, e.g. `2022-01-01T12:00:00+08:00` must be encoded as `2022-01-01T12%3A00%3A00%2B08%3A00`.
        :param status: Filters the results to only the reports that have a `status` that matches with any of the provided status values.
        :param creator_id: Filters the results to only the reports that were created by the users with these IDs.
        :param merchant_account_id: The ID of the merchant account to use for this request.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.ListAllReportExecutionsRequest(
            cursor=cursor,
            limit=limit,
            report_name=report_name,
            created_at_lte=created_at_lte,
            created_at_gte=created_at_gte,
            status=status,
            creator_id=creator_id,
            merchant_account_id=merchant_account_id,
        )

        req = self._build_request(
            method="GET",
            path="/report-executions",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=False,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            _globals=models.ListAllReportExecutionsGlobals(
                merchant_account_id=self.sdk_configuration.globals.merchant_account_id,
            ),
            security=self.sdk_configuration.security,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config
            else:
                retries = utils.RetryConfig(
                    "backoff", utils.BackoffStrategy(200, 200, 1, 1000), True
                )

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["5XX"])

        http_res = self.do_request(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="list_all_report_executions",
                oauth2_scopes=[],
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=[
                "400",
                "401",
                "403",
                "404",
                "405",
                "409",
                "422",
                "425",
                "429",
                "4XX",
                "500",
                "502",
                "504",
                "5XX",
            ],
            retry_config=retry_config,
        )

        def next_func() -> Optional[models.ListAllReportExecutionsResponse]:
            body = utils.unmarshal_json(http_res.text, Union[Dict[Any, Any], List[Any]])
            next_cursor = JSONPath("$.next_cursor").parse(body)

            if len(next_cursor) == 0:
                return None

            next_cursor = next_cursor[0]
            if next_cursor is None:
                return None

            return self.list(
                cursor=next_cursor,
                limit=limit,
                report_name=report_name,
                created_at_lte=created_at_lte,
                created_at_gte=created_at_gte,
                status=status,
                creator_id=creator_id,
                merchant_account_id=merchant_account_id,
                retries=retries,
            )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return models.ListAllReportExecutionsResponse(
                result=utils.unmarshal_json(http_res.text, models.ReportExecutions),
                next=next_func,
            )
        if utils.match_response(http_res, "400", "application/json"):
            response_data = utils.unmarshal_json(http_res.text, errors.Error400Data)
            raise errors.Error400(data=response_data)
        if utils.match_response(http_res, "401", "application/json"):
            response_data = utils.unmarshal_json(http_res.text, errors.Error401Data)
            raise errors.Error401(data=response_data)
        if utils.match_response(http_res, "403", "application/json"):
            response_data = utils.unmarshal_json(http_res.text, errors.Error403Data)
            raise errors.Error403(data=response_data)
        if utils.match_response(http_res, "404", "application/json"):
            response_data = utils.unmarshal_json(http_res.text, errors.Error404Data)
            raise errors.Error404(data=response_data)
        if utils.match_response(http_res, "405", "application/json"):
            response_data = utils.unmarshal_json(http_res.text, errors.Error405Data)
            raise errors.Error405(data=response_data)
        if utils.match_response(http_res, "409", "application/json"):
            response_data = utils.unmarshal_json(http_res.text, errors.Error409Data)
            raise errors.Error409(data=response_data)
        if utils.match_response(http_res, "422", "application/json"):
            response_data = utils.unmarshal_json(
                http_res.text, errors.HTTPValidationErrorData
            )
            raise errors.HTTPValidationError(data=response_data)
        if utils.match_response(http_res, "425", "application/json"):
            response_data = utils.unmarshal_json(http_res.text, errors.Error425Data)
            raise errors.Error425(data=response_data)
        if utils.match_response(http_res, "429", "application/json"):
            response_data = utils.unmarshal_json(http_res.text, errors.Error429Data)
            raise errors.Error429(data=response_data)
        if utils.match_response(http_res, "500", "application/json"):
            response_data = utils.unmarshal_json(http_res.text, errors.Error500Data)
            raise errors.Error500(data=response_data)
        if utils.match_response(http_res, "502", "application/json"):
            response_data = utils.unmarshal_json(http_res.text, errors.Error502Data)
            raise errors.Error502(data=response_data)
        if utils.match_response(http_res, "504", "application/json"):
            response_data = utils.unmarshal_json(http_res.text, errors.Error504Data)
            raise errors.Error504(data=response_data)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.APIError(
                "API error occurred", http_res.status_code, http_res_text, http_res
            )
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.APIError(
                "API error occurred", http_res.status_code, http_res_text, http_res
            )

        content_type = http_res.headers.get("Content-Type")
        http_res_text = utils.stream_to_text(http_res)
        raise errors.APIError(
            f"Unexpected response received (code: {http_res.status_code}, type: {content_type})",
            http_res.status_code,
            http_res_text,
            http_res,
        )

    async def list_async(
        self,
        *,
        cursor: OptionalNullable[str] = UNSET,
        limit: Optional[int] = 20,
        report_name: OptionalNullable[str] = UNSET,
        created_at_lte: OptionalNullable[datetime] = UNSET,
        created_at_gte: OptionalNullable[datetime] = UNSET,
        status: OptionalNullable[List[models.ReportExecutionStatus]] = UNSET,
        creator_id: OptionalNullable[List[str]] = UNSET,
        merchant_account_id: Optional[str] = None,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> Optional[models.ListAllReportExecutionsResponse]:
        r"""List executed reports

        List all executed reports that have been generated.

        :param cursor: A pointer to the page of results to return.
        :param limit: The maximum number of items that are at returned.
        :param report_name: Filters the reports by searching their name for (partial) matches.
        :param created_at_lte: Filters the results to only reports created before this ISO date-time string. The time zone must be included. Ensure that the date-time string is URL encoded, e.g. `2022-01-01T12:00:00+08:00` must be encoded as `2022-01-01T12%3A00%3A00%2B08%3A00`.
        :param created_at_gte: Filters the results to only reports created after this ISO date-time string. The time zone must be included. Ensure that the date-time string is URL encoded, e.g. `2022-01-01T12:00:00+08:00` must be encoded as `2022-01-01T12%3A00%3A00%2B08%3A00`.
        :param status: Filters the results to only the reports that have a `status` that matches with any of the provided status values.
        :param creator_id: Filters the results to only the reports that were created by the users with these IDs.
        :param merchant_account_id: The ID of the merchant account to use for this request.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.ListAllReportExecutionsRequest(
            cursor=cursor,
            limit=limit,
            report_name=report_name,
            created_at_lte=created_at_lte,
            created_at_gte=created_at_gte,
            status=status,
            creator_id=creator_id,
            merchant_account_id=merchant_account_id,
        )

        req = self._build_request_async(
            method="GET",
            path="/report-executions",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=False,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            _globals=models.ListAllReportExecutionsGlobals(
                merchant_account_id=self.sdk_configuration.globals.merchant_account_id,
            ),
            security=self.sdk_configuration.security,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config
            else:
                retries = utils.RetryConfig(
                    "backoff", utils.BackoffStrategy(200, 200, 1, 1000), True
                )

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["5XX"])

        http_res = await self.do_request_async(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="list_all_report_executions",
                oauth2_scopes=[],
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=[
                "400",
                "401",
                "403",
                "404",
                "405",
                "409",
                "422",
                "425",
                "429",
                "4XX",
                "500",
                "502",
                "504",
                "5XX",
            ],
            retry_config=retry_config,
        )

        def next_func() -> Optional[models.ListAllReportExecutionsResponse]:
            body = utils.unmarshal_json(http_res.text, Union[Dict[Any, Any], List[Any]])
            next_cursor = JSONPath("$.next_cursor").parse(body)

            if len(next_cursor) == 0:
                return None

            next_cursor = next_cursor[0]
            if next_cursor is None:
                return None

            return self.list(
                cursor=next_cursor,
                limit=limit,
                report_name=report_name,
                created_at_lte=created_at_lte,
                created_at_gte=created_at_gte,
                status=status,
                creator_id=creator_id,
                merchant_account_id=merchant_account_id,
                retries=retries,
            )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return models.ListAllReportExecutionsResponse(
                result=utils.unmarshal_json(http_res.text, models.ReportExecutions),
                next=next_func,
            )
        if utils.match_response(http_res, "400", "application/json"):
            response_data = utils.unmarshal_json(http_res.text, errors.Error400Data)
            raise errors.Error400(data=response_data)
        if utils.match_response(http_res, "401", "application/json"):
            response_data = utils.unmarshal_json(http_res.text, errors.Error401Data)
            raise errors.Error401(data=response_data)
        if utils.match_response(http_res, "403", "application/json"):
            response_data = utils.unmarshal_json(http_res.text, errors.Error403Data)
            raise errors.Error403(data=response_data)
        if utils.match_response(http_res, "404", "application/json"):
            response_data = utils.unmarshal_json(http_res.text, errors.Error404Data)
            raise errors.Error404(data=response_data)
        if utils.match_response(http_res, "405", "application/json"):
            response_data = utils.unmarshal_json(http_res.text, errors.Error405Data)
            raise errors.Error405(data=response_data)
        if utils.match_response(http_res, "409", "application/json"):
            response_data = utils.unmarshal_json(http_res.text, errors.Error409Data)
            raise errors.Error409(data=response_data)
        if utils.match_response(http_res, "422", "application/json"):
            response_data = utils.unmarshal_json(
                http_res.text, errors.HTTPValidationErrorData
            )
            raise errors.HTTPValidationError(data=response_data)
        if utils.match_response(http_res, "425", "application/json"):
            response_data = utils.unmarshal_json(http_res.text, errors.Error425Data)
            raise errors.Error425(data=response_data)
        if utils.match_response(http_res, "429", "application/json"):
            response_data = utils.unmarshal_json(http_res.text, errors.Error429Data)
            raise errors.Error429(data=response_data)
        if utils.match_response(http_res, "500", "application/json"):
            response_data = utils.unmarshal_json(http_res.text, errors.Error500Data)
            raise errors.Error500(data=response_data)
        if utils.match_response(http_res, "502", "application/json"):
            response_data = utils.unmarshal_json(http_res.text, errors.Error502Data)
            raise errors.Error502(data=response_data)
        if utils.match_response(http_res, "504", "application/json"):
            response_data = utils.unmarshal_json(http_res.text, errors.Error504Data)
            raise errors.Error504(data=response_data)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.APIError(
                "API error occurred", http_res.status_code, http_res_text, http_res
            )
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.APIError(
                "API error occurred", http_res.status_code, http_res_text, http_res
            )

        content_type = http_res.headers.get("Content-Type")
        http_res_text = await utils.stream_to_text_async(http_res)
        raise errors.APIError(
            f"Unexpected response received (code: {http_res.status_code}, type: {content_type})",
            http_res.status_code,
            http_res_text,
            http_res,
        )
