"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .method import Method
from gr4vy.types import BaseModel
from gr4vy.utils import validate_const, validate_open_enum
import pydantic
from pydantic.functional_validators import AfterValidator, PlainValidator
from typing import Literal, Optional
from typing_extensions import Annotated, TypedDict


class TransactionPaymentServiceTypedDict(TypedDict):
    id: str
    r"""The ID for the payment-service."""
    payment_service_definition_id: str
    r"""The definition ID of the service used to process this payment."""
    method: Method
    display_name: str
    r"""The display name for the payment service."""
    type: Literal["payment-service"]
    r"""Always `payment-service`."""


class TransactionPaymentService(BaseModel):
    id: str
    r"""The ID for the payment-service."""

    payment_service_definition_id: str
    r"""The definition ID of the service used to process this payment."""

    method: Annotated[Method, PlainValidator(validate_open_enum(False))]

    display_name: str
    r"""The display name for the payment service."""

    TYPE: Annotated[
        Annotated[
            Optional[Literal["payment-service"]],
            AfterValidator(validate_const("payment-service")),
        ],
        pydantic.Field(alias="type"),
    ] = "payment-service"
    r"""Always `payment-service`."""
