"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .airline import Airline, AirlineTypedDict
from gr4vy.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
from pydantic import model_serializer
from typing_extensions import NotRequired, TypedDict


class TransactionCaptureTypedDict(TypedDict):
    r"""Request body for capturing an authorized transaction."""

    amount: NotRequired[Nullable[int]]
    r"""The amount to capture, in the smallest currency unit (e.g., cents). This must be less than or equal to the authorized amount, unless over-capture is available."""
    airline: NotRequired[Nullable[AirlineTypedDict]]
    r"""The airline data to submit to the payment service during the capture call."""


class TransactionCapture(BaseModel):
    r"""Request body for capturing an authorized transaction."""

    amount: OptionalNullable[int] = UNSET
    r"""The amount to capture, in the smallest currency unit (e.g., cents). This must be less than or equal to the authorized amount, unless over-capture is available."""

    airline: OptionalNullable[Airline] = UNSET
    r"""The airline data to submit to the payment service during the capture call."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["amount", "airline"]
        nullable_fields = ["amount", "airline"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
