"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .field import FieldT, FieldTTypedDict
from .merchantprofilescheme import MerchantProfileScheme, MerchantProfileSchemeTypedDict
from gr4vy.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
from pydantic import model_serializer
from typing import Dict, List, Optional
from typing_extensions import NotRequired, TypedDict


class PaymentServiceCreateTypedDict(TypedDict):
    r"""Request body for activating a payment service"""

    display_name: str
    r"""The display name for the payment service."""
    payment_service_definition_id: str
    r"""The definition ID of the service to configure."""
    fields: List[FieldTTypedDict]
    r"""The non-secret credential fields that have been configured for this payment service. Any secret fields are omitted."""
    accepted_currencies: List[str]
    r"""A list of currencies for which this service is enabled, in ISO 4217 three-letter code format."""
    accepted_countries: List[str]
    r"""A list of countries for which this service is enabled, in ISO two-letter code format."""
    reporting_fields: NotRequired[Nullable[List[FieldTTypedDict]]]
    r"""The non-secret reporting fields that have been configured for this payment service. Any secret fields are omitted."""
    position: NotRequired[Nullable[int]]
    r"""Deprecated field used to define the order in which to process payment services"""
    active: NotRequired[Nullable[bool]]
    r"""Defines if this payment service is currently active."""
    three_d_secure_enabled: NotRequired[bool]
    r"""Defines if this payment service has 3DS enabled."""
    merchant_profile: NotRequired[
        Nullable[Dict[str, Nullable[MerchantProfileSchemeTypedDict]]]
    ]
    r"""An object containing a key for each supported card schemes, and for each key an object with the 3DS profile for this service for that scheme."""
    payment_method_tokenization_enabled: NotRequired[Nullable[bool]]
    r"""Defines if this payment service support payment method tokenization."""
    network_tokens_enabled: NotRequired[Nullable[bool]]
    r"""Defines if this payment service supports network tokens."""
    open_loop: NotRequired[Nullable[bool]]
    r"""Defines if this payment service is open loop."""
    settlement_reporting_enabled: NotRequired[bool]
    r"""Defines if this payment service has settlement reporting enabled."""


class PaymentServiceCreate(BaseModel):
    r"""Request body for activating a payment service"""

    display_name: str
    r"""The display name for the payment service."""

    payment_service_definition_id: str
    r"""The definition ID of the service to configure."""

    fields: List[FieldT]
    r"""The non-secret credential fields that have been configured for this payment service. Any secret fields are omitted."""

    accepted_currencies: List[str]
    r"""A list of currencies for which this service is enabled, in ISO 4217 three-letter code format."""

    accepted_countries: List[str]
    r"""A list of countries for which this service is enabled, in ISO two-letter code format."""

    reporting_fields: OptionalNullable[List[FieldT]] = UNSET
    r"""The non-secret reporting fields that have been configured for this payment service. Any secret fields are omitted."""

    position: OptionalNullable[int] = UNSET
    r"""Deprecated field used to define the order in which to process payment services"""

    active: OptionalNullable[bool] = UNSET
    r"""Defines if this payment service is currently active."""

    three_d_secure_enabled: Optional[bool] = False
    r"""Defines if this payment service has 3DS enabled."""

    merchant_profile: OptionalNullable[Dict[str, Nullable[MerchantProfileScheme]]] = (
        UNSET
    )
    r"""An object containing a key for each supported card schemes, and for each key an object with the 3DS profile for this service for that scheme."""

    payment_method_tokenization_enabled: OptionalNullable[bool] = UNSET
    r"""Defines if this payment service support payment method tokenization."""

    network_tokens_enabled: OptionalNullable[bool] = UNSET
    r"""Defines if this payment service supports network tokens."""

    open_loop: OptionalNullable[bool] = UNSET
    r"""Defines if this payment service is open loop."""

    settlement_reporting_enabled: Optional[bool] = False
    r"""Defines if this payment service has settlement reporting enabled."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "reporting_fields",
            "position",
            "active",
            "three_d_secure_enabled",
            "merchant_profile",
            "payment_method_tokenization_enabled",
            "network_tokens_enabled",
            "open_loop",
            "settlement_reporting_enabled",
        ]
        nullable_fields = [
            "reporting_fields",
            "position",
            "active",
            "merchant_profile",
            "payment_method_tokenization_enabled",
            "network_tokens_enabled",
            "open_loop",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
