"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .approvaltarget import ApprovalTarget
from gr4vy.types import BaseModel
from gr4vy.utils import validate_open_enum
from pydantic.functional_validators import PlainValidator
from typing_extensions import Annotated, TypedDict


class PaymentServiceConfigurationTypedDict(TypedDict):
    approval_ui_target: ApprovalTarget
    approval_ui_height: str
    r"""Height of the approval interface in either pixels or view height (vh)."""
    approval_ui_width: str
    r"""Width of the approval interface in either pixels or view width (vw)."""
    cart_items_limit: int
    r"""The maximum number of cart items supported by this connector before we will truncate the list."""
    cart_items_required: bool
    r"""Defines if cart items are required by this connector."""
    cart_items_should_match_amount: bool
    r"""Defines if the cart items sum value should match the transaction amount."""


class PaymentServiceConfiguration(BaseModel):
    approval_ui_target: Annotated[
        ApprovalTarget, PlainValidator(validate_open_enum(False))
    ]

    approval_ui_height: str
    r"""Height of the approval interface in either pixels or view height (vh)."""

    approval_ui_width: str
    r"""Width of the approval interface in either pixels or view width (vw)."""

    cart_items_limit: int
    r"""The maximum number of cart items supported by this connector before we will truncate the list."""

    cart_items_required: bool
    r"""Defines if cart items are required by this connector."""

    cart_items_should_match_amount: bool
    r"""Defines if the cart items sum value should match the transaction amount."""
