"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .giftcardserviceprovider import GiftCardServiceProvider
from gr4vy.types import BaseModel
from gr4vy.utils import validate_const, validate_open_enum
import pydantic
from pydantic.functional_validators import AfterValidator, PlainValidator
from typing import Literal, Optional
from typing_extensions import Annotated, TypedDict


class GiftCardServiceTypedDict(TypedDict):
    id: str
    r"""The ID for the gift card service."""
    gift_card_service_definition_id: GiftCardServiceProvider
    display_name: str
    r"""The display name for the gift card service."""
    type: Literal["gift-card-service"]
    r"""Always `gift-card-service`."""


class GiftCardService(BaseModel):
    id: str
    r"""The ID for the gift card service."""

    gift_card_service_definition_id: Annotated[
        GiftCardServiceProvider, PlainValidator(validate_open_enum(False))
    ]

    display_name: str
    r"""The display name for the gift card service."""

    TYPE: Annotated[
        Annotated[
            Optional[Literal["gift-card-service"]],
            AfterValidator(validate_const("gift-card-service")),
        ],
        pydantic.Field(alias="type"),
    ] = "gift-card-service"
    r"""Always `gift-card-service`."""
