"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from gr4vy.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
from pydantic import model_serializer
from typing_extensions import NotRequired, TypedDict


class GiftCardCreateTypedDict(TypedDict):
    number: str
    r"""The 16-19 digit number for the gift card."""
    pin: str
    r"""The PIN for this gift card."""
    buyer_id: NotRequired[Nullable[str]]
    r"""The ID of the buyer to associate this gift card to. If this field is provided then the `buyer_external_identifier` field needs to be unset."""
    buyer_external_identifier: NotRequired[Nullable[str]]
    r"""The `external_identifier` of the buyer to associate this gift card to. If this field is provided then the `buyer_id` field needs to be unset."""


class GiftCardCreate(BaseModel):
    number: str
    r"""The 16-19 digit number for the gift card."""

    pin: str
    r"""The PIN for this gift card."""

    buyer_id: OptionalNullable[str] = UNSET
    r"""The ID of the buyer to associate this gift card to. If this field is provided then the `buyer_external_identifier` field needs to be unset."""

    buyer_external_identifier: OptionalNullable[str] = UNSET
    r"""The `external_identifier` of the buyer to associate this gift card to. If this field is provided then the `buyer_id` field needs to be unset."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["buyer_id", "buyer_external_identifier"]
        nullable_fields = ["buyer_id", "buyer_external_identifier"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
