"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from .basesdk import BaseSDK
from gr4vy import errors, models, utils
from gr4vy._hooks import HookContext
from gr4vy.types import OptionalNullable, UNSET
from gr4vy.utils import get_security_from_env
from typing import Any, Mapping, Optional


class CardSchemeDefinitionsSDK(BaseSDK):
    def list(
        self,
        *,
        merchant_account_id: Optional[str] = None,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.CardSchemeDefinitions:
        r"""List card scheme definitions

        Fetch a list of the definitions of each card scheme.

        :param merchant_account_id: The ID of the merchant account to use for this request.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.ListCardSchemeDefinitionsRequest(
            merchant_account_id=merchant_account_id,
        )

        req = self._build_request(
            method="GET",
            path="/card-scheme-definitions",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=False,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            _globals=models.ListCardSchemeDefinitionsGlobals(
                merchant_account_id=self.sdk_configuration.globals.merchant_account_id,
            ),
            security=self.sdk_configuration.security,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config
            else:
                retries = utils.RetryConfig(
                    "backoff", utils.BackoffStrategy(200, 200, 1, 1000), True
                )

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["5XX"])

        http_res = self.do_request(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="list_card_scheme_definitions",
                oauth2_scopes=[],
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=[
                "400",
                "401",
                "403",
                "404",
                "405",
                "409",
                "422",
                "425",
                "429",
                "4XX",
                "500",
                "502",
                "504",
                "5XX",
            ],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return utils.unmarshal_json(http_res.text, models.CardSchemeDefinitions)
        if utils.match_response(http_res, "400", "application/json"):
            response_data = utils.unmarshal_json(http_res.text, errors.Error400Data)
            raise errors.Error400(data=response_data)
        if utils.match_response(http_res, "401", "application/json"):
            response_data = utils.unmarshal_json(http_res.text, errors.Error401Data)
            raise errors.Error401(data=response_data)
        if utils.match_response(http_res, "403", "application/json"):
            response_data = utils.unmarshal_json(http_res.text, errors.Error403Data)
            raise errors.Error403(data=response_data)
        if utils.match_response(http_res, "404", "application/json"):
            response_data = utils.unmarshal_json(http_res.text, errors.Error404Data)
            raise errors.Error404(data=response_data)
        if utils.match_response(http_res, "405", "application/json"):
            response_data = utils.unmarshal_json(http_res.text, errors.Error405Data)
            raise errors.Error405(data=response_data)
        if utils.match_response(http_res, "409", "application/json"):
            response_data = utils.unmarshal_json(http_res.text, errors.Error409Data)
            raise errors.Error409(data=response_data)
        if utils.match_response(http_res, "422", "application/json"):
            response_data = utils.unmarshal_json(
                http_res.text, errors.HTTPValidationErrorData
            )
            raise errors.HTTPValidationError(data=response_data)
        if utils.match_response(http_res, "425", "application/json"):
            response_data = utils.unmarshal_json(http_res.text, errors.Error425Data)
            raise errors.Error425(data=response_data)
        if utils.match_response(http_res, "429", "application/json"):
            response_data = utils.unmarshal_json(http_res.text, errors.Error429Data)
            raise errors.Error429(data=response_data)
        if utils.match_response(http_res, "500", "application/json"):
            response_data = utils.unmarshal_json(http_res.text, errors.Error500Data)
            raise errors.Error500(data=response_data)
        if utils.match_response(http_res, "502", "application/json"):
            response_data = utils.unmarshal_json(http_res.text, errors.Error502Data)
            raise errors.Error502(data=response_data)
        if utils.match_response(http_res, "504", "application/json"):
            response_data = utils.unmarshal_json(http_res.text, errors.Error504Data)
            raise errors.Error504(data=response_data)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.APIError(
                "API error occurred", http_res.status_code, http_res_text, http_res
            )
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.APIError(
                "API error occurred", http_res.status_code, http_res_text, http_res
            )

        content_type = http_res.headers.get("Content-Type")
        http_res_text = utils.stream_to_text(http_res)
        raise errors.APIError(
            f"Unexpected response received (code: {http_res.status_code}, type: {content_type})",
            http_res.status_code,
            http_res_text,
            http_res,
        )

    async def list_async(
        self,
        *,
        merchant_account_id: Optional[str] = None,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.CardSchemeDefinitions:
        r"""List card scheme definitions

        Fetch a list of the definitions of each card scheme.

        :param merchant_account_id: The ID of the merchant account to use for this request.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.ListCardSchemeDefinitionsRequest(
            merchant_account_id=merchant_account_id,
        )

        req = self._build_request_async(
            method="GET",
            path="/card-scheme-definitions",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=False,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            _globals=models.ListCardSchemeDefinitionsGlobals(
                merchant_account_id=self.sdk_configuration.globals.merchant_account_id,
            ),
            security=self.sdk_configuration.security,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config
            else:
                retries = utils.RetryConfig(
                    "backoff", utils.BackoffStrategy(200, 200, 1, 1000), True
                )

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["5XX"])

        http_res = await self.do_request_async(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="list_card_scheme_definitions",
                oauth2_scopes=[],
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=[
                "400",
                "401",
                "403",
                "404",
                "405",
                "409",
                "422",
                "425",
                "429",
                "4XX",
                "500",
                "502",
                "504",
                "5XX",
            ],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return utils.unmarshal_json(http_res.text, models.CardSchemeDefinitions)
        if utils.match_response(http_res, "400", "application/json"):
            response_data = utils.unmarshal_json(http_res.text, errors.Error400Data)
            raise errors.Error400(data=response_data)
        if utils.match_response(http_res, "401", "application/json"):
            response_data = utils.unmarshal_json(http_res.text, errors.Error401Data)
            raise errors.Error401(data=response_data)
        if utils.match_response(http_res, "403", "application/json"):
            response_data = utils.unmarshal_json(http_res.text, errors.Error403Data)
            raise errors.Error403(data=response_data)
        if utils.match_response(http_res, "404", "application/json"):
            response_data = utils.unmarshal_json(http_res.text, errors.Error404Data)
            raise errors.Error404(data=response_data)
        if utils.match_response(http_res, "405", "application/json"):
            response_data = utils.unmarshal_json(http_res.text, errors.Error405Data)
            raise errors.Error405(data=response_data)
        if utils.match_response(http_res, "409", "application/json"):
            response_data = utils.unmarshal_json(http_res.text, errors.Error409Data)
            raise errors.Error409(data=response_data)
        if utils.match_response(http_res, "422", "application/json"):
            response_data = utils.unmarshal_json(
                http_res.text, errors.HTTPValidationErrorData
            )
            raise errors.HTTPValidationError(data=response_data)
        if utils.match_response(http_res, "425", "application/json"):
            response_data = utils.unmarshal_json(http_res.text, errors.Error425Data)
            raise errors.Error425(data=response_data)
        if utils.match_response(http_res, "429", "application/json"):
            response_data = utils.unmarshal_json(http_res.text, errors.Error429Data)
            raise errors.Error429(data=response_data)
        if utils.match_response(http_res, "500", "application/json"):
            response_data = utils.unmarshal_json(http_res.text, errors.Error500Data)
            raise errors.Error500(data=response_data)
        if utils.match_response(http_res, "502", "application/json"):
            response_data = utils.unmarshal_json(http_res.text, errors.Error502Data)
            raise errors.Error502(data=response_data)
        if utils.match_response(http_res, "504", "application/json"):
            response_data = utils.unmarshal_json(http_res.text, errors.Error504Data)
            raise errors.Error504(data=response_data)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.APIError(
                "API error occurred", http_res.status_code, http_res_text, http_res
            )
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.APIError(
                "API error occurred", http_res.status_code, http_res_text, http_res
            )

        content_type = http_res.headers.get("Content-Type")
        http_res_text = await utils.stream_to_text_async(http_res)
        raise errors.APIError(
            f"Unexpected response received (code: {http_res.status_code}, type: {content_type})",
            http_res.status_code,
            http_res_text,
            http_res,
        )
