from setuptools import setup, find_packages
import codecs
import os

here = os.path.abspath(os.path.dirname(__file__))

with codecs.open(os.path.join(here, "README.md"), encoding="utf-8") as fh:
    long_description = "\n" + fh.read()

# This gets deployed when a new release is made by github actions
VERSION = '0.0.4'
DESCRIPTION = 'Package for building Machine learning models'
LONG_DESCRIPTION = 'A package that allows you to build complex machine learning models in a simple fashion'

setup(
    name="redmind",
    version=VERSION,
    author="Diego Velez",
    author_email="diegovelezs94@gmail.com",
    description=DESCRIPTION,
    long_description_content_type="text/markdown",
    long_description=long_description,
    packages=find_packages(),
    install_requires=['numpy', 'matplotlib', 'dill'],
    keywords=['python', 'ai', 'machine learning', 'neural network'],
    classifiers=[
        "Development Status :: 1 - Planning",
        "Intended Audience :: Developers",
        "Programming Language :: Python :: 3",
        "Operating System :: Unix",
        "Operating System :: MacOS :: MacOS X",
        "Operating System :: Microsoft :: Windows",
    ]
)