# -*- coding: utf-8 -*-
from setuptools import setup

package_dir = \
{'': 'src'}

packages = \
['jokeapi']

package_data = \
{'': ['*']}

install_requires = \
['aiohttp>=3.7.4,<4.0.0', 'simplejson>=3.17.2,<4.0.0', 'urllib3>=1.26.2,<2.0.0']

setup_kwargs = {
    'name': 'jokeapi',
    'version': '1.0.5',
    'description': "Python API Wrapper for Sv443's JokeAPI (https://v2.jokeapi.dev)",
    'long_description': '# Sv443\'s Joke API Wrapper\n<div align="center" style="text-align:center">\n\n[![Downloads](https://pepy.tech/badge/jokeapi)](https://pepy.tech/project/jokeapi)\n[![Downloads](https://pepy.tech/badge/jokeapi/month)](https://pepy.tech/project/jokeapi/month)\n[![Downloads](https://pepy.tech/badge/jokeapi/week)](https://pepy.tech/project/jokeapi/week)\n[![CircleCI](https://circleci.com/gh/leet-hakker/JokeAPI-Python.svg?style=svg)](https://circleci.com/gh/leet-hakker/JokeAPI-Python)\n\n\n</div>\nAn API wrapper for Sv443\'s joke api which provides simple yet versatile functionality,\nwhile also maintaining a readable codebase.\n\n## Install\n\nYou can install jokeapi through [pip](https://pypi.org/project/pip/) by using `pip install jokeapi`\n\n---\n\n# get_joke\n\nThe wrapper is structured in such a way that the end-user should only ever have to\ninteract with one function to get a joke. This function is `get_joke()`.\n\nPlease note that urllib3, the core dependency of this wrapper automatically abides by\n`Retry-After` headers, which means you may have to wait a long time for a joke if you\nhave made a lot of requests recently\n\n---\n\n# submit_joke\n\nThe wrapper also provides simple access to the submit endpoint through the `submit_joke()`\nfunction.\n\nNote that joke submissions are manually checked and you will be ratelimited.\n\n---\n\n## get_joke\n\n### Example\n\n```python\nfrom jokeapi import Jokes # Import the Jokes class\nimport asyncio\n\nasync def print_joke():\n    j = await Jokes()  # Initialise the class\n    joke = await j.get_joke()  # Retrieve a random joke\n    if joke["type"] == "single": # Print the joke\n        print(joke["joke"])\n    else:\n        print(joke["setup"])\n        print(joke["delivery"])\n\nasyncio.run(print_joke())\n```\n\n### Parameters\n\n---\n\n#### category\n\nA list of categories that the returned joke should fit in.\nOptions are:\n`programming`,\n`miscellaneous`,\n`dark`,\n`pun`\n\nIf left blank it will default to use `Any`.\n\n##### Example\n\n```python\n  joke = await j.get_joke(category=[\'programming\', \'dark\'])  # Will return a joke that fits in either the programming or dark category.\n```\n\n---\n\n#### blacklist\n\nA list of properties that the joke *shouldn\'t* have.\nOptions are:\n`nsfw`,\n`religious`,\n`political`,\n`racist`,\n`sexist`\n\nIf left blank it will default to `None`.\n\n##### Example\n\n```python\n  joke = await j.get_joke(blacklist=[\'nsfw\', \'racist\'])  # Will return a joke that does not have either the flag "nsfw" or "racist".\n```\n\n---\n\n#### response_format\n\nThe format in which the API should respond.\nOptions are:\n`json`,\n`yaml`,\n`xml`,\n`txt`\n\nIf left blank it will default to `json`.\n\n##### Example\n\n```python\n  joke = await j.get_joke(response_format="xml")  # Will return a joke in xml format.\n```\n\n---\n\n#### joke_type\n\nThe type of joke returned.\nOptions are:\n`single`,\n`twopart`,\n`Any`\n\nIf left blank it will default to `Any`\n\n##### Example\n\n```python\n  joke = await j.get_joke(joke_type="twopart")  # Will return a twopart joke; both a setup and a delivery.\n```\n\n---\n\n#### search_string\n\nA string to search for in jokes.\n\nIf left blank it will default to `None`\n\n##### Example\n\n```python\n  joke = await j.get_joke(search_string="the")  # Will return a joke with the word "the" in it.\n  # If there are no jokes then it will return the error from the API.\n```\n\n---\n\n#### id_range\n\nThe range in which the selected joke should fall. ID\'s are decided by the order in which jokes are submitted.\nThe argument passes should be in form of list or tuple, and should not exceed length of 2 items. First item\nshould be minimum 0. Maximum value can be determined [here](https://sv443.net/jokeapi/v2/info)\n\nIf left blank it will default to the maximum range.\n\n\n##### Example\n\n```python\n  joke = await j.get_joke(id_range=[10,100])  # Will return a joke with the ID between 10 and 100.\n```\n\n---\n\n#### amount\n\nThe amount of jokes you want the api to return. Will return them in a list. Maximum number is 10 jokes, and the\napi defaults to 1 if you use a number larger than the maximum. Defaults to 1.\n\n\n##### Example\n\n```python\n  joke = await j.get_joke(amount=2) # Will return 2 jokes.\n```\n\n---\n\n#### lang\n\nThe language that the joke and response should be in. Currently supported languages are in the official api\ndocumentation. Defaults to en.\n\n##### Example\n\n```python\n  joke = await j.get_joke(lang="de")\n```\n\n---\n\n#### auth_token\n\nA string token provided by the api owner. Using it will mean you are whitelisted by the api and can make\nmore requests than normal users. Defaults to None\n\n\n##### Example\n\n```python\n  joke = await j.get_joke(auth_token="aaaaaaaaaaaaaaaaaaaaabbbbbbbbbbbbbbbbbbbbb") # Will send the token to the api in a header.\n```\n\n---\n\n#### user_agent\n\nA string sent the the api that tells the api what browser you are (pretending to be). The default user agent\nis Mozilla Firefox from Windows 10 and should work fine, but the functionality is provided in case you wish\nto change it\n\n\n##### Example\n\n```python\n  joke = await j.get_joke(user_agent="Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:77.0) Gecko/20100101 Firefox/77.0")\n  # This is in fact the default user agent, and tells the API that we are visitng the page from a Firefox 77.0\n  # browser using Windows 10 64bit.\n```\n\n---\n\n#### return_headers\n\nA boolean value (True or False) that tells the wrapper if you wish to receive headers in the return from the function.\nWill return a list instead of a single value\nDefaults to False.\n\n\n##### Example\n\n```python\n  response = await j.get_joke(return_headers=True)\n  joke = response[0]\n  headers = response[1]\n\n  print(f"Joke: {joke}")\n  print(f"Headers: {headers}")\n```\n\n---\n\n### Returns\n\nDepending on what format is chosen different things will be returned.\n\n\n#### json\n\nA succesful API call will return:\n\n```json\n  {\n      "category": "Miscellaneous",\n      "type": "twopart",\n      "setup": "I told my psychiatrist I got suicidal tendencies.",\n      "delivery": "He said from now on I have to pay in advance.",\n      "flags": {\n          "nsfw": false,\n          "religious": false,\n          "political": false,\n          "racist": false,\n          "sexist": false\n      },\n      "id": 94,\n      "error": false\n  }\n```\n\n\n#### xml\n\nA succesful API call will return:\n\n```xml\n<?xml version=\'1.0\'?>\n<data>\n    <category>Dark</category>\n    <type>single</type>\n    <joke>My ex had an accident. I told the paramedics the wrong blood type for her. She\'ll finally experience what rejection is really like.</joke>\n    <flags>\n        <nsfw>false</nsfw>\n        <religious>false</religious>\n        <political>false</political>\n        <racist>false</racist>\n        <sexist>false</sexist>\n    </flags>\n    <id>154</id>\n    <error>false</error>\n</data>\n```\n\n\n#### yaml\n\nA succesful API call will return:\n\n```yaml\ncategory: "Programming"\ntype: "single"\njoke: "Your momma is so fat, you need to switch to NTFS to store a picture of her."\nflags:\n  nsfw: false\n  religious: false\n  political: false\n  racist: false\n  sexist: false\nid: 56\nerror: false\n```\n\n\n#### txt\n\nA succesful API call will return:\n\n```\nWhy does no one like SQLrillex?\n\nHe keeps dropping the database.\n```\n\n---\n\n### Errors\n\nThe wrapper can raise multiple different errors depending on what you did wrong.\n\nThe errors are descriptive enough that you should be able to solve them with the information provided in the error message.\nIf not, feel free to ask me through one of the channels provided below.\n\n---\n\n## submit_joke\n\n### Example\n\n```python\nfrom jokeapi import Jokes\nimport asyncio\n\nasync def submit_new_joke():\n\tj = await Jokes()\n\n\tawait j.submit_joke("Miscellaneous", "funny haha", {\n\t    "nsfw": False,\n\t    "religious": False,\n\t    "political": False,\n\t    "racist": False,\n\t    "sexist": False\n\t}, lang="de")\n\nasyncio.run(submit_new_joke())\n```\n\n---\n\n### Parameters\n\n---\n\n#### category\n\nThe category the joke is.\nOptions are:\n`programming`,\n`miscellaneous`,\n`dark`,\n`pun`\n\nHas no default value.\n\n---\n\n#### joke\n\nThe joke itself. Can either be a single string or a list/tuple, for the setup and\ndelivery. Setup should be at index 0 in the tuple, delivery at 1.\n\nHas no default value.\n\n---\n\n#### flags\n\nThe flags that the joke should have.\nOptions are:\n`nsfw`,\n`religious`,\n`political`,\n`racist`,\n`sexist`\n\nHas no default value.\n\n#### lang\n\nThe language code for the language the joke it written in. E.g en for english,\nde for german.\n\nDefaults to `en`\n\n---\n\n\n## Contributors\n\n[ThatCopy](https://github.com/ThatCopy)\n - [27994f7](https://github.com/thenamesweretakenalready/Sv443s-JokeAPI-Python-Wrapper/commit/27994f74fdea51cb2ddcee9ea127d393868aca00)\n - [01b578c](https://github.com/thenamesweretakenalready/Sv443s-JokeAPI-Python-Wrapper/commit/01b578cbb500d02ff27925459223e40505aafe96)\n\n[kdiri](https://github.com/kdiri)\n - [3e20cd1](https://github.com/thenamesweretakenalready/Sv443s-JokeAPI-Python-Wrapper/commit/3e20cd1dbd1e5ac6b08ed90c720bf2890a6a4ffd)\n - [3b6a2a6](https://github.com/thenamesweretakenalready/Sv443s-JokeAPI-Python-Wrapper/commit/3b6a2a6164225fb9d5cb1bd77b0ccebd9bd8bffd)\n\n\n## Developer contact\n\n![Discord](https://discord.com/assets/07dca80a102d4149e9736d4b162cff6f.ico)[**Discord**](https://discord.gg/mB989eP)\n\n[Issue Tracker](https://github.com/thenamesweretakenalready/JokeAPI-Python/issues)\n\n[e-mail](mailto:leet_haker@cyber-wizard.com)\n',
    'author': 'leet-hakker',
    'author_email': 'thenamesweretakenalready@gmail.com',
    'maintainer': 'leet-hakker',
    'maintainer_email': None,
    'url': 'https://pypi.org/project/jokeapi',
    'package_dir': package_dir,
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.7,<4.0',
}


setup(**setup_kwargs)
